/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.ArrayLowering;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StandardElementGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class Lowering
implements IOTConstants {
    public Expression lowerExpression(BlockScope scope, Expression expression, TypeBinding unloweredType, TypeBinding requiredType, Expression teamExpression, boolean needNullCheck) {
        int sourceStart = expression.sourceStart;
        int sourceEnd = expression.sourceEnd;
        AstGenerator gen = new AstGenerator(sourceStart, sourceEnd);
        unloweredType = TeamModel.strengthenRoleType(scope.enclosingSourceType(), unloweredType);
        Expression loweringExpr = null;
        TypeBinding expressionType = expression.resolvedType;
        assert (expressionType == null || expressionType.leafComponentType() instanceof ReferenceBinding);
        PushingExpression provider = new PushingExpression(expression);
        if (unloweredType.isArrayType()) {
            ArrayLowering trans = new ArrayLowering(teamExpression);
            loweringExpr = trans.lowerArray(scope, needNullCheck ? new PopExpression(expressionType, unloweredType, provider) : expression, unloweredType, requiredType);
        } else {
            boolean needMethod;
            RoleTypeBinding roleType = (RoleTypeBinding)unloweredType;
            boolean bl = needMethod = roleType.isRegularInterface() || !roleType.isSiblingRole(scope.enclosingSourceType());
            if (needMethod) {
                MessageSend callLower = gen.messageSend(needNullCheck ? new PopExpression(expressionType, unloweredType, provider) : expression, IOTConstants._OT_GETBASE, new Expression[0]);
                callLower.actualReceiverType = unloweredType;
                callLower.constant = Constant.NotAConstant;
                callLower.resolvedType = roleType.baseclass();
                callLower.binding = StandardElementGenerator.getGetBaseMethod(scope, roleType.roleModel, roleType.baseclass());
                loweringExpr = callLower;
            } else {
                FieldReference invokeBaseOnRole = new FieldReference(IOTConstants._OT_BASE, ((long)sourceStart << 32) + (long)sourceEnd);
                ReferenceBinding roleClass = roleType.roleModel.getClassPartBinding();
                if (needNullCheck) {
                    invokeBaseOnRole.receiver = new PopExpression(expressionType, roleClass, provider);
                } else {
                    TypeReference classRef = gen.typeReference(roleClass);
                    if (classRef != null) {
                        CastExpression unloweredExpr = new CastExpression(expression, classRef, 1);
                        unloweredExpr.constant = Constant.NotAConstant;
                        unloweredExpr.resolvedType = roleClass;
                        unloweredExpr.bits |= 0x40;
                        invokeBaseOnRole.receiver = unloweredExpr;
                    } else {
                        invokeBaseOnRole.receiver = expression;
                    }
                }
                invokeBaseOnRole.actualReceiverType = roleClass;
                invokeBaseOnRole.resolvedType = roleClass.baseclass();
                invokeBaseOnRole.binding = scope.findField(roleClass, IOTConstants._OT_BASE, invokeBaseOnRole, true);
                invokeBaseOnRole.constant = Constant.NotAConstant;
                loweringExpr = invokeBaseOnRole;
            }
        }
        if (needNullCheck) {
            loweringExpr = new LoweringConditional(expression, gen.nullCheck(provider), new PopExpression(expressionType, requiredType, provider), loweringExpr);
            loweringExpr.constant = Constant.NotAConstant;
            loweringExpr.resolvedType = requiredType;
        }
        return loweringExpr;
    }

    public static boolean isLoweringConditional(Expression expr) {
        return expr instanceof LoweringConditional;
    }

    public static boolean isPopExpression(Expression expression) {
        return expression instanceof PopExpression;
    }

    public static Expression unwrapExpression(Expression expression) {
        if (expression instanceof PushingExpression) {
            return ((PushingExpression)expression).expression;
        }
        if (expression instanceof PopExpression) {
            return ((PopExpression)expression).provider.expression;
        }
        return null;
    }

    class LoweringConditional
    extends ConditionalExpression {
        private Expression origExpression;

        LoweringConditional(Expression origExpression, Expression condition, Expression valueIfTrue, Expression valueIfFalse) {
            super(condition, valueIfTrue, valueIfFalse);
            this.origExpression = origExpression;
        }

        public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
            if (!valueRequired) {
                this.origExpression.generateCode(currentScope, codeStream, valueRequired);
            } else {
                super.generateCode(currentScope, codeStream, valueRequired);
            }
        }
    }

    static class PopExpression
    extends Expression {
        private boolean castRequired;
        PushingExpression provider;

        PopExpression(TypeBinding pushedType, TypeBinding popType, PushingExpression provider) {
            this.resolvedType = popType;
            if (popType == null) {
                this.resolvedType = pushedType;
            } else {
                this.castRequired = pushedType != popType;
            }
            this.provider = provider;
            this.sourceStart = provider.sourceStart;
            this.sourceEnd = provider.sourceEnd;
            this.constant = Constant.NotAConstant;
        }

        public StringBuffer printExpression(int indent, StringBuffer output) {
            output.append("<pop>");
            return output;
        }

        public TypeBinding resolveType(BlockScope scope) {
            return this.resolvedType;
        }

        public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
            if (this.provider.stackDepth + 1 == codeStream.stackDepth) {
                codeStream.swap();
            } else assert (this.provider.stackDepth == codeStream.stackDepth);
            if (this.castRequired) {
                codeStream.checkcast(this.resolvedType);
            }
        }
    }

    class PushingExpression
    extends Expression {
        Expression expression;
        int stackDepth = -1;

        PushingExpression(Expression expression) {
            this.expression = expression;
            this.constant = Constant.NotAConstant;
            this.sourceStart = expression.sourceStart;
            this.sourceEnd = expression.sourceEnd;
        }

        public void traverse(ASTVisitor visitor, BlockScope scope) {
            this.expression.traverse(visitor, scope);
        }

        public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
            return this.expression.analyseCode(currentScope, flowContext, flowInfo);
        }

        public TypeBinding resolveType(BlockScope scope) {
            if (this.constant == null) {
                this.constant = Constant.NotAConstant;
            }
            this.resolvedType = this.expression.resolveType(scope);
            return this.resolvedType;
        }

        public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
            this.expression.generateCode(currentScope, codeStream, valueRequired);
            this.stackDepth = codeStream.stackDepth;
            codeStream.dup();
        }

        public StringBuffer printExpression(int indent, StringBuffer output) {
            output.append("(");
            this.expression.printExpression(indent, output);
            output.append(")<pushed>");
            return output;
        }
    }
}

