/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.eclipse.monitor.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.objectteams.eclipse.monitor.internal.Activator;
import org.eclipse.objectteams.eclipse.monitor.internal.MonitorMessages;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.objectteams.Team;

public class MonitorView
extends ViewPart {
    private static final String IMG_AUTO_REFRESH = "icons/auto_refresh.png";
    private static final String IMG_REFRESH = "icons/refresh_nav.gif";
    private static final String IMG_REFRESH_DISABLED = "icons/refresh_nav_dis.gif";
    private Table table;
    private Action refreshAction;
    private Action toggleAutoRefreshAction;
    private boolean autoRefresh = true;
    private HashMap<Widget, String> hoverTexts = new HashMap();

    public void createPartControl(Composite parent) {
        Activator.registerMonitorView(this);
        this.table = new Table(parent, 802);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(parent.getFont());
        String[] columnTitles = new String[]{MonitorMessages.heading_team_class, MonitorMessages.heading_num_roles};
        int[] columnWidths = new int[]{500, 50};
        int i = 0;
        while (i < columnTitles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setWidth(columnWidths[i]);
            column.setText(columnTitles[i]);
            ++i;
        }
        this.readTeams();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MonitorView.this.printDetails(e.item);
            }
        });
        this.table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                TableItem item = MonitorView.this.table.getItem(new Point(e.x, e.y));
                String hoverText = (String)MonitorView.this.hoverTexts.get(item);
                if (hoverText != null) {
                    MonitorView.this.table.setToolTipText(hoverText);
                } else {
                    MonitorView.this.table.setToolTipText(MonitorMessages.tooltip_not_computed);
                }
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)gridData);
        Display display = parent.getDisplay();
        this.makeActions(display);
        this.contributeToActionBars();
    }

    private void makeActions(final Display display) {
        this.refreshAction = new Action(){

            public void run() {
                MonitorView.this.refreshAll();
            }
        };
        this.refreshAction.setText(MonitorMessages.button_text_refresh);
        this.refreshAction.setToolTipText(MonitorMessages.button_tooltip_refresh);
        this.refreshAction.setDisabledImageDescriptor(Activator.getImageDescriptor(IMG_REFRESH_DISABLED));
        this.refreshAction.setImageDescriptor(Activator.getImageDescriptor(IMG_REFRESH));
        this.toggleAutoRefreshAction = new Action(){

            public void run() {
                MonitorView.this.autoRefresh = !MonitorView.this.autoRefresh;
                if (MonitorView.this.autoRefresh) {
                    MonitorView.this.startAutoRefreshJob(display);
                }
            }
        };
        this.toggleAutoRefreshAction.setChecked(true);
        this.toggleAutoRefreshAction.setText(MonitorMessages.button_text_auto_refresh);
        this.toggleAutoRefreshAction.setToolTipText(MonitorMessages.button_tooltip_auto_refresh);
        this.toggleAutoRefreshAction.setImageDescriptor(Activator.getImageDescriptor(IMG_AUTO_REFRESH));
        this.startAutoRefreshJob(display);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.refreshAction);
        bars.getToolBarManager().add((IAction)this.toggleAutoRefreshAction);
    }

    void startAutoRefreshJob(final Display display) {
        Job job = new Job(MonitorMessages.job_name_refresh){

            protected IStatus run(IProgressMonitor monitor) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        MonitorView.this.refreshTableData();
                    }
                });
                if (MonitorView.this.autoRefresh) {
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule(1000L);
    }

    public void stop() {
        this.autoRefresh = false;
    }

    public void setFocus() {
        this.table.setFocus();
    }

    void readTeams() {
        ArrayList teamList = new ArrayList();
        TransformerPlugin.getTeamInstances(teamList);
        int i = 0;
        while (i < teamList.size()) {
            Team aTeam = (Team)teamList.get(i);
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)aTeam);
            item.setChecked(aTeam.isActive(Team.ALL_THREADS));
            this.setupData(item);
            ++i;
        }
    }

    void refreshAll() {
        this.table.removeAll();
        this.readTeams();
        this.refreshTableData();
    }

    private boolean setupData(TableItem item) {
        Team aTeam = (Team)item.getData();
        item.setText(0, aTeam.getClass().getName());
        String oldLength = item.getText(1);
        String newLength = String.valueOf(aTeam.getAllRoles().length);
        item.setText(1, newLength);
        return oldLength == null || !oldLength.equals(newLength);
    }

    void refreshTableData() {
        if (this.table.isDisposed()) {
            this.autoRefresh = false;
            return;
        }
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (this.setupData(item)) {
                this.hoverTexts.remove(item);
            }
            ++n2;
        }
    }

    void printDetails(Widget item) {
        StringBuilder buf = new StringBuilder();
        Team aTeam = (Team)item.getData();
        String teamName = aTeam.getClass().getName();
        buf.append(String.valueOf(MonitorMessages.tooltip_roles_of) + teamName);
        Object[] allRoles = aTeam.getAllRoles();
        if (allRoles.length == 0) {
            buf.append('\n');
            buf.append(MonitorMessages.tooltip_no_roles);
        } else {
            HashMap stats = new HashMap();
            Object[] objectArray = allRoles;
            int n = allRoles.length;
            int n2 = 0;
            while (n2 < n) {
                Object aRole = objectArray[n2];
                Integer i = (Integer)stats.get(aRole.getClass());
                i = i != null ? Integer.valueOf(i + 1) : Integer.valueOf(1);
                stats.put(aRole.getClass(), i);
                ++n2;
            }
            for (Map.Entry stat : stats.entrySet()) {
                int prefixLen = teamName.length() + "$__OT__".length();
                String roleName = ((Class)stat.getKey()).getName().substring(prefixLen);
                buf.append("\n" + stat.getValue() + "\t" + roleName);
            }
        }
        System.out.println(buf.toString());
        this.hoverTexts.put(item, buf.toString());
        boolean checked = ((TableItem)item).getChecked();
        if (checked != aTeam.isActive(Team.ALL_THREADS)) {
            if (checked) {
                aTeam.activate(Team.ALL_THREADS);
            } else {
                aTeam.deactivate(Team.ALL_THREADS);
            }
        }
    }
}

