/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui.views;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.objectteams.otdt.debug.OTDebugElementsContainer;
import org.eclipse.objectteams.otdt.debug.ui.internal.actions.ChangeTeamActivationAction;
import org.eclipse.objectteams.otdt.debug.ui.internal.actions.SortTeamAction;
import org.eclipse.objectteams.otdt.debug.ui.internal.actions.UpdateTeamViewAction;
import org.eclipse.objectteams.otdt.debug.ui.views.TeamViewMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public class TeamView
extends VariablesView
implements ILaunchesListener2 {
    private static final String ACTION_ACTIVATE_TEAM = "ActivateTeam";
    private static final String ACTION_DEACTIVATE_TEAM = "DeactivateTeam";
    private static final String ACTION_UPDATE_TEAMVIEW = "action.update.teamview";
    private String _sortMode;
    private boolean _updatePermantently = false;
    private static boolean DEBUG = false;

    public TeamView() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        this._sortMode = this.getDefaultSortMode();
    }

    protected String getPresentationContextId() {
        return "org.eclipse.objectteams.otdt.debug.ui.views.team";
    }

    public String getDefaultSortMode() {
        return "Teams.by.activationtime";
    }

    public void contextActivated(ISelection selection) {
        if (DEBUG) {
            System.out.println("TV: contextActivated: " + selection);
        }
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                this.setViewerInput(structuredSelection.getFirstElement());
            } else {
                this.setViewerInput(null);
            }
        }
        this.showViewer();
        this.updateAction(VARIABLES_FIND_ELEMENT_ACTION);
        this.updateAction(FIND_ACTION);
    }

    protected void setViewerInput(Object context) {
        ILaunch launch;
        OTDebugElementsContainer newInput;
        Object current;
        if (DEBUG) {
            System.out.println("TV: setViewerInput: " + context);
        }
        if (!this.isSuspended(context) && !this._updatePermantently) {
            return;
        }
        if (context == null) {
            this.refreshDetailPaneContents();
        }
        if ((current = this.getViewer().getInput()) == null && context == null) {
            return;
        }
        boolean hasContextChanged = false;
        if ((context instanceof IStackFrame || context instanceof IThread || context instanceof IDebugTarget) && (newInput = (OTDebugElementsContainer)(launch = ((IDebugElement)context).getLaunch()).getAdapter(OTDebugElementsContainer.class)) != null) {
            hasContextChanged = newInput.setContext((IDebugElement)context);
            newInput.setSortMode(this._sortMode);
            context = newInput;
        }
        if (!hasContextChanged && current != null && current.equals(context)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(context);
    }

    private boolean isSuspended(Object context) {
        if (context instanceof OTDebugElementsContainer) {
            return ((OTDebugElementsContainer)context).isSuspended();
        }
        return true;
    }

    public IJavaThread getSelectedThread() {
        Object input = this.getViewer().getInput();
        if (input instanceof OTDebugElementsContainer) {
            return ((OTDebugElementsContainer)input).getContextThread();
        }
        return null;
    }

    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        throw new RuntimeException("TeamView.modelChanged() should not be called");
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch.isTerminated()) {
                OTDebugElementsContainer current = (OTDebugElementsContainer)this.getViewer().getInput();
                IDebugTarget currentTarget = current.getContext().getDebugTarget();
                if (launch.getDebugTarget() == currentTarget) {
                    current.dispose();
                    this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TeamView.this.getViewer().setInput(null);
                        }
                    });
                    return;
                }
            }
            ++n2;
        }
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        super.dispose();
    }

    public Viewer createViewer(Composite parent) {
        TreeModelViewer variablesViewer = (TreeModelViewer)super.createViewer(parent);
        variablesViewer.removeModelChangedListener((IModelChangedListener)this);
        return variablesViewer;
    }

    protected void createActions() {
        super.createActions();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.createSortActions(viewMenu);
        this.setAction(ACTION_UPDATE_TEAMVIEW, (IAction)new UpdateTeamViewAction(this));
        this.setAction(ACTION_ACTIVATE_TEAM, (IAction)new ChangeTeamActivationAction(this, true));
        this.setAction(ACTION_DEACTIVATE_TEAM, (IAction)new ChangeTeamActivationAction(this, false));
    }

    private void createSortActions(IMenuManager viewMenu) {
        final SortTeamAction sortAction1 = new SortTeamAction(this, "Teams.by.activationtime");
        final SortTeamAction sortAction2 = new SortTeamAction(this, "Teams.by.instantiation");
        final SortTeamAction sortAction3 = new SortTeamAction(this, "Teams.by.name");
        final MenuManager layoutSubMenu = new MenuManager(TeamViewMessages.TeamView_0);
        layoutSubMenu.setRemoveAllWhenShown(true);
        layoutSubMenu.add((IAction)sortAction1);
        layoutSubMenu.add((IAction)sortAction2);
        layoutSubMenu.add((IAction)sortAction3);
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        layoutSubMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                layoutSubMenu.add((IAction)sortAction1);
                layoutSubMenu.add((IAction)sortAction2);
                layoutSubMenu.add((IAction)sortAction3);
            }
        });
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add(this.getAction(ACTION_ACTIVATE_TEAM));
        menu.add(this.getAction(ACTION_DEACTIVATE_TEAM));
    }

    protected String getToggleActionLabel() {
        return TeamViewMessages.TeamView_1;
    }

    public void setSortMode(String sortMode) {
        this._sortMode = sortMode;
    }

    protected void configureToolBar(IToolBarManager tbm) {
        super.configureToolBar(tbm);
        tbm.add((IContributionItem)new Separator("emptyRegisterGroup"));
        tbm.add((IContributionItem)new Separator("registerGroup"));
        tbm.add(this.getAction(ACTION_UPDATE_TEAMVIEW));
    }

    public void setUpdatePermanently(boolean updatePermanently) {
        this._updatePermantently = updatePermanently;
        if (!updatePermanently) {
            this.setViewerInput(null);
        }
    }
}

