/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodBindingOperator;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ModifierChangeCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.objectteams.otdt.ui.ImageManager;
import org.eclipse.swt.graphics.Image;

public class ChangeModifierProposalSubProcessor {
    static final int VISIBILITY_MASK = 7;
    static final String KEY_CALLIN_MODIFIER = "callin_modifier";

    static ASTRewriteCorrectionProposal getMakeTypeTeamProposal(ICompilationUnit cu, RoleTypeDeclaration typeDeclaration, int relevance) {
        AST ast = typeDeclaration.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        rewrite.set((ASTNode)typeDeclaration, (StructuralPropertyDescriptor)RoleTypeDeclaration.TEAM_PROPERTY, (Object)true, null);
        String label = Messages.format((String)CorrectionMessages.OTQuickfix_addteam_description, (Object)typeDeclaration.getName().getIdentifier());
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
        return new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
    }

    static ASTRewriteCorrectionProposal getMakeTypeAbstractProposal(ICompilationUnit cu, TypeDeclaration typeDeclaration, int relevance) {
        AST ast = typeDeclaration.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        ChildListPropertyDescriptor modifiersProperty = typeDeclaration instanceof RoleTypeDeclaration ? RoleTypeDeclaration.MODIFIERS2_PROPERTY : TypeDeclaration.MODIFIERS2_PROPERTY;
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)typeDeclaration, modifiersProperty);
        if (typeDeclaration.isTeam()) {
            listRewrite.insertAt((ASTNode)newModifier, ChangeModifierProposalSubProcessor.findTeamModifierIndex(typeDeclaration), null);
        } else {
            listRewrite.insertLast((ASTNode)newModifier, null);
        }
        String label = Messages.format((String)CorrectionMessages.OTQuickfix_addabstract_description, (Object)typeDeclaration.getName().getIdentifier());
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, relevance, image);
        proposal.addLinkedPosition(rewrite.track((ASTNode)newModifier), true, "modifier");
        return proposal;
    }

    private static int findTeamModifierIndex(TypeDeclaration typeDeclaration) {
        List modifiers = typeDeclaration.modifiers();
        if (modifiers == null) {
            throw new IllegalArgumentException("team without team modifier?");
        }
        int i = 0;
        while (i < modifiers.size()) {
            if (((Modifier)modifiers.get(i)).getKeyword() == Modifier.ModifierKeyword.TEAM_KEYWORD) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("team without team modifier?");
    }

    static ICommandAccess getChangeRoleVisibilityProposal(ICompilationUnit cu, RoleTypeDeclaration roleType, int modifier) {
        return new ModifierChangeCorrectionProposal(Messages.format((String)CorrectionMessages.OTQuickfix_changerolevisibility_description, (Object[])new String[]{roleType.getName().getIdentifier(), Modifier.isPublic((int)modifier) ? "public" : "protected"}), cu, (IBinding)roleType.resolveBinding(), (ASTNode)roleType, modifier, 7, 8, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
    }

    static ICommandAccess getChangeMethodModifierProposal(IInvocationContext context, MethodDeclaration methodDecl, IMethodBinding method, int modifier, boolean isAdding) {
        if (methodDecl == null) {
            methodDecl = (MethodDeclaration)context.getASTRoot().findDeclaringNode((IBinding)method);
        } else if (method == null) {
            method = methodDecl.resolveBinding();
        }
        if (methodDecl == null || method == null) {
            return null;
        }
        String label = null;
        Object[] values = null;
        if (modifier == Integer.MIN_VALUE) {
            label = isAdding ? CorrectionMessages.OTQuickfix_addcallinmodifier_description : CorrectionMessages.OTQuickfix_removecallinmodifier_description;
            values = new String[]{method.getName()};
        } else {
            label = isAdding ? CorrectionMessages.OTQuickfix_addmethodmodifier_description : CorrectionMessages.OTQuickfix_removemethodmodifier_description;
            values = new String[]{ChangeModifierProposalSubProcessor.getModifierString(modifier), method.getName()};
        }
        return new ModifierChangeCorrectionProposal(Messages.format((String)label, (Object[])values), context.getCompilationUnit(), (IBinding)method, (ASTNode)methodDecl, isAdding ? modifier : 0, modifier, 8, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
    }

    public static ICommandAccess getAddOrChangeCallinModifierProposal(ICompilationUnit cu, CallinMappingDeclaration callinMapping) {
        AST ast = callinMapping.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        IMethodBinding roleMethod = ((MethodSpec)callinMapping.getRoleMappingElement()).resolveBinding();
        boolean replaceRequired = roleMethod != null && Modifier.isCallin((int)roleMethod.getModifiers());
        Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.REPLACE_KEYWORD;
        if (!replaceRequired && roleMethod != null) {
            keyword = Modifier.ModifierKeyword.AFTER_KEYWORD;
        }
        Modifier modifier = ast.newModifier(keyword);
        rewrite.set((ASTNode)callinMapping.bindingOperator(), (StructuralPropertyDescriptor)MethodBindingOperator.BINDING_MODIFIER_PROPERTY, (Object)modifier, null);
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(callinMapping.getCallinModifier() == 8192 ? CorrectionMessages.OTQuickfix_AddCallinModifier : CorrectionMessages.OTQuickfix_ChangeCallinModifier, cu, rewrite, 10, ImageManager.getSharedInstance().get("callinbindingreplace_obj.gif"));
        if (!replaceRequired) {
            proposal.addLinkedPosition(rewrite.track((ASTNode)modifier), false, KEY_CALLIN_MODIFIER);
            proposal.addLinkedPositionProposal(KEY_CALLIN_MODIFIER, "after", null);
            proposal.addLinkedPositionProposal(KEY_CALLIN_MODIFIER, "before", null);
            if (roleMethod == null) {
                proposal.addLinkedPositionProposal(KEY_CALLIN_MODIFIER, "replace", null);
            }
        }
        return proposal;
    }

    public static ICommandAccess getChangeCalloutKindProposal(ICompilationUnit cu, CalloutMappingDeclaration calloutMapping, boolean toOverride) {
        AST ast = calloutMapping.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        rewrite.set((ASTNode)calloutMapping.bindingOperator(), (StructuralPropertyDescriptor)MethodBindingOperator.BINDING_KIND_PROPERTY, (Object)(toOverride ? 2 : 1), null);
        return new ASTRewriteCorrectionProposal(toOverride ? CorrectionMessages.OTQuickfix_ChangeCalloutToOverride : CorrectionMessages.OTQuickfix_ChangeCalloutToRegular, cu, rewrite, 10, ImageManager.getSharedInstance().get("calloutbinding_obj.gif"));
    }

    private static String getModifierString(int modifier) {
        switch (modifier) {
            case 1: {
                return "public";
            }
            case 4: {
                return "protected";
            }
            case 2: {
                return "private";
            }
            case 8: {
                return "static";
            }
        }
        return "<unexpected modifier>";
    }

    public static ModifierChangeCorrectionProposal changeAnchorToFinalProposal(ICompilationUnit cu, ASTNode anchor) {
        VariableDeclarationFragment var = null;
        String anchorName = null;
        if (anchor instanceof SimpleName) {
            anchorName = ((SimpleName)anchor).getIdentifier();
            IBinding variable = ((SimpleName)anchor).resolveBinding();
            if (variable instanceof IVariableBinding) {
                ASTNode outer = anchor;
                while (!(outer instanceof CompilationUnit)) {
                    if ((outer = outer.getParent()) != null) continue;
                    return null;
                }
                ASTNode declaringNode = ((CompilationUnit)outer).findDeclaringNode(variable);
                if (declaringNode instanceof VariableDeclarationFragment) {
                    var = (VariableDeclarationFragment)declaringNode;
                }
            }
        }
        if (var != null) {
            return new ModifierChangeCorrectionProposal(Messages.format((String)CorrectionMessages.OTQuickfix_makeanchorfinal_description, (Object[])new String[]{anchorName}), cu, (IBinding)var.resolveBinding(), var, 16, 0, 13, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
        }
        return null;
    }
}

