/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.GuardPredicateDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.objectteams.otdt.internal.ui.util.OTStubUtility;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            return this.hasToggleSignaturesOfMethodMappingProposal(coveringNode);
        }
        return false;
    }

    private boolean hasToggleSignaturesOfMethodMappingProposal(ASTNode coveringNode) {
        while (coveringNode != null) {
            switch (coveringNode.getNodeType()) {
                case 85: 
                case 86: {
                    AbstractMethodMappingDeclaration methodMapping = (AbstractMethodMappingDeclaration)coveringNode;
                    return !methodMapping.hasParameterMapping();
                }
                case 15: 
                case 55: 
                case 93: {
                    return false;
                }
            }
            coveringNode = coveringNode.getParent();
        }
        return false;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ASTRewriteCorrectionProposal> resultingCollections = new ArrayList<ASTRewriteCorrectionProposal>();
            boolean noErrorsAtLocation = QuickAssistProcessor.noErrorsAtLocation(locations);
            this.getRemoveMethodMappingSignaturesProposal(context.getCompilationUnit(), coveringNode, resultingCollections);
            if (noErrorsAtLocation) {
                this.getAddMethodMappingSignaturesProposal(context.getCompilationUnit(), coveringNode, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    private void getRemoveMethodMappingSignaturesProposal(ICompilationUnit cu, ASTNode coveringNode, ArrayList<ASTRewriteCorrectionProposal> resultingCollections) {
        AbstractMethodMappingDeclaration mapping = this.getMethodMapping(coveringNode);
        if (mapping != null && mapping.hasSignature()) {
            if (mapping.getNodeType() == 85 && this.predicateUsesMethodSpecArgument((CallinMappingDeclaration)mapping)) {
                return;
            }
            AST ast = mapping.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ListRewrite typeParamters = rewrite.getListRewrite((ASTNode)mapping.getRoleMappingElement(), MethodSpec.TYPE_PARAMETERS_PROPERTY);
            for (Object typeParamObject : ((MethodSpec)mapping.getRoleMappingElement()).typeParameters()) {
                typeParamters.remove((ASTNode)typeParamObject, null);
            }
            this.removeSignature(rewrite, mapping.getRoleMappingElement());
            if (mapping instanceof CalloutMappingDeclaration) {
                this.removeSignature(rewrite, ((CalloutMappingDeclaration)mapping).getBaseMappingElement());
            } else {
                for (Object baseElement : ((CallinMappingDeclaration)mapping).getBaseMappingElements()) {
                    this.removeSignature(rewrite, (MethodMappingElement)baseElement);
                }
            }
            String label = CorrectionMessages.QuickAssistProcessor_removeMethodBindingSignatures_label;
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.remove_correction.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 1, image);
            resultingCollections.add(proposal);
        }
    }

    private boolean predicateUsesMethodSpecArgument(CallinMappingDeclaration callinMapping) {
        GuardPredicateDeclaration predicate = callinMapping.getGuardPredicate();
        if (predicate == null) {
            return false;
        }
        final ArrayList<String> argNames = new ArrayList<String>();
        if (predicate.isBase()) {
            for (Object baseMethodObject : callinMapping.getBaseMappingElements()) {
                for (Object baseArgObj : ((MethodSpec)baseMethodObject).parameters()) {
                    argNames.add(((SingleVariableDeclaration)baseArgObj).getName().getIdentifier());
                }
            }
        } else {
            for (Object roleArgObj : ((MethodSpec)callinMapping.getRoleMappingElement()).parameters()) {
                argNames.add(((SingleVariableDeclaration)roleArgObj).getName().getIdentifier());
            }
        }
        try {
            predicate.getExpression().accept(new ASTVisitor(){

                public boolean visit(SimpleName node) {
                    for (String argName : argNames) {
                        if (!argName.equals(node.getIdentifier())) continue;
                        throw new RuntimeException();
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException runtimeException) {
            return true;
        }
        return false;
    }

    private void removeSignature(ASTRewrite rewrite, MethodMappingElement mappingElement) {
        rewrite.set((ASTNode)mappingElement, (StructuralPropertyDescriptor)mappingElement.signatureProperty(), (Object)Boolean.FALSE, null);
        switch (mappingElement.getNodeType()) {
            case 92: {
                rewrite.set((ASTNode)mappingElement, (StructuralPropertyDescriptor)FieldAccessSpec.FIELD_TYPE_PROPERTY, null, null);
                break;
            }
            case 84: {
                rewrite.set((ASTNode)mappingElement, (StructuralPropertyDescriptor)MethodSpec.RETURN_TYPE2_PROPERTY, null, null);
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)mappingElement, MethodSpec.TYPE_PARAMETERS_PROPERTY);
                for (Object toRemove : ((MethodSpec)mappingElement).typeParameters()) {
                    listRewrite.remove((ASTNode)toRemove, null);
                }
                listRewrite = rewrite.getListRewrite((ASTNode)mappingElement, MethodSpec.PARAMETERS_PROPERTY);
                for (Object toRemove : ((MethodSpec)mappingElement).parameters()) {
                    listRewrite.remove((ASTNode)toRemove, null);
                }
                break;
            }
        }
    }

    private void getAddMethodMappingSignaturesProposal(final ICompilationUnit cu, ASTNode coveringNode, ArrayList<ASTRewriteCorrectionProposal> resultingCollections) {
        final AbstractMethodMappingDeclaration mapping = this.getMethodMapping(coveringNode);
        if (mapping != null && !mapping.hasSignature()) {
            final AST ast = mapping.getAST();
            final ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            String label = CorrectionMessages.QuickAssistProcessor_addMethodBindingSignatures_label;
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 1, image){

                protected ASTRewrite getRewrite() throws CoreException {
                    TextEditGroup editGroup = new TextEditGroup(CorrectionMessages.QuickAssistProcessor_addSignature_editName);
                    ImportRewrite imports = this.createImportRewrite((CompilationUnit)ASTNodes.getParent((ASTNode)mapping, (int)15));
                    IMethodBinding roleMethod = mapping.resolveBinding().getRoleMethod();
                    MethodSpec newSpec = OTStubUtility.createMethodSpec(cu, rewrite, imports, roleMethod, true);
                    this.convertTypeParameters(ast, roleMethod, newSpec);
                    rewrite.set((ASTNode)mapping, (StructuralPropertyDescriptor)mapping.getRoleElementProperty(), (Object)newSpec, editGroup);
                    if (mapping.getNodeType() == 85) {
                        QuickAssistProcessor.this.addSignatureToCallinBases(cu, rewrite, imports, (CallinMappingDeclaration)mapping, editGroup);
                    } else {
                        QuickAssistProcessor.this.addSignatureToCalloutBase(cu, rewrite, imports, (CalloutMappingDeclaration)mapping, editGroup);
                    }
                    return rewrite;
                }

                private void convertTypeParameters(AST ast2, IMethodBinding roleMethod, MethodSpec destMethodSpec) {
                    ITypeBinding[] iTypeBindingArray = roleMethod.getTypeParameters();
                    int n = iTypeBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding typeParameter = iTypeBindingArray[n2];
                        TypeParameter newTypeParameter = ast2.newTypeParameter();
                        newTypeParameter.setName(ast2.newSimpleName(typeParameter.getName()));
                        ITypeBinding[] iTypeBindingArray2 = typeParameter.getTypeBounds();
                        int n3 = iTypeBindingArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ITypeBinding typeBound = iTypeBindingArray2[n4];
                            newTypeParameter.typeBounds().add(QuickAssistProcessor.this.convertType(ast2, typeBound));
                            ++n4;
                        }
                        destMethodSpec.typeParameters().add(newTypeParameter);
                        ++n2;
                    }
                }
            };
            resultingCollections.add(proposal);
        }
    }

    private void addSignatureToCallinBases(ICompilationUnit cu, ASTRewrite rewrite, ImportRewrite imports, CallinMappingDeclaration mapping, TextEditGroup editGroup) {
        List oldBaseSpecs = mapping.getBaseMappingElements();
        ListRewrite baseMethods = rewrite.getListRewrite((ASTNode)mapping, CallinMappingDeclaration.BASE_MAPPING_ELEMENTS_PROPERTY);
        int i = 0;
        IMethodBinding[] iMethodBindingArray = mapping.resolveBinding().getBaseMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding baseMethod = iMethodBindingArray[n2];
            try {
                try {
                    MethodSpec newSpec = OTStubUtility.createMethodSpec(cu, rewrite, imports, baseMethod, true);
                    baseMethods.replace((ASTNode)oldBaseSpecs.get(i), (ASTNode)newSpec, editGroup);
                }
                catch (CoreException e) {
                    OTDTUIPlugin.log((Throwable)e);
                    ++i;
                }
            }
            finally {
                ++i;
            }
        }
    }

    private void addSignatureToCalloutBase(ICompilationUnit cu, ASTRewrite rewrite, ImportRewrite imports, CalloutMappingDeclaration mapping, TextEditGroup editGroup) {
        try {
            FieldAccessSpec baseElement;
            if (mapping.bindingOperator().isCalloutToField()) {
                IVariableBinding baseField = ((FieldAccessSpec)mapping.getBaseMappingElement()).resolveBinding();
                baseElement = OTStubUtility.createFieldSpec(mapping.getAST(), imports, baseField, true);
            } else {
                IMethodBinding baseMethod = mapping.resolveBinding().getBaseMethods()[0];
                baseElement = OTStubUtility.createMethodSpec(cu, rewrite, imports, baseMethod, true);
            }
            rewrite.set((ASTNode)mapping, (StructuralPropertyDescriptor)CalloutMappingDeclaration.BASE_MAPPING_ELEMENT_PROPERTY, (Object)baseElement, editGroup);
        }
        catch (CoreException e) {
            OTDTUIPlugin.log((Throwable)e);
        }
    }

    AbstractMethodMappingDeclaration getMethodMapping(ASTNode coveringNode) {
        if (coveringNode instanceof AbstractMethodMappingDeclaration) {
            return (AbstractMethodMappingDeclaration)coveringNode;
        }
        return (AbstractMethodMappingDeclaration)ASTNodes.getParent((ASTNode)coveringNode, AbstractMethodMappingDeclaration.class);
    }

    private Type convertType(AST ast, ITypeBinding typeBinding) {
        if (typeBinding.isTypeVariable()) {
            return ast.newSimpleType((Name)ast.newSimpleName(typeBinding.getName()));
        }
        String typeName = typeBinding.getErasure().getQualifiedName();
        SimpleType type = typeName.indexOf(46) > -1 ? ast.newSimpleType(ast.newName(typeName)) : ast.newSimpleType((Name)ast.newSimpleName(typeName));
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length > 0) {
            ParameterizedType parameterizedType = ast.newParameterizedType((Type)type);
            ITypeBinding[] iTypeBindingArray = typeArguments;
            int n = typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding bound = iTypeBindingArray[n2];
                parameterizedType.typeArguments().add(this.convertType(ast, bound));
                ++n2;
            }
            return parameterizedType;
        }
        return type;
    }

    static boolean noErrorsAtLocation(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if (location.isError() && (!"org.eclipse.jdt.core.problem".equals(location.getMarkerType()) || JavaCore.getOptionForConfigurableSeverity((int)location.getProblemId()) == null)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

