/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.pde.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.objectteams.otdt.core.ext.OTREContainer;
import org.eclipse.objectteams.otdt.internal.pde.ui.ClasspathComputerAdapter;
import org.eclipse.objectteams.otdt.internal.pde.ui.OTPDEUIPlugin;
import org.eclipse.objectteams.otdt.internal.pde.ui.OTPluginProject;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.ui.templates.PluginReference;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleOTSupportAction
implements IObjectActionDelegate {
    private Shell shell;
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] objectArray = ((IStructuredSelection)this.selection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IProject project = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof IAdaptable) {
                project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
            }
            if (project != null) {
                this.toggleOTSupport(project);
            }
            ++n2;
        }
    }

    private void toggleOTSupport(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            if (description.hasNature("org.eclipse.objectteams.otdt.OTJavaNature")) {
                this.removeOTSupport(project);
            } else {
                this.addOTSupport(project);
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.shell, (String)"Project Configuration Error", (String)("Error Configuring Project " + project.getName() + "."), (IStatus)e.getStatus());
            OTPDEUIPlugin.getDefault().getLog().log(OTPDEUIPlugin.createErrorStatus("Project configuration error", e));
        }
    }

    private void addOTSupport(IProject project) throws CoreException {
        OTPluginProject.addOTNatureAndBuilder(project);
        if (PDE.hasPluginNature((IProject)project)) {
            WorkspaceBundlePluginModel fModel = new WorkspaceBundlePluginModel(project.getFile("META-INF/MANIFEST.MF"), project.getFile("plugin.xml"));
            IPluginBase pluginBase = fModel.getPluginBase();
            PluginReference ref = new PluginReference("org.eclipse.objectteams.otequinox", null, 0);
            IPluginImport iimport = fModel.getPluginFactory().createImport();
            iimport.setId(ref.getId());
            iimport.setVersion(ref.getVersion());
            iimport.setMatch(ref.getMatch());
            pluginBase.add(iimport);
            fModel.save();
        }
        OTREContainer.initializeOTJProject((IProject)project);
        if (PDE.hasPluginNature((IProject)project)) {
            ClasspathComputerAdapter.sortClasspathEntries(project);
        }
    }

    private void removeOTSupport(IProject project) throws CoreException {
    }
}

