/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.ui.help;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.objectteams.otdt.ui.help.OTHelpPlugin;
import org.eclipse.objectteams.otdt.ui.help.views.OTJLDView;

public class OTJLDError {
    private ArrayList<OTURL> m_urls;
    private static final Pattern OTLD_MARKER_PATTERN = Pattern.compile(".*\\(OTJLD\\s*(.*)\\s*\\).*", 32);
    private static final Pattern SUBSECTION_PATTERN = Pattern.compile("(.*)\\s*\\(\\s*(.*)\\s*\\).*");
    public static final String URL_PATH = "guide/otjld/xdef/";
    private static final String IMAGES_URL_PATH = "guide/otjld/images/";
    private static final String CSS_URL_PATH = "guide/otjld/css/";
    static boolean contentInitialized = false;

    public OTJLDError(String message) {
        this.parseMarkerMessage(message);
    }

    public OTURL[] getURLs() {
        if (this.m_urls == null || this.m_urls.isEmpty()) {
            return new OTURL[0];
        }
        return this.m_urls.toArray(new OTURL[this.m_urls.size()]);
    }

    private void parseMarkerMessage(String text) {
        Matcher matcher = OTLD_MARKER_PATTERN.matcher(text);
        if (!matcher.matches()) {
            return;
        }
        this.m_urls = new ArrayList();
        int i = 0;
        while (i < matcher.groupCount()) {
            String decl = matcher.group(i + 1);
            this.parseParagraphs(decl.trim());
            ++i;
        }
    }

    private void parseParagraphs(String decl) {
        String paragraph = null;
        String subSection = null;
        Matcher matcher = SUBSECTION_PATTERN.matcher(decl);
        if (matcher.matches()) {
            assert (matcher.groupCount() == 2);
            paragraph = matcher.group(1);
            subSection = matcher.group(2);
        } else {
            paragraph = decl;
        }
        OTURL url = this.lookupURL(paragraph, subSection);
        if (url != null) {
            this.m_urls.add(url);
        }
    }

    private OTURL lookupURL(String paragraph, String subSection) {
        String ssFileNameAddon = "";
        if (subSection != null && subSection.length() > 0) {
            ssFileNameAddon = "." + subSection;
        }
        String variablePart = String.valueOf(paragraph) + ssFileNameAddon;
        URL url = null;
        while (url == null) {
            String file = "guide/otjld/xdef/s" + variablePart + ".html";
            url = OTHelpPlugin.getDefault().getBundle().getEntry(file);
            int lastDot = variablePart.lastIndexOf(46);
            if (lastDot <= -1) break;
            variablePart = variablePart.substring(0, lastDot);
        }
        if (url == null) {
            return null;
        }
        return new OTURL(url);
    }

    public static String getHome() {
        return "guide/otjld/xdef/index.html";
    }

    public static OTURL getHomepageURL() {
        return new OTURL(OTHelpPlugin.getDefault().getBundle().getEntry(OTJLDError.getHome()));
    }

    public static boolean isOTJProblem(String text) {
        return OTLD_MARKER_PATTERN.matcher(text).matches();
    }

    public static class OTURL {
        private URL m_url;
        private String m_anchor;

        private OTURL(URL url) {
            this.m_url = url;
            this.m_anchor = "";
        }

        public OTURL(URL url, String anchor) {
            this.m_url = url;
            this.m_anchor = anchor != null && anchor.length() > 0 ? "#" + anchor : "";
        }

        public String toString() {
            return this.getURL();
        }

        public String getURL() {
            if (OTJLDView.hasBrowser()) {
                return this.getBrowserURL();
            }
            return this.getHelpSystemURL();
        }

        private String getBrowserURL() {
            String result = null;
            try {
                if (!contentInitialized) {
                    FileLocator.toFileURL((URL)OTHelpPlugin.getDefault().getBundle().getEntry(OTJLDError.URL_PATH));
                    FileLocator.toFileURL((URL)OTHelpPlugin.getDefault().getBundle().getEntry(OTJLDError.IMAGES_URL_PATH));
                    FileLocator.toFileURL((URL)OTHelpPlugin.getDefault().getBundle().getEntry(OTJLDError.CSS_URL_PATH));
                    contentInitialized = true;
                }
                result = FileLocator.toFileURL((URL)this.m_url).toString();
                result = String.valueOf(result) + this.m_anchor;
            }
            catch (IOException ex) {
                OTHelpPlugin.logException("Unable to resolve url: + url", ex);
            }
            return result;
        }

        private String getHelpSystemURL() {
            return "/org.eclipse.objectteams.otdt.ui.help" + this.m_url.getPath() + this.m_anchor;
        }
    }
}

