/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.bindingeditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.Messages;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AddTypeBindingDialog
extends FilteredTypesSelectionDialog {
    private boolean _baseRelativeToEnclosingBase = false;
    private IType _baseType;
    private IType _roleType;
    private IType _focusTeam;
    private String _roleTypeName;
    private String _baseTypeName;
    private IType[] _roleTypes;
    private FilteredList _rolList;
    private String _roleNamePattern = "";
    private Button _okButton;
    private IJavaSearchScope _currentSearchScope;

    static AddTypeBindingDialog create(Shell parentshell, IType focusTeam) {
        IJavaSearchScope scope = AddTypeBindingDialog.createSearchScope(focusTeam, true);
        return new AddTypeBindingDialog(parentshell, focusTeam, scope);
    }

    private AddTypeBindingDialog(Shell parentshell, IType focusTeam, IJavaSearchScope scope) {
        super(parentshell, false, null, scope, 0);
        this._currentSearchScope = scope;
        this._focusTeam = focusTeam;
        this.setMessage(OTDTUIPlugin.getResourceString("BindingEditor.AddconnectorDialog.BaseClassSelect.Input.title"));
    }

    protected static IJavaSearchScope createSearchScope(IType type, boolean onlyEnclosingBase) {
        IJavaSearchScope scope = null;
        if (onlyEnclosingBase) {
            IRoleType enclosingRole = null;
            if (type instanceof IRoleType) {
                enclosingRole = (IRoleType)type;
            } else {
                IOTType enclosingType = OTModelManager.getOTElement((IType)type);
                if (enclosingType instanceof IRoleType) {
                    enclosingRole = (IRoleType)enclosingType;
                }
            }
            if (enclosingRole != null) {
                try {
                    IType baseType = enclosingRole.getBaseClass();
                    scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{baseType}, (boolean)false);
                }
                catch (JavaModelException ex) {
                    OTDTUIPlugin.logException("Cannot create enclosing-base-searchscope", ex);
                }
            }
        }
        if (scope == null) {
            scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{type.getJavaProject()}, (boolean)true);
        }
        return scope;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(OTDTUIPlugin.getResourceString("BindingEditor.AddconnectorDialog.title"));
    }

    public Control createDialogArea(Composite parent) {
        Group panes = new Group(parent, 0);
        panes.setLayout((Layout)new GridLayout(2, true));
        panes.setLayoutData((Object)new GridData(4, 4, true, true));
        Group roleTypeGrp = this.createRoleGroup((Composite)panes);
        this.createRoleLabel(roleTypeGrp);
        this.createRoleTypeText(roleTypeGrp);
        this.createRoleListLabel(roleTypeGrp);
        this.createRoleList(roleTypeGrp);
        Group baseTypeGrp = this.createBaseGroup((Composite)panes);
        super.createDialogArea((Composite)baseTypeGrp);
        this.createSrchInEncBaseCheck(baseTypeGrp);
        return panes;
    }

    private Group createRoleGroup(Composite container) {
        Group roleClsGrp = new Group(container, 32);
        roleClsGrp.setText(OTDTUIPlugin.getResourceString("BindingEditor.AddconnectorDialog.RoleClassSelect.title"));
        roleClsGrp.setLayout((Layout)new GridLayout());
        roleClsGrp.setLayoutData((Object)new GridData(1808));
        return roleClsGrp;
    }

    private void createRoleLabel(Group roleTypeGrp) {
        Label rolPatLabel = new Label((Composite)roleTypeGrp, 0);
        rolPatLabel.setLayoutData((Object)new GridData(768));
        rolPatLabel.setText(OTDTUIPlugin.getResourceString("BindingEditor.AddconnectorDialog.RoleClassSelect.Input.title"));
    }

    private void createRoleTypeText(Group roleTypeGrp) {
        final Text result = new Text((Composite)roleTypeGrp, 2048);
        result.setLayoutData((Object)new GridData(768));
        result.setText(this._roleNamePattern == null ? "" : this._roleNamePattern);
        result.addListener(24, new Listener(){

            public void handleEvent(Event evt) {
                AddTypeBindingDialog.this._rolList.setFilter(result.getText());
                AddTypeBindingDialog.this.checkOkButton();
            }
        });
        result.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                if (evt.keyCode == 0x1000002) {
                    AddTypeBindingDialog.this._rolList.setFocus();
                }
            }

            public void keyReleased(KeyEvent evt) {
                AddTypeBindingDialog.this.checkOkButton();
            }
        });
    }

    private void createRoleListLabel(Group roleTypeGrp) {
        Label result = new Label((Composite)roleTypeGrp, 0);
        result.setLayoutData((Object)new GridData(768));
        result.setText(OTDTUIPlugin.getResourceString("BindingEditor.AddconnectorDialog.RoleClassSelect.List.title"));
    }

    private void createRoleList(Group roleGroup) {
        FilteredList result = new FilteredList((Composite)roleGroup, 2048, (ILabelProvider)new LabelProvider(), true, false, true);
        GridData gd = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)result);
        gd.widthHint = converter.convertWidthInCharsToPixels(70);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        result.setLayoutData((Object)gd);
        result.setElements((Object[])this._roleTypes);
        this._rolList = result;
    }

    private Group createBaseGroup(Composite container) {
        Group result = new Group(container, 128);
        result.setText(OTDTUIPlugin.getResourceString("BindingEditor.AddconnectorDialog.BaseClassSelect.title"));
        result.setLayout((Layout)new GridLayout());
        result.setLayoutData((Object)new GridData(1808));
        return result;
    }

    private void createSrchInEncBaseCheck(Group baseTypeGrp) {
        final Button srchInEncBaseCheck = new Button((Composite)baseTypeGrp, 32);
        srchInEncBaseCheck.setText(OTDTUIPlugin.getResourceString("BindingEditor.AddTypeBindingDialog.use_base_as_anchor"));
        srchInEncBaseCheck.setEnabled(false);
        GridData gd = new GridData(768);
        srchInEncBaseCheck.setLayoutData((Object)gd);
        try {
            IType baseclass;
            IOTType teamType = null;
            if (this._focusTeam != null) {
                teamType = OTModelManager.getOTElement((IType)this._focusTeam);
            }
            if (teamType != null && teamType.isRole() && (baseclass = ((IRoleType)teamType).getBaseClass()) != null) {
                srchInEncBaseCheck.setText(org.eclipse.jdt.internal.corext.util.Messages.format((String)OTDTUIPlugin.getResourceString("BindingEditor.AddTypeBindingDialog.use_specified_base_as_anchor"), (Object)baseclass.getElementName()));
                srchInEncBaseCheck.setEnabled(true);
                srchInEncBaseCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        AddTypeBindingDialog.this.showOnlyBaseOfEnclosing(srchInEncBaseCheck.getSelection());
                    }
                });
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void showOnlyBaseOfEnclosing(boolean onlyBase) {
        this._currentSearchScope = AddTypeBindingDialog.createSearchScope(this._focusTeam, onlyBase);
        this._baseRelativeToEnclosingBase = onlyBase;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this._okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this._okButton.setEnabled(false);
    }

    private void checkOkButton() {
        if (this._rolList.isEmpty() || this._rolList.getSelectionIndex() == -1) {
            this._okButton.setEnabled(false);
        } else {
            this._okButton.setEnabled(true);
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (!this._rolList.isEmpty()) {
            super.updateButtonsEnableState(status);
        }
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        this.checkOkButton();
    }

    protected void handleDoubleClick() {
    }

    public int open() {
        this.computeRoles();
        if (this._roleTypes == null || this._roleTypes.length == 0) {
            String title = Messages.AddTypeBindingDialog_role_selection_title;
            String message = Messages.AddTypeBindingDialog_no_roles_available_error;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return 1;
        }
        return super.open();
    }

    private void computeRoles() {
        IOTType teamType = null;
        if (this._focusTeam != null) {
            teamType = OTModelManager.getOTElement((IType)this._focusTeam);
            IType[] roles = null;
            try {
                roles = teamType.getRoleTypes(15);
                IType javaTeam = (IType)teamType.getCorrespondingJavaElement();
                IType[] relevant = new IType[roles.length];
                int j = 0;
                IType[] iTypeArray = roles;
                int n = roles.length;
                int n2 = 0;
                while (n2 < n) {
                    IType declaringTeam;
                    IType role = iTypeArray[n2];
                    IOTType roleType = OTModelManager.getOTElement((IType)role);
                    if (roleType.isRole() && (((IRoleType)roleType).getBaseClass() != null || (declaringTeam = roleType.getDeclaringType()) != javaTeam)) {
                        relevant[j++] = role;
                    }
                    ++n2;
                }
                if (j == 0) {
                    return;
                }
                if (j < roles.length) {
                    roles = new IType[j];
                    System.arraycopy(relevant, 0, roles, 0, j);
                }
            }
            catch (JavaModelException javaModelException) {
                String title = org.eclipse.jdt.internal.corext.util.Messages.format((String)OTDTUIPlugin.getResourceString("BindingEditor.generic_error_in_dialog"), (Object)OTDTUIPlugin.getResourceString("BindingEditor.AddconnectorDialog.title"));
                String message = org.eclipse.jdt.internal.corext.util.Messages.format((String)OTDTUIPlugin.getResourceString("BindingEditor.AddTypeBindingDialog.error_retrieving_roles"), (Object)this._focusTeam.getFullyQualifiedName());
                MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                this.buttonPressed(1);
            }
            this._roleTypes = AddTypeBindingDialog.replaceITypesWithOTTypes(roles);
        }
    }

    private static IType[] replaceITypesWithOTTypes(IType[] types) {
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            type.exists();
            IOTType otType = OTModelManager.getOTElement((IType)type);
            if (otType != null) {
                types[i] = otType;
            }
            ++i;
        }
        return types;
    }

    protected void computeResult() {
    }

    protected void okPressed() {
        if (this._rolList.isEmpty() || this.getResult()[0] == null) {
            this.checkOkButton();
            String title = org.eclipse.jdt.internal.corext.util.Messages.format((String)OTDTUIPlugin.getResourceString("BindingEditor.generic_error_in_dialog"), (Object)OTDTUIPlugin.getResourceString("BindingEditor.AddconnectorDialog.title"));
            String message = OTDTUIPlugin.getResourceString("BindingEditor.AddTypeBindingDialog.missing_class");
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else {
            this.computeResult();
            this._baseType = (IType)super.getFirstResult();
            this._baseTypeName = this._baseType.getFullyQualifiedName();
            this._roleType = (IType)this._rolList.getSelection()[0];
            this._roleTypeName = this._roleType.getFullyQualifiedName();
            this.setReturnCode(0);
            this.close();
        }
    }

    public IType getBaseType() {
        return this._baseType;
    }

    public String getBaseTypeName() {
        if (this._baseRelativeToEnclosingBase) {
            return "base." + this._baseType.getElementName();
        }
        return this._baseTypeName;
    }

    public IType getRoleType() {
        return this._roleType;
    }

    public String getRoleTypeName() {
        return this._roleTypeName;
    }

    public class LabelProvider
    extends WorkbenchLabelProvider
    implements ITableLabelProvider {
        protected String decorateText(String input, Object element) {
            IType role = (IType)element;
            String name = role.getTypeQualifiedName().replace('$', '.');
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return null;
        }
    }
}

