/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.templates;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.ICalloutMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IMethodSpec;

public class ParameterMappingTemplateResolver
extends TemplateVariableResolver {
    private static final String CALLIN_PARAMETER_NAME = "callin_parameter_name";
    private static final String CALLOUT_PARAMETER_NAME = "callout_parameter_name";
    private static final String VOID = "V";
    private static final String RESULT = "result";
    private static final String NOT_APPLICABLE = "$not applicable$";

    public void resolve(TemplateVariable variable, TemplateContext context) {
        IMethodMapping methodMapping;
        if (context instanceof JavaContext && (methodMapping = this.findEnclosingMethodMapping((JavaContext)context)) != null) {
            variable.setValue(NOT_APPLICABLE);
            String[] argumentNames = null;
            if (!methodMapping.hasSignature()) {
                return;
            }
            if (this.getType().equals(CALLIN_PARAMETER_NAME) && methodMapping.getElementType() == 102) {
                IMethodSpec method = methodMapping.getRoleMethodHandle();
                argumentNames = method.getArgumentNames();
            } else if (this.getType().equals(CALLOUT_PARAMETER_NAME) && methodMapping.getElementType() == 103) {
                IMethodSpec method = ((ICalloutMapping)methodMapping).getBaseMethodHandle();
                argumentNames = method.getArgumentNames();
            } else {
                if (this.isResultMappingSupported(methodMapping)) {
                    variable.setValue(RESULT);
                } else {
                    variable.setResolved(false);
                }
                return;
            }
            if (argumentNames != null && argumentNames.length > 0) {
                variable.setValues(argumentNames);
            } else {
                variable.setResolved(false);
            }
        }
    }

    private IMethodMapping findEnclosingMethodMapping(JavaContext jContext) {
        IJavaElement callinMapping = jContext.findEnclosingElement(102);
        if (callinMapping != null) {
            return (IMethodMapping)callinMapping;
        }
        return (IMethodMapping)jContext.findEnclosingElement(103);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isResultMappingSupported(IMethodMapping element) {
        if (element.getElementType() == 103) {
            if (!element.getRoleMethodHandle().getReturnType().equals(VOID)) return true;
            return false;
        }
        if (element.getElementType() != 102) return false;
        if (((ICallinMapping)element).getCallinKind() != 3) {
            return false;
        }
        try {
            IMethod[] iMethodArray = ((ICallinMapping)element).getBoundBaseMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IMethod boundBaseMethod = iMethodArray[n2];
                if (boundBaseMethod.getReturnType().equals(VOID)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

