/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.wizards.NewTeamWizardPage;
import org.eclipse.objectteams.otdt.internal.ui.wizards.NewTypeWizardPage;
import org.eclipse.objectteams.otdt.internal.ui.wizards.typecreation.TypeCreator;
import org.eclipse.objectteams.otdt.internal.ui.wizards.typecreation.TypeInfo;

public abstract class NewTypeCreationWizard
extends NewElementWizard {
    private IType _createdType;

    public boolean performFinish() {
        this.warnAboutTypeCommentDeprecation();
        return super.performFinish();
    }

    protected boolean canRunForked() {
        return false;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        ICompilationUnit cu;
        TypeCreator creator = this.createTypeCreator();
        this.setTypeData(creator);
        IType createdType = creator.createType(monitor);
        ICompilationUnit createdCompUnit = createdType.getCompilationUnit();
        ICompilationUnit iCompilationUnit = cu = createdCompUnit == null ? null : createdCompUnit.getPrimary();
        if (cu != null) {
            IResource resource = cu.getResource();
            this.selectAndReveal(resource);
            this.openResource((IFile)resource);
            this._createdType = cu.getType(createdType.getElementName());
        }
    }

    public IType getCreatedType() {
        return this._createdType;
    }

    protected abstract NewTypeWizardPage getPage();

    protected abstract TypeCreator createTypeCreator();

    protected TypeInfo createTypeInfo() {
        NewTypeWizardPage page = this.getPage();
        return new TypeInfo(page.getTypeName(), page.getPackageFragmentRoot(), page.getPackageFragment());
    }

    protected TypeInfo setTypeData(TypeCreator creator) {
        NewTypeWizardPage page = this.getPage();
        TypeInfo typeInfo = this.createTypeInfo();
        typeInfo.setEnclosingTypeName(page.getEnclosingTypeName());
        typeInfo.setSuperClassName(page.getSuperTypeName());
        typeInfo.setSuperInterfacesNames(page.getSuperInterfaces());
        typeInfo.setModifier(page.getModifiers());
        typeInfo.setCurrentType(page.getCurrentType());
        if (page instanceof NewTeamWizardPage) {
            IOTType enclosingOTType;
            IType enclosingType = page.getEnclosingType();
            if (enclosingType != null && enclosingType.exists() && (enclosingOTType = OTModelManager.getOTElement((IType)enclosingType)) != null) {
                typeInfo.setIsRole(true);
            }
        } else {
            typeInfo.setIsRole(true);
        }
        typeInfo.setInline(page.isInlineTypeSelected());
        typeInfo.setCreateMainMethod(page.isCreateMainSelected());
        typeInfo.setCreateConstructor(page.isCreateConstructorsSelected());
        typeInfo.setCreateAbstractInheritedMethods(page.isCreateInheritedSelected());
        creator.setTypeInfo(typeInfo);
        return typeInfo;
    }

    public IJavaElement getCreatedElement() {
        return this._createdType;
    }
}

