/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.wizards.listeners;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.wizards.NewRoleWizardPage;
import org.eclipse.objectteams.otdt.internal.ui.wizards.NewTypeWizardPage;
import org.eclipse.objectteams.otdt.internal.ui.wizards.OTNewWizardMessages;
import org.eclipse.objectteams.otdt.internal.ui.wizards.listeners.NewTypeWizardPageListener;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NewRoleWizardPageListener
extends NewTypeWizardPageListener {
    protected static final int BASE = 20;
    private IStatus _baseStatus = new StatusInfo();
    private IType[] fSuperTeams = null;

    public NewRoleWizardPageListener(NewTypeWizardPage observedPage) {
        super(observedPage);
    }

    protected int getChangedElement(DialogField field) {
        NewRoleWizardPage page;
        if (this.getObservedPage() instanceof NewRoleWizardPage && field == (page = (NewRoleWizardPage)this.getObservedPage()).getBaseClassDialogField()) {
            return 20;
        }
        return super.getChangedElement(field);
    }

    protected void performReviews(int change) {
        super.performReviews(change);
        if (change == 1 || change == 2 || change == 3 || change == 20 || change == 4) {
            this._baseStatus = this.validateBaseClass();
            this.handleImplicitSuperclassDialogField();
        }
    }

    protected void handleChangeControlPressed(DialogField field) {
        if (!(this.getObservedPage() instanceof NewRoleWizardPage)) {
            return;
        }
        NewRoleWizardPage page = (NewRoleWizardPage)this.getObservedPage();
        if (field == page.getBaseClassDialogField()) {
            IType type = this.chooseBaseType();
            if (type != null) {
                String str = type.getFullyQualifiedName('.');
                page.setBaseClassName(str);
            }
        } else {
            super.handleChangeControlPressed(field);
        }
    }

    protected IStatus validateTypeName() {
        IStatus superStatus = super.validateTypeName();
        if (superStatus.getSeverity() == 4) {
            return superStatus;
        }
        NewRoleWizardPage page = (NewRoleWizardPage)this.getObservedPage();
        String enclosingTypeName = page.getEnclosingTypeName();
        enclosingTypeName = enclosingTypeName.substring(enclosingTypeName.lastIndexOf(46) + 1);
        String simpleRoleName = page.getTypeName();
        if (simpleRoleName.equals(enclosingTypeName)) {
            StatusInfo status = new StatusInfo();
            status.setError(OTNewWizardMessages.NewRole_role_hides_team);
            return status;
        }
        return superStatus;
    }

    protected IType chooseEnclosingType() {
        IPackageFragmentRoot root = this.getObservedPage().getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        return NewRoleWizardPageListener.chooseTeam((IJavaElement)root, this.getObservedPage().getShell(), this.getObservedPage().getWizard().getContainer(), OTNewWizardMessages.NewRoleWizardPage_ChooseEnclosingTypeDialog_title, OTNewWizardMessages.NewRoleWizardPage_ChooseEnclosingTypeDialog_description, Signature.getSimpleName((String)this.getObservedPage().getEnclosingTypeName()));
    }

    protected IType chooseSuperType() {
        IPackageFragmentRoot root = this.getObservedPage().getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root.getJavaProject()});
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getObservedPage().getShell(), false, (IRunnableContext)this.getObservedPage().getWizard().getContainer(), scope, 5);
        dialog.setTitle(OTNewWizardMessages.NewRoleWizardPage_SuperclassDialog_title);
        dialog.setMessage(OTNewWizardMessages.NewRoleWizardPage_SuperclassDialog_message);
        dialog.setInitialPattern(this.getObservedPage().getSuperTypeName());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private IType chooseBaseType() {
        IPackageFragmentRoot root = this.getObservedPage().getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root.getJavaProject()});
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getObservedPage().getShell(), false, (IRunnableContext)this.getObservedPage().getWizard().getContainer(), scope, 0);
        dialog.setTitle(OTNewWizardMessages.NewRoleWizardPage_BaseclassDialog_title);
        dialog.setMessage(OTNewWizardMessages.NewRoleWizardPage_BaseclassDialog_message);
        dialog.setInitialPattern(((NewRoleWizardPage)this.getObservedPage()).getBaseClassName());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IType) {
                    return NewRoleWizardPageListener.this.validateBaseClassName(NewRoleWizardPageListener.this.getObservedPage().getEnclosingType(), ((IType)selection[0]).getElementName());
                }
                return StatusInfo.OK_STATUS;
            }
        });
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void handleEnclosingTypeDialogFieldIsEmpty(StatusInfo status) {
        status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeEnterName);
    }

    protected IStatus validateEnclosingType() {
        IStatus status = super.validateEnclosingType();
        if (status.isOK()) {
            this.cacheSuperTeams();
        }
        return status;
    }

    private void cacheSuperTeams() {
        try {
            IType enclosingType = this.getObservedPage().getEnclosingType();
            ITypeHierarchy hierarchy = enclosingType.newSupertypeHierarchy(null);
            this.fSuperTeams = hierarchy.getAllSuperclasses(enclosingType);
        }
        catch (JavaModelException ex) {
            OTDTUIPlugin.logException("Problems creating supertype hierarchy", ex);
        }
    }

    public IStatus[] getRelevantStates(boolean ignoreFirstField) {
        if (ignoreFirstField) {
            return new IStatus[]{this.getObservedPage().getContainerStatus(), this._packageStatus, this._enclosingTeamStatus, this._baseStatus, this._modifierStatus, this._superTypeStatus, this._superInterfacesStatus};
        }
        return new IStatus[]{this.getObservedPage().getContainerStatus(), this._packageStatus, this._enclosingTeamStatus, this._typeNameStatus, this._baseStatus, this._modifierStatus, this._superTypeStatus, this._superInterfacesStatus};
    }

    private void handleImplicitSuperclassDialogField() {
        if (!(this.getObservedPage() instanceof NewRoleWizardPage)) {
            return;
        }
        NewRoleWizardPage page = (NewRoleWizardPage)this.getObservedPage();
        page.setImplicitSuperclassName("");
        if (this.hasTypeNameError()) {
            return;
        }
        IType enclosingTeam = page.getEnclosingType();
        if (enclosingTeam != null) {
            if (this.fSuperTeams == null) {
                this.cacheSuperTeams();
            }
            int idx = 0;
            while (idx < this.fSuperTeams.length) {
                IType memberType = this.fSuperTeams[idx].getType(page.getTypeName());
                IOTType otType = OTModelManager.getOTElement((IType)memberType);
                if (otType != null && otType instanceof IRoleType) {
                    String fullQualName = memberType.getFullyQualifiedName('.');
                    page.setImplicitSuperclassName(fullQualName);
                    return;
                }
                ++idx;
            }
        }
    }

    private boolean hasTypeNameError() {
        IStatus[] stati = new IStatus[]{this.getObservedPage().getContainerStatus(), this._packageStatus, this._enclosingTeamStatus, this._typeNameStatus};
        return this.hasErrorStatus(stati);
    }

    private IStatus validateBaseClass() {
        NewRoleWizardPage page = (NewRoleWizardPage)this.getObservedPage();
        String baseclassName = page.getBaseClassName();
        if (baseclassName.length() == 0) {
            return StatusInfo.OK_STATUS;
        }
        IStatus validJava = JavaConventions.validateJavaTypeName((String)baseclassName);
        if (validJava.getSeverity() == 4) {
            return new StatusInfo(4, Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, (Object)validJava.getMessage()));
        }
        IType enclosingType = this.getObservedPage().getEnclosingType();
        IStatus status = this.validateBaseClassName(enclosingType, baseclassName);
        if (!status.isOK()) {
            return status;
        }
        if (validJava.getSeverity() == 2) {
            return new StatusInfo(2, Messages.format((String)NewWizardMessages.NewTypeWizardPage_warning_TypeNameDiscouraged, (Object)validJava.getMessage()));
        }
        return StatusInfo.OK_STATUS;
    }

    IStatus validateBaseClassName(IType enclosingType, String name) {
        while (enclosingType != null) {
            if (name.equals(enclosingType.getElementName())) {
                return new StatusInfo(4, Messages.format((String)OTNewWizardMessages.NewRole_base_class_equals_enclosing, (Object)name));
            }
            try {
                IJavaElement[] iJavaElementArray = enclosingType.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement member = iJavaElementArray[n2];
                    if (member.getElementType() == 101 && member.getElementName().equals(name)) {
                        return new StatusInfo(4, Messages.format((String)OTNewWizardMessages.NewRole_base_class_equals_member, (Object)name));
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
            enclosingType = enclosingType.getDeclaringType();
        }
        return StatusInfo.OK_STATUS;
    }
}

