/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleFileType;
import org.eclipse.objectteams.otdt.core.OTModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Object[] NO_OBJECTS = new Object[0];

    public static Object[] replaceOTTypes(Object[] types) {
        return Util.replaceOTTypes(types, false);
    }

    public static Object[] replaceOTTypes(Object[] types, boolean lazyCopy) {
        if (types == null) {
            return NO_OBJECTS;
        }
        boolean needCopy = lazyCopy;
        int idx = 0;
        while (idx < types.length) {
            IOTType otElement;
            Object curChild = types[idx];
            if (curChild instanceof IType && (otElement = OTModelManager.getOTElement((IType)((IType)curChild))) != null) {
                int len;
                try {
                    if (needCopy) {
                        len = types.length;
                        Object[] objectArray = types;
                        types = new IJavaElement[len];
                        System.arraycopy(objectArray, 0, types, 0, len);
                        needCopy = false;
                    }
                    types[idx] = otElement;
                }
                catch (ArrayStoreException arrayStoreException) {
                    len = types.length;
                    Object[] objectArray = types;
                    types = new IJavaElement[len];
                    System.arraycopy(objectArray, 0, types, 0, len);
                    types[idx] = otElement;
                }
            }
            ++idx;
        }
        return types;
    }

    public static List<Object> removeExternalDefinedRoles(Object[] types) {
        ArrayList<Object> result = new ArrayList<Object>(types.length);
        int idx = 0;
        while (idx < types.length) {
            Object curChild = types[idx];
            if (curChild != null && !(curChild instanceof IRoleFileType)) {
                result.add(curChild);
            }
            ++idx;
        }
        return result;
    }

    public static List<Object> filterOTGenerated(List<Object> children) {
        ArrayList<Object> result = new ArrayList<Object>(children.size());
        for (Object elem : children) {
            if (elem instanceof IJavaElement && Util.isGenerated((IJavaElement)elem)) continue;
            result.add(elem);
        }
        return result;
    }

    public static Object[] filterOTGenerated(Object[] children) {
        if (children == null) {
            return children;
        }
        ArrayList<Object> result = new ArrayList<Object>(children.length);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            if (!(elem instanceof IJavaElement) || !Util.isGenerated((IJavaElement)elem)) {
                result.add(elem);
            }
            ++n2;
        }
        return result.toArray();
    }

    public static boolean isGenerated(IJavaElement elem) {
        String name = elem.getElementName();
        String[] patterns = new String[]{"_OT$", "TSuper__OT__", "class$", "access$", "val$", "this$"};
        int i = 0;
        while (i < patterns.length) {
            if (name.indexOf(patterns[i]) >= 0) {
                return true;
            }
            ++i;
        }
        switch (elem.getElementType()) {
            case 7: 
            case 101: {
                String[] fullPatterns = new String[]{"IConfined", "Confined", "__OT__Confined", "ILowerable"};
                int i2 = 0;
                while (i2 < fullPatterns.length) {
                    if (name.equals(fullPatterns[i2])) {
                        return true;
                    }
                    ++i2;
                }
                break;
            }
            case 9: {
                String lastType;
                IMethod method = (IMethod)elem;
                String[] paramTypes = method.getParameterTypes();
                if (paramTypes.length <= 0 || !(lastType = Signature.getSimpleName((String)Signature.toString((String)paramTypes[paramTypes.length - 1]))).startsWith("TSuper__OT__")) break;
                return true;
            }
        }
        if (elem.getElementType() == 101) {
            IType type = (IType)elem;
            try {
                if (Flags.isSynthetic((int)type.getFlags())) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }
}

