/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHelper {
    private AnnotationModel fAnnotationModel;

    public AnnotationHelper(IEditorPart targetEditor, IEditorInput editorInput) {
        ITextEditor textEditor = (ITextEditor)targetEditor.getAdapter(ITextEditor.class);
        if (textEditor != null) {
            IDocumentProvider provider = textEditor.getDocumentProvider();
            this.fAnnotationModel = (AnnotationModel)provider.getAnnotationModel((Object)editorInput);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    <M> void removeSomeWarnings(IResource resource, ISourceRange nameRange) throws CoreException {
        if (this.fAnnotationModel == null) {
            return;
        }
        JavaAnnotationIterator annotationIterator = new JavaAnnotationIterator(this.fAnnotationModel.getAnnotationIterator(nameRange.getOffset(), nameRange.getLength(), false, true), false);
        boolean needRemoveMarker = false;
        block6: while (annotationIterator.hasNext()) {
            IJavaAnnotation javaAnnot;
            Object next = annotationIterator.next();
            if (!(next instanceof IJavaAnnotation) || !(javaAnnot = (IJavaAnnotation)next).isProblem() && !AnnotationHelper.isProblemMarkerAnnotation(javaAnnot)) continue;
            switch (javaAnnot.getId()) {
                case 570425421: 
                case 603979894: {
                    this.fAnnotationModel.removeAnnotation((Annotation)javaAnnot);
                    if (javaAnnot instanceof MarkerAnnotation) {
                        ((MarkerAnnotation)javaAnnot).getMarker().delete();
                        break block6;
                    }
                    needRemoveMarker = true;
                    break block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        if (!needRemoveMarker) {
            return;
        }
        IMarker[] problems = resource.findMarkers("org.eclipse.jdt.core.problem", true, 0);
        if (problems == null) return;
        IMarker[] iMarkerArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker problem = iMarkerArray[n2];
            int problemStart = problem.getAttribute("charStart", -1);
            if (problemStart >= nameRange.getOffset() && problemStart < nameRange.getOffset() + nameRange.getLength()) {
                switch (problem.getAttribute("id", -1)) {
                    case 570425421: 
                    case 603979894: {
                        problem.delete();
                        return;
                    }
                }
            }
            ++n2;
        }
    }

    private static boolean isProblemMarkerAnnotation(IJavaAnnotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

