/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.AbstractMarkable;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarkerRemover;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.MySubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaElementMarkable
extends AbstractMarkable {
    IClassFile fJavaElement;

    public JavaElementMarkable(IClassFile javaElement) {
        this.fJavaElement = javaElement;
    }

    @Override
    public String getName() {
        return this.fJavaElement.getElementName();
    }

    @Override
    public Set<IType> getAllTypes(IJavaProject[] projects, IProgressMonitor monitor) throws JavaModelException {
        HashSet<IType> result = new HashSet<IType>(13);
        IType type = this.fJavaElement.getType();
        HashSet<IType> members = new HashSet<IType>(5);
        HashSet<IType> supers = new HashSet<IType>(5);
        members.add(type);
        this.addSuperAndMemberTypes(members, supers, type, this.fJavaElement.getJavaProject(), projects, monitor);
        result.addAll(members);
        result.addAll(supers);
        monitor.worked(5);
        result.addAll(this.getSubTypes(members, (IProgressMonitor)new MySubProgressMonitor(monitor, 5)));
        monitor.done();
        return result;
    }

    @Override
    public void removeCallinMarkers() throws CoreException {
        CallinMarkerRemover.removeCallinMarkers(this.fJavaElement);
    }

    public IClassFile getJavaElement() {
        return this.fJavaElement;
    }

    @Override
    public IResource getResource() {
        return this.fJavaElement.getResource();
    }

    @Override
    boolean containsElement(IJavaElement element) {
        IJavaElement current = element;
        while (current != null) {
            if (current == this.fJavaElement) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    @Override
    public boolean exists() {
        return this.fJavaElement.exists();
    }

    @Override
    IJavaProject[] getProjects() throws JavaModelException {
        return this.getProjects(this.fJavaElement.getCorrespondingResource());
    }

    @Override
    public IMarker createMarker(String id) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMarker marker = root.createMarker(id);
        ((JavaCore)JavaCore.getPlugin()).configureJavaElementMarker(marker, (IJavaElement)this.fJavaElement);
        return marker;
    }
}

