/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal.hook;

public class ByteCodeAnalyzer {
    static final int AccTeam = 32768;
    static final int Utf8Tag = 1;
    static final int LongTag = 5;
    static final int DoubleTag = 6;
    static final int[] CPEntryLengths;

    static {
        int[] nArray = new int[13];
        nArray[1] = 3;
        nArray[3] = 5;
        nArray[4] = 5;
        nArray[5] = 9;
        nArray[6] = 9;
        nArray[7] = 3;
        nArray[8] = 3;
        nArray[9] = 5;
        nArray[10] = 5;
        nArray[11] = 5;
        nArray[12] = 5;
        CPEntryLengths = nArray;
    }

    static boolean isTeam(byte[] classbytes) {
        int constantPoolCount = ByteCodeAnalyzer.combineTwoBytes(classbytes, 8);
        int readOffset = 10;
        int i = 1;
        while (i < constantPoolCount) {
            byte tag = classbytes[readOffset];
            if (tag == 1) {
                readOffset += ByteCodeAnalyzer.combineTwoBytes(classbytes, readOffset + 1);
            }
            if (tag < CPEntryLengths.length) {
                readOffset += CPEntryLengths[tag];
            } else {
                throw new RuntimeException("bad tag?");
            }
            if (tag == 6 || tag == 5) {
                ++i;
            }
            ++i;
        }
        int classFlags = ByteCodeAnalyzer.combineTwoBytes(classbytes, readOffset);
        return (classFlags & 0x8000) != 0;
    }

    static int combineTwoBytes(byte[] bytes, int start) {
        byte first = bytes[start];
        byte second = bytes[start + 1];
        int twoBytes = 0;
        twoBytes |= first & 0xFF;
        twoBytes <<= 8;
        return twoBytes |= second & 0xFF;
    }
}

