/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal.hook;

import java.util.HashSet;
import org.eclipse.objectteams.otequinox.hook.IAspectRegistry;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.eclipse.objectteams.otequinox.hook.IOTEquinoxService;
import org.eclipse.objectteams.otequinox.internal.hook.TransformerHook;
import org.eclipse.objectteams.otequinox.internal.hook.Util;
import org.osgi.framework.Bundle;

public class SafeAspectRegistry
implements IAspectRegistry {
    private TransformerHook hook;
    private IOTEquinoxService otEquinox;
    private HashSet<String> nonAdaptableBundles = new HashSet();

    SafeAspectRegistry(TransformerHook hook) {
        this.hook = hook;
    }

    void connectOTEquinoxService(IOTEquinoxService otEquinoxService, ILogger log) {
        this.otEquinox = otEquinoxService;
        for (String bundle : this.nonAdaptableBundles) {
            if (!otEquinoxService.isAdaptedBasePlugin(bundle)) continue;
            log.log(4, "Trying to adapt non-adaptable platform bundle " + bundle);
        }
    }

    public boolean isOTDT() {
        return this.otEquinox != null && this.otEquinox.isOTDT();
    }

    public boolean isAdaptedBasePlugin(String baseBundleName) {
        InitState state = this.checkInitialization(baseBundleName);
        if (state == InitState.NOT_YET) {
            return false;
        }
        boolean result = this.otEquinox.isAdaptedBasePlugin(baseBundleName);
        if (!result) {
            return false;
        }
        if (state == InitState.TOO_LATE) {
            throw new RuntimeException("Boot order problem: base bundle " + baseBundleName + " was loaded before the transformer plug-in was ready!");
        }
        return result;
    }

    public String[] getAdaptingAspectPlugins(Bundle baseBundle) {
        InitState state = this.checkInitialization(baseBundle.getSymbolicName());
        if (state == InitState.NOT_YET) {
            return new String[0];
        }
        String[] result = this.otEquinox.getAdaptingAspectPlugins(baseBundle);
        if (result.length > 0 && state == InitState.TOO_LATE) {
            throw new RuntimeException("Boot order problem: base bundle " + baseBundle.getSymbolicName() + " was loaded before the transformer plug-in was ready!");
        }
        return result;
    }

    public String[] getAdaptedBasePlugins(Bundle aspectBundle) {
        if (aspectBundle == this.hook.otEquinoxBundle) {
            return null;
        }
        if (this.otEquinox == null) {
            return null;
        }
        return this.otEquinox.getAdaptedBasePlugins(aspectBundle);
    }

    public boolean hasInternalTeams(Bundle baseBundle) {
        if (this.otEquinox == null) {
            return false;
        }
        return this.otEquinox.hasInternalTeams(baseBundle);
    }

    private InitState checkInitialization(String baseBundle) {
        if (this.nonAdaptableBundles.contains(baseBundle)) {
            if (this.otEquinox == null) {
                return InitState.NOT_YET;
            }
            return InitState.TOO_LATE;
        }
        if (this.otEquinox == null) {
            if (!Util.isPlatformBundle(baseBundle)) {
                System.err.println("Accessing non-adaptable element " + baseBundle);
            }
            this.nonAdaptableBundles.add(baseBundle);
            return InitState.NOT_YET;
        }
        return InitState.OK;
    }

    public boolean isDeniedAspectPlugin(String symbolicName) {
        if (this.otEquinox != null) {
            return this.otEquinox.isDeniedAspectPlugin(symbolicName);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InitState {
        OK,
        NOT_YET,
        TOO_LATE;

    }
}

