/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.BindingComparator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IMethodMappingBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.objectteams.otdt.core.compiler.InferenceKind;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;

class MethodMappingBinding
implements IMethodMappingBinding {
    private CallinCalloutBinding _binding;
    private BindingResolver _resolver;
    private String _name;
    private ITypeBinding _declaringClass;
    private ITypeBinding _baseClass;
    private IMethodBinding _roleMethod;
    private IMethodBinding[] _baseMethods;
    private IAnnotationBinding[] annotations;

    MethodMappingBinding(BindingResolver resolver, CallinCalloutBinding binding) {
        this._resolver = resolver;
        this._binding = binding;
    }

    public String getName() {
        if (this._name == null) {
            this._name = new String(this._binding.readableName());
        }
        return this._name;
    }

    public ITypeBinding getDeclaringRoleClass() {
        if (this._declaringClass == null) {
            this._declaringClass = this._resolver.getTypeBinding(this._binding._declaringRoleClass);
        }
        return this._declaringClass;
    }

    public ITypeBinding getReferencedBaseClass() {
        if (this._baseClass == null) {
            this._baseClass = this._resolver.getTypeBinding(this._binding._declaringRoleClass.baseclass());
        }
        return this._baseClass;
    }

    public IMethodBinding getRoleMethod() {
        if (this._roleMethod == null) {
            this._roleMethod = this._resolver.getMethodBinding(this._binding._roleMethodBinding);
        }
        return this._roleMethod;
    }

    public IMethodBinding[] getBaseMethods() {
        if (this._baseMethods == null) {
            MethodBinding[] methodBindings = this._binding._baseMethods;
            if (methodBindings == null) {
                return new IMethodBinding[0];
            }
            this._baseMethods = new IMethodBinding[methodBindings.length];
            int i = 0;
            while (i < methodBindings.length) {
                this._baseMethods[i] = this._resolver.getMethodBinding(methodBindings[i]);
                ++i;
            }
        }
        return this._baseMethods;
    }

    public String[] getBaseArgumentNames() {
        MethodBinding[] methodBindings = this._binding._baseMethods;
        if (methodBindings != null && methodBindings.length > 0) {
            Argument[] args;
            String[] result = new String[methodBindings[0].parameters.length];
            AbstractMethodDeclaration methodDecl = methodBindings[0].sourceMethod();
            if (methodDecl != null && (args = methodDecl.arguments) != null) {
                int i = 0;
                while (i < args.length) {
                    result[i] = String.valueOf(args[i].name);
                    ++i;
                }
                return result;
            }
            int i = 0;
            while (i < result.length) {
                result[i] = "arg" + i;
                ++i;
            }
            return result;
        }
        return new String[0];
    }

    public int getKind() {
        return 7;
    }

    public int getModifiers() {
        if (this._binding.type == 1) {
            switch (this._binding.callinModifier) {
                case 122: {
                    return 16384;
                }
                case 119: {
                    return 65536;
                }
                case 121: {
                    return 4096;
                }
            }
            return 0;
        }
        return 0;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isCallin() {
        return this._binding.isCallin();
    }

    public String getKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDeclaringRoleClass().getKey());
        buffer.append('/');
        buffer.append(this.getName());
        buffer.append(')');
        return buffer.toString();
    }

    public String toString() {
        return this._binding.toString();
    }

    public IJavaElement getJavaElement() {
        return null;
    }

    public boolean isEqualTo(IBinding other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MethodMappingBinding)) {
            return !this.isCallin() && this.getRoleMethod().isEqualTo(other);
        }
        CallinCalloutBinding otherBinding = ((MethodMappingBinding)other)._binding;
        return BindingComparator.isEqual(this._binding, otherBinding);
    }

    public IAnnotationBinding[] getAnnotations() {
        int length;
        if (this.annotations != null) {
            return this.annotations;
        }
        org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] annots = this._binding.getAnnotations();
        int n = length = annots == null ? 0 : annots.length;
        if (annots == null) {
            this.annotations = AnnotationBinding.NoAnnotations;
            return AnnotationBinding.NoAnnotations;
        }
        IAnnotationBinding[] domInstances = new AnnotationBinding[length];
        int i = 0;
        while (i < length) {
            IAnnotationBinding annotationInstance = this._resolver.getAnnotationInstance(annots[i]);
            if (annotationInstance == null) {
                this.annotations = AnnotationBinding.NoAnnotations;
                return AnnotationBinding.NoAnnotations;
            }
            domInstances[i] = annotationInstance;
            ++i;
        }
        this.annotations = domInstances;
        return domInstances;
    }

    public boolean isRecovered() {
        return false;
    }

    public InferenceKind getInferenceKind() {
        if (this._binding != null) {
            return this._binding.inferred;
        }
        return InferenceKind.NONE;
    }
}

