/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.GuardPredicateDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ParameterMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ResultReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class CallinMappingDeclaration
extends AbstractMethodMappingDeclaration {
    public int callinModifier;
    public char[] name;
    public MethodSpec[] baseMethodSpecs;
    public Map<ReferenceBinding, Integer> rolesWithLiftingProblem;
    public TypeBinding realRoleReturn = null;
    public MethodBinding liftMethod;
    public MethodDeclaration[] wrappers;
    public GuardPredicateDeclaration predicate = null;
    private MethodSpec baseMethodNeedingResultFromBasecall = null;
    public boolean isResultMapped = false;

    public MethodSpec[] getBaseMethodSpecs() {
        return this.baseMethodSpecs;
    }

    public int baseDeclarationSourceStart() {
        if (this.baseMethodSpecs == null || this.baseMethodSpecs.length == 0) {
            return this.declarationSourceEnd + 1;
        }
        MethodSpec baseMethod = this.baseMethodSpecs[0];
        if (baseMethod.returnType != null) {
            return baseMethod.returnType.sourceStart;
        }
        return baseMethod.declarationSourceStart;
    }

    public void checkAddBasemethodSpec(MethodSpec baseSpec) {
        if (this.baseMethodSpecs == null || this.baseMethodSpecs.length == 0) {
            this.baseMethodSpecs = new MethodSpec[]{baseSpec};
        }
    }

    public boolean canAccessInvisibleBase() {
        return true;
    }

    public CallinMappingDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void resolveMethodSpecs(RoleModel role, ReferenceBinding baseType, boolean resolveBaseMethods) {
        super.resolveMethodSpecs(role, baseType, resolveBaseMethods);
        if (this.roleMethodSpec.isValid() && this.roleMethodSpec.isStatic() && this.predicate != null) {
            this.makeMethodStatic(this.predicate);
        }
        if (!resolveBaseMethods) {
            return;
        }
        MethodBinding[] baseMethods = new MethodBinding[this.baseMethodSpecs.length];
        int i = 0;
        while (i < this.baseMethodSpecs.length) {
            if (this.baseMethodSpecs[i].resolvedMethod != null) {
                baseMethods[i] = this.baseMethodSpecs[i].resolvedMethod;
                if (this.isDangerousMethod(baseMethods[i])) {
                    this.scope.problemReporter().dangerousCallinBinding(this.baseMethodSpecs[i]);
                }
            } else {
                MethodSpec spec = this.baseMethodSpecs[i];
                baseMethods[i] = new ProblemMethodBinding(spec.selector, null, baseType, 0);
            }
            ++i;
        }
        MethodBinding[] methodBindingArray = baseMethods;
        int n = baseMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding aBaseMethod = methodBindingArray[n2];
            if (aBaseMethod.isValidBinding() && aBaseMethod.returnType != TypeBinding.VOID) {
                if (this.callinModifier != 119 || !this.roleMethodSpec.isValid() || this.roleMethodSpec.resolvedType() == TypeBinding.VOID) break;
                this.scope.problemReporter().ignoringRoleMethodReturn(this.roleMethodSpec);
                break;
            }
            ++n2;
        }
        this.binding._baseMethods = baseMethods;
    }

    boolean isDangerousMethod(MethodBinding method) {
        if (CharOperation.equals(method.selector, "hashCode".toCharArray())) {
            return method.parameters == Binding.NO_PARAMETERS;
        }
        if (CharOperation.equals(method.selector, "equals".toCharArray())) {
            return method.parameters.length == 1 && method.parameters[0].id == 1;
        }
        return false;
    }

    private void makeMethodStatic(AbstractMethodDeclaration method) {
        method.modifiers |= 8;
        if (method.binding != null) {
            method.binding.modifiers |= 8;
        }
        if (method.scope != null) {
            method.scope.isStatic = true;
        }
        if (method.interfacePartMethod != null) {
            this.makeMethodStatic(method.interfacePartMethod);
        }
    }

    protected void checkModifiers(boolean haveBaseMethods, ReferenceBinding baseClass) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.isReplaceCallin()) {
            if (!this.roleMethodSpec.resolvedMethod.isCallin()) {
                this.scope.problemReporter().replaceMappingToNonCallin(this.roleMethodSpec, this.roleMethodSpec.resolvedMethod);
                this.binding.tagBits |= 0x1000000000000000L;
                return;
            }
        } else if (this.roleMethodSpec.resolvedMethod.isCallin()) {
            this.scope.problemReporter().callinMethodBoundNonReplace(this.roleMethodSpec, this);
            this.binding.tagBits |= 0x1000000000000000L;
            return;
        }
        if (haveBaseMethods) {
            int i;
            if (!this.roleMethodSpec.resolvedMethod.isStatic()) {
                i = 0;
                while (i < this.baseMethodSpecs.length) {
                    this.baseMethodSpecs[i].checkStaticness(this, false);
                    ++i;
                }
            }
            if (this.isReplaceCallin() && this.roleMethodSpec.resolvedMethod.isStatic()) {
                i = 0;
                while (i < this.baseMethodSpecs.length) {
                    this.baseMethodSpecs[i].checkStaticness(this, true);
                    ++i;
                }
            }
            i = 0;
            while (i < this.baseMethodSpecs.length) {
                MethodBinding baseMethod = this.baseMethodSpecs[i].resolvedMethod;
                if (baseMethod != null && baseMethod.isFinal() && baseMethod.declaringClass != baseClass) {
                    this.scope.problemReporter().bindingToInheritedFinal(this.baseMethodSpecs[i], baseMethod, baseClass);
                    this.binding.tagBits |= 0x1000000000000000L;
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean internalCheckParametersCompatibility(MethodSpec methodSpec, TypeBinding[] roleParams, TypeBinding[] baseParams) {
        if (baseParams.length < roleParams.length) {
            this.scope.problemReporter().tooFewArgumentsInMethodMapping(this.roleMethodSpec, methodSpec, false);
            this.binding.tagBits |= 0x1000000000000000L;
            return false;
        }
        this.roleMethodSpec.parameters = new TypeBinding[roleParams.length];
        System.arraycopy(this.roleMethodSpec.parameters, 0, this.roleMethodSpec.parameters, 0, roleParams.length);
        j = 0;
        while (j < roleParams.length) {
            block34: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block33: {
                                        block40: {
                                            baseParam = baseParams[j];
                                            roleParam = roleParams[j];
                                            if (baseParam.dimensions() == roleParam.dimensions()) break block40;
                                            this.scope.problemReporter().incompatibleMappedArgument(baseParam, roleParam, this.roleMethodSpec, j, false);
                                            this.binding.tagBits |= 0x1000000000000000L;
                                            break block34;
                                        }
                                        baseLeaf = baseParam.leafComponentType();
                                        roleLeaf = roleParam.leafComponentType();
                                        location = methodSpec.hasSignature != false ? methodSpec.arguments[j] : methodSpec;
                                        compatibilityViaBaseAnchor = false;
                                        hasReportedError = false;
                                        isTypeVariable = false;
                                        try {
                                            if (!roleParam.isTypeVariable()) ** GOTO lbl45
                                            typeVariableBinding = (TypeVariableBinding)roleParam;
                                            if (typeVariableBinding.firstBound != null) break block33;
                                            if (hasReportedError) {
                                                this.binding.tagBits |= 0x1000000000000000L;
                                            }
                                            if (hasReportedError || !baseLeaf.isCompatibleWith(roleLeaf) || !this.isReplaceCallin() || isTypeVariable) break block34;
                                            v0 = twowayCompatible = compatibilityViaBaseAnchor != false ? RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 75) : roleLeaf.isCompatibleWith(baseLeaf);
                                        }
                                        catch (Throwable var17_20) {
                                            if (hasReportedError) {
                                                this.binding.tagBits |= 0x1000000000000000L;
                                            }
                                            if (!hasReportedError && baseLeaf.isCompatibleWith(roleLeaf) && this.isReplaceCallin() && !isTypeVariable) {
                                                v1 = twowayCompatible = compatibilityViaBaseAnchor != false ? RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 75) : roleLeaf.isCompatibleWith(baseLeaf);
                                                if (!twowayCompatible) {
                                                    this.scope.problemReporter().typesNotTwowayCompatibleInReplace(baseParam, roleParam, location, j);
                                                }
                                            }
                                            throw var17_20;
                                        }
                                        if (!twowayCompatible) {
                                            this.scope.problemReporter().typesNotTwowayCompatibleInReplace(baseParam, roleParam, location, j);
                                        }
                                        break block34;
                                    }
                                    isTypeVariable = true;
                                    roleLeaf = typeVariableBinding.firstBound.leafComponentType();
lbl45:
                                    // 2 sources

                                    dimensions = roleParam.dimensions();
                                    if (!baseLeaf.isCompatibleWith(roleLeaf)) break block35;
                                    this.roleMethodSpec.parameters[j] = roleParam;
                                    if (hasReportedError) {
                                        this.binding.tagBits |= 0x1000000000000000L;
                                    }
                                    if (hasReportedError || !baseLeaf.isCompatibleWith(roleLeaf) || !this.isReplaceCallin() || isTypeVariable) break block34;
                                    v2 = twowayCompatible = compatibilityViaBaseAnchor != false ? RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 75) : roleLeaf.isCompatibleWith(baseLeaf);
                                    if (!twowayCompatible) {
                                        this.scope.problemReporter().typesNotTwowayCompatibleInReplace(baseParam, roleParam, location, j);
                                    }
                                    break block34;
                                }
                                if (!RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 79)) break block36;
                                this.roleMethodSpec.parameters[j] = roleParam;
                                compatibilityViaBaseAnchor = true;
                                if (hasReportedError) {
                                    this.binding.tagBits |= 0x1000000000000000L;
                                }
                                if (hasReportedError || !baseLeaf.isCompatibleWith(roleLeaf) || !this.isReplaceCallin() || isTypeVariable) break block34;
                                v3 = twowayCompatible = compatibilityViaBaseAnchor != false ? RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 75) : roleLeaf.isCompatibleWith(baseLeaf);
                                if (!twowayCompatible) {
                                    this.scope.problemReporter().typesNotTwowayCompatibleInReplace(baseParam, roleParam, location, j);
                                }
                                break block34;
                            }
                            roleToLiftTo = null;
                            if (this.isReplaceCallin()) {
                                roleSideType = roleLeaf;
                                if (roleSideType.isRole()) {
                                    roleRef = (ReferenceBinding)roleSideType;
                                    roleRef = (ReferenceBinding)TeamModel.strengthenRoleType(this.scope.enclosingReceiverType(), roleRef);
                                    if (roleRef.baseclass() == baseLeaf) {
                                        roleToLiftTo = dimensions > 0 ? (roleRef instanceof DependentTypeBinding ? ((DependentTypeBinding)roleRef).getArrayType(dimensions) : this.scope.createArrayType(roleRef, dimensions)) : roleRef;
                                    }
                                }
                            } else {
                                roleToLiftTo = TeamModel.getRoleToLiftTo(this.scope, baseParam, roleParam, false, location);
                            }
                            if (roleToLiftTo == null) break block37;
                            methodSpec.argNeedsTranslation[j] = true;
                            this.roleMethodSpec.argNeedsTranslation[j] = true;
                            this.roleMethodSpec.parameters[j] = roleToLiftTo;
                            enclosingTeam = this.scope.enclosingSourceType().enclosingType();
                            iProblem = enclosingTeam.getTeamModel().canLiftingFail((ReferenceBinding)roleToLiftTo.leafComponentType());
                            if (iProblem > 0) {
                                this.addRoleLiftingProblem((ReferenceBinding)roleToLiftTo.leafComponentType(), iProblem);
                            }
                            if (hasReportedError) {
                                this.binding.tagBits |= 0x1000000000000000L;
                            }
                            if (hasReportedError || !baseLeaf.isCompatibleWith(roleLeaf) || !this.isReplaceCallin() || isTypeVariable) break block34;
                            v4 = twowayCompatible = compatibilityViaBaseAnchor != false ? RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 75) : roleLeaf.isCompatibleWith(baseLeaf);
                            if (!twowayCompatible) {
                                this.scope.problemReporter().typesNotTwowayCompatibleInReplace(baseParam, roleParam, location, j);
                            }
                            break block34;
                        }
                        if (!this.scope.isBoxingCompatibleWith(baseLeaf, roleLeaf)) break block38;
                        if (hasReportedError) {
                            this.binding.tagBits |= 0x1000000000000000L;
                        }
                        if (hasReportedError || !baseLeaf.isCompatibleWith(roleLeaf) || !this.isReplaceCallin() || isTypeVariable) break block34;
                        v5 = twowayCompatible = compatibilityViaBaseAnchor != false ? RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 75) : roleLeaf.isCompatibleWith(baseLeaf);
                        if (!twowayCompatible) {
                            this.scope.problemReporter().typesNotTwowayCompatibleInReplace(baseParam, roleParam, location, j);
                        }
                        break block34;
                    }
                    if (!(roleParam instanceof ReferenceBinding) || !(roleRef = (ReferenceBinding)roleParam).isRole() || roleRef.baseclass() == null) break block39;
                    this.scope.problemReporter().typeMismatchErrorPotentialLift(location, baseParam, roleParam, roleRef.baseclass());
                    hasReportedError = true;
                    if (hasReportedError) {
                        this.binding.tagBits |= 0x1000000000000000L;
                    }
                    if (hasReportedError || !baseLeaf.isCompatibleWith(roleLeaf) || !this.isReplaceCallin() || isTypeVariable) break block34;
                    v6 = twowayCompatible = compatibilityViaBaseAnchor != false ? RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 75) : roleLeaf.isCompatibleWith(baseLeaf);
                    if (!twowayCompatible) {
                        this.scope.problemReporter().typesNotTwowayCompatibleInReplace(baseParam, roleParam, location, j);
                    }
                    break block34;
                }
                this.scope.problemReporter().incompatibleMappedArgument(baseParam, roleParam, this.roleMethodSpec, j, false);
                hasReportedError = true;
                if (hasReportedError) {
                    this.binding.tagBits |= 0x1000000000000000L;
                }
                if (!hasReportedError && baseLeaf.isCompatibleWith(roleLeaf) && this.isReplaceCallin() && !isTypeVariable) {
                    v7 = twowayCompatible = compatibilityViaBaseAnchor != false ? RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseLeaf, roleLeaf, 75) : roleLeaf.isCompatibleWith(baseLeaf);
                    if (!twowayCompatible) {
                        this.scope.problemReporter().typesNotTwowayCompatibleInReplace(baseParam, roleParam, location, j);
                    }
                }
            }
            ++j;
        }
        return true;
    }

    public void addRoleLiftingProblem(ReferenceBinding roleRef, int iProblem) {
        if (this.rolesWithLiftingProblem == null) {
            this.rolesWithLiftingProblem = new HashMap<ReferenceBinding, Integer>();
        }
        this.rolesWithLiftingProblem.put(roleRef, iProblem);
    }

    protected void checkReturnCompatibility(MethodSpec methodSpec) {
        Config.requireTypeAdjustment();
        if (this.isReplaceCallin()) {
            this.checkResultForReplace(methodSpec);
        }
    }

    public boolean checkVisibility(MethodSpec spec, ReferenceBinding baseType) {
        if (!super.checkVisibility(spec, baseType)) {
            return false;
        }
        if (this.isReplaceCallin()) {
            MessageSend anticipatedBaseCall = new MessageSend();
            anticipatedBaseCall.receiver = new SingleNameReference("<fake>".toCharArray(), 0L);
            anticipatedBaseCall.receiver.resolvedType = anticipatedBaseCall.actualReceiverType = baseType;
            if (!spec.resolvedMethod.canBeSeenBy(baseType, anticipatedBaseCall, this.scope.classScope()) && (spec.resolvedMethod.modifiers & 4) == 0) {
                this.scope.problemReporter().callinDecapsulation(spec, this.scope);
            }
        }
        return true;
    }

    public void checkResultForReplace(MethodSpec baseSpec) {
        TypeBinding roleReturnLeaf;
        TypeVariableBinding returnVariable;
        TypeBinding resolvedRoleReturn;
        boolean typeIdentityRequired = true;
        if (baseSpec.covariantReturn && this.roleMethodSpec.returnType != null && (resolvedRoleReturn = this.roleMethodSpec.returnType.resolvedType) != null) {
            if (!resolvedRoleReturn.isTypeVariable()) {
                this.scope.problemReporter().covariantReturnRequiresTypeParameter(this.roleMethodSpec.returnType);
                this.binding.tagBits |= 0x1000000000000000L;
            } else {
                Argument[] argumentArray = this.roleMethodSpec.arguments;
                int n = this.roleMethodSpec.arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    Argument arg = argumentArray[n2];
                    if (this.typeUsesTypeVariable(arg.type.resolvedType.leafComponentType(), resolvedRoleReturn)) {
                        this.scope.problemReporter().duplicateUseOfTypeVariableInCallin(this.roleMethodSpec.returnType, resolvedRoleReturn);
                        this.binding.tagBits |= 0x1000000000000000L;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if ((returnVariable = MethodModel.checkedGetReturnTypeVariable(this.roleMethodSpec.resolvedMethod)) != null) {
            if (returnVariable.firstBound == null) {
                return;
            }
            typeIdentityRequired = false;
        }
        TypeBinding baseReturn = baseSpec.resolvedMethod.returnType;
        TypeBinding roleReturn = MethodModel.getReturnType(this.roleMethodSpec.resolvedMethod);
        TypeBinding typeBinding = roleReturnLeaf = roleReturn != null ? roleReturn.leafComponentType() : null;
        if (roleReturnLeaf instanceof ReferenceBinding && ((ReferenceBinding)roleReturnLeaf).isRole()) {
            int dims;
            roleReturnLeaf = TeamModel.strengthenRoleType(this.scope.enclosingSourceType(), roleReturnLeaf);
            if (roleReturnLeaf == null) {
                String roleReturnName = roleReturn != null ? new String(roleReturn.readableName()) : "null return type";
                throw new InternalCompilerError("role strengthening for " + roleReturnName + " -> null");
            }
            if (((ReferenceBinding)roleReturnLeaf).baseclass() != null) {
                roleReturnLeaf = RoleModel.getTopmostBoundRole(this.scope, (ReferenceBinding)roleReturnLeaf);
            }
            if (!DependentTypeBinding.isDependentType(roleReturnLeaf)) {
                roleReturnLeaf = RoleTypeCreator.maybeWrapUnqualifiedRoleType(roleReturnLeaf, this.scope.enclosingSourceType());
            }
            int n = dims = roleReturn != null ? roleReturn.dimensions() : 0;
            if (dims == 0) {
                roleReturn = roleReturnLeaf;
                this.realRoleReturn = roleReturnLeaf;
            } else {
                roleReturn = ((DependentTypeBinding)roleReturnLeaf).getArrayType(dims);
                this.realRoleReturn = ((DependentTypeBinding)roleReturnLeaf).getArrayType(dims);
            }
        }
        if (baseReturn == null || baseReturn == TypeBinding.VOID) {
            if (roleReturn != null && roleReturn != TypeBinding.VOID) {
                this.scope.problemReporter().callinIllegalRoleReturnReturn(baseSpec, this.roleMethodSpec);
                this.binding.tagBits |= 0x1000000000000000L;
            }
        } else {
            TypeBinding firstBound;
            TypeBinding translatedReturn;
            SourceTypeBinding enclosingRole;
            FieldBinding baseField;
            if (roleReturn == null || roleReturn == TypeBinding.VOID) {
                this.baseMethodNeedingResultFromBasecall = baseSpec;
                return;
            }
            TypeBinding baseLeaf = baseReturn.leafComponentType();
            if (baseLeaf instanceof DependentTypeBinding && (baseField = ((ReferenceBinding)(enclosingRole = this.scope.enclosingSourceType())).getField(IOTConstants._OT_BASE, true)) != null && baseField.isValidBinding()) {
                baseReturn = baseField.getRoleTypeBinding((ReferenceBinding)baseLeaf, baseReturn.dimensions());
            }
            if (this.scope.isBoxingCompatibleWith(roleReturn, baseReturn)) {
                return;
            }
            Config oldConfig = Config.createOrResetConfig(this);
            try {
                if (!roleReturn.isCompatibleWith(baseReturn) && typeIdentityRequired) {
                    this.scope.problemReporter().callinIncompatibleReturnType(baseSpec, this.roleMethodSpec);
                    this.binding.tagBits |= 0x1000000000000000L;
                    return;
                }
                baseSpec.returnNeedsTranslation = Config.getLoweringRequired();
            }
            finally {
                Config.removeOrRestore(oldConfig, this);
            }
            roleReturn = roleReturn.leafComponentType();
            baseReturn = baseReturn.leafComponentType();
            TypeBinding typeBinding2 = translatedReturn = baseSpec.returnNeedsTranslation ? ((ReferenceBinding)roleReturn).baseclass() : roleReturn;
            if (translatedReturn.isTypeVariable() && (firstBound = ((TypeVariableBinding)translatedReturn).firstBound) != null) {
                translatedReturn = firstBound;
            }
            if (!baseReturn.isCompatibleWith(translatedReturn)) {
                this.scope.problemReporter().callinIncompatibleReturnTypeBaseCall(baseSpec, this.roleMethodSpec);
                this.binding.tagBits |= 0x1000000000000000L;
            }
        }
    }

    public void checkResultMapping() {
        if (this.mappings == null) {
            return;
        }
        MethodSpec[] methodSpecArray = this.baseMethodSpecs;
        int n = this.baseMethodSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            MethodSpec baseSpec = methodSpecArray[n2];
            int i = 0;
            while (i < this.mappings.length) {
                if (CharOperation.equals(this.mappings[i].ident.token, IOTConstants.RESULT)) {
                    this.isResultMapped = true;
                    if (baseSpec.resolvedType() != TypeBinding.VOID) {
                        Expression resultExpr;
                        if (this.roleMethodSpec.resolvedType() != TypeBinding.VOID && !((resultExpr = this.mappings[i].expression) instanceof ResultReference)) {
                            this.scope.problemReporter().nonResultExpressionInReplaceResult(resultExpr);
                            this.binding.tagBits |= 0x1000000000000000L;
                        }
                    } else {
                        this.scope.problemReporter().resultMappingForVoidMethod(this, baseSpec, this.mappings[i]);
                        this.binding.tagBits |= 0x1000000000000000L;
                    }
                }
                ++i;
            }
            ++n2;
        }
    }

    private boolean typeUsesTypeVariable(TypeBinding type, TypeBinding variable) {
        if (type.leafComponentType() == variable) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = type.typeVariables();
        int n = referenceBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeVariableBinding t = referenceBindingArray[n2];
            if (this.typeUsesTypeVariable(t, variable)) {
                return true;
            }
            ++n2;
        }
        if (type.isTypeVariable()) {
            if (this.typeUsesTypeVariable(((ReferenceBinding)type).superclass(), variable)) {
                return true;
            }
            referenceBindingArray = ((ReferenceBinding)type).superInterfaces();
            n = referenceBindingArray.length;
            n2 = 0;
            while (n2 < n) {
                ReferenceBinding superIfc = referenceBindingArray[n2];
                if (this.typeUsesTypeVariable(superIfc, variable)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void checkResult(MethodSpec baseSpec) {
        if (this.isReplaceCallin()) {
            this.checkResultForReplace(baseSpec);
        }
    }

    protected void checkThrownExceptions(MethodSpec baseSpec) {
        this.checkThrownExceptions(this.roleMethodSpec.resolvedMethod, baseSpec.resolvedMethod);
        ReferenceBinding[] baseExceptions = baseSpec.resolvedMethod.thrownExceptions;
        if (baseExceptions != null && baseExceptions.length > 0) {
            MethodModel roleMethodModel = MethodModel.getModel(this.roleMethodSpec.resolvedMethod);
            roleMethodModel.addBaseExceptions(baseExceptions);
        }
    }

    public void analyseDetails(TypeDeclaration roleClass) {
        if (this.roleMethodSpec.isValid() && MethodModel.hasCallinFlag(this.roleMethodSpec.resolvedMethod, 32)) {
            int i = 0;
            while (i < this.baseMethodSpecs.length) {
                MethodBinding baseMethod = this.baseMethodSpecs[i].resolvedMethod;
                if (baseMethod != null) {
                    if (!MethodModel.isOverriding(baseMethod, this.scope.compilationUnitScope())) {
                        this.scope.problemReporter().baseSuperCallToNonOverriding(this.baseMethodSpecs[i], this.roleMethodSpec);
                    } else {
                        roleClass.getRoleModel().addMethodSuperAccess(baseMethod);
                    }
                }
                ++i;
            }
        }
        if (this.baseMethodNeedingResultFromBasecall != null && !this.isResultMapped) {
            if (MethodModel.hasCallinFlag(this.roleMethodSpec.resolvedMethod, 8)) {
                this.scope.problemReporter().callinMappingMissingResult(this, this.baseMethodNeedingResultFromBasecall);
                this.binding.tagBits |= 0x1000000000000000L;
            } else if (MethodModel.hasCallinFlag(this.roleMethodSpec.resolvedMethod, 16)) {
                this.scope.problemReporter().fragileCallinMapping(this, this.baseMethodNeedingResultFromBasecall);
            }
        }
    }

    public boolean isCallin() {
        return true;
    }

    public boolean isReplaceCallin() {
        return this.callinModifier == 120;
    }

    public boolean isStaticReplace() {
        return this.isReplaceCallin() && this.roleMethodSpec.resolvedMethod.isStatic();
    }

    public boolean isCallout() {
        return false;
    }

    public char[] getCallinModifier() {
        switch (this.callinModifier) {
            case 120: {
                return IOTConstants.NAME_REPLACE;
            }
            case 119: {
                return IOTConstants.NAME_AFTER;
            }
            case 121: {
                return IOTConstants.NAME_BEFORE;
            }
        }
        return null;
    }

    public boolean hasCovariantReturn() {
        MethodSpec[] methodSpecArray = this.baseMethodSpecs;
        int n = this.baseMethodSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            MethodSpec spec = methodSpecArray[n2];
            if (spec.covariantReturn) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public MethodSpec getImplementationMethodSpec() {
        return this.roleMethodSpec;
    }

    public Expression getResultExpression(MethodSpec baseMethodSpec, boolean needBoxing, AstGenerator gen) {
        if (baseMethodSpec.resolvedType() == TypeBinding.VOID) {
            return new SingleNameReference(IOTConstants.RESULT, ((long)this.roleMethodSpec.sourceStart << 32) + (long)this.roleMethodSpec.sourceEnd);
        }
        Expression resultExpr = null;
        int i = 0;
        while (i < this.mappings.length) {
            if (!this.mappings[i].isUsedFor(baseMethodSpec) && CharOperation.equals(this.mappings[i].ident.token, IOTConstants.RESULT)) {
                if (resultExpr != null) {
                    this.scope.problemReporter().duplicateParamMapping(this.mappings[i], IOTConstants.RESULT, false);
                    this.binding.tagBits |= 0x1000000000000000L;
                } else {
                    resultExpr = this.mappings[i].expression;
                }
            }
            ++i;
        }
        if (resultExpr != null && this.roleMethodSpec.resolvedType() == TypeBinding.VOID && resultExpr instanceof ResultReference) {
            this.scope.problemReporter().resultNotDefinedForVoidMethod(resultExpr, this.roleMethodSpec.selector, false);
            this.binding.tagBits |= 0x1000000000000000L;
        }
        if (resultExpr != null && !this.isResultMapped && needBoxing) {
            resultExpr = gen.createBoxing(resultExpr, (BaseTypeBinding)baseMethodSpec.resolvedType());
        }
        return resultExpr;
    }

    Integer analyzeArgForReplace(MethodSpec sourceMethodSpec, int implIdx, Expression mappedArgExpr) {
        if (!this.isReplaceCallin()) {
            return null;
        }
        Expression currentExpression = mappedArgExpr;
        if (currentExpression instanceof CastExpression) {
            currentExpression = ((CastExpression)currentExpression).expression;
        }
        if (currentExpression instanceof SingleNameReference) {
            SingleNameReference arg = (SingleNameReference)currentExpression;
            return this.recordPosition(implIdx, arg.token, sourceMethodSpec);
        }
        SingleNameReference match = this.findBaseArgName(currentExpression, this.scope, sourceMethodSpec.arguments);
        if (match != null && this.scope != null) {
            this.scope.problemReporter().baseArgInNonSimpleExpression(match);
            this.binding.tagBits |= 0x1000000000000000L;
        }
        return null;
    }

    public int[] getUnmappedBasePositions(MethodSpec baseSpec) {
        int baseArgCount = baseSpec.resolvedParameters().length;
        int[] result = new int[baseArgCount];
        int idx = 0;
        int i = 0;
        while (i < baseArgCount) {
            if (!this.isMapped(i)) {
                result[idx++] = i;
            }
            ++i;
        }
        if (idx < baseArgCount) {
            int[] nArray = result;
            result = new int[idx];
            System.arraycopy(nArray, 0, result, 0, idx);
        }
        return result;
    }

    private boolean isMapped(int pos) {
        if (this.positions == null) {
            return pos < this.roleMethodSpec.resolvedParameters().length;
        }
        int i = 0;
        while (i < this.positions.length) {
            if (this.positions[i] == pos + 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            this.roleMethodSpec.traverse(visitor, this.scope);
            int idx = 0;
            while (idx < this.baseMethodSpecs.length) {
                this.baseMethodSpecs[idx].traverse(visitor, this.scope);
                ++idx;
            }
            if (this.mappings != null) {
                int idy = 0;
                while (idy < this.mappings.length) {
                    ParameterMapping mapping = this.mappings[idy];
                    mapping.traverse(visitor, this.scope);
                    ++idy;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    public String callinModifier() {
        return CallinMappingDeclaration.callinModifier(this.callinModifier);
    }

    public static String callinModifier(int callinModifier) {
        switch (callinModifier) {
            case 120: {
                return "replace";
            }
            case 119: {
                return "after";
            }
            case 121: {
                return "before";
            }
        }
        return "<unknown>";
    }

    public StringBuffer print(int indent, StringBuffer output) {
        CallinMappingDeclaration.printIndent(indent, output);
        if (this.name != null) {
            output.append(this.name);
            output.append(":\n");
            CallinMappingDeclaration.printIndent(++indent, output);
        }
        this.roleMethodSpec.print(0, output);
        output.append(" <- ");
        output.append(String.valueOf(this.callinModifier()) + " ");
        int length = this.baseMethodSpecs.length;
        if (length > 1) {
            output.append(" { ");
        }
        int t = 0;
        while (t < length) {
            this.baseMethodSpecs[t].print(0, output);
            if (t < length - 1) {
                output.append(", ");
            }
            ++t;
        }
        if (length > 1) {
            output.append(" } ");
        }
        if (this.predicate != null) {
            output.append('\n');
            CallinMappingDeclaration.printIndent(indent + 1, output);
            if (this.predicate.isBasePredicate) {
                output.append("base ");
            }
            output.append("when ");
            if (this.predicate.returnStatement != null) {
                this.predicate.returnStatement.expression.printExpression(indent, output);
            } else {
                output.append("<null expression>");
            }
        }
        if (this.mappings != null) {
            output.append(" with { ");
            length = this.mappings.length;
            t = 0;
            while (t < length) {
                this.mappings[t].print(indent, output);
                if (t < length - 1) {
                    output.append(", ");
                }
                ++t;
            }
            output.append(" } ");
        } else {
            output.append(";");
        }
        return output;
    }

    public StringBuffer printShort(int indent, StringBuffer output, MethodSpec baseMethodSpec) {
        CallinMappingDeclaration.printIndent(indent, output);
        this.roleMethodSpec.print(0, output);
        output.append(this.getCallinModifier());
        baseMethodSpec.print(0, output);
        return output;
    }

    public void setWrapper(MethodSpec baseMethodSpec, MethodDeclaration wrapperMethod) {
        if (this.wrappers == null) {
            this.wrappers = new MethodDeclaration[this.baseMethodSpecs.length];
        }
        int i = 0;
        while (i < this.baseMethodSpecs.length) {
            if (this.baseMethodSpecs[i] == baseMethodSpec) {
                this.wrappers[i] = wrapperMethod;
                return;
            }
            ++i;
        }
        this.scope.problemReporter().abortDueToInternalError("trying to set wrapper for non-existing baseMethodSpec" + baseMethodSpec);
    }

    public MethodDeclaration getWrapper(MethodSpec baseMethodSpec) {
        int i = 0;
        while (i < this.baseMethodSpecs.length) {
            if (this.baseMethodSpecs[i] == baseMethodSpec) {
                return this.wrappers[i];
            }
            ++i;
        }
        return null;
    }

    public boolean hasName() {
        return this.name != null && this.name[0] != '<';
    }

    public char[] declaringRoleName() {
        char[] roleName = this.scope.enclosingSourceType().sourceName();
        if (this.name == null) {
            return roleName;
        }
        if (this.name[0] != '<') {
            ReferenceBinding currentRole = this.scope.enclosingSourceType();
            while (currentRole != null && currentRole.isRole()) {
                CallinCalloutBinding[] callinCalloutBindingArray = currentRole.callinCallouts;
                int n = currentRole.callinCallouts.length;
                int n2 = 0;
                while (n2 < n) {
                    CallinCalloutBinding mapping = callinCalloutBindingArray[n2];
                    if (CharOperation.equals(this.name, mapping.name)) {
                        roleName = currentRole.sourceName();
                        break;
                    }
                    ++n2;
                }
                currentRole = currentRole.superclass();
            }
        }
        return roleName;
    }
}

