/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.refactoring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.hierarchy.InheritedMethodsRequestor;
import org.eclipse.objectteams.otdt.core.hierarchy.OTTypeHierarchyTraverser;
import org.eclipse.objectteams.otdt.core.hierarchy.TraverseRequestor;
import org.eclipse.objectteams.otdt.core.search.OTSearchEngine;
import org.eclipse.objectteams.otdt.core.search.OTSearchRequestor;
import org.eclipse.objectteams.otdt.internal.refactoring.OTRefactoringPlugin;
import org.eclipse.objectteams.otdt.internal.refactoring.corext.OTRefactoringCoreMessages;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.OTRefactoringMessages;
import org.eclipse.objectteams.otdt.internal.refactoring.util.IAmbuguityMessageCreator;
import org.eclipse.objectteams.otdt.internal.refactoring.util.IOverloadingMessageCreator;
import org.eclipse.objectteams.otdt.internal.refactoring.util.ITeamConstants;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringUtil
implements ITeamConstants {
    public static RefactoringStatus checkOOClass(ICompilationUnit compUnit, String str) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        IType type = RefactoringUtil.robustFindPrimaryType(compUnit);
        if (Flags.isTeam((int)type.getFlags())) {
            status.addFatalError(OTRefactoringCoreMessages.getString(str));
        }
        return status;
    }

    private static IType robustFindPrimaryType(ICompilationUnit compUnit) {
        IType type = compUnit.findPrimaryType();
        if (type != null) {
            return type;
        }
        try {
            IType[] types = compUnit.getTypes();
            if (types != null) {
                IType[] iTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type2 = iTypeArray[n2];
                    if (Flags.isPublic((int)type2.getFlags())) {
                        return type2;
                    }
                    ++n2;
                }
                if (types.length > 0) {
                    return types[0];
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IOTType[] getAllRoleClasses(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        OTSearchRequestor requestor = new OTSearchRequestor();
        try {
            SearchPattern rolePattern = OTSearchEngine.createRoleTypePattern((int)0, (int)0);
            IJavaElement[] relevantProjects = RefactoringUtil.getRelevantProjects(project);
            IJavaSearchScope scope = OTSearchEngine.createOTSearchScope((IJavaElement[])relevantProjects, (boolean)true);
            OTSearchEngine engine = new OTSearchEngine();
            engine.search(rolePattern, scope, (SearchRequestor)requestor, monitor);
        }
        catch (CoreException ex) {
            throw new JavaModelException(ex);
        }
        return requestor.getOTTypes();
    }

    public static ArrayList<IRoleType> getAllRolesForBase(IType baseType) throws CoreException {
        OTSearchEngine engine = new OTSearchEngine();
        IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)baseType, (int)6);
        final ArrayList<IRoleType> roles = new ArrayList<IRoleType>();
        if (pattern == null) {
            OTRefactoringPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.refactoring", "Error creating pattern"));
        } else {
            engine.search(pattern, searchScope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    Object element = match.getElement();
                    if (element instanceof IType) {
                        roles.add((IRoleType)OTModelManager.getOTElement((IType)((IType)element)));
                    }
                }
            }, null);
        }
        return roles;
    }

    private static IJavaElement[] getRelevantProjects(IJavaProject srcProject) throws JavaModelException {
        ArrayList<IJavaProject> relevantProjects = new ArrayList<IJavaProject>();
        relevantProjects.add(srcProject);
        IJavaProject[] allJavaProjects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
        int idx = 0;
        while (idx < allJavaProjects.length) {
            IJavaProject prj = allJavaProjects[idx];
            if (prj.isOnClasspath((IJavaElement)srcProject)) {
                relevantProjects.add(prj);
            }
            ++idx;
        }
        return relevantProjects.toArray(new IJavaElement[relevantProjects.size()]);
    }

    public static ArrayList<IType> getAllDeclaredBaseTypes(IOTType[] roleTypes) throws JavaModelException {
        ArrayList<IType> baseTypes = new ArrayList<IType>();
        int idx = 0;
        while (idx < roleTypes.length) {
            IType baseType;
            IRoleType roleType = (IRoleType)roleTypes[idx];
            if (roleType.getBaseclassName() != null && (baseType = roleType.getBaseClass()) != null && !baseTypes.contains(baseType)) {
                baseTypes.add(baseType);
            }
            ++idx;
        }
        return baseTypes;
    }

    public static IMethod[] hierarchyDeclaresMethodName(IProgressMonitor pm, IMethod method, String newName) throws CoreException {
        IType[] implementingClasses;
        IMethod[] foundInImplementingClasses;
        IMethod[] foundInHierarchyClasses;
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        ITypeHierarchy hier = type.newTypeHierarchy(pm);
        IMethod foundMethod = Checks.findMethod((String)newName, (int)method.getParameterTypes().length, (boolean)false, (IType)type);
        if (foundMethod != null) {
            result.add(foundMethod);
        }
        if ((foundInHierarchyClasses = RefactoringUtil.classesDeclareMethodName(hier, Arrays.asList(hier.getAllClasses()), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInHierarchyClasses));
        }
        if ((foundInImplementingClasses = RefactoringUtil.classesDeclareMethodName(hier, Arrays.asList(implementingClasses = hier.getImplementingClasses(type)), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInImplementingClasses));
        }
        return result.toArray(new IMethod[result.size()]);
    }

    private static IMethod[] classesDeclareMethodName(ITypeHierarchy hier, List<IType> classes, IMethod method, String newName) throws CoreException {
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        List<IType> subtypes = Arrays.asList(hier.getAllSubtypes(type));
        int parameterCount = method.getParameterTypes().length;
        boolean isMethodPrivate = JdtFlags.isPrivate((IMember)method);
        for (IType clazz : classes) {
            IMethod[] methods = clazz.getMethods();
            boolean isSubclass = subtypes.contains(clazz);
            int j = 0;
            while (j < methods.length) {
                IMethod foundMethod = Checks.findMethod((String)newName, (int)parameterCount, (boolean)false, (IMethod[])new IMethod[]{methods[j]});
                if (foundMethod != null) {
                    if (isSubclass || type.equals(clazz)) {
                        result.add(foundMethod);
                    } else if (!isMethodPrivate && !JdtFlags.isPrivate((IMember)methods[j])) {
                        result.add(foundMethod);
                    }
                }
                ++j;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IMethod isDeclaredInInterface(IMethod method, ITypeHierarchy hierarchy, IProgressMonitor pm) throws JavaModelException {
        assert (RefactoringUtil.isVirtual(method));
        try {
            IType[] classes = hierarchy.getAllClasses();
            SubProgressMonitor subPm = new SubProgressMonitor(pm, 3);
            subPm.beginTask("", classes.length);
            int idxAllHierarchyClasses = 0;
            while (idxAllHierarchyClasses < classes.length) {
                ITypeHierarchy superTypes = classes[idxAllHierarchyClasses].newSupertypeHierarchy((IProgressMonitor)subPm);
                IType[] superinterfaces = superTypes.getAllSuperInterfaces(classes[idxAllHierarchyClasses]);
                int idxSuperInterfaces = 0;
                while (idxSuperInterfaces < superinterfaces.length) {
                    IMethod found = Checks.findSimilarMethod((IMethod)method, (IType)superinterfaces[idxSuperInterfaces]);
                    if (found != null && !found.equals(method)) {
                        IMethod iMethod = found;
                        return iMethod;
                    }
                    ++idxSuperInterfaces;
                }
                subPm.worked(1);
                ++idxAllHierarchyClasses;
            }
            return null;
        }
        finally {
            pm.done();
        }
    }

    public static boolean isVirtual(IMethod method) throws JavaModelException {
        IType declaringType = method.getDeclaringType();
        if (TypeHelper.isRole((int)declaringType.getFlags())) {
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isStatic((IMember)method)) {
                return false;
            }
        } else {
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isPrivate((IMember)method)) {
                return false;
            }
            if (JdtFlags.isStatic((IMember)method)) {
                return false;
            }
        }
        return true;
    }

    public static IMethod overridesAnotherMethod(IMethod method, ITypeHierarchy hier, IProgressMonitor pm) throws JavaModelException {
        IType declaringType = method.getDeclaringType();
        InheritedMethodsRequestor requestor = new InheritedMethodsRequestor(declaringType, true, true);
        OTTypeHierarchyTraverser traverser = new OTTypeHierarchyTraverser(hier, (TraverseRequestor)requestor, false, false, false);
        traverser.traverse(pm);
        IMethod[] collectedMethods = requestor.getResult();
        int idx = collectedMethods.length - 1;
        while (idx >= 0) {
            if (method.isSimilar(collectedMethods[idx])) {
                return collectedMethods[idx];
            }
            --idx;
        }
        return null;
    }

    public static boolean isRoleMethod(IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        IOTType otType = OTModelManager.getOTElement((IType)type);
        if (otType == null) {
            return false;
        }
        return otType.isRole();
    }

    public static String stripOffJavaSuffix(String compUnit) {
        int dot = compUnit.lastIndexOf(46);
        return compUnit.substring(0, dot);
    }

    public static RoleTypeDeclaration getRoleClassDeclaration(IMember role) throws JavaModelException {
        ASTNode result = RefactoringUtil.getASTNode(role, RoleTypeDeclaration.class);
        return (RoleTypeDeclaration)result;
    }

    public static MethodDeclaration getMethodDeclaration(IMember method) throws JavaModelException {
        ASTNode result = RefactoringUtil.getASTNode(method, MethodDeclaration.class);
        return (MethodDeclaration)result;
    }

    public static IMethod[] getInheritedMethods(IOTType iotType, boolean includeFocusType, boolean includeRootClass, boolean checkVisibility, IProgressMonitor pm) throws JavaModelException {
        return RefactoringUtil.getInheritedMethods((IType)iotType.getCorrespondingJavaElement(), includeFocusType, includeRootClass, checkVisibility, pm);
    }

    public static IMethod[] getInheritedMethods(IType type, boolean includeFocusType, boolean includeRootClass, boolean checkVisibility, IProgressMonitor pm) throws JavaModelException {
        InheritedMethodsRequestor requestor = new InheritedMethodsRequestor(type, false, checkVisibility);
        OTTypeHierarchyTraverser traverser = new OTTypeHierarchyTraverser(null, (TraverseRequestor)requestor, true, includeFocusType, includeRootClass);
        traverser.traverse(pm);
        return requestor.getResult();
    }

    public static IType determineFocusType(IType topLevelType, ASTNode destinationType) {
        if (destinationType instanceof RoleTypeDeclaration) {
            RoleTypeDeclaration roleTypeDecl = (RoleTypeDeclaration)destinationType;
            ITypeBinding roleTypeBinding = ASTNodes.getTypeBinding((Name)roleTypeDecl.getName());
            if (roleTypeBinding != null) {
                String topLevelName = topLevelType.getFullyQualifiedName();
                String roleName = roleTypeBinding.getQualifiedName();
                if (roleName.equals(topLevelName)) {
                    return topLevelType;
                }
                if (roleTypeBinding.getDeclaringClass().getQualifiedName().equals(topLevelName)) {
                    String simpleRoleName = roleTypeBinding.getName();
                    if (simpleRoleName.startsWith("__OT__")) {
                        simpleRoleName = simpleRoleName.substring(IOTConstants.OT_DELIM_LEN);
                    }
                    return TypeHelper.findRoleType((IType)topLevelType, (String)simpleRoleName);
                }
                String relativeRoleName = RefactoringUtil.getRelativeName(topLevelName, roleName);
                return TypeHelper.findNestedRoleType((IType)topLevelType, (String)relativeRoleName);
            }
            return null;
        }
        return topLevelType;
    }

    private static String getRelativeName(String rootType, String fullyQualifiedName) {
        assert (fullyQualifiedName.startsWith(rootType)) : "role type must start like enclosing team";
        int pos = rootType.lastIndexOf(46);
        if (pos == -1) {
            pos = rootType.length();
        }
        return fullyQualifiedName.substring(pos + 1);
    }

    public static RefactoringStatus checkOverloading(IMethod[] inheritedMethods, String newName, String[] newParameterTypes, IOverloadingMessageCreator msgCreator) {
        RefactoringStatus result = new RefactoringStatus();
        int idx = 0;
        while (idx < inheritedMethods.length) {
            IMethod actualMethod = inheritedMethods[idx];
            if (actualMethod.getElementName().equals(newName)) {
                int refactoredMethodParamCount;
                int actualMethodParamCount = actualMethod.getParameterTypes().length;
                String[] actualMethodParamTypes = RefactoringUtil.getParameterTypesOfActualMethod(actualMethod);
                int n = refactoredMethodParamCount = newParameterTypes == null ? 0 : newParameterTypes.length;
                if (actualMethodParamCount != refactoredMethodParamCount) {
                    result.merge(RefactoringUtil.addOverloadingWarning(msgCreator));
                } else if (newParameterTypes != null) {
                    int idz = 0;
                    while (idz < actualMethodParamTypes.length) {
                        if (!actualMethodParamTypes[idz].equals(newParameterTypes[idz])) {
                            result.merge(RefactoringUtil.addOverloadingWarning(msgCreator));
                        }
                        ++idz;
                    }
                }
            }
            ++idx;
        }
        return result;
    }

    private static String[] getParameterTypesOfActualMethod(IMethod actualMethod) {
        String[] actualMethodParamTypes = actualMethod.getParameterTypes();
        String[] readableActualMethodParamTypes = new String[actualMethodParamTypes.length];
        int idy = 0;
        while (idy < actualMethodParamTypes.length) {
            readableActualMethodParamTypes[idy] = Signature.toString((String)actualMethodParamTypes[idy]);
            ++idy;
        }
        return readableActualMethodParamTypes;
    }

    public static RefactoringStatus checkForAmbiguousBaseMethodSpecs(ArrayList<IRoleType> boundRoleTypes, String newMethodName, String oldMethodName, IAmbuguityMessageCreator msgCreator) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        for (IRoleType boundRoleType : boundRoleTypes) {
            AbstractMethodMappingDeclaration[] mappings = RefactoringUtil.getAllMethodMappings(boundRoleType);
            if (mappings == null || mappings.length == 0) continue;
            int idx = 0;
            while (idx < mappings.length) {
                CalloutMappingDeclaration calloutDecl;
                MethodMappingElement baseElement;
                AbstractMethodMappingDeclaration mapping = mappings[idx];
                if (mapping instanceof CallinMappingDeclaration) {
                    CallinMappingDeclaration callinDecl = (CallinMappingDeclaration)mapping;
                    List baseMethodSpecs = callinDecl.getBaseMappingElements();
                    for (MethodMappingElement baseMethodSpec : baseMethodSpecs) {
                        String baseMethodName = baseMethodSpec.getName().getIdentifier();
                        if (baseMethodSpec.hasSignature() || !baseMethodName.equals(newMethodName) && !baseMethodName.equals(oldMethodName)) continue;
                        RefactoringStatusContext context = RefactoringUtil.createContext(boundRoleType, baseMethodSpec);
                        result.merge(RefactoringUtil.addAmbiguityFatalError(context, msgCreator));
                    }
                } else if (mapping instanceof CalloutMappingDeclaration && (baseElement = (calloutDecl = (CalloutMappingDeclaration)mapping).getBaseMappingElement()) instanceof MethodSpec) {
                    MethodSpec baseMethodSpec = (MethodSpec)baseElement;
                    String baseMethodName = baseMethodSpec.getName().getIdentifier();
                    if (!baseMethodSpec.hasSignature() && (baseMethodName.equals(newMethodName) || baseMethodName.equals(oldMethodName))) {
                        RefactoringStatusContext context = RefactoringUtil.createContext(boundRoleType, (MethodMappingElement)baseMethodSpec);
                        result.merge(RefactoringUtil.addAmbiguityFatalError(context, msgCreator));
                    }
                }
                ++idx;
            }
        }
        return result;
    }

    public static RefactoringStatus checkForAmbiguousRoleMethodSpecs(IRoleType roleType, String newMethodName, IAmbuguityMessageCreator msgCreator) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        AbstractMethodMappingDeclaration[] mappings = RefactoringUtil.getAllMethodMappings(roleType);
        if (mappings != null && mappings.length != 0) {
            int idx = 0;
            while (idx < mappings.length) {
                RefactoringStatusContext context;
                String roleMethodName;
                MethodSpec roleMethodSpec;
                AbstractMethodMappingDeclaration mapping = mappings[idx];
                if (mapping instanceof CallinMappingDeclaration) {
                    CallinMappingDeclaration callinDecl = (CallinMappingDeclaration)mapping;
                    roleMethodSpec = (MethodSpec)callinDecl.getRoleMappingElement();
                    roleMethodName = roleMethodSpec.getName().getIdentifier();
                    if (!roleMethodSpec.hasSignature() && roleMethodName.equals(newMethodName)) {
                        context = RefactoringUtil.createContext(roleType, (MethodMappingElement)roleMethodSpec);
                        result.merge(RefactoringUtil.addAmbiguityFatalError(context, msgCreator));
                    }
                } else if (mapping instanceof CalloutMappingDeclaration) {
                    CalloutMappingDeclaration calloutDecl = (CalloutMappingDeclaration)mapping;
                    roleMethodSpec = (MethodSpec)calloutDecl.getRoleMappingElement();
                    roleMethodName = roleMethodSpec.getName().getIdentifier();
                    if (!roleMethodSpec.hasSignature() && roleMethodName.equals(newMethodName)) {
                        context = RefactoringUtil.createContext(roleType, (MethodMappingElement)roleMethodSpec);
                        result.merge(RefactoringUtil.addAmbiguityFatalError(context, msgCreator));
                    }
                }
                ++idx;
            }
        }
        return result;
    }

    public static AbstractMethodMappingDeclaration[] getAllMethodMappings(IRoleType roleType) throws JavaModelException {
        RoleTypeDeclaration roleClassDecl = RefactoringUtil.getRoleClassDeclaration((IMember)roleType);
        CallinMappingDeclaration[] callinMappings = roleClassDecl.getCallIns();
        CalloutMappingDeclaration[] calloutMappings = roleClassDecl.getCallOuts();
        AbstractMethodMappingDeclaration[] mappings = new AbstractMethodMappingDeclaration[callinMappings.length + calloutMappings.length];
        if (callinMappings.length != 0) {
            System.arraycopy(callinMappings, 0, mappings, 0, callinMappings.length);
            System.arraycopy(calloutMappings, 0, mappings, callinMappings.length, calloutMappings.length);
        } else {
            System.arraycopy(calloutMappings, 0, mappings, 0, calloutMappings.length);
        }
        return mappings;
    }

    public static RefactoringStatus addOverloadingWarning(IOverloadingMessageCreator msgCreator) {
        RefactoringStatus result = RefactoringUtil.createWarningStatus(msgCreator.createOverloadingMessage(), null, 10);
        return result;
    }

    public static RefactoringStatus addAmbiguityFatalError(RefactoringStatusContext context, IAmbuguityMessageCreator msgCreator) {
        RefactoringStatus result = RefactoringUtil.createFatalErrorStatus(msgCreator.createAmbiguousMethodSpecifierMsg(), context, 4);
        return result;
    }

    public static RefactoringStatus checkOverloadingForTeamOrRegularClass(RefactoringStatus result, String newMethodName, String[] newParamTypes, IType focusType, IOverloadingMessageCreator msgCreator, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        RefactoringStatusEntry overloading = result.getEntryMatchingCode(Corext.getPluginId(), 10);
        if (overloading == null) {
            IMethod[] methods = RefactoringUtil.getInheritedMethods(focusType, true, true, true, pm);
            status.merge(RefactoringUtil.checkOverloading(methods, newMethodName, newParamTypes, msgCreator));
        }
        return status;
    }

    public static RefactoringStatus checkOverloadingAndAmbiguityForRole(RefactoringStatus result, String newMethodName, String[] newParamTypes, IRoleType roleType, IAmbuguityMessageCreator ambiguityMsgCreator, IOverloadingMessageCreator overloadingMsgCreator, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        RefactoringStatusEntry overloading = result.getEntryMatchingCode(Corext.getPluginId(), 10);
        if (overloading == null) {
            IMethod[] methods = RefactoringUtil.getInheritedMethods((IOTType)roleType, true, true, false, pm);
            status.merge(RefactoringUtil.checkOverloading(methods, newMethodName, newParamTypes, overloadingMsgCreator));
        }
        if (status.hasWarning() || result.hasWarning()) {
            status.merge(RefactoringUtil.checkForAmbiguousRoleMethodSpecs(roleType, newMethodName, ambiguityMsgCreator));
        }
        return status;
    }

    public static RefactoringStatus checkOverloadingAndAmbiguityForBase(RefactoringStatus result, String newMethodName, String oldMethodName, String[] newParamTypes, IType focusType, IOTType[] roleTypes, IAmbuguityMessageCreator ambiguityMsgCreator, IOverloadingMessageCreator overloadingMsgCreator, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        ArrayList<IRoleType> boundRoleTypes = new ArrayList<IRoleType>();
        int idx = 0;
        while (idx < roleTypes.length) {
            IRoleType roleType = (IRoleType)roleTypes[idx];
            IType baseClass = roleType.getBaseClass();
            if (baseClass != null && baseClass.equals(focusType)) {
                RefactoringStatusEntry overloadingThis = status.getEntryMatchingCode(Corext.getPluginId(), 10);
                RefactoringStatusEntry overloadingOther = result.getEntryMatchingCode(Corext.getPluginId(), 10);
                if (overloadingThis == null && overloadingOther == null) {
                    IMethod[] baseMethods = RefactoringUtil.getInheritedMethods(baseClass, true, true, false, pm);
                    status.merge(RefactoringUtil.checkOverloading(baseMethods, newMethodName, newParamTypes, overloadingMsgCreator));
                }
                boundRoleTypes.add(roleType);
            }
            ++idx;
        }
        if (status.hasWarning() || result.hasWarning()) {
            status.merge(RefactoringUtil.checkForAmbiguousBaseMethodSpecs(boundRoleTypes, newMethodName, oldMethodName, ambiguityMsgCreator));
        }
        return status;
    }

    public static RefactoringStatus checkAmbiguityForBasePresentInFocusTypeSuperhierarchy(String newMethodName, String oldMethodName, IType[] superTypes, IAmbuguityMessageCreator msgCreator, IRoleType roleType) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        ArrayList<IRoleType> roleList = new ArrayList<IRoleType>();
        IType baseClass = roleType.getBaseClass();
        if (baseClass != null) {
            int idx = 0;
            while (idx < superTypes.length) {
                if (baseClass.equals(superTypes[idx])) {
                    roleList.add(roleType);
                    status.merge(RefactoringUtil.checkForAmbiguousBaseMethodSpecs(roleList, newMethodName, oldMethodName, msgCreator));
                }
                ++idx;
            }
        }
        return status;
    }

    public static RefactoringStatus checkOverloadingAndAmbiguity(ICompilationUnit compUnit, ASTNode destination, String newMethodName, String[] newParamTypes, IAmbuguityMessageCreator ambiguityMsgCreator, IOverloadingMessageCreator overloadingMsgCreator, IProgressMonitor pm) throws JavaModelException {
        IType topLevelType = RefactoringUtil.robustFindPrimaryType(compUnit);
        IType focusType = RefactoringUtil.determineFocusType(topLevelType, destination);
        return RefactoringUtil.checkOverloadingAndAmbiguity(focusType, null, newMethodName, newParamTypes, ambiguityMsgCreator, overloadingMsgCreator, pm);
    }

    public static RefactoringStatus checkOverloadingAndAmbiguity(IType focusType, ITypeHierarchy focusTypeHierarchy, String newMethodName, String[] newParamTypes, IAmbuguityMessageCreator ambigutiyMsgCreator, IOverloadingMessageCreator overloadingMsgCreator, IProgressMonitor pm) throws JavaModelException {
        ICompilationUnit compUnit = focusType.getCompilationUnit();
        if (focusTypeHierarchy == null) {
            focusTypeHierarchy = focusType.newTypeHierarchy(pm);
        }
        IType[] superTypes = focusTypeHierarchy.getAllSupertypes(focusType);
        IType[] subTypes = focusTypeHierarchy.getAllSubtypes(focusType);
        IOTType[] roleTypes = RefactoringUtil.getAllRoleClasses(compUnit.getJavaProject(), pm);
        ArrayList<IType> baseTypes = RefactoringUtil.getAllDeclaredBaseTypes(roleTypes);
        RefactoringStatus result = new RefactoringStatus();
        if (TypeHelper.isTeam((int)focusType.getFlags())) {
            result.merge(RefactoringUtil.checkOverloadingForTeamOrRegularClass(result, newMethodName, newParamTypes, focusType, overloadingMsgCreator, pm));
            if (result.getSeverity() == 2) {
                return result;
            }
        }
        if (TypeHelper.isRole((int)focusType.getFlags())) {
            IRoleType roleType = (IRoleType)OTModelManager.getOTElement((IType)focusType);
            result.merge(RefactoringUtil.checkOverloadingAndAmbiguityForRole(result, newMethodName, newParamTypes, roleType, ambigutiyMsgCreator, overloadingMsgCreator, pm));
            result.merge(RefactoringUtil.checkAmbiguityForBasePresentInFocusTypeSuperhierarchy(newMethodName, null, superTypes, ambigutiyMsgCreator, roleType));
        } else if (!baseTypes.contains(focusType)) {
            RefactoringUtil.checkOverloadingForTeamOrRegularClass(result, newMethodName, newParamTypes, focusType, overloadingMsgCreator, pm);
            if (result.getSeverity() == 2) {
                return result;
            }
        } else if (baseTypes.contains(focusType)) {
            result.merge(RefactoringUtil.checkOverloadingAndAmbiguityForBase(result, newMethodName, null, newParamTypes, focusType, roleTypes, ambigutiyMsgCreator, overloadingMsgCreator, pm));
        }
        if (subTypes.length != 0) {
            int idx = 0;
            while (idx < subTypes.length) {
                IType subType = subTypes[idx];
                if (TypeHelper.isRole((int)subType.getFlags())) {
                    IRoleType roleType = (IRoleType)OTModelManager.getOTElement((IType)subType);
                    result.merge(RefactoringUtil.checkOverloadingAndAmbiguityForRole(result, newMethodName, newParamTypes, roleType, ambigutiyMsgCreator, overloadingMsgCreator, pm));
                    if (result.hasWarning()) {
                        IType baseClass = roleType.getBaseClass();
                        ArrayList<IRoleType> roleList = new ArrayList<IRoleType>();
                        if (baseClass != null && baseClass.equals(focusType)) {
                            roleList.add(roleType);
                            result.merge(RefactoringUtil.checkForAmbiguousBaseMethodSpecs(roleList, newMethodName, null, ambigutiyMsgCreator));
                        } else {
                            result.merge(RefactoringUtil.checkAmbiguityForBasePresentInFocusTypeSuperhierarchy(newMethodName, null, superTypes, ambigutiyMsgCreator, roleType));
                        }
                    }
                } else if (!baseTypes.contains(subType)) {
                    result.merge(RefactoringUtil.checkOverloadingForTeamOrRegularClass(result, newMethodName, newParamTypes, subType, overloadingMsgCreator, pm));
                } else if (baseTypes.contains(subType)) {
                    result.merge(RefactoringUtil.checkOverloadingAndAmbiguityForBase(result, newMethodName, null, newParamTypes, subType, roleTypes, ambigutiyMsgCreator, overloadingMsgCreator, pm));
                }
                ++idx;
            }
        }
        return result;
    }

    public static RefactoringStatus checkOverloadingAndAmbiguity(ICompilationUnit compUnit, IType focusType, String newMethodName, String oldMethodName, String[] newParamTypes, IAmbuguityMessageCreator ambiguityMsgCreator, IOverloadingMessageCreator overloadingMsgCreator, IProgressMonitor pm) throws JavaModelException {
        ITypeHierarchy completeHierarchy = focusType.newTypeHierarchy(pm);
        IType[] superTypes = completeHierarchy.getAllSupertypes(focusType);
        IType[] subTypes = completeHierarchy.getAllSubtypes(focusType);
        IOTType[] roleTypes = RefactoringUtil.getAllRoleClasses(compUnit.getJavaProject(), pm);
        ArrayList<IType> baseTypes = RefactoringUtil.getAllDeclaredBaseTypes(roleTypes);
        RefactoringStatus result = new RefactoringStatus();
        if (TypeHelper.isTeam((int)focusType.getFlags())) {
            result.merge(RefactoringUtil.checkOverloadingForTeamOrRegularClass(result, newMethodName, newParamTypes, focusType, overloadingMsgCreator, pm));
            if (result.getSeverity() == 2) {
                return result;
            }
        }
        if (TypeHelper.isRole((int)focusType.getFlags())) {
            IRoleType roleType = (IRoleType)OTModelManager.getOTElement((IType)focusType);
            result.merge(RefactoringUtil.checkOverloadingAndAmbiguityForRole(result, newMethodName, newParamTypes, roleType, ambiguityMsgCreator, overloadingMsgCreator, pm));
            result.merge(RefactoringUtil.checkAmbiguityForBasePresentInFocusTypeSuperhierarchy(newMethodName, oldMethodName, superTypes, ambiguityMsgCreator, roleType));
        } else if (!baseTypes.contains(focusType)) {
            RefactoringUtil.checkOverloadingForTeamOrRegularClass(result, newMethodName, newParamTypes, focusType, overloadingMsgCreator, pm);
            if (result.getSeverity() == 2) {
                return result;
            }
        } else if (baseTypes.contains(focusType)) {
            result.merge(RefactoringUtil.checkOverloadingAndAmbiguityForBase(result, newMethodName, oldMethodName, newParamTypes, focusType, roleTypes, ambiguityMsgCreator, overloadingMsgCreator, pm));
        }
        if (subTypes.length != 0) {
            int idx = 0;
            while (idx < subTypes.length) {
                IType subType = subTypes[idx];
                if (TypeHelper.isRole((int)subType.getFlags())) {
                    IRoleType roleType = (IRoleType)OTModelManager.getOTElement((IType)subType);
                    result.merge(RefactoringUtil.checkOverloadingAndAmbiguityForRole(result, newMethodName, newParamTypes, roleType, ambiguityMsgCreator, overloadingMsgCreator, pm));
                    if (result.hasWarning()) {
                        IType baseClass = roleType.getBaseClass();
                        ArrayList<IRoleType> roleList = new ArrayList<IRoleType>();
                        if (baseClass != null && baseClass.equals(focusType)) {
                            roleList.add(roleType);
                            result.merge(RefactoringUtil.checkForAmbiguousBaseMethodSpecs(roleList, newMethodName, oldMethodName, ambiguityMsgCreator));
                        } else {
                            result.merge(RefactoringUtil.checkAmbiguityForBasePresentInFocusTypeSuperhierarchy(newMethodName, oldMethodName, superTypes, ambiguityMsgCreator, roleType));
                        }
                    }
                } else if (!baseTypes.contains(subType)) {
                    result.merge(RefactoringUtil.checkOverloadingForTeamOrRegularClass(result, newMethodName, newParamTypes, subType, overloadingMsgCreator, pm));
                } else if (baseTypes.contains(subType)) {
                    result.merge(RefactoringUtil.checkOverloadingAndAmbiguityForBase(result, newMethodName, oldMethodName, newParamTypes, subType, roleTypes, ambiguityMsgCreator, overloadingMsgCreator, pm));
                }
                ++idx;
            }
        }
        return result;
    }

    public static RefactoringStatusContext createContext(IRoleType roleType, MethodMappingElement methodSpec) {
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)roleType.getCompilationUnit(), (ASTNode)methodSpec);
        return context;
    }

    public static RefactoringStatus createWarningStatus(String msg, RefactoringStatusContext context, int code) {
        return RefactoringStatus.createStatus((int)2, (String)msg, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)code, null);
    }

    public static RefactoringStatus createErrorStatus(String msg, RefactoringStatusContext context, int code) {
        return RefactoringStatus.createStatus((int)3, (String)msg, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)code, null);
    }

    public static RefactoringStatus createFatalErrorStatus(String msg, RefactoringStatusContext context, int code) {
        return RefactoringStatus.createStatus((int)4, (String)msg, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)code, null);
    }

    public static boolean isOTSpecialCase(IMethod origMethod, String newMethodName, boolean checkImplementingClasses, IProgressMonitor pm) throws CoreException {
        IType declaringType = origMethod.getDeclaringType();
        if (!Flags.isTeam((int)declaringType.getFlags())) {
            if (Flags.isInterface((int)declaringType.getFlags()) && checkImplementingClasses) {
                ITypeHierarchy hier = declaringType.newTypeHierarchy(pm);
                IType[] impementingClasses = hier.getImplementingClasses(declaringType);
                boolean teamImplementsInterface = false;
                int idx = 0;
                while (idx < impementingClasses.length) {
                    if (Flags.isTeam((int)impementingClasses[idx].getFlags())) {
                        teamImplementsInterface = true;
                        break;
                    }
                    ++idx;
                }
                if (!teamImplementsInterface) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (newMethodName == null || newMethodName.length() == 0) {
            newMethodName = origMethod.getElementName();
        }
        assert (virtualTeamMethodNames.length == virtualTeamMethodParamTypes.length && virtualTeamMethodParamTypes.length == virtualTeamMethodReturnTypes.length);
        int i = 0;
        while (i < virtualTeamMethodNames.length) {
            if (virtualTeamMethodNames[i].equals(newMethodName) && Checks.compareParamTypes((String[])origMethod.getParameterTypes(), (String[])virtualTeamMethodParamTypes[i]) && virtualTeamMethodReturnTypes[i].equals(origMethod.getReturnType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ASTNode getASTNode(IMember member, Class<? extends ASTNode> nodeClass) {
        if (member == null || member.getCompilationUnit() == null) {
            return null;
        }
        ICompilationUnit source = member.getCompilationUnit();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        parser.setResolveBindings(true);
        CompilationUnit astRoot = (CompilationUnit)parser.createAST(null);
        try {
            ASTNode name = NodeFinder.perform((ASTNode)astRoot, (ISourceRange)member.getNameRange());
            return RefactoringUtil.getParent(name, nodeClass);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IMethod[] getOverriddenMethods(IMethod method, IProgressMonitor monitor) throws CoreException {
        assert (method != null);
        return RippleMethodFinder2.getRelatedMethods((IMethod)method, (IProgressMonitor)monitor, null);
    }

    public static IMethod getTopmostMethod(IMethod method, ITypeHierarchy typeHierarchy, IProgressMonitor monitor) throws JavaModelException {
        assert (method != null);
        ITypeHierarchy hierarchy = typeHierarchy;
        IMethod topmostMethod = null;
        IType declaringType = method.getDeclaringType();
        if (!declaringType.isInterface()) {
            IMethod inInterface;
            if (hierarchy == null || !declaringType.equals(hierarchy.getType())) {
                hierarchy = declaringType.newSupertypeHierarchy(monitor);
            }
            if ((inInterface = RefactoringUtil.isDeclaredInInterface(method, hierarchy, monitor)) != null && !inInterface.equals(method)) {
                topmostMethod = inInterface;
            }
        }
        if (topmostMethod == null) {
            IMethod overrides;
            if (hierarchy == null) {
                hierarchy = declaringType.newSupertypeHierarchy(monitor);
            }
            if ((overrides = RefactoringUtil.overridesAnotherMethod(method, hierarchy, monitor)) != null && !overrides.equals(method)) {
                topmostMethod = overrides;
            }
        }
        return topmostMethod;
    }

    public static IField fieldIsShadowedInType(String elementName, String typeSignature, IType type) throws JavaModelException {
        IField field = type.getField(elementName);
        if (field.exists() && !field.getTypeSignature().equals(typeSignature)) {
            return field;
        }
        return null;
    }

    public static MethodDeclaration methodToDeclaration(IMethod method, CompilationUnit node) throws JavaModelException {
        ICompilationUnit methodCU = (ICompilationUnit)method.getAncestor(5);
        if (!methodCU.equals(node.getJavaElement())) {
            node = RefactoringASTParser.parseWithASTProvider((ITypeRoot)methodCU, (boolean)true, null);
        }
        Name result = (Name)NodeFinder.perform((ASTNode)node, (ISourceRange)method.getNameRange());
        return (MethodDeclaration)RefactoringUtil.getParent((ASTNode)result, MethodDeclaration.class);
    }

    public static AbstractMethodMappingDeclaration methodMappingToDeclaration(IMethodMapping methodMapping, CompilationUnit node) throws JavaModelException {
        Name result = (Name)NodeFinder.perform((ASTNode)node, (ISourceRange)methodMapping.getNameRange());
        return (AbstractMethodMappingDeclaration)RefactoringUtil.getParent((ASTNode)result, AbstractMethodMappingDeclaration.class);
    }

    public static RefactoringStatus createNotYetFullyOTAwareMsg(String refactoringName) {
        return RefactoringStatus.createInfoStatus((String)NLS.bind((String)OTRefactoringMessages.RefactoringUtil_notFullyOTAware_info, (Object)refactoringName));
    }

    private static ASTNode getParent(ASTNode node, Class parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    public static ASTNode typeToDeclaration(IType type, CompilationUnit node) throws JavaModelException {
        Name result = (Name)NodeFinder.perform((ASTNode)node, (ISourceRange)type.getNameRange());
        if (type.isAnonymous()) {
            return RefactoringUtil.getParent((ASTNode)result, AnonymousClassDeclaration.class);
        }
        return RefactoringUtil.getParent((ASTNode)result, AbstractTypeDeclaration.class);
    }

    public static RefactoringStatus checkForExistingRoles(String refactoringName, IJavaProject project, IProgressMonitor pm) {
        try {
            if (project == null) {
                return RefactoringUtil.createNotYetFullyOTAwareMsg(refactoringName);
            }
            if (RefactoringUtil.getAllRoleClasses(project, pm).length > 0) {
                return RefactoringUtil.createNotYetFullyOTAwareMsg(refactoringName);
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringUtil.createNotYetFullyOTAwareMsg(refactoringName);
        }
        return new RefactoringStatus();
    }
}

