/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.help.actions;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.objectteams.otdt.internal.ui.help.Messages;
import org.eclipse.objectteams.otdt.internal.ui.help.OTJLDError;
import org.eclipse.objectteams.otdt.internal.ui.help.views.OTJLDView;
import org.eclipse.objectteams.otdt.ui.help.OTHelpPlugin;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.MarkerItem;

public class ShowOTJLDAction
implements IViewActionDelegate {
    private IWorkbenchPartSite m_site;
    private OTJLDView m_otjldView;
    private OTJLDError.OTURL[] m_urls;

    public void init(IViewPart view) {
        this.m_site = view.getSite();
    }

    public ShowOTJLDAction() {
    }

    private ShowOTJLDAction(IWorkbenchPartSite site, String text) {
        this.m_site = site;
        this.m_urls = new OTJLDError(text).getURLs();
    }

    public static IAction createAction(IWorkbenchPartSite site, String text) {
        final ShowOTJLDAction action = new ShowOTJLDAction(site, text);
        return new Action(Messages.UpdateRulerAction_goto_otjld_command_label){

            public void run() {
                action.run(null);
            }

            public ImageDescriptor getImageDescriptor() {
                return OTHelpPlugin.getOTJLDImage();
            }
        };
    }

    public void run(IAction action) {
        if (this.m_urls == null || this.m_urls.length == 0) {
            return;
        }
        try {
            if (OTJLDView.hasBrowser()) {
                IWorkbenchPage page = this.m_site != null ? this.m_site.getPage() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                this.m_otjldView = (OTJLDView)page.showView("org.eclipse.objectteams.otdt.ui.help.views.OTJLDView");
                this.m_otjldView.setURL(this.m_urls[0].getURL());
            }
        }
        catch (PartInitException ex) {
            OTHelpPlugin.logException("Unable to initialize browser", ex);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            this.evaluateSelection(selection);
            action.setEnabled(this.m_urls != null && this.m_urls.length > 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void evaluateSelection(ISelection selection) {
        this.m_urls = null;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() != 1) {
            return;
        }
        Object item = sel.getFirstElement();
        IMarker marker = null;
        if (item instanceof MarkerItem) {
            marker = ((MarkerItem)item).getMarker();
        } else if (item instanceof IMarker) {
            marker = (IMarker)item;
        }
        if (marker == null) {
            return;
        }
        try {
            if (!"org.eclipse.jdt.core.problem".equals(marker.getType())) {
                return;
            }
            String text = marker.getAttribute("message", null);
            if (text == null) {
                return;
            }
            OTJLDError error = new OTJLDError(text);
            this.m_urls = error.getURLs();
        }
        catch (CoreException ex) {
            OTHelpPlugin.logException("Cannot retrieve marker from selection", ex);
        }
    }
}

