/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.objectteams.otdt.core.compiler.OTNameUtils;
import org.eclipse.objectteams.otdt.internal.ui.OTDTUIMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarkable {
    static final String PDE_PLUGIN_NATURE_ID = "org.eclipse.pde.PluginNature";

    abstract String getName();

    abstract void removeCallinMarkers() throws CoreException;

    abstract IJavaElement getJavaElement();

    abstract IResource getResource();

    abstract IMarker createMarker(String var1) throws CoreException;

    abstract Set<IType> getAllTypes(IJavaProject[] var1, IProgressMonitor var2) throws CoreException;

    abstract IJavaProject[] getProjects() throws JavaModelException;

    abstract boolean containsElement(IJavaElement var1);

    void addSuperAndMemberTypes(Set<IType> members, Set<IType> supers, IType type, IJavaProject currentProject, IJavaProject[] projects, IProgressMonitor monitor) throws JavaModelException {
        int n;
        if (!type.exists()) {
            return;
        }
        IType superType = null;
        String superclassName = type.getSuperclassName();
        String packageName = null;
        String typeName = null;
        if (superclassName != null) {
            if ((superclassName = superclassName.replace('$', '.')).indexOf(46) != -1) {
                superType = currentProject.findType(superclassName);
            } else {
                String[][] resolvedSuperName = type.resolveType(superclassName);
                if (resolvedSuperName != null && resolvedSuperName.length == 1) {
                    packageName = resolvedSuperName[0][0];
                    typeName = resolvedSuperName[0][1];
                    if (!(packageName.equals("java.lang") && typeName.equals("Object") || (superType = currentProject.findType(packageName, typeName, null)) != null)) {
                        IJavaProject[] iJavaProjectArray = projects;
                        int n2 = projects.length;
                        n = 0;
                        while (n < n2) {
                            IJavaProject prj = iJavaProjectArray[n];
                            superType = prj.findType(packageName, typeName, null);
                            if (superType != null) break;
                            ++n;
                        }
                    }
                }
            }
        }
        if (superType != null && !superType.isAnonymous()) {
            supers.add(superType);
            if (!members.contains(superType)) {
                this.addSuperAndMemberTypes(members, supers, superType, currentProject, projects, monitor);
            }
        }
        IType[] iTypeArray = type.getTypes();
        n = iTypeArray.length;
        int n3 = 0;
        while (n3 < n) {
            IType member = iTypeArray[n3];
            if (!(member.isInterface() || Flags.isRole((int)member.getFlags()) && OTNameUtils.isTopConfined((String)member.getElementName()))) {
                members.add(member);
                if (!supers.contains(member)) {
                    this.addSuperAndMemberTypes(members, supers, member, currentProject, projects, monitor);
                }
            }
            ++n3;
        }
    }

    Set<IType> getSubTypes(Set<IType> types, IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask(OTDTUIMessages.AbstractMarkable_baseClassHierarchy_progress, types.size());
        IJavaSearchScope workspaceScope = SearchEngine.createWorkspaceScope();
        HashSet<IType> subTypes = new HashSet<IType>(13);
        for (IType type : types) {
            TypeHierarchy hier = new TypeHierarchy(type, null, workspaceScope, true);
            hier.refresh(monitor);
            IType[] iTypeArray = hier.getSubtypes(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType subType = iTypeArray[n2];
                subTypes.add(subType);
                ++n2;
            }
            monitor.worked(1);
        }
        monitor.done();
        return subTypes;
    }

    IJavaProject[] getProjects(IResource resource) {
        IJavaProject[] projects = null;
        if (resource != null) {
            IProject project = resource.getProject();
            projects = this.getProjectsToSearch(project);
        } else {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ArrayList<IJavaProject> projectList = new ArrayList<IJavaProject>();
            IProject[] iProjectArray = ws.getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject prj = iProjectArray[n2];
                if (this.isOTProject(prj) && prj.isOpen()) {
                    projectList.add(JavaCore.create((IProject)prj));
                }
                ++n2;
            }
            projects = projectList.toArray(new IJavaProject[projectList.size()]);
        }
        return projects;
    }

    private IJavaProject[] getProjectsToSearch(IProject baseProject) {
        HashSet<IJavaProject> result = new HashSet<IJavaProject>();
        this.calculateProjectsToSearch(baseProject, result);
        return result.toArray(new IJavaProject[result.size()]);
    }

    private boolean isOTProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.objectteams.otdt.OTJavaNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isPluginProject(IProject project) {
        try {
            return project.hasNature(PDE_PLUGIN_NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void calculateProjectsToSearch(IProject currentProject, Set<IJavaProject> allProjects) {
        if (this.isOTProject(currentProject)) {
            allProjects.add(JavaCore.create((IProject)currentProject));
        }
        IProject[] referencingProjects = currentProject.getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IProject project = referencingProjects[i];
            this.calculateProjectsToSearch(project, allProjects);
            ++i;
        }
    }

    public abstract boolean exists();
}

