/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.AbstractMarkable;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.JavaElementMarkable;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.ResourceMarkable;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;

public abstract class CallinMarkerJob
extends Job {
    private final IResource _resource;
    private final IClassFile _javaElement;

    public CallinMarkerJob(AbstractMarkable target) {
        super(OTDTUIPlugin.getResourceString("CallinMarkerJob.job_title"));
        if (target instanceof ResourceMarkable) {
            this._resource = ((ResourceMarkable)target).fResource;
            this._javaElement = null;
        } else {
            this._resource = null;
            this._javaElement = ((JavaElementMarkable)target).fJavaElement;
        }
        IResource resource = target.getResource();
        if (resource != null) {
            this.setRule(resource.getWorkspace().getRuleFactory().markerRule(resource));
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.updateMarkers(monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception ex) {
            return OTDTUIPlugin.createErrorStatus("Exception during marker creation.", ex);
        }
        catch (Error error) {}
        return Status.OK_STATUS;
    }

    protected abstract void updateMarkers(IProgressMonitor var1) throws Exception;

    public final IResource getResource() {
        return this._resource;
    }

    public final IClassFile getJavaElement() {
        return this._javaElement;
    }
}

