/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.eclipse.jdt.internal.core.index.JarIndexLocation;

public abstract class IndexLocation {
    private final URL url;
    protected boolean participantIndex;

    public static IndexLocation createIndexLocation(URL url) {
        URL localUrl;
        try {
            localUrl = FileLocator.resolve((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
        if (localUrl.getProtocol().equals("file")) {
            return new FileIndexLocation(url, new File(localUrl.getPath()));
        }
        return new JarIndexLocation(url, localUrl);
    }

    protected IndexLocation(File file) {
        URL tempUrl = null;
        try {
            tempUrl = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {}
        this.url = tempUrl;
    }

    public IndexLocation(URL url) {
        this.url = url;
    }

    public void close() {
    }

    public abstract boolean createNewFile() throws IOException;

    public abstract boolean delete();

    public abstract boolean exists();

    public abstract String fileName();

    public abstract String getCanonicalFilePath();

    public abstract File getIndexFile();

    abstract InputStream getInputStream() throws IOException;

    public URL getUrl() {
        return this.url;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean isParticipantIndex() {
        return this.participantIndex;
    }

    public abstract long lastModified();

    public abstract long length();

    public abstract boolean startsWith(IPath var1);

    public String toString() {
        return this.url.toString();
    }
}

