/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.debug.adaptor.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.objectteams.otdt.internal.debug.adaptor.DebugMessages;
import org.eclipse.objectteams.otdt.internal.debug.adaptor.OTDebugAdaptorPlugin;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class OTREBlock {
    protected String enableCheckboxLabel = DebugMessages.OTLaunching_OTRE_checkbox_label;
    Button _otreToggleButton;
    boolean _useOTRE;

    public abstract Button createCheckButton(Composite var1, String var2);

    public abstract void setDirty(boolean var1);

    public abstract void updateLaunchConfigurationDialog();

    public Group createOTRESection(Composite parent) {
        Group group;
        block2: {
            group = new Group(parent, 0);
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(String.valueOf(DebugMessages.OTLaunching_OTRE_group_title) + ':');
            GridData gd = new GridData(768);
            gd.horizontalSpan = 1;
            group.setLayoutData((Object)gd);
            this._otreToggleButton = this.createCheckButton((Composite)group, this.enableCheckboxLabel);
            this._otreToggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OTREBlock.this._useOTRE = OTREBlock.this._otreToggleButton.getSelection();
                    OTREBlock.this.setDirty(true);
                    OTREBlock.this.updateLaunchConfigurationDialog();
                }
            });
            while (!(parent instanceof CTabFolder)) {
                if (parent != null) {
                    parent = parent.getParent();
                    continue;
                }
                break block2;
            }
            this._otreToggleButton.setFont(parent.getFont());
        }
        return group;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.tryInitializeFrom(config, this.hasOTJProject(config));
        }
        catch (CoreException ex) {
            OTDebugAdaptorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.internal.debug.adaptor", DebugMessages.OTLaunching_loading_failed_msg, (Throwable)ex));
        }
    }

    protected void tryInitializeFrom(ILaunchConfiguration config, boolean hasOTJProject) throws CoreException {
        this._otreToggleButton.setEnabled(hasOTJProject);
        this._useOTRE = config.getAttribute("org.eclipse.objectteams.launch", this._useOTRE);
        this._otreToggleButton.setSelection(this._useOTRE);
    }

    boolean hasOTJProject(ILaunchConfiguration config) {
        try {
            IProject project;
            String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName != null && new Path("").isValidSegment(projectName) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.hasNature("org.eclipse.objectteams.otdt.OTJavaNature")) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this._otreToggleButton != null) {
            try {
                if (config.getAttribute("org.eclipse.objectteams.launch", false) != this._useOTRE) {
                    config.setAttribute("org.eclipse.objectteams.launch", this._useOTRE);
                }
            }
            catch (CoreException ex) {
                OTDebugAdaptorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.internal.debug.adaptor", DebugMessages.OTLaunching_loading_failed_msg, (Throwable)ex));
            }
        }
    }
}

