/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodMappingBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PrecedenceDeclaration;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.objectteams.otdt.internal.ui.assist.LinkedModeAdaptor;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.StringLinkedModeProposal;
import org.eclipse.objectteams.otdt.ui.ImageManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEdit;

public class PrecedenceProposalSubProcessor {
    static final String KEY_PRECEDENCE = "precedence";
    static final String KEY_LABEL1 = "label1";
    static final String KEY_LABEL2 = "label2";
    ICompilationUnit cu;
    ASTNode focusNode;
    AST ast;
    ASTRewrite rewrite;

    public PrecedenceProposalSubProcessor(ICompilationUnit cu, ASTNode focusNode) {
        this.cu = cu;
        this.focusNode = focusNode;
    }

    ICommandAccess getAddBindingPrecedenceProposal(TypeDeclaration roleType, String[] problemArguments) {
        this.ast = this.focusNode.getAST();
        this.rewrite = ASTRewrite.create((AST)this.ast);
        SimpleName name1 = null;
        SimpleName name2 = null;
        String callin1 = problemArguments[1];
        String callin2 = problemArguments[3];
        CallinMappingDeclaration mapping1 = PrecedenceProposalSubProcessor.findCallinMapping(roleType, callin1);
        CallinMappingDeclaration mapping2 = PrecedenceProposalSubProcessor.findCallinMapping(roleType, callin2);
        if (callin1.charAt(0) == '<' && mapping1 != null) {
            callin1 = "callin1";
            name1 = this.ast.newSimpleName(callin1);
        }
        if (callin2.charAt(0) == '<' && mapping2 != null) {
            callin2 = "callin2";
            name2 = this.ast.newSimpleName(callin2);
        }
        if (callin1.charAt(0) == '<' || callin2.charAt(0) == '<') {
            return null;
        }
        if (!problemArguments[0].equals(problemArguments[2])) {
            return null;
        }
        LinkedCorrectionProposal proposal = this.getPrecedenceProposal(roleType, Messages.format((String)CorrectionMessages.OTQuickfix_addbindingprecedence_description, (Object[])new String[]{roleType.getName().getIdentifier()}), callin1, callin2, mapping1 != null && Modifier.isAfter((int)mapping1.getCallinModifier()), name1 != null, name2 != null);
        if (name2 != null) {
            this.rewrite.set((ASTNode)mapping2, (StructuralPropertyDescriptor)CallinMappingDeclaration.NAME_PROPERTY, (Object)name2, null);
            proposal.addLinkedPosition(this.rewrite.track((ASTNode)name2), true, KEY_LABEL2);
        }
        if (name1 != null) {
            this.rewrite.set((ASTNode)mapping1, (StructuralPropertyDescriptor)CallinMappingDeclaration.NAME_PROPERTY, (Object)name1, null);
            proposal.addLinkedPosition(this.rewrite.track((ASTNode)name1), true, KEY_LABEL1);
        }
        return proposal;
    }

    ICommandAccess getAddBindingPrecedenceToTeamProposal(TypeDeclaration teamType, String[] problemArguments) {
        String callin1 = problemArguments[1];
        String callin2 = problemArguments[3];
        if (callin1.charAt(0) == '<' || callin2.charAt(0) == '<') {
            return null;
        }
        this.ast = this.focusNode.getAST();
        this.rewrite = ASTRewrite.create((AST)this.ast);
        return this.getPrecedenceProposal(teamType, Messages.format((String)CorrectionMessages.OTQuickfix_addbindingprecedence_description, (Object[])new String[]{teamType.getName().getIdentifier()}), String.valueOf(Signature.getSimpleName((String)problemArguments[0])) + "." + callin1, String.valueOf(Signature.getSimpleName((String)problemArguments[2])) + "." + callin2, Modifier.ModifierKeyword.AFTER_KEYWORD.toString().equals(problemArguments[4]), false, false);
    }

    ICommandAccess getAddRolePrecedenceToTeamProposal(TypeDeclaration teamType, String[] problemArguments) {
        if (problemArguments[0].equals(problemArguments[2])) {
            return null;
        }
        this.ast = this.focusNode.getAST();
        this.rewrite = ASTRewrite.create((AST)this.ast);
        return this.getPrecedenceProposal(teamType, Messages.format((String)CorrectionMessages.OTQuickfix_addroleprecedence_description, (Object[])new String[]{teamType.getName().getIdentifier()}), Signature.getSimpleName((String)problemArguments[0]), Signature.getSimpleName((String)problemArguments[2]), Modifier.ModifierKeyword.AFTER_KEYWORD.toString().equals(problemArguments[4]), false, false);
    }

    private LinkedCorrectionProposal getPrecedenceProposal(TypeDeclaration targetType, String label, String callin1, String callin2, boolean isAfter, boolean linkLabel1, boolean linkLabel2) {
        ChildListPropertyDescriptor precedenceProperty = targetType instanceof RoleTypeDeclaration ? RoleTypeDeclaration.PRECEDENCE_PROPERTY : TypeDeclaration.PRECEDENCE_PROPERTY;
        ListRewrite listRewrite = this.rewrite.getListRewrite((ASTNode)targetType, precedenceProperty);
        PrecedenceDeclaration newPrecedence = this.ast.newPrecedenceDeclaration();
        Name element1 = this.ast.newName(callin1);
        Name element2 = this.ast.newName(callin2);
        newPrecedence.elements().add(element1);
        newPrecedence.elements().add(element2);
        if (isAfter) {
            newPrecedence.setAfter(true);
        }
        listRewrite.insertLast((ASTNode)newPrecedence, null);
        MyLinkedCorrectionProposal proposal = new MyLinkedCorrectionProposal(label, this.cu, this.rewrite, 10, ImageManager.getSharedInstance().get("callinbindingreplace_obj.gif"));
        if (callin1 != null && callin2 != null) {
            if (!linkLabel1 && !linkLabel2) {
                String prefix = isAfter ? "precedence after " : "precedence ";
                proposal.addLinkedPosition(this.rewrite.track((ASTNode)newPrecedence), false, KEY_PRECEDENCE);
                proposal.addLinkedPositionProposal(KEY_PRECEDENCE, String.valueOf(prefix) + callin1 + ", " + callin2 + ";", null);
                proposal.addLinkedPositionProposal(KEY_PRECEDENCE, String.valueOf(prefix) + callin2 + ", " + callin1 + ";", null);
            } else {
                final ITrackedNodePosition precedencePosition = this.rewrite.track((ASTNode)newPrecedence);
                ITrackedNodePosition swapPosition = new ITrackedNodePosition(){

                    public int getLength() {
                        return PrecedenceProposalSubProcessor.KEY_PRECEDENCE.length();
                    }

                    public int getStartPosition() {
                        return precedencePosition.getStartPosition();
                    }
                };
                proposal.addLinkedPosition(swapPosition, false, KEY_PRECEDENCE);
                LinkedProposalPositionGroup positionGroup = proposal.getLinkedProposalModel().getPositionGroup(KEY_PRECEDENCE, true);
                positionGroup.addProposal((LinkedProposalPositionGroup.Proposal)new StringLinkedModeProposal(CorrectionMessages.OTQuickfix_swapordermenu_label, CorrectionMessages.OTQuickfix_swapordermenu_description));
                positionGroup.addProposal((LinkedProposalPositionGroup.Proposal)new SwapPrecedencesProposal());
                if (linkLabel1) {
                    proposal.addLinkedPosition(this.rewrite.track((ASTNode)element1), false, KEY_LABEL1);
                }
                if (linkLabel2) {
                    proposal.addLinkedPosition(this.rewrite.track((ASTNode)element2), false, KEY_LABEL2);
                }
            }
        }
        return proposal;
    }

    private static CallinMappingDeclaration findCallinMapping(TypeDeclaration roleType, String callinName) {
        boolean isAnonymous = callinName.charAt(0) == '<';
        List members = roleType.bodyDeclarations();
        if (members != null) {
            for (Object object : members) {
                String currentName;
                IMethodMappingBinding binding;
                CallinMappingDeclaration mapping;
                if (!(object instanceof CallinMappingDeclaration) || !((mapping = (CallinMappingDeclaration)object).getName() != null ? mapping.getName().getIdentifier().equals(callinName) : isAnonymous && (binding = mapping.resolveBinding()) != null && (currentName = binding.getName()).startsWith(callinName))) continue;
                return mapping;
            }
        }
        return null;
    }

    class MyLinkedCorrectionProposal
    extends LinkedCorrectionProposal {
        public MyLinkedCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance, Image image) {
            super(name, cu, rewrite, relevance, image);
        }

        public LinkedProposalModel getLinkedProposalModel() {
            return super.getLinkedProposalModel();
        }
    }

    class SwapPrecedencesProposal
    extends LinkedProposalPositionGroup.Proposal {
        public SwapPrecedencesProposal() {
            super(Messages.format((String)CorrectionMessages.OTQuickfix_swapprecedenceorder_label, null), null, 0);
        }

        public String getAdditionalProposalInfo() {
            return Messages.format((String)CorrectionMessages.OTQuickfix_swapprecedenceorder_description, null);
        }

        public TextEdit computeEdits(int offset, LinkedPosition position, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            try {
                if (!LinkedModeAdaptor.instance.leaveLinkedMode()) {
                    return null;
                }
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            ASTParser p = ASTParser.newParser((int)4);
            p.setSource(PrecedenceProposalSubProcessor.this.cu);
            p.setResolveBindings(false);
            p.setFocalPosition(offset);
            CompilationUnit astCU = (CompilationUnit)p.createAST(null);
            PrecedenceProposalSubProcessor.this.ast = astCU.getAST();
            ASTNode node = NodeFinder.perform((ASTNode)astCU, (int)offset, (int)1);
            PrecedenceDeclaration prec = (PrecedenceDeclaration)node;
            try {
                PrecedenceProposalSubProcessor.this.rewrite = ASTRewrite.create((AST)PrecedenceProposalSubProcessor.this.ast);
                ListRewrite listRewrite = PrecedenceProposalSubProcessor.this.rewrite.getListRewrite((ASTNode)prec, PrecedenceDeclaration.ELEMENTS_PROPERTY);
                SimpleName n1 = (SimpleName)prec.elements().get(0);
                listRewrite.remove((ASTNode)n1, null);
                listRewrite.insertLast((ASTNode)PrecedenceProposalSubProcessor.this.ast.newSimpleName(n1.getIdentifier()), null);
                return PrecedenceProposalSubProcessor.this.rewrite.rewriteAST();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }
}

