/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.objectteams.otdt.core.ext.IMarkableJavaElement;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallinMarker {
    public static final String CALLIN_ID = "org.eclipse.objectteams.otdt.ui.callinMarker";
    public static final String CALLOUT_ID = "org.eclipse.objectteams.otdt.ui.calloutMarker";
    public static final String PLAYEDBY_ID = "org.eclipse.objectteams.otdt.ui.playedByMarker";
    public static final String ATTR_BASE_ELEMENT = "org.eclipse.objectteams.otdt.ui.markerAttr.BaseElement";
    public static final String ATTR_ROLE_ELEMENTS = "org.eclipse.objectteams.otdt.ui.markerAttr.RoleElements";
    public static final String[] CALLIN_MARKER_IDS = new String[]{"org.eclipse.objectteams.otdt.ui.playedByMarker", "org.eclipse.objectteams.otdt.ui.callinMarker", "org.eclipse.objectteams.otdt.ui.calloutMarker"};
    private Map<String, Object> _attribs = new HashMap<String, Object>(11);
    private String id;

    public CallinMarker(String markerKind) {
        this.id = markerKind;
        this._attribs.put("severity", new Integer(0));
        this._attribs.put("priority", new Integer(2));
    }

    public void setLineNumber(int line) {
        this._attribs.put("lineNumber", new Integer(line));
    }

    public void setNameRange(ISourceRange nameRange) {
        this._attribs.put("charStart", nameRange.getOffset());
        this._attribs.put("charEnd", nameRange.getOffset() + nameRange.getLength());
    }

    public <M extends IMember> void setRoleElement(Set<M> roleElements) {
        StringBuffer encoded = new StringBuffer();
        for (IMember m : roleElements) {
            encoded.append(m.getHandleIdentifier());
            encoded.append('\n');
        }
        this._attribs.put(ATTR_ROLE_ELEMENTS, encoded.toString());
    }

    public void setBaseElement(IMember baseElement) {
        this._attribs.put(ATTR_BASE_ELEMENT, baseElement.getHandleIdentifier());
        if (baseElement.getElementType() == 7) {
            this._attribs.put("message", String.valueOf(OTDTUIPlugin.getResourceString("CallinMarker.playedby_tooltip")) + ' ' + baseElement.getElementName());
        } else if (this.id == CALLIN_ID) {
            this._attribs.put("message", String.valueOf(OTDTUIPlugin.getResourceString("CallinMarker.callin_tooltip")) + ' ' + baseElement.getElementName() + "()");
        } else if (this.id == CALLOUT_ID) {
            String baseMemberName = baseElement.getElementName();
            if (baseElement.getElementType() == 9) {
                baseMemberName = String.valueOf(baseMemberName) + "()";
            }
            this._attribs.put("message", String.valueOf(OTDTUIPlugin.getResourceString("CallinMarker.callout_tooltip")) + ' ' + baseMemberName);
        }
    }

    public void create(IMarkableJavaElement target) throws CoreException {
        IMarker marker = target.createMarker(this.id);
        Map markerAttributes = marker.getAttributes();
        if (markerAttributes != null) {
            this._attribs.putAll(markerAttributes);
        }
        marker.setAttributes(this._attribs);
        this._attribs.clear();
    }

    public static IMarker[] getAllBindingMarkers(IResource resource) throws CoreException {
        IMarker[] markers1 = resource.findMarkers(PLAYEDBY_ID, true, 2);
        IMarker[] markers2 = resource.findMarkers(CALLIN_ID, true, 2);
        IMarker[] markers3 = resource.findMarkers(CALLOUT_ID, true, 2);
        int len1 = markers1.length;
        int len2 = markers2.length;
        int len3 = markers3.length;
        IMarker[] result = new IMarker[len1 + len2 + len3];
        System.arraycopy(markers1, 0, result, 0, len1);
        System.arraycopy(markers2, 0, result, len1, len2);
        System.arraycopy(markers3, 0, result, len1 + len2, len3);
        return result;
    }

    public static boolean isTypeMarker(IMarker marker) {
        try {
            return marker.getType().equals(PLAYEDBY_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

