/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.bindingeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.BindingEditor;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.Messages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class BindingEditorDialog
extends Dialog {
    private String _title;
    protected IType _team;
    private BindingEditor _bindingEditor;
    private CompilationUnit _root;
    private IDocument _originalDocument;

    public BindingEditorDialog(Shell parentShell, IType teamType) {
        super(parentShell);
        super.setShellStyle(this.getShellStyle() | 0x10);
        this._title = String.valueOf(Messages.BindingEditorDialog_dialog_title) + teamType.getElementName();
        this._team = teamType;
    }

    public int open() {
        this.parseCurrentTeam();
        this.openResource((IFile)this._team.getCompilationUnit().getResource());
        return super.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this._title != null) {
            shell.setText(this._title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new FormLayout());
        this._bindingEditor = new BindingEditor(container, 0, this._team, this._root);
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        this._bindingEditor.setLayoutData(formData);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point calced = super.getInitialSize();
        return new Point(Math.max(calced.x, 881), calced.y);
    }

    protected void okPressed() {
        this.setReturnCode(0);
        NullProgressMonitor monitor = new NullProgressMonitor();
        ICompilationUnit cu = this._team.getCompilationUnit();
        Map options = cu.getJavaProject().getOptions(true);
        options.put("org.eclipse.objectteams.otdt.compiler.option.scoped_keywords", "disabled");
        TextEdit edits = this._root.rewrite(this._originalDocument, options);
        try {
            edits.apply(this._originalDocument);
            String newSource = this._originalDocument.get();
            IBuffer buf = cu.getBuffer();
            buf.setContents(newSource);
            try {
                IWorkbenchPage activePage = JavaPlugin.getActivePage();
                IEditorSite site = activePage.getActiveEditor().getEditorSite();
                OrganizeImportsAction organizeImportsAction = new OrganizeImportsAction((IWorkbenchSite)site);
                organizeImportsAction.run(cu);
            }
            catch (NullPointerException ex) {
                JavaPlugin.log((Throwable)ex);
            }
            buf.save((IProgressMonitor)monitor, false);
        }
        catch (Exception ex) {
            JavaPlugin.log((Throwable)ex);
        }
        this.close();
    }

    private void openResource(IFile resource) {
        try {
            IDE.openEditor((IWorkbenchPage)JavaPlugin.getActivePage(), (IFile)resource, (boolean)true);
        }
        catch (PartInitException ex) {
            JavaPlugin.log((Throwable)ex);
        }
    }

    private void parseCurrentTeam() {
        try {
            this._originalDocument = new Document(this._team.getCompilationUnit().getSource());
            ASTParser parser = ASTParser.newParser((int)4);
            parser.setSource(this._team.getCompilationUnit());
            parser.setResolveBindings(true);
            HashMap<String, String> options = new HashMap<String, String>(JavaCore.getOptions());
            options.put("org.eclipse.jdt.core.ASTIncludesRoleFiles", "enabled");
            parser.setCompilerOptions(options);
            this._root = (CompilationUnit)parser.createAST(null);
            this._root.recordModifications();
        }
        catch (JavaModelException ex) {
            this._originalDocument = null;
            JavaPlugin.log((Throwable)ex);
        }
    }
}

