/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal.hook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.objectteams.otequinox.hook.ClassScanner;
import org.eclipse.objectteams.otequinox.hook.HookConfigurator;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.eclipse.objectteams.otequinox.hook.ITeamLoader;
import org.eclipse.objectteams.otequinox.internal.hook.BundleRegistry;
import org.eclipse.objectteams.otequinox.internal.hook.SafeAspectRegistry;
import org.osgi.framework.Bundle;

public class BaseBundleRole {
    static final String SELF = "SELF";
    final String symbolicName;
    Bundle bundle;
    ArrayList<Bundle> aspectBundles = new ArrayList();
    State state = State.INITIAL;
    HashSet<String> missingClassNames = new HashSet();
    HashMap<String, Class<?>> knownAlienClasses = new HashMap();

    BaseBundleRole(Bundle bundle) {
        this.bundle = bundle;
        this.symbolicName = bundle.getSymbolicName();
    }

    void setup(Bundle bundle, State state) {
        this.state = state;
        this.bundle = bundle;
    }

    static BaseBundleRole createBaseBundleRole(BundleRegistry bundleRegistry, Bundle baseBundle, Bundle aspectBundle) {
        String symbolicName = baseBundle.getSymbolicName();
        BaseBundleRole baseRole = bundleRegistry.adaptedBaseBundles.get(symbolicName);
        if (baseRole == null) {
            baseRole = new BaseBundleRole(baseBundle);
            bundleRegistry.adaptedBaseBundles.put(symbolicName, baseRole);
        }
        baseRole.aspectBundles.add(aspectBundle);
        return baseRole;
    }

    /*
     * Unable to fully structure code
     */
    static void endActivation(BundleRegistry bundleRegistry, Bundle bundle, SafeAspectRegistry aspectRegistry, ITeamLoader loader) {
        symbolicName = bundle.getSymbolicName();
        baseRole = bundleRegistry.adaptedBaseBundles.get(symbolicName);
        if (baseRole != null) {
            aspects = aspectRegistry.getAdaptingAspectPlugins(bundle);
            if (aspects.length == 0) {
                return;
            }
            bundle.getResource("META-INF/MANIFEST.MF");
            try {
                var10_7 = aspects;
                var9_8 = aspects.length;
                var8_9 = 0;
                while (var8_9 < var9_8) {
                    aspect = var10_7[var8_9];
                    aspectBundleRole = bundleRegistry.aspectBundles.get(aspect);
                    aspectBundleRole.isLoading = true;
                    ++var8_9;
                }
                baseRole.endActivation(loader);
            }
            finally {
                var16_14 = aspects;
                var15_16 = aspects.length;
                var14_18 = 0;
                ** while (var14_18 < var15_16)
            }
lbl-1000:
            // 1 sources

            {
                aspect = var16_14[var14_18];
                aspectBundleRole = bundleRegistry.aspectBundles.get(aspect);
                aspectBundleRole.isLoading = false;
                ++var14_18;
                continue;
            }
        }
lbl31:
        // 3 sources

    }

    private void endActivation(ITeamLoader loader) {
        ILogger log = HookConfigurator.getLogger();
        switch (this.state) {
            case WAIT_FOR_TEAM: {
                log.log(4, "Asynchronuous activation while initializing class loader: " + this);
                this.state = State.ACTIVATED;
                break;
            }
            case TEAMS_LOADED: {
                this.state = State.TEAMS_INSTANTIATED;
                log.log(0, "PHASE 2: Handling base plugin with aspects pending for instantiation: " + this.bundle.getSymbolicName());
                loader.instantiateTeams(this.bundle, null);
            }
        }
    }

    void loadTeams(ITeamLoader loader, ClassScanner scanner) {
        ILogger log = HookConfigurator.getLogger();
        if (this.state != State.WAIT_FOR_TEAM) {
            log.log(4, "Unexpected state when loading teams for " + this);
        }
        log.log(0, "PHASE 1: Load team classes adapting plugin " + this.symbolicName);
        if (loader.loadTeams(this.bundle, scanner)) {
            if (this.state == State.ACTIVATED) {
                this.state = State.TEAMS_INSTANTIATED;
                log.log(4, "!!!! Unexpected control flow !!!!");
                log.log(1, "PHASE 2: Handling base plugin with aspects pending for instantiation: " + this.symbolicName);
                loader.instantiateTeams(this.bundle, null);
            } else {
                this.state = State.TEAMS_LOADED;
            }
        } else {
            this.state = State.TEAMS_INSTANTIATED;
        }
    }

    public String toString() {
        String result = "Base Bundle " + this.symbolicName + "(" + (Object)((Object)this.state) + ")";
        for (Bundle aspect : this.aspectBundles) {
            result = String.valueOf(result) + "\n\t" + aspect;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INITIAL,
        WAIT_FOR_TEAM,
        ACTIVATED,
        TEAMS_LOADED,
        TEAMS_INSTANTIATED;

    }
}

