/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.IDependentTypeSubstitution;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class AnchorMapping {
    private static final ThreadLocal<AnchorMapping> currentMappings = new ThreadLocal();
    private AnchorMapping _previous = null;
    private Statement[] _arguments = null;
    private Expression _receiver = null;
    private Scope _scope = null;
    private HashMap<MethodBinding, TypeBinding[]> _instantiatedParameters = new HashMap();
    private boolean _allowInstantiation = true;
    private MethodSignatureEnhancer _methodSignatureEnhancer;

    public static boolean isDefined() {
        return currentMappings.get() != null;
    }

    public static AnchorMapping setupNewMapping(Expression receiver, Statement[] arguments, Scope scope) {
        AnchorMapping previous = currentMappings.get();
        if (receiver instanceof CastExpression) {
            receiver = ((CastExpression)receiver).expression;
        }
        AnchorMapping newMapping = new AnchorMapping(receiver, arguments, scope);
        newMapping._previous = previous;
        currentMappings.set(newMapping);
        return newMapping;
    }

    public static void removeCurrentMapping(AnchorMapping current) {
        currentMappings.set(null);
        if (current != null) {
            currentMappings.set(current._previous);
        }
    }

    public static void allowInstantiation(boolean allow) {
        AnchorMapping currentMapping = currentMappings.get();
        if (currentMapping != null) {
            currentMapping._allowInstantiation = allow;
        }
    }

    public static TypeBinding[] instantiateParameters(Scope scope, TypeBinding[] parameters, MethodBinding currentMethod) {
        AnchorMapping currentMapping = currentMappings.get();
        if (currentMapping == null || !currentMapping._allowInstantiation) {
            return parameters;
        }
        return currentMapping.internalInstantiateParameters(scope, parameters, currentMethod);
    }

    private TypeBinding[] internalInstantiateParameters(Scope scope, TypeBinding[] parameters, MethodBinding currentMethod) {
        int start;
        if (this._arguments != null && this._arguments.length != parameters.length) {
            return parameters;
        }
        if (scope == null) {
            scope = this._scope;
        }
        TypeBinding[] newParams = null;
        boolean isMethodEnhanced = currentMethod != null && currentMethod.isCallin();
        int i = start = isMethodEnhanced ? this._methodSignatureEnhancer.ENHANCING_ARG_LEN : 0;
        while (i < parameters.length) {
            TypeBinding newParameter = this.instantiateParameter(scope, parameters[i], i, currentMethod, isMethodEnhanced);
            if (newParameter != null && TypeBinding.notEquals(newParameter, parameters[i])) {
                if (newParams == null) {
                    newParams = new TypeBinding[parameters.length];
                    System.arraycopy(parameters, 0, newParams, 0, parameters.length);
                }
                newParams[i] = newParameter;
            }
            ++i;
        }
        if (newParams != null) {
            return newParams;
        }
        return parameters;
    }

    private TypeBinding instantiateParameter(final Scope scope, TypeBinding parameter, final int i, final MethodBinding currentMethod, final boolean isMethodEnhanced) {
        return RoleTypeCreator.deepSubstitute(parameter, scope.environment(), new IDependentTypeSubstitution(){

            @Override
            public TypeBinding substitute(DependentTypeBinding paramDependentType, TypeBinding[] typeArguments, int dimensions) {
                int srcIdx = isMethodEnhanced ? i - ((AnchorMapping)AnchorMapping.this)._methodSignatureEnhancer.ENHANCING_ARG_LEN : i;
                ITeamAnchor anchor = null;
                if (AnchorMapping.this._arguments != null) {
                    anchor = AnchorMapping.this.translateAnchor(scope, AnchorMapping.this._arguments[srcIdx], paramDependentType, currentMethod);
                }
                if (anchor == null && paramDependentType.hasAnchorWithinThisMethodsSignature(currentMethod)) {
                    return new ProblemReferenceBinding(paramDependentType.sourceName(), (ReferenceBinding)paramDependentType, 29);
                }
                if (anchor == null && AnchorMapping.this._receiver != null) {
                    if (DependentTypeBinding.isDependentTypeOf(((AnchorMapping)AnchorMapping.this)._receiver.resolvedType, paramDependentType._teamAnchor)) {
                        DependentTypeBinding depReceiver = (DependentTypeBinding)((AnchorMapping)AnchorMapping.this)._receiver.resolvedType;
                        return depReceiver._teamAnchor.getRoleTypeBinding(paramDependentType, typeArguments, dimensions);
                    }
                    ITeamAnchor newAnchor = TeamAnchor.getTeamAnchor(AnchorMapping.this._receiver);
                    if (newAnchor != null && newAnchor.isValidBinding() && newAnchor != paramDependentType._teamAnchor && paramDependentType._teamAnchor.isPrefixLegal(scope.enclosingSourceType(), newAnchor)) {
                        newAnchor = paramDependentType._teamAnchor.setPathPrefix(newAnchor);
                        return newAnchor.getRoleTypeBinding(paramDependentType, typeArguments, dimensions);
                    }
                    if (DependentTypeBinding.isDependentTypeVariable(currentMethod.parameters[i])) {
                        int pos;
                        TypeVariableBinding typeVariable = (TypeVariableBinding)((DependentTypeBinding)currentMethod.parameters[i]).type;
                        ITeamAnchor[] anchors = typeVariable.anchors;
                        if (anchors != null && anchors[0] instanceof LocalVariableBinding && (pos = ((LocalVariableBinding)anchors[0]).resolvedPosition) < AnchorMapping.this._arguments.length) {
                            anchor = AnchorMapping.this.translateAnchor(scope, AnchorMapping.this._arguments[pos], (DependentTypeBinding)currentMethod.parameters[i], currentMethod);
                        }
                    }
                }
                if ((anchor = AnchorMapping.this.validAnchor(anchor)) != null) {
                    return anchor.getRoleTypeBinding(paramDependentType, typeArguments, dimensions);
                }
                return paramDependentType;
            }
        });
    }

    private ITeamAnchor translateAnchor(Scope scope, ASTNode typedNode, DependentTypeBinding paramDependentType, MethodBinding currentMethod) {
        ProblemReporter problemReporter = scope != null ? scope.problemReporter() : null;
        ITeamAnchor anchor = null;
        if (paramDependentType.hasAnchorWithinThisMethodsSignature(currentMethod) && this._arguments != null) {
            Statement anchorExpr = this._arguments[paramDependentType._argumentPosition];
            ReferenceBinding roleType = paramDependentType.getRealType();
            anchor = anchorExpr instanceof Expression ? RoleTypeCreator.getAnchorVariableBinding(null, (Expression)anchorExpr, roleType, problemReporter, typedNode) : ((Argument)anchorExpr).binding;
        } else if (paramDependentType._teamAnchor instanceof TThisBinding) {
            ReferenceBinding paramRoleType = paramDependentType instanceof WeakenedTypeBinding ? paramDependentType.type : paramDependentType;
            ReferenceBinding tthisType = ((ParameterizedTypeBinding)paramRoleType).enclosingType();
            SourceTypeBinding site = scope != null ? scope.enclosingSourceType() : null;
            ReferenceBinding roleRef = ((DependentTypeBinding)paramRoleType).getRealType();
            if (this._receiver != null && TypeAnalyzer.isVariableRef(this._receiver)) {
                boolean reportError = TeamModel.isTeamContainingRole((ReferenceBinding)this._receiver.resolvedType.leafComponentType(), roleRef);
                anchor = RoleTypeCreator.getAnchorVariableBinding(site, this._receiver, paramRoleType, reportError ? problemReporter : null, null);
            }
            if ((anchor = this.validAnchor(anchor)) == null) {
                anchor = this.validAnchor(TThisBinding.getTThisForRole(roleRef, site));
            }
            if (anchor != null && !anchor.isTypeCompatibleWith(tthisType)) {
                anchor = null;
            }
        }
        return anchor;
    }

    private ITeamAnchor validAnchor(ITeamAnchor anchor) {
        if (anchor != null && anchor != RoleTypeBinding.NoAnchor && anchor.isValidAnchor()) {
            return anchor;
        }
        return null;
    }

    public static void storeInstantiatedParameters(MethodBinding candidate, TypeBinding[] parameters) {
        AnchorMapping currentMapping = currentMappings.get();
        if (currentMapping != null) {
            currentMapping._instantiatedParameters.put(candidate, parameters);
        }
    }

    public static boolean areTypesEqual(TypeBinding t1, TypeBinding t2, MethodBinding currentMethod) {
        AnchorMapping currentMapping;
        if (TypeBinding.equalsEquals(t1, t2)) {
            return true;
        }
        if (t1 instanceof RoleTypeBinding && t2 instanceof RoleTypeBinding && (currentMapping = currentMappings.get()) != null) {
            return currentMapping.areTypeEqual((RoleTypeBinding)t1, (RoleTypeBinding)t2, currentMethod);
        }
        return false;
    }

    public static boolean isLegalInstantiation(TypeVariableBinding typeVariable, DependentTypeBinding instantiation) {
        AnchorMapping currentMapping = currentMappings.get();
        if (currentMapping != null) {
            return currentMapping.internalIsLegalInstantiation(typeVariable, instantiation);
        }
        return false;
    }

    private boolean internalIsLegalInstantiation(TypeVariableBinding typeVariable, DependentTypeBinding instantiation) {
        ITeamAnchor[] anchors = typeVariable.anchors;
        if (anchors == null) {
            return true;
        }
        if (!(anchors[0] instanceof LocalVariableBinding)) {
            return true;
        }
        int position = ((LocalVariableBinding)anchors[0]).resolvedPosition;
        Statement argument = this._arguments[position];
        ITeamAnchor[] anchorPath = TeamAnchor.getBestNameFromStat(argument);
        if (anchorPath != null) {
            return instantiation.getAnchor().hasSameBestNameAs(anchorPath, null);
        }
        return false;
    }

    private boolean areTypeEqual(RoleTypeBinding role1, RoleTypeBinding role2, MethodBinding currentMethod) {
        ITeamAnchor anchor = this.translateAnchor(null, null, role1, currentMethod);
        if (anchor != null) {
            return role2.isSameType(role1, anchor);
        }
        return false;
    }

    private AnchorMapping(Expression receiver, Statement[] arguments, Scope scope) {
        this._arguments = arguments;
        this._receiver = receiver;
        if (this._receiver instanceof ArrayReference) {
            this._receiver = ((ArrayReference)this._receiver).receiver;
        }
        this._scope = scope;
        this._methodSignatureEnhancer = MethodSignatureEnhancer.variants[scope.compilerOptions().weavingScheme.ordinal()];
    }

    public boolean checkInstantiatedParameters(MessageSend messageSend, Scope scope) {
        boolean success = true;
        boolean loweringPossible = Config.getLoweringPossible();
        Expression[] arguments = messageSend.arguments;
        TypeBinding[] parameters = this._instantiatedParameters.get(messageSend.binding);
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i] instanceof RoleTypeBinding) {
                    RoleTypeBinding roleType = (RoleTypeBinding)parameters[i];
                    if (!roleType._teamAnchor.isFinal()) {
                        scope.problemReporter().anchorPathNotFinal(arguments[i], roleType._teamAnchor, roleType.readableName());
                        success = false;
                    } else if (roleType.hasExplicitAnchor() && !roleType.isPublic() && !arguments[i].getBaseclassDecapsulation().isAllowed()) {
                        scope.problemReporter().externalizingNonPublicRole(arguments[i], roleType);
                        success = false;
                    }
                } else if (loweringPossible && arguments[i].resolvedType != null && arguments[i].resolvedType.isRoleType()) {
                    ((DependentTypeBinding)arguments[i].resolvedType).recheckAmbiguousLowering(parameters[i], arguments[i], scope, messageSend.binding);
                }
                ++i;
            }
        }
        return success;
    }

    public TypeBinding[] getInstantiatedParameters(MethodBinding selectedMethod) {
        if (this._instantiatedParameters.containsKey(selectedMethod)) {
            return this._instantiatedParameters.get(selectedMethod);
        }
        return Binding.NO_PARAMETERS;
    }

    public String toString() {
        String NULL = "null";
        StringBuffer out = new StringBuffer();
        out.append("[allowInstantiation: ");
        out.append(this._allowInstantiation);
        out.append(", scope kind: ");
        out.append(this._scope == null ? NULL : this.computeScopeKind(this._scope));
        out.append(", receiver: ");
        out.append(this._receiver == null ? NULL : this._receiver.toString());
        out.append(", arguments: ");
        if (this._arguments == null) {
            out.append(NULL);
        } else {
            int idx = 0;
            while (idx < this._arguments.length) {
                out.append(this._arguments[idx] == null ? NULL : String.valueOf(this._arguments[idx].toString()) + ", ");
                ++idx;
            }
        }
        out.append(" instantiated parameters: ");
        if (this._instantiatedParameters == null) {
            out.append(NULL);
        } else {
            for (Map.Entry<MethodBinding, TypeBinding[]> entry : this._instantiatedParameters.entrySet()) {
                out.append('\n');
                out.append(String.valueOf(entry.getKey().readableName()));
                TypeBinding[] parameters = entry.getValue();
                int idx = 0;
                while (idx < parameters.length) {
                    out.append(parameters[idx] == null ? NULL : String.valueOf(parameters[idx].toString()) + ", ");
                    ++idx;
                }
            }
        }
        out.append("]");
        return out.toString();
    }

    private String computeScopeKind(Scope scope) {
        String result;
        if (scope == null) {
            return "scope is null";
        }
        switch (scope.kind) {
            case 1: {
                result = "BlockScope";
                break;
            }
            case 2: {
                result = "MethodScope";
                break;
            }
            case 3: {
                result = "ClassScope";
                break;
            }
            case 4: {
                result = "CompilationUnitScope";
                break;
            }
            case 5: {
                result = "BindingScope";
                break;
            }
            default: {
                result = "unknown scope type";
            }
        }
        return result;
    }
}

