/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ClassFilePool;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.AnnotatableTypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.IQualifiedTypeResolutionListener;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier15;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolymorphicMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.RoleSplitter;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.TeamMethodGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleFileHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class LookupEnvironment
implements ProblemReasons,
TypeConstants {
    private Map accessRestrictions;
    ImportBinding[] defaultImports;
    public PackageBinding defaultPackage;
    HashtableOfPackage knownPackages;
    private int lastCompletedUnitIndex = -1;
    private int lastUnitIndex = -1;
    private TypeSystem typeSystem;
    public INameEnvironment nameEnvironment;
    public CompilerOptions globalOptions;
    public ProblemReporter problemReporter;
    public ClassFilePool classFilePool;
    private int stepCompleted;
    public ITypeRequestor typeRequestor;
    private SimpleLookupTable uniqueParameterizedGenericMethodBindings;
    private SimpleLookupTable uniquePolymorphicMethodBindings;
    private SimpleLookupTable uniqueGetClassMethodBinding;
    public CompilationUnitDeclaration unitBeingCompleted = null;
    public Object missingClassFileLocation = null;
    private CompilationUnitDeclaration[] units = new CompilationUnitDeclaration[4];
    private MethodVerifier verifier;
    public MethodBinding arrayClone;
    private ArrayList missingTypes;
    Set typesBeingConnected;
    public boolean isProcessingAnnotations = false;
    public boolean mayTolerateMissingType = false;
    PackageBinding nullableAnnotationPackage;
    PackageBinding nonnullAnnotationPackage;
    PackageBinding nonnullByDefaultAnnotationPackage;
    AnnotationBinding nonNullAnnotation;
    AnnotationBinding nullableAnnotation;
    static final int BUILD_FIELDS_AND_METHODS = 4;
    static final int BUILD_TYPE_HIERARCHY = 1;
    static final int CHECK_AND_SET_IMPORTS = 2;
    static final int CONNECT_TYPE_HIERARCHY = 3;
    static final int ROLES_LINKED = 5;
    static final ProblemPackageBinding TheNotFoundPackage = new ProblemPackageBinding(CharOperation.NO_CHAR, 1);
    static final ProblemReferenceBinding TheNotFoundType = new ProblemReferenceBinding(CharOperation.NO_CHAR_CHAR, null, 1);
    private TeamMethodGenerator teamMethodGenerator;
    private TypeDeclaration pendingRoFi = null;
    private char[][] expectedTeamName = null;
    public IQualifiedTypeResolutionListener[] resolutionListeners = new IQualifiedTypeResolutionListener[0];

    public TeamMethodGenerator getTeamMethodGenerator() {
        if (this.teamMethodGenerator == null) {
            this.teamMethodGenerator = new TeamMethodGenerator(this.globalOptions.weavingScheme);
        }
        return this.teamMethodGenerator;
    }

    public LookupEnvironment(ITypeRequestor typeRequestor, CompilerOptions globalOptions, ProblemReporter problemReporter, INameEnvironment nameEnvironment) {
        this.typeRequestor = typeRequestor;
        this.globalOptions = globalOptions;
        this.problemReporter = problemReporter;
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.nameEnvironment = nameEnvironment;
        this.knownPackages = new HashtableOfPackage();
        this.uniqueParameterizedGenericMethodBindings = new SimpleLookupTable(3);
        this.uniquePolymorphicMethodBindings = new SimpleLookupTable(3);
        this.missingTypes = null;
        this.accessRestrictions = new HashMap(3);
        this.classFilePool = ClassFilePool.newInstance();
        this.typesBeingConnected = new HashSet();
        this.typeSystem = this.globalOptions.sourceLevel >= 0x340000L && this.globalOptions.storeAnnotations ? new AnnotatableTypeSystem(this) : new TypeSystem(this);
    }

    public ReferenceBinding askForType(char[][] compoundName) {
        NameEnvironmentAnswer answer = this.nameEnvironment.findType(compoundName);
        if (answer == null) {
            return null;
        }
        if (!answer.isBinaryType()) {
            Config.setSourceTypeRequired(false);
        }
        if (answer.isBinaryType()) {
            this.typeRequestor.accept(answer.getBinaryType(), this.computePackageFrom(compoundName, false), answer.getAccessRestriction());
        } else if (answer.isCompilationUnit()) {
            this.typeRequestor.accept(answer.getCompilationUnit(), answer.getAccessRestriction());
        } else if (answer.isSourceType()) {
            this.typeRequestor.accept(answer.getSourceTypes(), this.computePackageFrom(compoundName, false), answer.getAccessRestriction());
        }
        return this.getCachedType(compoundName);
    }

    ReferenceBinding askForType(PackageBinding packageBinding, char[] name) {
        block17: {
            NameEnvironmentAnswer answer;
            if (packageBinding == null) {
                packageBinding = this.defaultPackage;
            }
            if ((answer = this.nameEnvironment.findType(name, packageBinding.compoundName)) == null) {
                return null;
            }
            if (!answer.isBinaryType()) {
                Config.setSourceTypeRequired(false);
            }
            if (answer.isBinaryType()) {
                this.typeRequestor.accept(answer.getBinaryType(), packageBinding, answer.getAccessRestriction());
            } else {
                if (answer.isCompilationUnit()) {
                    boolean prevFlag = false;
                    TypeDeclaration typeDeclaration = null;
                    if (this.problemReporter.referenceContext instanceof TypeDeclaration) {
                        typeDeclaration = (TypeDeclaration)this.problemReporter.referenceContext;
                        prevFlag = typeDeclaration.willCatchAbort;
                        typeDeclaration.willCatchAbort = true;
                    }
                    try {
                        try {
                            this.typeRequestor.accept(answer.getCompilationUnit(), answer.getAccessRestriction());
                            break block17;
                        }
                        catch (AbortCompilation abort) {
                            if (CharOperation.equals(name, TypeConstants.PACKAGE_INFO_NAME)) {
                                if (typeDeclaration != null) {
                                    typeDeclaration.willCatchAbort = prevFlag;
                                }
                                return null;
                            }
                            throw abort;
                        }
                    }
                    finally {
                        if (typeDeclaration != null) {
                            typeDeclaration.willCatchAbort = prevFlag;
                        }
                    }
                }
                if (answer.isSourceType()) {
                    this.typeRequestor.accept(answer.getSourceTypes(), packageBinding, answer.getAccessRestriction());
                }
            }
        }
        return packageBinding.getType0(name);
    }

    public void buildTypeBindings(CompilationUnitDeclaration unit, AccessRestriction accessRestriction) {
        Dependencies.ensureState(unit, accessRestriction, 3);
    }

    public void internalBuildTypeBindings(CompilationUnitDeclaration unit, AccessRestriction accessRestriction) {
        CompilationUnitScope scope = new CompilationUnitScope(unit, this);
        scope.buildTypeBindings(accessRestriction);
        int unitsLength = this.units.length;
        if (++this.lastUnitIndex >= unitsLength) {
            this.units = new CompilationUnitDeclaration[2 * unitsLength];
            System.arraycopy(this.units, 0, this.units, 0, unitsLength);
        }
        this.units[this.lastUnitIndex] = unit;
    }

    public BinaryTypeBinding cacheBinaryType(IBinaryType binaryType, AccessRestriction accessRestriction) {
        return this.cacheBinaryType(binaryType, true, accessRestriction);
    }

    public BinaryTypeBinding cacheBinaryType(IBinaryType binaryType, boolean needFieldsAndMethods, AccessRestriction accessRestriction) {
        char[][] compoundName = CharOperation.splitOn('/', binaryType.getName());
        ReferenceBinding existingType = this.getCachedType(compoundName);
        if (existingType == null || existingType instanceof UnresolvedReferenceBinding) {
            return this.createBinaryTypeFrom(binaryType, this.computePackageFrom(compoundName, false), needFieldsAndMethods, accessRestriction);
        }
        return null;
    }

    public void completeTypeBindings() {
        boolean done;
        this.stepCompleted = 1;
        int i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            if (this.units[i].state.getState() < 5) {
                this.unitBeingCompleted = this.units[i];
                this.unitBeingCompleted.scope.checkAndSetImports();
            }
            StateHelper.setStateRecursive(this.units[i], 5, false);
            ++i;
        }
        this.stepCompleted = 2;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            done = false;
            Dependencies.checkReadKnownRoles(this.units[i]);
            if (this.units[i].state.getState() < 6) {
                this.unitBeingCompleted = this.units[i];
                this.unitBeingCompleted.scope.connectTypeHierarchy();
                done = true;
            }
            StateHelper.setStateRecursive(this.units[i], 6, done);
            ++i;
        }
        this.stepCompleted = 3;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            done = false;
            if (this.units[i].state.getState() < 7) {
                this.unitBeingCompleted = this.units[i];
                CompilationUnitScope unitScope = this.unitBeingCompleted.scope;
                unitScope.checkParameterizedTypes();
                unitScope.buildFieldsAndMethods();
                done = true;
            }
            StateHelper.setStateRecursive(this.units[i], 7, done);
            ++i;
        }
        this.stepCompleted = 4;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            done = false;
            if (this.units[i].state.getState() < 8) {
                RoleSplitter.linkRoles(this.units[i]);
                done = true;
            }
            StateHelper.setStateRecursive(this.units[i], 8, done);
            this.units[i] = null;
            ++i;
        }
        this.stepCompleted = 5;
        this.lastCompletedUnitIndex = this.lastUnitIndex;
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration parsedUnit) {
        this.checkConnectTeamToRoFi(parsedUnit);
        Dependencies.ensureState(parsedUnit, this.getDependenciesStateCompleted());
    }

    public int internalCompleteTypeBindings(CompilationUnitDeclaration parsedUnit) {
        if (this.unitBeingCompleted == parsedUnit) {
            return 0;
        }
        int todo = this.stepCompleted;
        if (this.stepCompleted == 5) {
            this.completeTypeBindings();
        } else {
            TeamModel enclosingTeam;
            ReferenceBinding enclosingType;
            SourceTypeBinding roleBinding;
            if (parsedUnit.scope == null) {
                return 0;
            }
            if (parsedUnit.isRoleUnit() && (roleBinding = parsedUnit.types[0].binding) != null && (enclosingType = roleBinding.enclosingType()) != null && (enclosingTeam = enclosingType.getTeamModel()) != null && enclosingTeam._state.getProcessingState() == 6) {
                todo = 3;
            }
            if (this.stepCompleted >= 2) {
                this.unitBeingCompleted = parsedUnit;
                this.unitBeingCompleted.scope.checkAndSetImports();
            }
            if (todo >= 3) {
                this.unitBeingCompleted = parsedUnit;
                this.unitBeingCompleted.scope.connectTypeHierarchy();
            }
            if (todo >= 5) {
                this.unitBeingCompleted = parsedUnit;
                RoleSplitter.linkRoles(this.unitBeingCompleted);
            }
            this.unitBeingCompleted = null;
        }
        return todo;
    }

    public void completeTypeBindings(CompilationUnitDeclaration parsedUnit, boolean buildFieldsAndMethods) {
        Config.assertBuildFieldsAndMethods(buildFieldsAndMethods);
        Config config = Config.getConfig();
        boolean modeSave = config.setBundledCompleteTypeBindingsMode(false);
        this.checkConnectTeamToRoFi(parsedUnit);
        Dependencies.ensureState(parsedUnit, 7);
        config.setBundledCompleteTypeBindingsMode(modeSave);
    }

    void internalCompleteTypeBindings(CompilationUnitDeclaration parsedUnit, int requestedState, boolean buildFieldsAndMethods) {
        if (parsedUnit.scope == null) {
            return;
        }
        this.unitBeingCompleted = parsedUnit;
        this.unitBeingCompleted.scope.checkAndSetImports();
        parsedUnit.scope.connectTypeHierarchy();
        parsedUnit.scope.checkParameterizedTypes();
        if (buildFieldsAndMethods) {
            parsedUnit.scope.buildFieldsAndMethods();
        }
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration[] parsedUnits, boolean[] buildFieldsAndMethods, int unitCount) {
        boolean done;
        CompilationUnitDeclaration parsedUnit;
        int i = 0;
        while (i < unitCount) {
            parsedUnit = parsedUnits[i];
            if (parsedUnit.scope != null && parsedUnit.state.getState() < 5) {
                this.unitBeingCompleted = parsedUnit;
                this.unitBeingCompleted.scope.checkAndSetImports();
            }
            StateHelper.setStateRecursive(parsedUnit, 5, false);
            ++i;
        }
        i = 0;
        while (i < unitCount) {
            parsedUnit = parsedUnits[i];
            if (parsedUnit.scope != null) {
                done = false;
                Dependencies.checkReadKnownRoles(parsedUnit);
                if (parsedUnit.state.getState() < 6) {
                    this.unitBeingCompleted = parsedUnit;
                    this.unitBeingCompleted.scope.connectTypeHierarchy();
                    done = true;
                }
                StateHelper.setStateRecursive(parsedUnit, 6, done);
            }
            ++i;
        }
        i = 0;
        while (i < unitCount) {
            parsedUnit = parsedUnits[i];
            if (parsedUnit.scope != null) {
                done = false;
                if (parsedUnit.state.getState() < 7) {
                    if (TypeAnalyzer.containsAnchoredBaseclass(parsedUnit)) {
                        buildFieldsAndMethods[i] = true;
                    }
                    this.unitBeingCompleted = parsedUnit;
                    this.unitBeingCompleted.scope.checkParameterizedTypes();
                    if (buildFieldsAndMethods[i]) {
                        parsedUnit.scope.buildFieldsAndMethods();
                    } else {
                        parsedUnit.scope.connectBaseclass();
                    }
                    done = true;
                }
                StateHelper.setStateRecursive(parsedUnit, 7, done);
            }
            ++i;
        }
        this.unitBeingCompleted = null;
    }

    public MethodBinding computeArrayClone(MethodBinding objectClone) {
        if (this.arrayClone == null) {
            this.arrayClone = new MethodBinding(objectClone.modifiers & 0xFFFFFFFB | 1, TypeConstants.CLONE, objectClone.returnType, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, (ReferenceBinding)objectClone.returnType);
        }
        return this.arrayClone;
    }

    public TypeBinding computeBoxingType(TypeBinding type) {
        switch (type.id) {
            case 33: {
                return TypeBinding.BOOLEAN;
            }
            case 26: {
                return TypeBinding.BYTE;
            }
            case 28: {
                return TypeBinding.CHAR;
            }
            case 27: {
                return TypeBinding.SHORT;
            }
            case 32: {
                return TypeBinding.DOUBLE;
            }
            case 31: {
                return TypeBinding.FLOAT;
            }
            case 29: {
                return TypeBinding.INT;
            }
            case 30: {
                return TypeBinding.LONG;
            }
            case 10: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_INTEGER);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_INTEGER, null, 1);
            }
            case 3: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_BYTE);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_BYTE, null, 1);
            }
            case 4: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_SHORT);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_SHORT, null, 1);
            }
            case 2: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_CHARACTER);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_CHARACTER, null, 1);
            }
            case 7: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_LONG);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_LONG, null, 1);
            }
            case 9: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_FLOAT);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_FLOAT, null, 1);
            }
            case 8: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_DOUBLE);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_DOUBLE, null, 1);
            }
            case 5: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_BOOLEAN);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_BOOLEAN, null, 1);
            }
        }
        switch (type.kind()) {
            case 516: 
            case 4100: 
            case 8196: {
                switch (type.erasure().id) {
                    case 33: {
                        return TypeBinding.BOOLEAN;
                    }
                    case 26: {
                        return TypeBinding.BYTE;
                    }
                    case 28: {
                        return TypeBinding.CHAR;
                    }
                    case 27: {
                        return TypeBinding.SHORT;
                    }
                    case 32: {
                        return TypeBinding.DOUBLE;
                    }
                    case 31: {
                        return TypeBinding.FLOAT;
                    }
                    case 29: {
                        return TypeBinding.INT;
                    }
                    case 30: {
                        return TypeBinding.LONG;
                    }
                }
                break;
            }
            case 65540: {
                return ((PolyTypeBinding)type).computeBoxingType();
            }
            case 32772: {
                return this.computeBoxingType(type.getIntersectingTypes()[0]);
            }
        }
        return type;
    }

    private PackageBinding computePackageFrom(char[][] constantPoolName, boolean isMissing) {
        if (constantPoolName.length == 1) {
            return this.defaultPackage;
        }
        PackageBinding packageBinding = this.getPackage0(constantPoolName[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(constantPoolName[0], this);
            if (isMissing) {
                packageBinding.tagBits |= 0x80L;
            }
            this.knownPackages.put(constantPoolName[0], packageBinding);
        }
        int i = 1;
        int length = constantPoolName.length - 1;
        while (i < length) {
            PackageBinding parent = packageBinding;
            if ((packageBinding = parent.getPackage0(constantPoolName[i])) == null || packageBinding == TheNotFoundPackage) {
                packageBinding = new PackageBinding(CharOperation.subarray(constantPoolName, 0, i + 1), parent, this);
                if (isMissing) {
                    packageBinding.tagBits |= 0x80L;
                }
                parent.addPackage(packageBinding);
            }
            ++i;
        }
        return packageBinding;
    }

    public ReferenceBinding convertToParameterizedType(ReferenceBinding originalType) {
        if (originalType != null) {
            ReferenceBinding originalEnclosingType;
            boolean isGeneric = originalType.isGenericType();
            ReferenceBinding convertedEnclosingType = originalEnclosingType = originalType.enclosingType();
            boolean needToConvert = isGeneric;
            if (originalEnclosingType != null) {
                convertedEnclosingType = originalType.isStatic() ? (ReferenceBinding)this.convertToRawType(originalEnclosingType, false) : this.convertToParameterizedType(originalEnclosingType);
                needToConvert |= TypeBinding.notEquals(originalEnclosingType, convertedEnclosingType);
            }
            if (needToConvert) {
                return this.createParameterizedType(originalType, isGeneric ? originalType.typeVariables() : null, convertedEnclosingType);
            }
        }
        return originalType;
    }

    public TypeBinding convertToRawType(TypeBinding type, boolean forceRawEnclosingType) {
        TypeBinding convertedType;
        boolean needToConvert;
        TypeBinding originalType;
        int dimension;
        switch (type.kind()) {
            case 132: 
            case 516: 
            case 1028: 
            case 4100: 
            case 8196: {
                return type;
            }
            case 68: {
                dimension = type.dimensions();
                originalType = type.leafComponentType();
                break;
            }
            default: {
                if (type.id == 1) {
                    return type;
                }
                dimension = 0;
                originalType = type;
            }
        }
        switch (originalType.kind()) {
            case 132: {
                return type;
            }
            case 2052: {
                needToConvert = true;
                break;
            }
            case 260: {
                ParameterizedTypeBinding paramType = (ParameterizedTypeBinding)originalType;
                needToConvert = paramType.genericType().isGenericType();
                break;
            }
            default: {
                needToConvert = false;
            }
        }
        ReferenceBinding originalEnclosing = originalType.enclosingType();
        if (originalEnclosing == null) {
            convertedType = needToConvert ? this.createRawType((ReferenceBinding)originalType.erasure(), null) : originalType;
        } else {
            ReferenceBinding convertedEnclosing;
            if (originalEnclosing.kind() == 1028) {
                needToConvert |= !((ReferenceBinding)originalType).isStatic();
                convertedEnclosing = originalEnclosing;
            } else if (forceRawEnclosingType && !needToConvert) {
                convertedEnclosing = (ReferenceBinding)this.convertToRawType(originalEnclosing, forceRawEnclosingType);
                needToConvert = TypeBinding.notEquals(originalEnclosing, convertedEnclosing);
            } else {
                convertedEnclosing = needToConvert || ((ReferenceBinding)originalType).isStatic() ? (ReferenceBinding)this.convertToRawType(originalEnclosing, false) : this.convertToParameterizedType(originalEnclosing);
            }
            convertedType = needToConvert ? this.createRawType((ReferenceBinding)originalType.erasure(), convertedEnclosing) : (TypeBinding.notEquals(originalEnclosing, convertedEnclosing) ? this.createParameterizedType((ReferenceBinding)originalType.erasure(), null, convertedEnclosing) : originalType);
        }
        if (TypeBinding.notEquals(originalType, convertedType)) {
            return dimension > 0 ? this.createArrayType(convertedType, dimension) : convertedType;
        }
        return type;
    }

    public ReferenceBinding[] convertToRawTypes(ReferenceBinding[] originalTypes, boolean forceErasure, boolean forceRawEnclosingType) {
        if (originalTypes == null) {
            return null;
        }
        ReferenceBinding[] convertedTypes = originalTypes;
        int i = 0;
        int length = originalTypes.length;
        while (i < length) {
            ReferenceBinding originalType = originalTypes[i];
            ReferenceBinding convertedType = (ReferenceBinding)this.convertToRawType(forceErasure ? originalType.erasure() : originalType, forceRawEnclosingType);
            if (TypeBinding.notEquals(convertedType, originalType)) {
                if (convertedTypes == originalTypes) {
                    convertedTypes = new ReferenceBinding[length];
                    System.arraycopy(originalTypes, 0, convertedTypes, 0, i);
                }
                convertedTypes[i] = convertedType;
            } else if (convertedTypes != originalTypes) {
                convertedTypes[i] = originalType;
            }
            ++i;
        }
        return convertedTypes;
    }

    public TypeBinding convertUnresolvedBinaryToRawType(TypeBinding type) {
        TypeBinding convertedType;
        boolean needToConvert;
        TypeBinding originalType;
        int dimension;
        switch (type.kind()) {
            case 132: 
            case 516: 
            case 1028: 
            case 4100: 
            case 8196: {
                return type;
            }
            case 68: {
                dimension = type.dimensions();
                originalType = type.leafComponentType();
                break;
            }
            default: {
                if (type.id == 1) {
                    return type;
                }
                dimension = 0;
                originalType = type;
            }
        }
        switch (originalType.kind()) {
            case 132: {
                return type;
            }
            case 2052: {
                needToConvert = true;
                break;
            }
            case 260: {
                ParameterizedTypeBinding paramType = (ParameterizedTypeBinding)originalType;
                needToConvert = paramType.genericType().isGenericType();
                break;
            }
            default: {
                needToConvert = false;
            }
        }
        ReferenceBinding originalEnclosing = originalType.enclosingType();
        if (originalEnclosing == null) {
            convertedType = needToConvert ? this.createRawType((ReferenceBinding)originalType.erasure(), null) : originalType;
        } else {
            ReferenceBinding convertedEnclosing = (ReferenceBinding)this.convertUnresolvedBinaryToRawType(originalEnclosing);
            if (TypeBinding.notEquals(convertedEnclosing, originalEnclosing)) {
                needToConvert |= !((ReferenceBinding)originalType).isStatic();
            }
            convertedType = needToConvert ? this.createRawType((ReferenceBinding)originalType.erasure(), convertedEnclosing) : (TypeBinding.notEquals(originalEnclosing, convertedEnclosing) ? this.createParameterizedType((ReferenceBinding)originalType.erasure(), null, convertedEnclosing) : originalType);
        }
        if (TypeBinding.notEquals(originalType, convertedType)) {
            return dimension > 0 ? this.createArrayType(convertedType, dimension) : convertedType;
        }
        return type;
    }

    public AnnotationBinding createAnnotation(ReferenceBinding annotationType, ElementValuePair[] pairs) {
        if (pairs.length != 0) {
            AnnotationBinding.setMethodBindings(annotationType, pairs);
            return new AnnotationBinding(annotationType, pairs);
        }
        return this.typeSystem.getAnnotationType(annotationType, true);
    }

    public AnnotationBinding createUnresolvedAnnotation(ReferenceBinding annotationType, ElementValuePair[] pairs) {
        if (pairs.length != 0) {
            return new UnresolvedAnnotationBinding(annotationType, pairs, this);
        }
        return this.typeSystem.getAnnotationType(annotationType, false);
    }

    public ArrayBinding createArrayType(TypeBinding leafComponentType, int dimensionCount) {
        return this.typeSystem.getArrayType(leafComponentType, dimensionCount);
    }

    public ArrayBinding createArrayType(TypeBinding leafComponentType, int dimensionCount, AnnotationBinding[] annotations) {
        return this.typeSystem.getArrayType(leafComponentType, dimensionCount, annotations);
    }

    public TypeBinding createIntersectionCastType(ReferenceBinding[] intersectingTypes) {
        return this.typeSystem.getIntersectionCastType(intersectingTypes);
    }

    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        return this.createBinaryTypeFrom(binaryType, packageBinding, true, accessRestriction);
    }

    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType binaryType, PackageBinding packageBinding, boolean needFieldsAndMethods, AccessRestriction accessRestriction) {
        BinaryTypeBinding binaryBinding = new BinaryTypeBinding(packageBinding, binaryType, this);
        ReferenceBinding cachedType = packageBinding.getType0(binaryBinding.compoundName[binaryBinding.compoundName.length - 1]);
        if (cachedType != null && !cachedType.isUnresolvedType()) {
            if (cachedType.isBinaryBinding()) {
                return (BinaryTypeBinding)cachedType;
            }
            return null;
        }
        packageBinding.addType(binaryBinding);
        this.setAccessRestriction(binaryBinding, accessRestriction);
        binaryBinding.cachePartsFrom(binaryType, needFieldsAndMethods);
        return binaryBinding;
    }

    public MissingTypeBinding createMissingType(PackageBinding packageBinding, char[][] compoundName) {
        if (packageBinding == null && (packageBinding = this.computePackageFrom(compoundName, true)) == TheNotFoundPackage) {
            packageBinding = this.defaultPackage;
        }
        MissingTypeBinding missingType = new MissingTypeBinding(packageBinding, compoundName, this);
        if (missingType.id != 1) {
            ReferenceBinding objectType = this.getType(TypeConstants.JAVA_LANG_OBJECT);
            if (objectType == null) {
                objectType = this.createMissingType(null, TypeConstants.JAVA_LANG_OBJECT);
            }
            missingType.setMissingSuperclass(objectType);
        }
        packageBinding.addType(missingType);
        if (this.missingTypes == null) {
            this.missingTypes = new ArrayList(3);
        }
        this.missingTypes.add(missingType);
        return missingType;
    }

    public PackageBinding createPackage(char[][] compoundName) {
        ReferenceBinding foundType;
        if (compoundName.length == 1 && (foundType = this.defaultPackage.getType0(compoundName[0])) != null && foundType != TheNotFoundType) {
            return null;
        }
        PackageBinding packageBinding = this.getPackage0(compoundName[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(compoundName[0], this);
            this.knownPackages.put(compoundName[0], packageBinding);
        }
        int i = 1;
        int length = compoundName.length;
        while (i < length) {
            ReferenceBinding type = packageBinding.getType0(compoundName[i]);
            if (type != null && type != TheNotFoundType && !(type instanceof UnresolvedReferenceBinding)) {
                return null;
            }
            PackageBinding parent = packageBinding;
            if ((packageBinding = parent.getPackage0(compoundName[i])) == null || packageBinding == TheNotFoundPackage) {
                if (this.nameEnvironment.findType(compoundName[i], parent.compoundName) != null) {
                    return null;
                }
                packageBinding = new PackageBinding(CharOperation.subarray(compoundName, 0, i + 1), parent, this);
                parent.addPackage(packageBinding);
            }
            ++i;
        }
        return packageBinding;
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding genericMethod, RawTypeBinding rawType) {
        ParameterizedGenericMethodBinding parameterizedGenericMethod;
        ParameterizedGenericMethodBinding[] cachedInfo = (ParameterizedGenericMethodBinding[])this.uniqueParameterizedGenericMethodBindings.get(genericMethod);
        boolean needToGrow = false;
        int index = 0;
        if (cachedInfo != null) {
            int max = cachedInfo.length;
            while (index < max) {
                ParameterizedGenericMethodBinding cachedMethod = cachedInfo[index];
                if (cachedMethod == null) break;
                if (cachedMethod.isRaw && cachedMethod.declaringClass == (rawType == null ? genericMethod.declaringClass : rawType)) {
                    return cachedMethod;
                }
                ++index;
            }
            needToGrow = true;
        } else {
            cachedInfo = new ParameterizedGenericMethodBinding[5];
            this.uniqueParameterizedGenericMethodBindings.put(genericMethod, cachedInfo);
        }
        int length = cachedInfo.length;
        if (needToGrow && index == length) {
            ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray = cachedInfo;
            cachedInfo = new ParameterizedGenericMethodBinding[length * 2];
            System.arraycopy(parameterizedGenericMethodBindingArray, 0, cachedInfo, 0, length);
            this.uniqueParameterizedGenericMethodBindings.put(genericMethod, cachedInfo);
        }
        cachedInfo[index] = parameterizedGenericMethod = new ParameterizedGenericMethodBinding(genericMethod, rawType, this);
        return parameterizedGenericMethod;
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding genericMethod, TypeBinding[] typeArguments) {
        ParameterizedGenericMethodBinding parameterizedGenericMethod;
        ParameterizedGenericMethodBinding[] cachedInfo = (ParameterizedGenericMethodBinding[])this.uniqueParameterizedGenericMethodBindings.get(genericMethod);
        int argLength = typeArguments == null ? 0 : typeArguments.length;
        boolean needToGrow = false;
        int index = 0;
        if (cachedInfo != null) {
            int max = cachedInfo.length;
            while (index < max) {
                block8: {
                    ParameterizedGenericMethodBinding cachedMethod = cachedInfo[index];
                    if (cachedMethod == null) break;
                    if (!cachedMethod.isRaw) {
                        int cachedArgLength;
                        TypeBinding[] cachedArguments = cachedMethod.typeArguments;
                        int n = cachedArgLength = cachedArguments == null ? 0 : cachedArguments.length;
                        if (argLength == cachedArgLength) {
                            int j = 0;
                            while (j < cachedArgLength) {
                                if (typeArguments[j] == cachedArguments[j]) {
                                    ++j;
                                    continue;
                                }
                                break block8;
                            }
                            return cachedMethod;
                        }
                    }
                }
                ++index;
            }
            needToGrow = true;
        } else {
            cachedInfo = new ParameterizedGenericMethodBinding[5];
            this.uniqueParameterizedGenericMethodBindings.put(genericMethod, cachedInfo);
        }
        int length = cachedInfo.length;
        if (needToGrow && index == length) {
            ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray = cachedInfo;
            cachedInfo = new ParameterizedGenericMethodBinding[length * 2];
            System.arraycopy(parameterizedGenericMethodBindingArray, 0, cachedInfo, 0, length);
            this.uniqueParameterizedGenericMethodBindings.put(genericMethod, cachedInfo);
        }
        cachedInfo[index] = parameterizedGenericMethod = new ParameterizedGenericMethodBinding(genericMethod, typeArguments, this);
        return parameterizedGenericMethod;
    }

    public PolymorphicMethodBinding createPolymorphicMethod(MethodBinding originalPolymorphicMethod, TypeBinding[] parameters) {
        PolymorphicMethodBinding polymorphicMethod;
        String key = new String(originalPolymorphicMethod.selector);
        PolymorphicMethodBinding[] cachedInfo = (PolymorphicMethodBinding[])this.uniquePolymorphicMethodBindings.get(key);
        int parametersLength = parameters == null ? 0 : parameters.length;
        TypeBinding[] parametersTypeBinding = new TypeBinding[parametersLength];
        int i = 0;
        while (i < parametersLength) {
            TypeBinding parameterTypeBinding = parameters[i];
            parametersTypeBinding[i] = parameterTypeBinding.id == 12 ? this.getType(JAVA_LANG_VOID) : parameterTypeBinding.erasure();
            ++i;
        }
        boolean needToGrow = false;
        int index = 0;
        if (cachedInfo != null) {
            int max = cachedInfo.length;
            while (index < max) {
                PolymorphicMethodBinding cachedMethod = cachedInfo[index];
                if (cachedMethod == null) break;
                if (cachedMethod.matches(parametersTypeBinding, originalPolymorphicMethod.returnType)) {
                    return cachedMethod;
                }
                ++index;
            }
            needToGrow = true;
        } else {
            cachedInfo = new PolymorphicMethodBinding[5];
            this.uniquePolymorphicMethodBindings.put(key, cachedInfo);
        }
        int length = cachedInfo.length;
        if (needToGrow && index == length) {
            PolymorphicMethodBinding[] polymorphicMethodBindingArray = cachedInfo;
            cachedInfo = new PolymorphicMethodBinding[length * 2];
            System.arraycopy(polymorphicMethodBindingArray, 0, cachedInfo, 0, length);
            this.uniquePolymorphicMethodBindings.put(key, cachedInfo);
        }
        cachedInfo[index] = polymorphicMethod = new PolymorphicMethodBinding(originalPolymorphicMethod, parametersTypeBinding);
        return polymorphicMethod;
    }

    public boolean usesAnnotatedTypeSystem() {
        return this.typeSystem.isAnnotatedTypeSystem();
    }

    public MethodBinding updatePolymorphicMethodReturnType(PolymorphicMethodBinding binding, TypeBinding typeBinding) {
        PolymorphicMethodBinding polymorphicMethod;
        String key = new String(binding.selector);
        PolymorphicMethodBinding[] cachedInfo = (PolymorphicMethodBinding[])this.uniquePolymorphicMethodBindings.get(key);
        boolean needToGrow = false;
        int index = 0;
        TypeBinding[] parameters = binding.parameters;
        if (cachedInfo != null) {
            int max = cachedInfo.length;
            while (index < max) {
                PolymorphicMethodBinding cachedMethod = cachedInfo[index];
                if (cachedMethod == null) break;
                if (cachedMethod.matches(parameters, typeBinding)) {
                    return cachedMethod;
                }
                ++index;
            }
            needToGrow = true;
        } else {
            cachedInfo = new PolymorphicMethodBinding[5];
            this.uniquePolymorphicMethodBindings.put(key, cachedInfo);
        }
        int length = cachedInfo.length;
        if (needToGrow && index == length) {
            PolymorphicMethodBinding[] polymorphicMethodBindingArray = cachedInfo;
            cachedInfo = new PolymorphicMethodBinding[length * 2];
            System.arraycopy(polymorphicMethodBindingArray, 0, cachedInfo, 0, length);
            this.uniquePolymorphicMethodBindings.put(key, cachedInfo);
        }
        cachedInfo[index] = polymorphicMethod = new PolymorphicMethodBinding(binding.original(), typeBinding, parameters);
        return polymorphicMethod;
    }

    public ParameterizedMethodBinding createGetClassMethod(TypeBinding receiverType, MethodBinding originalMethod, Scope scope) {
        ParameterizedMethodBinding retVal = null;
        if (this.uniqueGetClassMethodBinding == null) {
            this.uniqueGetClassMethodBinding = new SimpleLookupTable(3);
        } else {
            retVal = (ParameterizedMethodBinding)this.uniqueGetClassMethodBinding.get(receiverType);
        }
        if (retVal == null) {
            retVal = ParameterizedMethodBinding.instantiateGetClass(receiverType, originalMethod, scope);
            this.uniqueGetClassMethodBinding.put(receiverType, retVal);
        }
        return retVal;
    }

    public ReferenceBinding createMemberType(ReferenceBinding memberType, ReferenceBinding enclosingType) {
        return this.typeSystem.getMemberType(memberType, enclosingType);
    }

    public ParameterizedTypeBinding createParameterizedType(ReferenceBinding genericType, TypeBinding[] typeArguments, ReferenceBinding enclosingType) {
        return this.typeSystem.getParameterizedType(genericType, typeArguments, null, -1, enclosingType);
    }

    public ParameterizedTypeBinding createParameterizedType(ReferenceBinding genericType, TypeBinding[] typeArguments, ReferenceBinding enclosingType, AnnotationBinding[] annotations) {
        return this.typeSystem.getParameterizedType(genericType, typeArguments, null, -1, enclosingType, annotations);
    }

    public ParameterizedTypeBinding createParameterizedType(ReferenceBinding genericType, TypeBinding[] typeArguments, ITeamAnchor teamAnchor, int valueParamPosition, ReferenceBinding enclosingType, AnnotationBinding[] annotations) {
        if (teamAnchor != null && (genericType = genericType.getRealType()).isParameterizedType()) {
            genericType = (ReferenceBinding)genericType.erasure();
        }
        return this.typeSystem.getParameterizedType(genericType, typeArguments, teamAnchor, valueParamPosition, enclosingType, annotations);
    }

    public TypeBinding createAnnotatedType(TypeBinding type, AnnotationBinding[][] annotations) {
        return this.typeSystem.getAnnotatedType(type, annotations);
    }

    public TypeBinding createAnnotatedType(TypeBinding type, AnnotationBinding[] newbies) {
        int oldLength;
        int newLength;
        int n = newLength = newbies == null ? 0 : newbies.length;
        if (type == null || newLength == 0) {
            return type;
        }
        AnnotationBinding[] oldies = type.getTypeAnnotations();
        int n2 = oldLength = oldies == null ? 0 : oldies.length;
        if (oldLength > 0) {
            AnnotationBinding[] annotationBindingArray = newbies;
            newbies = new AnnotationBinding[newLength + oldLength];
            System.arraycopy(annotationBindingArray, 0, newbies, 0, newLength);
            System.arraycopy(oldies, 0, newbies, newLength, oldLength);
        }
        if (this.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            long tagBitsSeen = 0L;
            AnnotationBinding[] filtered = new AnnotationBinding[newbies.length];
            int count = 0;
            int i = 0;
            while (i < newbies.length) {
                if (newbies[i] == null) {
                    filtered[count++] = null;
                } else {
                    long tagBits = 0L;
                    switch (newbies[i].type.id) {
                        case 66: {
                            tagBits = 0x100000000000000L;
                            break;
                        }
                        case 65: {
                            tagBits = 0x80000000000000L;
                        }
                    }
                    if ((tagBitsSeen & tagBits) == 0L) {
                        tagBitsSeen |= tagBits;
                        filtered[count++] = newbies[i];
                    }
                }
                ++i;
            }
            if (count < newbies.length) {
                newbies = new AnnotationBinding[count];
                System.arraycopy(filtered, 0, newbies, 0, count);
            }
        }
        return this.typeSystem.getAnnotatedType(type, new AnnotationBinding[][]{newbies});
    }

    public RawTypeBinding createRawType(ReferenceBinding genericType, ReferenceBinding enclosingType) {
        return this.typeSystem.getRawType(genericType, enclosingType);
    }

    public RawTypeBinding createRawType(ReferenceBinding genericType, ReferenceBinding enclosingType, AnnotationBinding[] annotations) {
        return this.typeSystem.getRawType(genericType, enclosingType, annotations);
    }

    public WildcardBinding createWildcard(ReferenceBinding genericType, int rank, TypeBinding bound, TypeBinding[] otherBounds, int boundKind) {
        return this.typeSystem.getWildcard(genericType, rank, bound, otherBounds, boundKind);
    }

    public WildcardBinding createWildcard(ReferenceBinding genericType, int rank, TypeBinding bound, TypeBinding[] otherBounds, int boundKind, AnnotationBinding[] annotations) {
        return this.typeSystem.getWildcard(genericType, rank, bound, otherBounds, boundKind, annotations);
    }

    public AccessRestriction getAccessRestriction(TypeBinding type) {
        return (AccessRestriction)this.accessRestrictions.get(type);
    }

    public ReferenceBinding getCachedType(char[][] compoundName) {
        if (compoundName.length == 1) {
            return this.defaultPackage.getType0(compoundName[0]);
        }
        PackageBinding packageBinding = this.getPackage0(compoundName[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            return null;
        }
        int i = 1;
        int packageLength = compoundName.length - 1;
        while (i < packageLength) {
            if ((packageBinding = packageBinding.getPackage0(compoundName[i])) == null || packageBinding == TheNotFoundPackage) {
                return null;
            }
            ++i;
        }
        return packageBinding.getType0(compoundName[compoundName.length - 1]);
    }

    public AnnotationBinding getNullableAnnotation() {
        if (this.nullableAnnotation != null) {
            return this.nullableAnnotation;
        }
        ReferenceBinding nullable = this.getResolvedType(this.globalOptions.nullableAnnotationName, null);
        this.nullableAnnotation = this.typeSystem.getAnnotationType(nullable, true);
        return this.nullableAnnotation;
    }

    public char[][] getNullableAnnotationName() {
        return this.globalOptions.nullableAnnotationName;
    }

    public AnnotationBinding getNonNullAnnotation() {
        if (this.nonNullAnnotation != null) {
            return this.nonNullAnnotation;
        }
        ReferenceBinding nonNull = this.getResolvedType(this.globalOptions.nonNullAnnotationName, null);
        this.nonNullAnnotation = this.typeSystem.getAnnotationType(nonNull, true);
        return this.nonNullAnnotation;
    }

    public AnnotationBinding[] nullAnnotationsFromTagBits(long nullTagBits) {
        if (nullTagBits == 0x100000000000000L) {
            return new AnnotationBinding[]{this.getNonNullAnnotation()};
        }
        if (nullTagBits == 0x80000000000000L) {
            return new AnnotationBinding[]{this.getNullableAnnotation()};
        }
        return null;
    }

    public char[][] getNonNullAnnotationName() {
        return this.globalOptions.nonNullAnnotationName;
    }

    public char[][] getNonNullByDefaultAnnotationName() {
        return this.globalOptions.nonNullByDefaultAnnotationName;
    }

    PackageBinding getPackage0(char[] name) {
        return this.knownPackages.get(name);
    }

    public ReferenceBinding getResolvedType(char[][] compoundName, Scope scope) {
        ReferenceBinding type = this.getType(compoundName);
        if (type != null) {
            return type;
        }
        this.problemReporter.isClassPathCorrect(compoundName, scope == null ? this.unitBeingCompleted : scope.referenceCompilationUnit(), this.missingClassFileLocation);
        return this.createMissingType(null, compoundName);
    }

    PackageBinding getTopLevelPackage(char[] name) {
        PackageBinding packageBinding = this.getPackage0(name);
        if (packageBinding != null) {
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            return packageBinding;
        }
        if (this.nameEnvironment.isPackage(null, name)) {
            packageBinding = new PackageBinding(name, this);
            this.knownPackages.put(name, packageBinding);
            return packageBinding;
        }
        this.knownPackages.put(name, TheNotFoundPackage);
        return null;
    }

    public ReferenceBinding getType(char[][] compoundName) {
        ReferenceBinding referenceBinding;
        if (compoundName.length == 1) {
            referenceBinding = this.defaultPackage.getType0(compoundName[0]);
            if (referenceBinding == null) {
                PackageBinding packageBinding = this.getPackage0(compoundName[0]);
                if (packageBinding != null && packageBinding != TheNotFoundPackage) {
                    return null;
                }
                referenceBinding = this.askForType(this.defaultPackage, compoundName[0]);
            }
        } else {
            PackageBinding packageBinding = this.getPackage0(compoundName[0]);
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            if (packageBinding != null) {
                int i = 1;
                int packageLength = compoundName.length - 1;
                while (i < packageLength) {
                    if ((packageBinding = packageBinding.getPackage0(compoundName[i])) == null) break;
                    if (packageBinding == TheNotFoundPackage) {
                        return null;
                    }
                    ++i;
                }
            }
            if (packageBinding == null) {
                referenceBinding = this.askForType(compoundName);
            } else {
                referenceBinding = packageBinding.getType0(compoundName[compoundName.length - 1]);
                if (referenceBinding == null) {
                    referenceBinding = this.askForType(packageBinding, compoundName[compoundName.length - 1]);
                }
            }
        }
        if (referenceBinding == null || referenceBinding == TheNotFoundType) {
            return null;
        }
        if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this, false)).isNestedType()) {
            return new ProblemReferenceBinding(compoundName, referenceBinding, 4);
        }
        return referenceBinding;
    }

    public ReferenceBinding getTeamForRoFi(char[][] compoundName, TypeDeclaration roleType) {
        TypeDeclaration pendingRoFiSave = this.pendingRoFi;
        char[][] expectedTeamNameSave = this.expectedTeamName;
        this.pendingRoFi = roleType;
        this.expectedTeamName = compoundName;
        try {
            ReferenceBinding referenceBinding = this.getType(compoundName);
            return referenceBinding;
        }
        finally {
            this.pendingRoFi = pendingRoFiSave;
            this.expectedTeamName = expectedTeamNameSave;
        }
    }

    void checkConnectTeamToRoFi(CompilationUnitDeclaration parsedUnit) {
        if (this.pendingRoFi == null) {
            return;
        }
        if (parsedUnit.types == null) {
            return;
        }
        TypeDeclaration[] typeDeclarationArray = parsedUnit.types;
        int n = parsedUnit.types.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration type = typeDeclarationArray[n2];
            if (type.binding != null && !type.isInterface() && RoleFileHelper.compoundNameMatch(type.binding.compoundName, this.expectedTeamName)) {
                this.pendingRoFi.getRoleModel().setState(1);
                AstEdit.addMemberTypeDeclaration(type, this.pendingRoFi);
                Dependencies.ensureRoleState(this.pendingRoFi.getRoleModel(), 3);
                this.pendingRoFi = null;
                this.expectedTeamName = null;
                return;
            }
            ++n2;
        }
    }

    private TypeBinding[] getTypeArgumentsFromSignature(SignatureWrapper wrapper, TypeVariableBinding[] staticVariables, ReferenceBinding enclosingType, ReferenceBinding genericType, char[][][] missingTypeNames, TypeAnnotationWalker walker) {
        ArrayList<TypeBinding> args = new ArrayList<TypeBinding>(2);
        int rank = 0;
        do {
            args.add(this.getTypeFromVariantTypeSignature(wrapper, staticVariables, enclosingType, genericType, rank, missingTypeNames, walker.toTypeArgument(rank++)));
        } while (wrapper.signature[wrapper.start] != '>');
        ++wrapper.start;
        TypeBinding[] typeArguments = new TypeBinding[args.size()];
        args.toArray(typeArguments);
        return typeArguments;
    }

    public ReferenceBinding getTypeFromCompoundName(char[][] compoundName, boolean isParameterized, boolean wasMissingType) {
        ReferenceBinding binding = this.getCachedType(compoundName);
        if (binding == null) {
            PackageBinding packageBinding = this.computePackageFrom(compoundName, false);
            binding = new UnresolvedReferenceBinding(compoundName, packageBinding);
            if (wasMissingType) {
                binding.tagBits |= 0x80L;
            }
            packageBinding.addType(binding);
        } else if (binding == TheNotFoundType) {
            if (!wasMissingType) {
                this.problemReporter.isClassPathCorrect(compoundName, this.unitBeingCompleted, this.missingClassFileLocation);
            }
            binding = this.createMissingType(null, compoundName);
        } else if (!isParameterized) {
            binding = (ReferenceBinding)this.convertUnresolvedBinaryToRawType(binding);
        }
        return binding;
    }

    public ReferenceBinding getTypeFromConstantPoolName(char[] signature, int start, int end, boolean isParameterized, char[][][] missingTypeNames, TypeAnnotationWalker walker) {
        if (end == -1) {
            end = signature.length;
        }
        char[][] compoundName = CharOperation.splitOn('/', signature, start, end);
        boolean wasMissingType = false;
        if (missingTypeNames != null) {
            int i = 0;
            int max = missingTypeNames.length;
            while (i < max) {
                if (CharOperation.equals(compoundName, missingTypeNames[i])) {
                    wasMissingType = true;
                    break;
                }
                ++i;
            }
        }
        ReferenceBinding binding = this.getTypeFromCompoundName(compoundName, isParameterized, wasMissingType);
        if (walker != TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            binding = (ReferenceBinding)this.annotateType(binding, walker, missingTypeNames);
        }
        return binding;
    }

    public ReferenceBinding getTypeFromConstantPoolName(char[] signature, int start, int end, boolean isParameterized, char[][][] missingTypeNames) {
        return this.getTypeFromConstantPoolName(signature, start, end, isParameterized, missingTypeNames, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
    }

    public TypeBinding getTypeFromSignature(char[] signature, int start, int end, boolean isParameterized, TypeBinding enclosingType, char[][][] missingTypeNames, TypeAnnotationWalker walker) {
        int dimension = 0;
        while (signature[start] == '[') {
            ++start;
            ++dimension;
        }
        AnnotationBinding[][] annotationsOnDimensions = null;
        if (dimension > 0 && walker != TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            int i = 0;
            while (i < dimension) {
                AnnotationBinding[] annotations = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
                if (annotations != Binding.NO_ANNOTATIONS) {
                    if (annotationsOnDimensions == null) {
                        annotationsOnDimensions = new AnnotationBinding[dimension][];
                    }
                    annotationsOnDimensions[i] = annotations;
                }
                walker = walker.toNextArrayDimension();
                ++i;
            }
        }
        if (end == -1) {
            end = signature.length - 1;
        }
        TypeBinding binding = null;
        if (start == end) {
            switch (signature[start]) {
                case 'I': {
                    binding = TypeBinding.INT;
                    break;
                }
                case 'Z': {
                    binding = TypeBinding.BOOLEAN;
                    break;
                }
                case 'V': {
                    binding = TypeBinding.VOID;
                    break;
                }
                case 'C': {
                    binding = TypeBinding.CHAR;
                    break;
                }
                case 'D': {
                    binding = TypeBinding.DOUBLE;
                    break;
                }
                case 'B': {
                    binding = TypeBinding.BYTE;
                    break;
                }
                case 'F': {
                    binding = TypeBinding.FLOAT;
                    break;
                }
                case 'J': {
                    binding = TypeBinding.LONG;
                    break;
                }
                case 'S': {
                    binding = TypeBinding.SHORT;
                    break;
                }
                default: {
                    this.problemReporter.corruptedSignature(enclosingType, signature, start);
                    break;
                }
            }
        } else {
            binding = this.getTypeFromConstantPoolName(signature, start + 1, end, isParameterized, missingTypeNames);
        }
        if (isParameterized) {
            if (dimension != 0) {
                throw new IllegalStateException();
            }
            return binding;
        }
        if (walker != TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            binding = this.annotateType(binding, walker, missingTypeNames);
        }
        if (dimension != 0) {
            binding = this.typeSystem.getArrayType(binding, dimension, AnnotatableTypeSystem.flattenedAnnotations(annotationsOnDimensions));
        }
        return binding;
    }

    private TypeBinding annotateType(TypeBinding binding, TypeAnnotationWalker walker, char[][][] missingTypeNames) {
        int depth = binding.depth() + 1;
        if (depth > 1) {
            if (binding.isUnresolvedType()) {
                binding = ((UnresolvedReferenceBinding)binding).resolve(this, true);
            }
            TypeBinding currentBinding = binding;
            depth = 0;
            while (currentBinding != null) {
                ++depth;
                if (currentBinding.isStatic()) break;
                currentBinding = currentBinding.enclosingType();
            }
        }
        AnnotationBinding[][] annotations = null;
        int i = 0;
        while (i < depth) {
            AnnotationBinding[] annots = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
            if (annots != null && annots.length > 0) {
                if (annotations == null) {
                    annotations = new AnnotationBinding[depth][];
                }
                annotations[i] = annots;
            }
            walker = walker.toNextNestedType();
            ++i;
        }
        if (annotations != null) {
            binding = this.createAnnotatedType(binding, annotations);
        }
        return binding;
    }

    boolean qualifiedNameMatchesSignature(char[][] name, char[] signature) {
        int s = 1;
        int i = 0;
        while (i < name.length) {
            char[] n = name[i];
            int j = 0;
            while (j < n.length) {
                if (n[j] != signature[s++]) {
                    return false;
                }
                ++j;
            }
            if (signature[s] == ';' && i == name.length - 1) {
                return true;
            }
            if (signature[s++] != '/') {
                return false;
            }
            ++i;
        }
        return false;
    }

    public TypeBinding getTypeFromTypeSignature(SignatureWrapper wrapper, TypeVariableBinding[] staticVariables, ReferenceBinding enclosingType, char[][][] missingTypeNames, TypeAnnotationWalker walker) {
        ReferenceBinding actualEnclosing;
        int dimension = 0;
        while (wrapper.signature[wrapper.start] == '[') {
            ++wrapper.start;
            ++dimension;
        }
        AnnotationBinding[][] annotationsOnDimensions = null;
        if (dimension > 0 && walker != TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            int i = 0;
            while (i < dimension) {
                AnnotationBinding[] annotations = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
                if (annotations != Binding.NO_ANNOTATIONS) {
                    if (annotationsOnDimensions == null) {
                        annotationsOnDimensions = new AnnotationBinding[dimension][];
                    }
                    annotationsOnDimensions[i] = annotations;
                }
                walker = walker.toNextArrayDimension();
                ++i;
            }
        }
        if (wrapper.signature[wrapper.start] == 'T') {
            int varStart = wrapper.start + 1;
            int varEnd = wrapper.computeEnd();
            int i = staticVariables.length;
            while (--i >= 0) {
                if (!CharOperation.equals(staticVariables[i].sourceName, wrapper.signature, varStart, varEnd)) continue;
                return this.getTypeFromTypeVariable(staticVariables[i], dimension, annotationsOnDimensions, walker, missingTypeNames);
            }
            ReferenceBinding initialType = enclosingType;
            do {
                TypeVariableBinding[] enclosingTypeVariables = enclosingType instanceof BinaryTypeBinding ? ((BinaryTypeBinding)enclosingType).typeVariables : enclosingType.typeVariables();
                int i2 = enclosingTypeVariables.length;
                while (--i2 >= 0) {
                    if (!CharOperation.equals(enclosingTypeVariables[i2].sourceName, wrapper.signature, varStart, varEnd)) continue;
                    return this.getTypeFromTypeVariable(enclosingTypeVariables[i2], dimension, annotationsOnDimensions, walker, missingTypeNames);
                }
            } while ((enclosingType = enclosingType.enclosingType()) != null);
            this.problemReporter.undefinedTypeVariableSignature(CharOperation.subarray(wrapper.signature, varStart, varEnd), initialType);
            return null;
        }
        boolean isParameterized = wrapper.end == wrapper.bracket;
        TypeBinding type = this.getTypeFromSignature(wrapper.signature, wrapper.start, wrapper.computeEnd(), isParameterized, enclosingType, missingTypeNames, walker);
        if (!isParameterized) {
            return dimension == 0 ? type : this.createArrayType(type, dimension, AnnotatableTypeSystem.flattenedAnnotations(annotationsOnDimensions));
        }
        ReferenceBinding actualType = (ReferenceBinding)type;
        if (actualType instanceof UnresolvedReferenceBinding && CharOperation.indexOf('$', actualType.compoundName[actualType.compoundName.length - 1]) > 0) {
            actualType = (ReferenceBinding)BinaryTypeBinding.resolveType(actualType, this, false);
        }
        if ((actualEnclosing = actualType.enclosingType()) != null) {
            actualEnclosing = (ReferenceBinding)this.convertToRawType(actualEnclosing, false);
        }
        AnnotationBinding[] annotations = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
        TypeBinding[] typeArguments = this.getTypeArgumentsFromSignature(wrapper, staticVariables, enclosingType, actualType, missingTypeNames, walker);
        ParameterizedTypeBinding parameterizedType = this.createParameterizedType(actualType, typeArguments, actualEnclosing, annotations);
        while (wrapper.signature[wrapper.start] == '.') {
            int memberStart = ++wrapper.start;
            char[] memberName = wrapper.nextWord();
            BinaryTypeBinding.resolveType(parameterizedType, this, false);
            ReferenceBinding memberType = parameterizedType.genericType().getMemberType(memberName);
            if (memberType == null) {
                this.problemReporter.corruptedSignature(parameterizedType, wrapper.signature, memberStart);
            }
            walker = walker.toNextNestedType();
            annotations = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
            if (wrapper.signature[wrapper.start] == '<') {
                ++wrapper.start;
                typeArguments = this.getTypeArgumentsFromSignature(wrapper, staticVariables, enclosingType, memberType, missingTypeNames, walker);
            } else {
                typeArguments = null;
            }
            parameterizedType = this.createParameterizedType(memberType, typeArguments, parameterizedType, annotations);
        }
        ++wrapper.start;
        return dimension == 0 ? parameterizedType : this.createArrayType(parameterizedType, dimension, AnnotatableTypeSystem.flattenedAnnotations(annotationsOnDimensions));
    }

    private TypeBinding getTypeFromTypeVariable(TypeVariableBinding typeVariableBinding, int dimension, AnnotationBinding[][] annotationsOnDimensions, TypeAnnotationWalker walker, char[][][] missingTypeNames) {
        AnnotationBinding[] annotations = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
        if (annotations != null && annotations != Binding.NO_ANNOTATIONS) {
            typeVariableBinding = (TypeVariableBinding)this.createAnnotatedType((TypeBinding)typeVariableBinding, new AnnotationBinding[][]{annotations});
        }
        if (dimension == 0) {
            return typeVariableBinding;
        }
        return this.typeSystem.getArrayType(typeVariableBinding, dimension, AnnotatableTypeSystem.flattenedAnnotations(annotationsOnDimensions));
    }

    TypeBinding getTypeFromVariantTypeSignature(SignatureWrapper wrapper, TypeVariableBinding[] staticVariables, ReferenceBinding enclosingType, ReferenceBinding genericType, int rank, char[][][] missingTypeNames, TypeAnnotationWalker walker) {
        switch (wrapper.signature[wrapper.start]) {
            case '-': {
                ++wrapper.start;
                TypeBinding bound = this.getTypeFromTypeSignature(wrapper, staticVariables, enclosingType, missingTypeNames, walker.toWildcardBound());
                AnnotationBinding[] annotations = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
                return this.typeSystem.getWildcard(genericType, rank, bound, null, 2, annotations);
            }
            case '+': {
                ++wrapper.start;
                TypeBinding bound = this.getTypeFromTypeSignature(wrapper, staticVariables, enclosingType, missingTypeNames, walker.toWildcardBound());
                AnnotationBinding[] annotations = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
                return this.typeSystem.getWildcard(genericType, rank, bound, null, 1, annotations);
            }
            case '*': {
                ++wrapper.start;
                AnnotationBinding[] annotations = BinaryTypeBinding.createAnnotations(walker.getAnnotationsAtCursor(), this, missingTypeNames);
                return this.typeSystem.getWildcard(genericType, rank, null, null, 0, annotations);
            }
        }
        return this.getTypeFromTypeSignature(wrapper, staticVariables, enclosingType, missingTypeNames, walker);
    }

    boolean isMissingType(char[] typeName) {
        int i = this.missingTypes == null ? 0 : this.missingTypes.size();
        while (--i >= 0) {
            MissingTypeBinding missingType = (MissingTypeBinding)this.missingTypes.get(i);
            if (!CharOperation.equals(missingType.sourceName, typeName)) continue;
            return true;
        }
        return false;
    }

    boolean isPackage(char[][] compoundName, char[] name) {
        if (compoundName == null || compoundName.length == 0) {
            return this.nameEnvironment.isPackage(null, name);
        }
        return this.nameEnvironment.isPackage(compoundName, name);
    }

    public MethodVerifier methodVerifier() {
        if (this.verifier == null) {
            this.verifier = this.newMethodVerifier();
        }
        return this.verifier;
    }

    public MethodVerifier newMethodVerifier() {
        return new MethodVerifier15(this);
    }

    public void releaseClassFiles(ClassFile[] classFiles) {
        int i = 0;
        int fileCount = classFiles.length;
        while (i < fileCount) {
            this.classFilePool.release(classFiles[i]);
            ++i;
        }
    }

    public void reset() {
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.knownPackages = new HashtableOfPackage();
        this.accessRestrictions = new HashMap(3);
        this.verifier = null;
        this.uniqueParameterizedGenericMethodBindings = new SimpleLookupTable(3);
        this.uniquePolymorphicMethodBindings = new SimpleLookupTable(3);
        this.uniqueGetClassMethodBinding = null;
        this.missingTypes = null;
        this.typesBeingConnected = new HashSet();
        int i = this.units.length;
        while (--i >= 0) {
            this.units[i] = null;
        }
        this.lastUnitIndex = -1;
        this.lastCompletedUnitIndex = -1;
        this.unitBeingCompleted = null;
        this.classFilePool.reset();
        this.typeSystem.reset();
        this.teamMethodGenerator = null;
    }

    public void setAccessRestriction(ReferenceBinding type, AccessRestriction accessRestriction) {
        if (accessRestriction == null) {
            return;
        }
        type.modifiers |= 0x40000;
        this.accessRestrictions.put(type, accessRestriction);
    }

    void updateCaches(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType) {
        this.typeSystem.updateCaches(unresolvedType, resolvedType);
    }

    public int getDependenciesStateCompleted() {
        switch (this.stepCompleted) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
        }
        return 0;
    }

    public void addResolutionListener(IQualifiedTypeResolutionListener resolutionListener) {
        int length = this.resolutionListeners.length;
        int i = 0;
        while (i < length) {
            if (this.resolutionListeners[i].equals(resolutionListener)) {
                return;
            }
            ++i;
        }
        this.resolutionListeners = new IQualifiedTypeResolutionListener[length + 1];
        System.arraycopy(this.resolutionListeners, 0, this.resolutionListeners, 0, length);
        this.resolutionListeners[length] = resolutionListener;
    }

    public TypeBinding getUnannotatedType(TypeBinding typeBinding) {
        return this.typeSystem.getUnannotatedType(typeBinding);
    }

    public TypeBinding[] getAnnotatedTypes(TypeBinding type) {
        return this.typeSystem.getAnnotatedTypes(type);
    }

    public AnnotationBinding[] filterNullTypeAnnotations(AnnotationBinding[] typeAnnotations) {
        if (typeAnnotations.length == 0) {
            return typeAnnotations;
        }
        AnnotationBinding[] filtered = new AnnotationBinding[typeAnnotations.length];
        int count = 0;
        int i = 0;
        while (i < typeAnnotations.length) {
            AnnotationBinding typeAnnotation = typeAnnotations[i];
            if (typeAnnotation == null) {
                ++count;
            } else {
                int id = typeAnnotation.type.id;
                if (id != 66 && id != 65) {
                    filtered[count++] = typeAnnotation;
                }
            }
            ++i;
        }
        if (count == 0) {
            return Binding.NO_ANNOTATIONS;
        }
        if (count == typeAnnotations.length) {
            return typeAnnotations;
        }
        AnnotationBinding[] annotationBindingArray = filtered;
        filtered = new AnnotationBinding[count];
        System.arraycopy(annotationBindingArray, 0, filtered, 0, count);
        return filtered;
    }
}

