/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLiftExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class PotentialRoleReceiverExpression
extends Expression {
    Expression expression;
    char[] roleVarName;
    TypeReference roleClassRef;
    private Expression altExpression;

    public PotentialRoleReceiverExpression(Expression expression, char[] roleName, TypeReference roleClassRef) {
        this.expression = expression;
        this.roleVarName = roleName;
        this.roleClassRef = roleClassRef;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = expression.sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.altExpression != null) {
            return this.altExpression.analyseCode(currentScope, flowContext, flowInfo);
        }
        return this.expression.analyseCode(currentScope, flowContext, flowInfo);
    }

    @Override
    public void computeConversion(Scope scope, TypeBinding runtimeType, TypeBinding compileTimeType) {
        if (this.altExpression != null) {
            this.altExpression.computeConversion(scope, runtimeType, compileTimeType);
        } else {
            this.expression.computeConversion(scope, runtimeType, compileTimeType);
        }
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        if (this.altExpression != null) {
            this.altExpression.generateCode(currentScope, codeStream, valueRequired);
        } else {
            this.expression.generateCode(currentScope, codeStream, valueRequired);
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        ReferenceContext referenceContext = scope.referenceContext();
        CompilationResult compilationResult = referenceContext.compilationResult();
        CompilationResult.CheckPoint cp = compilationResult.getCheckPoint(referenceContext);
        this.resolvedType = this.expression.resolveType(scope);
        if (this.resolvedType != null && this.resolvedType.isValidBinding()) {
            this.constant = this.expression.constant;
            return this.resolvedType;
        }
        Binding altResult = null;
        AstGenerator gen = new AstGenerator(this.expression);
        if (this.expression instanceof PotentialLiftExpression) {
            this.expression = ((PotentialLiftExpression)this.expression).expression;
        }
        if (this.expression instanceof SingleNameReference) {
            this.altExpression = gen.fieldReference(gen.castExpression(gen.singleNameReference(this.roleVarName), this.roleClassRef, 1), ((SingleNameReference)this.expression).token);
            altResult = this.altExpression.resolveType(scope);
            ((NameReference)this.expression).binding = ((FieldReference)this.altExpression).binding;
        } else if (this.expression instanceof MessageSend) {
            MessageSend send = (MessageSend)this.expression;
            if (send.receiver.isThis()) {
                this.altExpression = gen.messageSend(gen.singleNameReference(this.roleVarName), send.selector, send.arguments);
                altResult = this.altExpression.resolveType(scope);
                ((MessageSend)this.expression).binding = ((MessageSend)this.altExpression).binding;
                ((MessageSend)this.expression).resolvedType = ((MessageSend)this.altExpression).resolvedType;
                ((MessageSend)this.expression).actualReceiverType = ((MessageSend)this.altExpression).actualReceiverType;
            }
        }
        if (altResult != null && altResult.isValidBinding()) {
            compilationResult.rollBack(cp);
            this.constant = this.altExpression.constant;
            this.resolvedType = altResult;
            return this.resolvedType;
        }
        this.altExpression = null;
        this.constant = this.expression.constant;
        return this.resolvedType;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        return this.expression.printExpression(indent, output);
    }
}

