/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.debug.adaptor.launching;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.List;

public class OTEquinoxDebugAgent {
    static boolean DUMP = System.getProperty("otequinox.dump.redefine") != null;

    public static void premain(String options, Instrumentation inst) {
        inst.addTransformer(new OTEquinoxTransformerDelegate());
    }

    static class OTEquinoxTransformerDelegate
    implements ClassFileTransformer {
        private Class<?> dclClass;
        private Method getConfiguration;
        private Method getHookRegistry;
        private Method getClassLoaderHooks;
        private Method getClasspathManager;
        private Method processClass;

        OTEquinoxTransformerDelegate() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (classBeingRedefined == null) {
                return null;
            }
            try {
                if (this.isDefaultClassLoader(loader)) {
                    String classNameDot = className.replace('/', '.');
                    boolean modified = false;
                    for (Object hook : this.getClassLoadingHooks(loader)) {
                        byte[] newBytes = this.processClass(hook, classNameDot, classfileBuffer, null, null, this.getClasspathManager(loader));
                        if (newBytes == null) continue;
                        if (DUMP) {
                            this.dumpBytes(className, newBytes);
                        }
                        classfileBuffer = newBytes;
                        modified = true;
                    }
                    if (modified) {
                        return classfileBuffer;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return null;
        }

        private void dumpBytes(String className, byte[] newBytes) throws FileNotFoundException, IOException {
            String fileName = String.valueOf(className) + ".class";
            int lastSlash = fileName.lastIndexOf(47);
            if (lastSlash != -1) {
                new File(fileName.substring(0, lastSlash)).mkdirs();
            }
            File dumpFile = new File(fileName);
            FileOutputStream dumpStream = new FileOutputStream(dumpFile);
            dumpStream.write(newBytes);
            dumpStream.close();
        }

        private boolean isDefaultClassLoader(ClassLoader loader) {
            Class<?> clazz = loader.getClass();
            if (this.dclClass != null) {
                return this.dclClass == clazz;
            }
            if (clazz.getName().equals("org.eclipse.osgi.internal.loader.EquinoxClassLoader")) {
                this.dclClass = clazz;
                return true;
            }
            return false;
        }

        private List<?> getClassLoadingHooks(ClassLoader loader) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.getConfiguration == null) {
                this.getConfiguration = this.dclClass.getDeclaredMethod("getConfiguration", null);
                this.getConfiguration.setAccessible(true);
            }
            Object conf = this.getConfiguration.invoke((Object)loader, null);
            if (this.getHookRegistry == null) {
                this.getHookRegistry = conf.getClass().getMethod("getHookRegistry", null);
            }
            Object hookRegistry = this.getHookRegistry.invoke(conf, null);
            if (this.getClassLoaderHooks == null) {
                this.getClassLoaderHooks = hookRegistry.getClass().getMethod("getClassLoaderHooks", null);
            }
            return (List)this.getClassLoaderHooks.invoke(hookRegistry, null);
        }

        private Object getClasspathManager(ClassLoader loader) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
            if (this.getClasspathManager == null) {
                this.getClasspathManager = this.dclClass.getMethod("getClasspathManager", null);
            }
            return this.getClasspathManager.invoke((Object)loader, null);
        }

        private byte[] processClass(Object hook, String className, byte[] classfileBuffer, Object classpathEntry, Object entry, Object classpathManager) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            block4: {
                if (!hook.getClass().getName().equals("org.eclipse.osgi.internal.weaving.WeavingHookConfigurator")) {
                    return null;
                }
                if (this.processClass == null) {
                    Method[] methodArray = hook.getClass().getMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method m = methodArray[n2];
                        if (m.getName().equals("processClass")) {
                            this.processClass = m;
                            break block4;
                        }
                        ++n2;
                    }
                    throw new NoSuchMethodError("processClass");
                }
            }
            return (byte[])this.processClass.invoke(hook, className, classfileBuffer, classpathEntry, entry, classpathManager);
        }
    }
}

