/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.Pair;
import org.eclipse.objectteams.internal.osgi.weaving.Util;
import org.eclipse.objectteams.internal.osgi.weaving.WaitingTeamRecord;
import org.eclipse.objectteams.otequinox.ActivationKind;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.eclipse.objectteams.otredyn.runtime.TeamManager;
import org.objectteams.Team;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WovenClass;

@NonNullByDefault
public class TeamLoader {
    private List<WaitingTeamRecord> deferredTeams;
    private Set<String> beingDefined;
    boolean useDynamicWeaving;

    public TeamLoader(List<WaitingTeamRecord> deferredTeams, Set<String> beingDefined, boolean useDynamicWeaving) {
        this.deferredTeams = deferredTeams;
        this.beingDefined = beingDefined;
        this.useDynamicWeaving = useDynamicWeaving;
    }

    public void loadTeamsForBase(Bundle aspectBundle, AspectBinding aspectBinding, WovenClass baseClass) {
        String className = baseClass.getClassName();
        Collection<AspectBinding.TeamBinding> teamsForBase = aspectBinding.getTeamsForBase(className);
        if (teamsForBase == null) {
            return;
        }
        for (AspectBinding.TeamBinding teamForBase : teamsForBase) {
            if (teamForBase.isActivated) continue;
            Class<? extends Team> teamClass = teamForBase.loadTeamClass(aspectBundle);
            if (teamClass == null) {
                TransformerPlugin.log(new ClassNotFoundException("Not found: " + teamForBase), "Failed to load team " + teamForBase);
                continue;
            }
            ActivationKind activationKind = teamForBase.activation;
            if (activationKind == ActivationKind.NONE) {
                if ((teamForBase = aspectBinding.getOtherTeamToActivate(teamForBase)) == null || teamForBase.isActivated) continue;
                activationKind = teamForBase.activation;
                teamClass = teamForBase.loadTeamClass(aspectBundle);
                if (teamClass == null) {
                    TransformerPlugin.log(new ClassNotFoundException("Not found: " + teamForBase.teamName + " in bundle " + aspectBundle.getSymbolicName()), "Failed to load team " + teamForBase);
                    continue;
                }
            }
            if (activationKind == ActivationKind.NONE) continue;
            this.instantiateAndActivate(aspectBinding, teamForBase, activationKind);
        }
    }

    @Nullable
    public static Pair<URL, String> findTeamClassResource(String className, Bundle bundle) {
        for (String candidate : TeamLoader.possibleTeamNames(className)) {
            URL result = bundle.getResource(String.valueOf(candidate.replace('.', '/')) + ".class");
            if (result == null) continue;
            return new Pair<URL, String>(result, candidate);
        }
        return null;
    }

    public static List<String> possibleTeamNames(String currentName) {
        int pos;
        ArrayList<String> result = new ArrayList<String>();
        result.add(currentName);
        int sep = 46;
        if (currentName.indexOf(36) > -1) {
            sep = 36;
        }
        int from = currentName.length() - 1;
        while ((pos = currentName.lastIndexOf(sep, from)) != -1) {
            String prefix = currentName.substring(0, pos);
            String postfix = currentName.substring(pos + 1);
            if (sep == 36) {
                if (!postfix.startsWith("__OT__")) {
                    currentName = String.valueOf(prefix) + "$__OT__" + postfix;
                    result.add(0, currentName);
                }
            } else {
                int prevDot = prefix.lastIndexOf(46);
                if (prevDot <= -1 || !Character.isUpperCase(prefix.charAt(prevDot + 1))) break;
                currentName = String.valueOf(prefix) + "$__OT__" + postfix;
                result.add(0, currentName);
            }
            from = pos - 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void instantiateAndActivate(AspectBinding aspectBinding, AspectBinding.TeamBinding team, ActivationKind activationKind) {
        String teamName = team.teamName;
        AspectBinding aspectBinding2 = aspectBinding;
        synchronized (aspectBinding2) {
            if (!this.isReadyToLoad(aspectBinding, team, teamName, activationKind)) {
                if (this.useDynamicWeaving) {
                    TeamManager.prepareTeamActivation(team.teamClass);
                }
                return;
            }
            for (AspectBinding.TeamBinding equivalent : team.equivalenceSet) {
                equivalent.isActivated = true;
            }
        }
        try {
            long time = 0L;
            if (Util.PROFILE) {
                time = System.nanoTime();
            }
            Team instance = team.teamClass.newInstance();
            TransformerPlugin.registerTeamInstance(instance);
            TransformerPlugin.log(1, "Instantiated team " + teamName);
            try {
                switch (activationKind) {
                    case ALL_THREADS: {
                        instance.activate(Team.ALL_THREADS);
                        TransformerPlugin.log(1, "Activated team " + teamName);
                        break;
                    }
                    case THREAD: {
                        instance.activate();
                        TransformerPlugin.log(1, "Activated team " + teamName);
                        break;
                    }
                }
                if (Util.PROFILE) {
                    Util.profile(time, Util.ProfileKind.Activation, teamName);
                }
            }
            catch (Throwable t) {
                TransformerPlugin.log(t, "Failed to activate team " + teamName);
            }
        }
        catch (Throwable e) {
            TransformerPlugin.log(e, "Failed to instantiate team " + teamName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReadyToLoad(AspectBinding aspectBinding, AspectBinding.TeamBinding team, String teamName, ActivationKind activationKind) {
        for (String baseclass : team.baseClassNames) {
            if (!this.beingDefined.contains(baseclass)) continue;
            List<WaitingTeamRecord> list = this.deferredTeams;
            synchronized (list) {
                WaitingTeamRecord record = new WaitingTeamRecord(team, aspectBinding, activationKind, baseclass);
                this.deferredTeams.add(record);
            }
            TransformerPlugin.log(1, "Defer instantation/activation of team " + teamName);
            return false;
        }
        return true;
    }
}

