/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBindingRegistry;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.otequinox.IAspectRegistry;
import org.eclipse.objectteams.otre.ClassLoaderAccess;
import org.objectteams.Team;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClassListener;

public class TransformerPlugin
implements BundleActivator,
IAspectRegistry {
    private static BundleContext context;
    private static ILog log;
    private static List<IStatus> pendingLogEntries;
    private static TransformerPlugin plugin;
    private AspectBindingRegistry aspectBindingRegistry;
    private List<Team> teamInstances = new ArrayList<Team>();
    public static int WARN_LEVEL;

    static {
        pendingLogEntries = new ArrayList<IStatus>();
        WARN_LEVEL = 4;
        String level = System.getProperty("otequinox.debug");
        if (level != null) {
            WARN_LEVEL = (level = level.toUpperCase()).equals("OK") ? 0 : (level.equals("INFO") ? 1 : (level.startsWith("WARN") ? 2 : (level.startsWith("ERR") ? 4 : 0)));
        }
    }

    public static Bundle getBundle() {
        return context.getBundle();
    }

    public void start(final BundleContext bundleContext) throws Exception {
        plugin = this;
        context = bundleContext;
        TransformerPlugin.acquireLog(bundleContext);
        if (!"false".equals(System.getProperty("ot.equinox"))) {
            this.OTREInit();
            final OTWeavingHook otWeavingHook = new OTWeavingHook();
            context.registerService(new String[]{WeavingHook.class.getName(), WovenClassListener.class.getName()}, (Object)otWeavingHook, null);
            try {
                ServiceReference reference = context.getServiceReference(IExtensionRegistry.class);
                if (reference != null) {
                    otWeavingHook.activate(bundleContext, (ServiceReference<IExtensionRegistry>)reference);
                } else {
                    context.addServiceListener(new ServiceListener(){

                        public void serviceChanged(ServiceEvent event) {
                            if (event.getType() == 1) {
                                otWeavingHook.activate(bundleContext, (ServiceReference<IExtensionRegistry>)context.getServiceReference(IExtensionRegistry.class));
                            }
                        }
                    }, "(objectclass=" + IExtensionRegistry.class.getName() + ")");
                }
            }
            catch (InvalidSyntaxException ex) {
                TransformerPlugin.log(ex, "Failed to register service listener");
            }
        }
    }

    private static void acquireLog(BundleContext bundleContext) {
        try {
            log = InternalPlatform.getDefault().getLog(bundleContext.getBundle());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void OTREInit() {
        System.setProperty("ot.equinox", "true");
        try {
            ClassLoaderAccess.setLoadClass((Method)Bundle.class.getMethod("loadClass", String.class));
            ClassLoaderAccess.setGetResource((Method)Bundle.class.getMethod("getResource", String.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            TransformerPlugin.log(e, "Failed to wire an OSGi class into the OTRE");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public static synchronized void log(Throwable ex, String msg) {
        msg = "OT/Equinox: " + msg;
        System.err.println(msg);
        ex.printStackTrace();
        pendingLogEntries.add((IStatus)new Status(4, "org.eclipse.objectteams.otequinox", msg, ex));
    }

    public static void log(int status, String msg) {
        if (status >= WARN_LEVEL) {
            TransformerPlugin.doLog(status, msg);
        }
    }

    public static synchronized void doLog(int status, String msg) {
        msg = "OT/Equinox: " + msg;
        try {
            pendingLogEntries.add((IStatus)new Status(status, "org.eclipse.objectteams.otequinox", msg));
        }
        catch (NoClassDefFoundError e) {
            System.err.println("OT/Euqinox (not ready for logging): " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushLog() {
        Class<TransformerPlugin> clazz = TransformerPlugin.class;
        synchronized (TransformerPlugin.class) {
            List<IStatus> copy = pendingLogEntries;
            pendingLogEntries = new ArrayList<IStatus>();
            // ** MonitorExit[var1] (shouldn't be in output)
            for (IStatus status : copy) {
                if (log != null) {
                    log.log(status);
                    continue;
                }
                if (status.getCode() == 4) {
                    System.err.println(status.getMessage());
                    continue;
                }
                System.out.println(status.getMessage());
            }
            return;
        }
    }

    public static TransformerPlugin getDefault() {
        return plugin;
    }

    public void registerAspectBindingRegistry(AspectBindingRegistry aspectBindingRegistry) {
        this.aspectBindingRegistry = aspectBindingRegistry;
    }

    @Override
    @NonNull
    public String[] getAdaptingAspectPlugins(Bundle basePlugin) {
        return this.getAdaptingAspectPlugins(basePlugin.getSymbolicName());
    }

    @NonNull
    public String[] getAdaptingAspectPlugins(String id) {
        List<AspectBinding> aspectBindings = this.aspectBindingRegistry.getAdaptingAspectBindings(id);
        if (aspectBindings == null) {
            return new String[0];
        }
        String[] result = new String[aspectBindings.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = aspectBindings.get((int)i).aspectPlugin;
            ++i;
        }
        return result;
    }

    public static synchronized void registerTeamInstance(Team instance) {
        TransformerPlugin.plugin.teamInstances.add(instance);
    }

    public static synchronized void getTeamInstances(List<Team> list) {
        list.addAll(TransformerPlugin.plugin.teamInstances);
    }

    @Override
    public boolean isOTDT() {
        return false;
    }

    @Override
    public boolean isAdaptedBasePlugin(String baseBundleName) {
        return this.aspectBindingRegistry.isAdaptedBasePlugin(baseBundleName);
    }

    @Override
    public String[] getAdaptedBasePlugins(Bundle aspectBundle) {
        return null;
    }

    @Override
    public boolean hasInternalTeams(Bundle bundle) {
        return false;
    }

    @Override
    public boolean isDeniedAspectPlugin(String symbolicName) {
        return false;
    }
}

