/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

@NonNullByDefault
public class AspectBindingRegistry {
    private static List<String> KNOWN_OTDT_ASPECTS = new ArrayList<String>();
    private static HashMap<String, ArrayList<AspectBinding>> aspectBindingsByBasePlugin;
    private static HashMap<String, ArrayList<AspectBinding>> aspectBindingsByAspectPlugin;
    private Map<String, AspectBinding.BaseBundle> baseBundleLookup = new HashMap<String, AspectBinding.BaseBundle>();
    private Set<String> selfAdaptingAspects = new HashSet<String>();
    public static boolean IS_OTDT;

    static {
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.jdt.ui");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.compiler.adaptor");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.refactoring");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.pde.ui");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.samples");
        aspectBindingsByBasePlugin = new HashMap();
        aspectBindingsByAspectPlugin = new HashMap();
        IS_OTDT = false;
    }

    public boolean isOTDT() {
        return IS_OTDT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadAspectBindings(IExtensionRegistry extensionRegistry, @Nullable PackageAdmin packageAdmin, OTWeavingHook hook) {
        IConfigurationElement[] aspectBindingConfigs = extensionRegistry.getConfigurationElementsFor("org.eclipse.objectteams.otequinox", "aspectBindings");
        HashMap<String, Set<AspectBinding.TeamBinding>> teamLookup = new HashMap<String, Set<AspectBinding.TeamBinding>>();
        AspectBinding[] bindings = new AspectBinding[aspectBindingConfigs.length];
        int i = 0;
        while (i < aspectBindingConfigs.length) {
            block11: {
                AspectBinding binding;
                String baseBundleId;
                IConfigurationElement[] basePlugins;
                Bundle aspectBundle;
                String aspectBundleId;
                IConfigurationElement currentBindingConfig;
                block13: {
                    block12: {
                        block9: {
                            Bundle[] aspectBundles;
                            block10: {
                                currentBindingConfig = aspectBindingConfigs[i];
                                aspectBundleId = currentBindingConfig.getContributor().getName();
                                IS_OTDT |= KNOWN_OTDT_ASPECTS.contains(aspectBundleId);
                                aspectBundle = null;
                                if (packageAdmin == null) break block9;
                                aspectBundles = packageAdmin.getBundles(aspectBundleId, null);
                                if (aspectBundles != null && aspectBundles.length != 0 && aspectBundles[0].getState() >= 4) break block10;
                                TransformerPlugin.log(4, "aspect bundle " + aspectBundleId + " is not resolved - not loading aspectBindings.");
                                break block11;
                            }
                            aspectBundle = aspectBundles[0];
                        }
                        if ((basePlugins = currentBindingConfig.getChildren("basePlugin")).length == 1) break block12;
                        TransformerPlugin.log(4, "aspectBinding of " + aspectBundleId + " must declare exactly one basePlugin");
                        break block11;
                    }
                    baseBundleId = basePlugins[0].getAttribute("id");
                    if (baseBundleId != null) break block13;
                    TransformerPlugin.log(4, "aspectBinding of " + aspectBundleId + " must specify the id of a basePlugin");
                    break block11;
                }
                AspectBinding.BaseBundle baseBundle = this.getBaseBundle(baseBundleId);
                IConfigurationElement[] fragments = basePlugins[0].getChildren("requiredFragment");
                if (fragments != null && !this.checkRequiredFragments(aspectBundleId, baseBundleId, fragments, packageAdmin)) break block11;
                IConfigurationElement[] teams = currentBindingConfig.getChildren("team");
                int teamCount = teams.length;
                int j = 0;
                while (j < teams.length) {
                    if (teams[j].getAttribute("class") == null) {
                        --teamCount;
                    }
                    ++j;
                }
                bindings[i] = binding = new AspectBinding(aspectBundleId, aspectBundle, baseBundle, basePlugins[0].getChildren("forcedExports"), teamCount);
                try {
                    int j2 = 0;
                    int count = 0;
                    while (true) {
                        block14: {
                            if (count < teamCount) break block14;
                        }
                        String teamClass = teams[j2].getAttribute("class");
                        if (teamClass != null) {
                            AspectBinding.TeamBinding team = binding.createResolvedTeam(count++, teamClass, teams[j2].getAttribute("activation"), teams[j2].getAttribute("superclass"));
                            HashSet<AspectBinding.TeamBinding> teamSet = (HashSet<AspectBinding.TeamBinding>)teamLookup.get(teamClass);
                            if (teamSet == null) {
                                teamSet = new HashSet<AspectBinding.TeamBinding>();
                                teamLookup.put(teamClass, teamSet);
                            }
                            teamSet.add(team);
                        }
                        ++j2;
                    }
                    String realBaseBundleId = baseBundleId.toUpperCase().equals("SELF") ? aspectBundleId : baseBundleId;
                    AspectBindingRegistry.addBindingForBaseBundle(realBaseBundleId, binding);
                    this.addBindingForAspectBundle(aspectBundleId, binding);
                    hook.setBaseTripWire(packageAdmin, realBaseBundleId, baseBundle);
                    TransformerPlugin.log(1, "registered:\n" + binding);
                }
                catch (Throwable t) {
                    TransformerPlugin.log(t, "Invalid aspectBinding extension");
                }
            }
            ++i;
        }
        i = 0;
        while (i < bindings.length) {
            bindings[i].connect(teamLookup);
            ++i;
        }
    }

    private boolean checkRequiredFragments(String aspectBundleId, String baseBundleId, IConfigurationElement[] fragments, @Nullable PackageAdmin packageAdmin) {
        boolean hasError = false;
        IConfigurationElement[] iConfigurationElementArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement fragment = iConfigurationElementArray[n2];
            String fragId = fragment.getAttribute("id");
            if (fragId == null) {
                TransformerPlugin.log(4, "Mandatory attribute \"id\" missing from element \"requiredFragment\" of aspect binding in " + aspectBundleId);
                return false;
            }
            if (packageAdmin == null) {
                TransformerPlugin.log(4, "Not checking required fragment " + fragId + " in aspect binding of " + aspectBundleId + ", package admin service not present");
                return false;
            }
            Bundle[] fragmentBundles = packageAdmin.getBundles(fragId, null);
            if (fragmentBundles == null || fragmentBundles.length == 0) {
                TransformerPlugin.log(4, "Required fragment " + fragId + " not found in aspect binding of " + aspectBundleId);
                hasError = true;
            } else {
                Bundle fragmentBundle = fragmentBundles[0];
                String aspectBindingHint = " (aspect binding of " + aspectBundleId + ")";
                if (packageAdmin.getBundleType(fragmentBundle) != 1) {
                    TransformerPlugin.log(4, "Required fragment " + fragId + " is not a fragment" + aspectBindingHint);
                    hasError = true;
                } else {
                    Bundle[] hosts = packageAdmin.getHosts(fragmentBundle);
                    if (hosts == null || hosts.length == 0) {
                        if (fragmentBundle.getState() < 4) {
                            TransformerPlugin.log(4, "Required fragment " + fragId + " is not resolved" + aspectBindingHint);
                            hasError = true;
                        } else {
                            TransformerPlugin.log(4, "Required fragment " + fragId + " has no host bundle" + aspectBindingHint);
                            hasError = true;
                        }
                    } else {
                        Bundle host = hosts[0];
                        if (!host.getSymbolicName().equals(baseBundleId)) {
                            TransformerPlugin.log(4, "Required fragment " + fragId + " has wrong host " + host.getSymbolicName() + aspectBindingHint);
                            hasError = true;
                        }
                    }
                }
            }
            ++n2;
        }
        return !hasError;
    }

    private static void addBindingForBaseBundle(String baseBundleId, AspectBinding binding) {
        ArrayList<AspectBinding> bindingList = aspectBindingsByBasePlugin.get(baseBundleId);
        if (bindingList == null) {
            bindingList = new ArrayList();
            aspectBindingsByBasePlugin.put(baseBundleId, bindingList);
        }
        bindingList.add(binding);
    }

    private void addBindingForAspectBundle(String aspectBundleId, AspectBinding binding) {
        ArrayList<AspectBinding> bindingList = aspectBindingsByAspectPlugin.get(aspectBundleId);
        if (bindingList == null) {
            bindingList = new ArrayList();
            aspectBindingsByAspectPlugin.put(aspectBundleId, bindingList);
        }
        bindingList.add(binding);
        if (binding.basePluginName.toUpperCase().equals("SELF")) {
            this.selfAdaptingAspects.add(aspectBundleId);
        }
    }

    @Nullable
    public String[] getAdaptedBasePlugins(Bundle aspectBundle) {
        ArrayList<AspectBinding> bindings = aspectBindingsByAspectPlugin.get(aspectBundle.getSymbolicName());
        if (bindings == null) {
            return null;
        }
        String[] basePlugins = new String[bindings.size()];
        int i = 0;
        while (i < basePlugins.length) {
            basePlugins[i] = bindings.get((int)i).basePluginName;
            ++i;
        }
        return basePlugins;
    }

    public boolean isAdaptedBasePlugin(@Nullable String symbolicName) {
        ArrayList<AspectBinding> list = aspectBindingsByBasePlugin.get(symbolicName);
        return list != null && !list.isEmpty();
    }

    @Nullable
    public List<AspectBinding> getAdaptingAspectBindings(@Nullable String basePluginName) {
        return aspectBindingsByBasePlugin.get(basePluginName);
    }

    @Nullable
    public List<AspectBinding> getAspectBindings(String aspectBundle) {
        return aspectBindingsByAspectPlugin.get(aspectBundle);
    }

    public AspectBinding.BaseBundle getBaseBundle(String bundleName) {
        AspectBinding.BaseBundle bundle = this.baseBundleLookup.get(bundleName);
        if (bundle == null) {
            bundle = new AspectBinding.BaseBundle(bundleName);
            this.baseBundleLookup.put(bundleName, bundle);
        }
        return bundle;
    }
}

