/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmTypeHelper;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public abstract class AbstractTransformableClassNode
extends ClassNode {
    public AbstractTransformableClassNode() {
        super(327680);
    }

    protected InsnList getBoxingInstructions(Type[] args, boolean isStatic) {
        int firstArgIndex = 1;
        if (isStatic) {
            firstArgIndex = 0;
        }
        InsnList instructions = new InsnList();
        instructions.add(this.createLoadIntConstant(args.length));
        instructions.add((AbstractInsnNode)new TypeInsnNode(189, ClassNames.OBJECT_SLASH));
        int i = 0;
        int slot = 0;
        while (i < args.length) {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add(this.createLoadIntConstant(i));
            instructions.add((AbstractInsnNode)new IntInsnNode(args[i].getOpcode(21), slot + firstArgIndex));
            if (args[i].getSort() != 10 && args[i].getSort() != 9) {
                instructions.add(AsmTypeHelper.getBoxingInstructionForType(args[i]));
            }
            instructions.add((AbstractInsnNode)new InsnNode(83));
            slot += args[i++].getSize();
        }
        return instructions;
    }

    protected InsnList getUnboxingInstructionsForReturnValue(Type returnType) {
        InsnList instructions = new InsnList();
        switch (returnType.getSort()) {
            case 0: {
                instructions.add((AbstractInsnNode)new InsnNode(87));
                instructions.add((AbstractInsnNode)new InsnNode(177));
                break;
            }
            case 9: 
            case 10: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, returnType.getInternalName()));
                instructions.add((AbstractInsnNode)new InsnNode(176));
                break;
            }
            default: {
                String objectType = AsmTypeHelper.getObjectType(returnType);
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, objectType));
                instructions.add(AsmTypeHelper.getUnboxingInstructionForType(returnType, objectType));
                instructions.add((AbstractInsnNode)new InsnNode(returnType.getOpcode(172)));
            }
        }
        return instructions;
    }

    protected void addNewLabelToSwitch(InsnList instructions, InsnList newInstructions, int labelIndex) {
        ListIterator iter = instructions.iterator();
        LookupSwitchInsnNode lSwitch = null;
        while (iter.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iter.next();
            if (node.getType() != 12) continue;
            lSwitch = (LookupSwitchInsnNode)node;
            LabelNode label = new LabelNode();
            boolean labelAdded = false;
            int i = 0;
            while (i < lSwitch.keys.size()) {
                Integer key = (Integer)lSwitch.keys.get(i);
                if (key >= labelIndex) {
                    lSwitch.keys.add(i, labelIndex);
                    lSwitch.labels.add(i, label);
                    labelAdded = true;
                    break;
                }
                ++i;
            }
            if (!labelAdded) {
                lSwitch.labels.add(label);
                lSwitch.keys.add(labelIndex);
            }
            boolean foundDefLabel = false;
            AbstractInsnNode prevNode = node;
            while (iter.hasNext()) {
                node = (AbstractInsnNode)iter.next();
                if (node.getType() == 8) {
                    if (foundDefLabel) break;
                    foundDefLabel = true;
                }
                prevNode = node;
            }
            instructions.insert(prevNode, (AbstractInsnNode)label);
            instructions.insert((AbstractInsnNode)label, newInstructions);
        }
        if (lSwitch == null) {
            throw new RuntimeException("No switch statement found.");
        }
    }

    protected MethodNode getMethod(Method method) {
        List methodList = this.methods;
        for (MethodNode methodNode : methodList) {
            if (methodNode.name.compareTo(method.getName()) != 0 || methodNode.desc.compareTo(method.getSignature()) != 0) continue;
            return methodNode;
        }
        return null;
    }

    protected InsnList getInstructionsForDebugOutput(String message) {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, "java/lang/System", "out", "Ljava/io/PrintStream;"));
        instructions.add((AbstractInsnNode)new LdcInsnNode((Object)message));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false));
        return instructions;
    }

    protected void addInstructionsForLoadArguments(InsnList instructions, Type[] args, boolean isStatic) {
        int firstArgIndex = 1;
        if (isStatic) {
            firstArgIndex = 0;
        }
        if (!isStatic) {
            instructions.add((AbstractInsnNode)new IntInsnNode(25, 0));
        }
        int i = 0;
        int slot = firstArgIndex;
        while (i < args.length) {
            instructions.add((AbstractInsnNode)new IntInsnNode(args[i].getOpcode(21), slot));
            slot += args[i++].getSize();
        }
    }

    protected void replaceReturn(InsnList instructions, Type returnType) {
        if (returnType.getSort() != 10 && returnType.getSort() != 9 && returnType.getSort() != 0) {
            for (AbstractInsnNode orgMethodNode : instructions) {
                if (orgMethodNode.getOpcode() != returnType.getOpcode(172)) continue;
                instructions.remove(orgMethodNode);
                instructions.add(AsmTypeHelper.getBoxingInstructionForType(returnType));
                instructions.add((AbstractInsnNode)new InsnNode(176));
            }
        } else if (returnType.getSort() == 0) {
            for (AbstractInsnNode orgMethodNode : instructions) {
                if (orgMethodNode.getOpcode() != 177) continue;
                instructions.remove(orgMethodNode);
            }
            instructions.add((AbstractInsnNode)new InsnNode(1));
            instructions.add((AbstractInsnNode)new InsnNode(176));
        }
    }

    protected AbstractInsnNode createLoadIntConstant(int constant) {
        if (constant <= 5) {
            return new InsnNode(3 + constant);
        }
        if (constant < 127) {
            return new IntInsnNode(16, constant);
        }
        return new LdcInsnNode((Object)constant);
    }

    protected abstract boolean transform();
}

