/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.util.HashSet;
import org.eclipse.objectteams.otredyn.bytecode.Binding;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddImplicitActivationAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.asm.Attributes;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

class AsmClassVisitor
extends ClassVisitor {
    private AsmBoundClass clazz;

    public AsmClassVisitor(AsmBoundClass clazz) {
        super(327680);
        this.clazz = clazz;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.clazz.setSuperClassName(superName);
        this.clazz.setSuperInterfaces(interfaces);
        this.clazz.setModifiers(access);
    }

    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        this.clazz.addMethod(name, desc, (access & 8) != 0, access & 7);
        if (this.clazz.isTeam() || this.clazz.isRole()) {
            return new MethodVisitor(this.api){

                public AnnotationVisitor visitAnnotation(String annDesc, boolean visible) {
                    if (annDesc.equals(AddImplicitActivationAdapter.ANNOTATION_IMPLICIT_ACTIVATION)) {
                        AsmClassVisitor.this.clazz.registerMethodForImplicitActivation(String.valueOf(name) + desc);
                    }
                    return super.visitAnnotation(annDesc, visible);
                }
            };
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.clazz.addField(name, desc, (access & 8) != 0, access & 7);
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitAttribute(Attribute attribute) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (this.clazz.boundBaseClasses == null) {
                                this.clazz.boundBaseClasses = new HashSet<String>();
                            }
                            if (!attribute.type.equals("OTDynCallinBindings")) break block4;
                            Attributes.CallinBindingsAttribute attr = (Attributes.CallinBindingsAttribute)attribute;
                            Attributes.CallinBindingsAttribute.MultiBinding[] multiBindings = attr.getBindings();
                            int i = multiBindings.length - 1;
                            while (i >= 0) {
                                String roleClassName = multiBindings[i].getRoleClassName();
                                String callinLabel = multiBindings[i].getCallinLabel();
                                String baseClassName = multiBindings[i].getBaseClassName();
                                this.clazz.boundBaseClasses.add(baseClassName.replace('/', '.'));
                                String[] baseMethodNames = multiBindings[i].getBaseMethodNames();
                                String[] baseMethodSignatures = multiBindings[i].getBaseMethodSignatures();
                                String[] declaringBaseClassNames = multiBindings[i].getDeclaringBaseClassName();
                                int callinModifier = multiBindings[i].getCallinModifier();
                                int[] callinIds = multiBindings[i].getCallinIds();
                                int[] baseFlags = multiBindings[i].getBaseFlags();
                                boolean handleCovariantReturn = multiBindings[i].isHandleCovariantReturn();
                                int j = 0;
                                while (j < baseMethodNames.length) {
                                    Binding binding = new Binding(this.clazz, roleClassName, callinLabel, baseClassName, baseMethodNames[j], baseMethodSignatures[j], declaringBaseClassNames[j], callinModifier, callinIds[j], baseFlags[j], handleCovariantReturn);
                                    this.clazz.addBinding(binding);
                                    ++j;
                                }
                                --i;
                            }
                            break block5;
                        }
                        if (!attribute.type.equals("CallinPrecedence")) break block6;
                        Attributes.CallinPrecedenceAttribute attr = (Attributes.CallinPrecedenceAttribute)attribute;
                        this.clazz.precedenceses.add(attr.labels);
                        break block5;
                    }
                    if (!attribute.type.equals("OTClassFlags")) break block7;
                    this.clazz.setOTClassFlags(((Attributes.OTClassFlagsAttribute)attribute).flags);
                    break block5;
                }
                if (!attribute.type.equals("OTSpecialAccess")) break block8;
                ((Attributes.OTSpecialAccessAttribute)attribute).registerAt(this.clazz);
                break block5;
            }
            if (!attribute.type.equals("CallinRoleBaseBindings")) break block5;
            String[] stringArray = ((Attributes.RoleBaseBindingsAttribute)attribute).bases;
            int n = ((Attributes.RoleBaseBindingsAttribute)attribute).bases.length;
            int n2 = 0;
            while (n2 < n) {
                String base = stringArray[n2];
                this.clazz.boundBaseClasses.add(base.replace('/', '.'));
                ++n2;
            }
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals(AddImplicitActivationAdapter.ANNOTATION_IMPLICIT_ACTIVATION)) {
            this.clazz.enableImplicitActivation();
        }
        return super.visitAnnotation(desc, visible);
    }
}

