/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.objectteams.otredyn.bytecode.asm.ASMByteCodeAnalyzer;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class LoaderAwareClassWriter
extends ClassWriter {
    private ClassLoader loader;
    private ASMByteCodeAnalyzer analyzer;
    private Map<String, ASMByteCodeAnalyzer.ClassInformation> knownClasses = new HashMap<String, ASMByteCodeAnalyzer.ClassInformation>();

    public LoaderAwareClassWriter(ClassReader reader, int computeFrames, ClassLoader loader) {
        super(reader, computeFrames);
        this.loader = loader;
        this.analyzer = new ASMByteCodeAnalyzer(false);
    }

    protected String getCommonSuperClass(String type1, String type2) {
        ASMByteCodeAnalyzer.ClassInformation ci2;
        ASMByteCodeAnalyzer.ClassInformation ci1;
        if (type1.equals(type2)) {
            return type1;
        }
        if (type1.equals(ClassNames.OBJECT_SLASH) || type2.equals(ClassNames.OBJECT_SLASH)) {
            return ClassNames.OBJECT_SLASH;
        }
        try {
            InputStream s1 = this.loader.getResourceAsStream(String.valueOf(type1) + ".class");
            ci1 = this.analyzer.getClassInformation(s1, type1);
            if (ci1 == null) {
                return ClassNames.OBJECT_SLASH;
            }
            InputStream s2 = this.loader.getResourceAsStream(String.valueOf(type2) + ".class");
            ci2 = this.analyzer.getClassInformation(s2, type2);
            if (ci2 == null) {
                return ClassNames.OBJECT_SLASH;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        HashSet<String> allTypes1 = new HashSet<String>();
        HashSet<String> allTypes2 = new HashSet<String>();
        allTypes1.add(type1);
        allTypes2.add(type2);
        List<String> newTypes1 = new ArrayList<String>();
        this.addSuperClass(newTypes1, ci1);
        List<String> newTypes2 = new ArrayList<String>();
        this.addSuperClass(newTypes2, ci2);
        while (!newTypes1.isEmpty() || !newTypes2.isEmpty()) {
            for (String newType1 : newTypes1) {
                if (!allTypes2.contains(newType1)) continue;
                return newType1;
            }
            allTypes1.addAll(newTypes1);
            for (String newType2 : newTypes2) {
                if (!allTypes1.contains(newType2)) continue;
                return newType2;
            }
            allTypes2.addAll(newTypes2);
            newTypes1 = this.getDirectSupersLayer(newTypes1, true);
            newTypes2 = this.getDirectSupersLayer(newTypes2, true);
        }
        this.addSuperInterfaces(newTypes1, ci1);
        this.addSuperInterfaces(newTypes2, ci2);
        while (!newTypes1.isEmpty() || !newTypes2.isEmpty()) {
            for (String newType1 : newTypes1) {
                if (!allTypes2.contains(newType1)) continue;
                return newType1;
            }
            allTypes1.addAll(newTypes1);
            for (String newType2 : newTypes2) {
                if (!allTypes1.contains(newType2)) continue;
                return newType2;
            }
            allTypes2.addAll(newTypes2);
            newTypes1 = this.getDirectSupersLayer(newTypes1, false);
            newTypes2 = this.getDirectSupersLayer(newTypes2, false);
        }
        return ClassNames.OBJECT_SLASH;
    }

    private List<String> getDirectSupersLayer(List<String> types, boolean classes) {
        ArrayList<String> result = new ArrayList<String>();
        for (String type : types) {
            ASMByteCodeAnalyzer.ClassInformation ci = this.knownClasses.get(type);
            if (ci == null) {
                InputStream s;
                try {
                    s = this.loader.getResourceAsStream(String.valueOf(type) + ".class");
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
                ci = this.analyzer.getClassInformation(s, type);
                this.knownClasses.put(type, ci);
            }
            if (ci == null) continue;
            if (classes) {
                this.addSuperClass(result, ci);
                continue;
            }
            this.addSuperInterfaces(result, ci);
        }
        return result;
    }

    private void addSuperClass(List<String> result, ASMByteCodeAnalyzer.ClassInformation ci) {
        String superClass = ci.getSuperClassName();
        if (superClass != null && !superClass.equals(ClassNames.OBJECT_SLASH)) {
            result.add(superClass);
        }
    }

    private void addSuperInterfaces(List<String> result, ASMByteCodeAnalyzer.ClassInformation ci) {
        String[] stringArray = ci.getSuperInterfaceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ifc = stringArray[n2];
            result.add(ifc);
            ++n2;
        }
    }
}

