/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.ClassScanner;
import org.eclipse.objectteams.internal.osgi.weaving.DelegatingTransformer;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.internal.osgi.weaving.TeamLoader;
import org.eclipse.objectteams.internal.osgi.weaving.Util;
import org.eclipse.objectteams.otequinox.ActivationKind;
import org.eclipse.objectteams.otequinox.AspectPermission;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.objectteams.Team;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;

@NonNullByDefault
public class AspectBinding {
    static final String OT_ASPECT_HOST_ATTRIBUTE = "ot-aspect-host";
    public String aspectPlugin;
    @Nullable
    public Bundle aspectBundle;
    public String basePluginName;
    public BaseBundle baseBundle;
    public IConfigurationElement[] forcedExports;
    public TeamBinding[] teams;
    public Set<String> allBaseClassNames = new HashSet<String>();
    public boolean hasScannedTeams;
    public AspectPermission forcedExportsPermission = AspectPermission.UNDEFINED;
    public boolean hasBeenDenied = false;
    Set<TeamBinding> teamsInProgress = new HashSet<TeamBinding>();

    public AspectBinding(String aspectId, @Nullable Bundle aspectBundle, BaseBundle baseBundle, IConfigurationElement[] forcedExportsConfs, int count) {
        this.aspectPlugin = aspectId;
        this.aspectBundle = aspectBundle;
        this.baseBundle = baseBundle;
        this.basePluginName = baseBundle.bundleName;
        this.forcedExports = forcedExportsConfs;
        this.teams = new TeamBinding[count];
    }

    public TeamBinding createResolvedTeam(int count, String teamName, @Nullable String activationSpecifier, @Nullable String superTeamName) {
        ActivationKind kind = ActivationKind.NONE;
        try {
            if (activationSpecifier != null) {
                kind = ActivationKind.valueOf(activationSpecifier);
            }
        }
        catch (IllegalArgumentException iae) {
            TransformerPlugin.log(iae, "Invalid activation kind " + activationSpecifier + " for team " + teamName);
        }
        this.teams[count] = new TeamBinding(teamName, kind, superTeamName);
        return this.teams[count];
    }

    public void connect(Map<String, Set<TeamBinding>> teamLookup) {
        int i = 0;
        while (i < this.teams.length) {
            TeamBinding team = this.teams[i];
            Set<TeamBinding> equivalenceSet = teamLookup.get(team.teamName);
            if (equivalenceSet != null) {
                for (TeamBinding equivalent : equivalenceSet) {
                    team.connectEquivalent(equivalent);
                }
            }
            if (team.equivalenceSet.size() > 1) {
                TransformerPlugin.log(1, "team " + team.teamName + " participates in " + team.equivalenceSet.size() + " aspect bindings.");
            }
            if (team.superTeamName != null) {
                Set<TeamBinding> superTeams = teamLookup.get(team.superTeamName);
                if (superTeams != null) {
                    Iterator<TeamBinding> iterator = superTeams.iterator();
                    while (iterator.hasNext()) {
                        TeamBinding superTeam;
                        team.superTeam = superTeam = iterator.next();
                        superTeam.subTeams.add(team);
                    }
                } else {
                    Exception e = new Exception("No such aspect binding");
                    TransformerPlugin.log(e, "Class " + team.superTeamName + " not registered (declared to be superclass of team " + team.teamName);
                }
            }
            ++i;
        }
    }

    @Nullable
    public synchronized Collection<TeamBinding> getTeamsForBase(String baseClassName) {
        Set<TeamBinding> teams = this.baseBundle.teamsPerBase.get(baseClassName);
        if (teams != null) {
            teams = new HashSet<TeamBinding>(teams);
            teams.removeAll(this.teamsInProgress);
            this.teamsInProgress.addAll(teams);
        }
        return teams;
    }

    public synchronized Collection<String> scanTeamClasses(Bundle bundle, DelegatingTransformer transformer) {
        long time = 0L;
        if (Util.PROFILE) {
            time = System.nanoTime();
        }
        ClassScanner scanner = new ClassScanner();
        for (TeamBinding team : this.getAllTeamBindings()) {
            if (team.hasScannedBases) {
                if (team.hasScannedRoles) continue;
                team.hasScannedRoles = true;
                scanner.readMemberTypeAttributes(bundle, team.teamName, transformer);
                continue;
            }
            team.hasScannedBases = true;
            team.hasScannedRoles = true;
            try {
                String teamName = scanner.readOTAttributes(bundle, team.teamName, transformer);
                Collection<String> baseClassNames = scanner.getCollectedBaseClassNames();
                if (team.baseClassNames.isEmpty()) {
                    for (TeamBinding equivalent : team.equivalenceSet) {
                        equivalent.addBaseClassNames(baseClassNames);
                    }
                }
                TransformerPlugin.log(1, "Scanned team class " + teamName + ", found " + baseClassNames.size() + " base classes");
            }
            catch (Exception e) {
                TransformerPlugin.log(e, "Failed to scan team class " + team.teamName);
            }
        }
        this.hasScannedTeams = true;
        if (Util.PROFILE) {
            Util.profile(time, Util.ProfileKind.Scan, bundle.getSymbolicName());
        }
        return this.allBaseClassNames;
    }

    private List<TeamBinding> getAllTeamBindings() {
        ArrayList<TeamBinding> all = new ArrayList<TeamBinding>();
        TeamBinding[] teamBindingArray = this.teams;
        int n = this.teams.length;
        int n2 = 0;
        while (n2 < n) {
            TeamBinding team = teamBindingArray[n2];
            all.add(team);
            ++n2;
        }
        int i = 0;
        while (i < this.teams.length) {
            if (this.teams[i].superTeam != null) {
                all.add(this.teams[i].superTeam);
            }
            all.addAll(this.teams[i].subTeams);
            ++i;
        }
        return all;
    }

    public void addImports(WovenClass baseClass) {
        String baseClassName = baseClass.getClassName();
        Set<TeamBinding> teams = this.baseBundle.teamsPerBase.get(baseClassName);
        if (teams != null) {
            for (TeamBinding resolvedTeam : teams) {
                resolvedTeam.addImportTo(baseClass, 0);
            }
        }
    }

    public void cleanUp(String baseClass) {
        this.baseBundle.teamsPerBase.remove(baseClass);
    }

    public boolean isDone() {
        int i = 0;
        while (i < this.teams.length) {
            if (!this.teams[i].isDone()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String result = "\tbase plugin " + this.basePluginName + "\n\tadapted by aspect pluging " + this.aspectPlugin;
        TeamBinding[] teamBindingArray = this.teams;
        int n = this.teams.length;
        int n2 = 0;
        while (n2 < n) {
            TeamBinding team = teamBindingArray[n2];
            result = String.valueOf(result) + "\n\t\t " + team.toString();
            ++n2;
        }
        return result;
    }

    static class BaseBundle {
        String bundleName;
        final HashMap<String, Set<TeamBinding>> teamsPerBase = new HashMap();
        boolean otreAdded;

        public BaseBundle(String bundleName) {
            this.bundleName = bundleName;
        }
    }

    class TeamBinding {
        String teamName;
        @Nullable
        Class<? extends Team> teamClass;
        @Nullable
        Team instance;
        @Nullable
        String superTeamName;
        @Nullable
        TeamBinding superTeam;
        final List<TeamBinding> subTeams = new ArrayList<TeamBinding>();
        Set<TeamBinding> equivalenceSet = new HashSet<TeamBinding>();
        private ActivationKind activation;
        boolean hasScannedBases;
        boolean hasScannedRoles;
        @Nullable
        AspectPermission checkedPermission;
        boolean isActivated;
        boolean importsAdded;
        boolean importsAddedToSuper;
        boolean importsAddedToSub;
        final Set<String> baseClassNames = new HashSet<String>();
        public final List<String> superBases = new ArrayList<String>();

        public TeamBinding(String teamName, @Nullable ActivationKind activationKind, String superTeamName) {
            this.teamName = teamName;
            this.activation = activationKind;
            this.superTeamName = superTeamName;
            this.equivalenceSet.add(this);
        }

        AspectBinding getAspectBinding() {
            return AspectBinding.this;
        }

        public void addBaseClassNames(Collection<String> baseClassNames) {
            AspectBinding.this.allBaseClassNames.addAll(baseClassNames);
            for (String baseClassName : baseClassNames) {
                if (!this.baseClassNames.add(baseClassName)) continue;
                Set<TeamBinding> teams = AspectBinding.this.baseBundle.teamsPerBase.get(baseClassName);
                if (teams == null) {
                    teams = new HashSet<TeamBinding>();
                    AspectBinding.this.baseBundle.teamsPerBase.put(baseClassName, teams);
                }
                teams.add(this);
            }
        }

        void connectEquivalent(TeamBinding equivalent) {
            boolean locallyHaveBases;
            if (this == equivalent) {
                return;
            }
            if (!this.equivalenceSet.add(equivalent)) {
                return;
            }
            boolean bl = locallyHaveBases = !this.baseClassNames.isEmpty();
            if (!equivalent.baseClassNames.isEmpty()) {
                this.addBaseClassNames(equivalent.baseClassNames);
            }
            if (locallyHaveBases) {
                equivalent.addBaseClassNames(this.baseClassNames);
            }
        }

        @Nullable
        public Class<? extends Team> loadTeamClass() {
            if (this.teamClass != null) {
                return this.teamClass;
            }
            for (String candidate : TeamLoader.possibleTeamNames(this.teamName)) {
                try {
                    Class result;
                    Bundle aspectBundle = AspectBinding.this.aspectBundle;
                    if (aspectBundle == null || (result = aspectBundle.loadClass(candidate)) == null) continue;
                    this.teamClass = result;
                    return this.teamClass;
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public void addImportTo(WovenClass baseClass, int direction) {
            String packageWithAttribute;
            this.importsAdded = true;
            if (AspectBinding.this.hasBeenDenied) {
                return;
            }
            String packageOfTeam = "";
            int dot = this.teamName.lastIndexOf(46);
            if (dot != -1) {
                packageOfTeam = this.teamName.substring(0, dot);
            }
            if (!OTWeavingHook.hasImport(baseClass, packageOfTeam, packageWithAttribute = String.valueOf(packageOfTeam) + ";" + AspectBinding.OT_ASPECT_HOST_ATTRIBUTE + "=\"" + AspectBinding.this.aspectPlugin + "\"")) {
                block12: {
                    BundleRevision bundleRevision;
                    List imports = baseClass.getDynamicImports();
                    Bundle aspectBundle = AspectBinding.this.aspectBundle;
                    BundleRevision bundleRevision2 = bundleRevision = aspectBundle != null ? (BundleRevision)aspectBundle.adapt(BundleRevision.class) : null;
                    if (bundleRevision != null) {
                        for (Capability capability : bundleRevision.getCapabilities("osgi.wiring.package")) {
                            Object exported = capability.getAttributes().get("osgi.wiring.package");
                            if (!(exported instanceof String) || !exported.equals(packageOfTeam)) continue;
                            if (capability.getAttributes().containsKey(AspectBinding.OT_ASPECT_HOST_ATTRIBUTE)) {
                                imports.add(packageWithAttribute);
                            } else {
                                TransformerPlugin.log(2, "Package " + packageOfTeam + " for team " + this.teamName.substring(dot + 1) + " is exported without an 'ot-aspect-host' attribute.");
                                imports.add(packageOfTeam);
                            }
                            break block12;
                        }
                        TransformerPlugin.log(4, "Package " + packageOfTeam + " for team " + this.teamName.substring(dot + 1) + " is not exported by its bundle " + AspectBinding.this.aspectPlugin);
                    } else {
                        TransformerPlugin.log(2, "Can't check exporting of " + this.teamName + ", bundle information for " + AspectBinding.this.aspectPlugin + " is not available");
                    }
                }
                TransformerPlugin.log(1, "Added dependency from base " + baseClass.getClassName() + " to package '" + packageOfTeam + "'");
            }
            if (direction != -1) {
                this.importsAddedToSuper = true;
                TeamBinding superTeam2 = this.superTeam;
                if (superTeam2 != null) {
                    superTeam2.addImportTo(baseClass, 1);
                }
            }
            if (direction != 1) {
                this.importsAddedToSub = true;
                for (TeamBinding subTeam : this.subTeams) {
                    subTeam.addImportTo(baseClass, -1);
                }
            }
        }

        public boolean isDone() {
            if (this.activation != ActivationKind.NONE && !this.isActivated) {
                return false;
            }
            return this.importsAdded && this.importsAddedToSub && this.importsAddedToSuper;
        }

        public String toString() {
            String result = "team " + this.teamName + "(" + (Object)((Object)this.activation) + ") super " + this.superTeamName;
            for (String superBase : this.superBases) {
                result = String.valueOf(result) + "\n\t\t\tsuperBase " + superBase;
            }
            return result;
        }

        public ActivationKind getActivation() {
            ActivationKind activation = this.activation;
            for (TeamBinding equiv : this.equivalenceSet) {
                if (equiv.activation.ordinal() <= activation.ordinal()) continue;
                activation = equiv.activation;
            }
            return activation;
        }

        @Nullable
        public TeamBinding getOtherTeamToActivate() {
            TeamBinding superTeam = this.superTeam;
            if (superTeam != null && superTeam.getActivation() != ActivationKind.NONE) {
                return superTeam;
            }
            return null;
        }

        public boolean hasBeenDenied() {
            return this.checkedPermission == AspectPermission.DENY || AspectBinding.this.hasBeenDenied;
        }

        public Team getInstance() throws InstantiationException, IllegalAccessException {
            for (TeamBinding equalivalent : this.equivalenceSet) {
                Team inst = equalivalent.instance;
                if (inst == null) continue;
                return inst;
            }
            Class<? extends Team> cl = this.teamClass;
            assert (cl != null) : "Precondition";
            Team nnInst = cl.newInstance();
            TransformerPlugin.registerTeamInstance(nnInst);
            TransformerPlugin.log(1, "Instantiated team " + this.teamName);
            this.instance = nnInst;
            return this.instance;
        }
    }
}

