/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.objectteams.otdt.core.search.Messages;
import org.eclipse.objectteams.otdt.core.search.OTSearchEngine;

public class OTSearchHelper {
    public static <M extends IMember> void addToMapOfSets(Map<IMember, Set<M>> mapOfSets, IMember key, M value) {
        Set<M> setForType = mapOfSets.get(key);
        if (setForType == null) {
            setForType = new HashSet<M>();
            mapOfSets.put(key, setForType);
        }
        setForType.add(value);
    }

    public static Map<IMember, Set<IType>> searchPlayedByBindings(Collection<IType> baseTypes, IJavaProject[] projects, IProgressMonitor monitor) {
        if (baseTypes == null || baseTypes.size() == 0) {
            monitor.beginTask("", 1);
            monitor.done();
            return null;
        }
        OTSearchEngine engine = new OTSearchEngine();
        IJavaSearchScope searchScope = OTSearchEngine.createOTSearchScope(projects, false);
        final HashMap<IMember, Set<IType>> resultMap = new HashMap<IMember, Set<IType>>();
        try {
            monitor.beginTask(Messages.OTSearchHelper_progress_searchRoleTypes, baseTypes.size());
            for (final IType baseType : baseTypes) {
                if (monitor.isCanceled()) {
                    return null;
                }
                try {
                    SubProgressMonitor searchMonitor = new SubProgressMonitor(monitor, 1);
                    if (!baseType.exists() || baseType.isEnum() || baseType.isAnnotation()) continue;
                    SearchPattern pattern = SearchPattern.createPattern(baseType, 6);
                    if (pattern == null) {
                        JavaCore.getJavaCore().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.core", "Error creating pattern"));
                        continue;
                    }
                    engine.search(pattern, searchScope, new SearchRequestor(){

                        @Override
                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            Object element = match.getElement();
                            if (element instanceof IType) {
                                OTSearchHelper.addToMapOfSets(resultMap, baseType, (IType)element);
                            }
                        }
                    }, (IProgressMonitor)searchMonitor);
                }
                catch (CoreException ex) {
                    JavaCore.getJavaCore().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.core", "Error finding playedBy bindings", (Throwable)ex));
                }
            }
        }
        finally {
            monitor.done();
        }
        return resultMap;
    }
}

