/*******************************************************************************
 * Copyright (c) 2000, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Technical University Berlin - extended API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int 
		TokenNameNotAToken = 0,
	    TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;

	int
      TokenNameIdentifier = 17,
      TokenNameabstract = 54,
      TokenNameassert = 82,
      TokenNameboolean = 109,
      TokenNamebreak = 83,
      TokenNamebyte = 110,
      TokenNamecase = 111,
      TokenNamecatch = 112,
      TokenNamechar = 113,
      TokenNameclass = 71,
      TokenNamecontinue = 84,
      TokenNameconst = 145,
      TokenNamedefault = 79,
      TokenNamedo = 85,
      TokenNamedouble = 114,
      TokenNameelse = 126,
      TokenNameenum = 75,
      TokenNameextends = 94,
      TokenNamefalse = 39,
      TokenNamefinal = 55,
      TokenNamefinally = 122,
      TokenNamefloat = 115,
      TokenNamefor = 86,
      TokenNamegoto = 146,
      TokenNameif = 87,
      TokenNameimplements = 141,
      TokenNameimport = 116,
      TokenNameinstanceof = 18,
      TokenNameint = 117,
      TokenNameinterface = 74,
      TokenNamelong = 118,
      TokenNamenative = 56,
      TokenNamenew = 37,
      TokenNamenull = 40,
      TokenNamepackage = 95,
      TokenNameprivate = 57,
      TokenNameprotected = 58,
      TokenNamepublic = 59,
      TokenNamereturn = 88,
      TokenNameshort = 119,
      TokenNamestatic = 50,
      TokenNamestrictfp = 60,
      TokenNamesuper = 35,
      TokenNameswitch = 89,
      TokenNamesynchronized = 51,
      TokenNamethis = 36,
      TokenNamethrow = 90,
      TokenNamethrows = 127,
      TokenNametransient = 61,
      TokenNametrue = 41,
      TokenNametry = 91,
      TokenNamevoid = 120,
      TokenNamevolatile = 62,
      TokenNamewhile = 81,
      TokenNamemodule = 123,
      TokenNameopen = 124,
      TokenNamerequires = 128,
      TokenNametransitive = 134,
      TokenNameexports = 129,
      TokenNameopens = 130,
      TokenNameto = 142,
      TokenNameuses = 131,
      TokenNameprovides = 132,
      TokenNamewith = 96,
      TokenNameas = 135,
      TokenNamebase = 33,
      TokenNamecallin = 63,
      TokenNameplayedBy = 143,
      TokenNameprecedence = 125,
      TokenNamereadonly = 64,
      TokenNameteam = 53,
      TokenNametsuper = 38,
      TokenNamewhen = 97,
      TokenNamewithin = 92,
      TokenNamereplace = 136,
      TokenNameafter = 133,
      TokenNamebefore = 137,
      TokenNameget = 138,
      TokenNameset = 139,
      TokenNameIntegerLiteral = 42,
      TokenNameLongLiteral = 43,
      TokenNameFloatingPointLiteral = 44,
      TokenNameDoubleLiteral = 45,
      TokenNameCharacterLiteral = 46,
      TokenNameStringLiteral = 47,
      TokenNamePLUS_PLUS = 2,
      TokenNameMINUS_MINUS = 3,
      TokenNameEQUAL_EQUAL = 20,
      TokenNameLESS_EQUAL = 14,
      TokenNameGREATER_EQUAL = 15,
      TokenNameNOT_EQUAL = 21,
      TokenNameLEFT_SHIFT = 19,
      TokenNameRIGHT_SHIFT = 13,
      TokenNameUNSIGNED_RIGHT_SHIFT = 16,
      TokenNamePLUS_EQUAL = 98,
      TokenNameMINUS_EQUAL = 99,
      TokenNameMULTIPLY_EQUAL = 100,
      TokenNameDIVIDE_EQUAL = 101,
      TokenNameAND_EQUAL = 102,
      TokenNameOR_EQUAL = 103,
      TokenNameXOR_EQUAL = 104,
      TokenNameREMAINDER_EQUAL = 105,
      TokenNameLEFT_SHIFT_EQUAL = 106,
      TokenNameRIGHT_SHIFT_EQUAL = 107,
      TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 108,
      TokenNameOR_OR = 31,
      TokenNameAND_AND = 30,
      TokenNamePLUS = 4,
      TokenNameMINUS = 5,
      TokenNameNOT = 67,
      TokenNameREMAINDER = 10,
      TokenNameXOR = 26,
      TokenNameAND = 23,
      TokenNameMULTIPLY = 9,
      TokenNameOR = 28,
      TokenNameTWIDDLE = 68,
      TokenNameDIVIDE = 11,
      TokenNameGREATER = 12,
      TokenNameLESS = 8,
      TokenNameLPAREN = 22,
      TokenNameRPAREN = 24,
      TokenNameLBRACE = 52,
      TokenNameRBRACE = 34,
      TokenNameLBRACKET = 6,
      TokenNameRBRACKET = 70,
      TokenNameSEMICOLON = 25,
      TokenNameQUESTION = 29,
      TokenNameCOLON = 66,
      TokenNameCOMMA = 32,
      TokenNameDOT = 1,
      TokenNameEQUAL = 78,
      TokenNameAT = 48,
      TokenNameELLIPSIS = 140,
      TokenNameARROW = 76,
      TokenNameCOLON_COLON = 7,
      TokenNameBeginLambda = 49,
      TokenNameBeginIntersectionCast = 69,
      TokenNameBeginTypeArguments = 80,
      TokenNameElidedSemicolonAndRightBrace = 72,
      TokenNameAT308 = 27,
      TokenNameAT308DOTDOTDOT = 144,
      TokenNameATOT = 121,
      TokenNameBINDIN = 77,
      TokenNameCALLOUT_OVERRIDE = 93,
      TokenNameSYNTHBINDOUT = 73,
      TokenNameEOF = 65,
      TokenNameERROR = 147;


	// This alias is statically inserted by generateOTParser.sh:
	int TokenNameBINDOUT = TokenNameARROW;
}

