/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.ASMByteCodeAnalyzer;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBindingRegistry;
import org.eclipse.objectteams.internal.osgi.weaving.AspectPermissionManager;
import org.eclipse.objectteams.internal.osgi.weaving.BCELPatcher;
import org.eclipse.objectteams.internal.osgi.weaving.BaseBundleLoadTrigger;
import org.eclipse.objectteams.internal.osgi.weaving.DelegatingTransformer;
import org.eclipse.objectteams.internal.osgi.weaving.TeamLoader;
import org.eclipse.objectteams.internal.osgi.weaving.Util;
import org.eclipse.objectteams.internal.osgi.weaving.WaitingTeamRecord;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.eclipse.objectteams.runtime.IReweavingTask;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Wire;
import org.osgi.service.packageadmin.PackageAdmin;

public class OTWeavingHook
implements WeavingHook,
WovenClassListener {
    @NonNull
    static WeavingScheme DEFAULT_WEAVING_SCHEME;
    static final ThreadWeaving WEAVE_THREAD_NOTIFICATION;
    static final Map<String, Set<String>> KNOWN_LOGGING_CLASSES;
    boolean skipBaseClassCheck = "skip".equals(System.getProperty("otequinox.baseClassChecks"));
    private static final String LIFTING_PARTICIPANT_FIELD = "_OT$liftingParticipant";
    @NonNull
    private AspectBindingRegistry aspectBindingRegistry = new AspectBindingRegistry();
    @NonNull
    private HashMap<String, BaseBundleLoadTrigger> baseTripWires = new HashMap();
    @NonNull
    private Set<String> beingDefined = new HashSet<String>();
    @NonNull
    private Map<String, IReweavingTask> pendingReweavingTasks = new HashMap<String, IReweavingTask>();
    @NonNull
    private List<WaitingTeamRecord> deferredTeams = new ArrayList<WaitingTeamRecord>();
    @NonNull
    private ASMByteCodeAnalyzer byteCodeAnalyzer = new ASMByteCodeAnalyzer();
    private AspectPermissionManager permissionManager;
    @Nullable
    private IConfigurationElement liftingParticipantConfig;
    @Nullable
    private Class<?> ooTeam;

    static {
        String threadWeaving;
        DEFAULT_WEAVING_SCHEME = WeavingScheme.Unknown;
        KNOWN_LOGGING_CLASSES = new HashMap<String, Set<String>>();
        String weaving = System.getProperty("ot.weaving.force");
        if (weaving != null) {
            System.err.println("OT/Equinox: ot.weaving.force=" + weaving);
            if ("otdre".equalsIgnoreCase(weaving)) {
                DEFAULT_WEAVING_SCHEME = WeavingScheme.OTDRE;
            } else if ("otre".equalsIgnoreCase(weaving)) {
                DEFAULT_WEAVING_SCHEME = WeavingScheme.OTRE;
            }
        }
        WEAVE_THREAD_NOTIFICATION = "base".equalsIgnoreCase(threadWeaving = System.getProperty("otequinox.weave.thread")) ? ThreadWeaving.Base : ("false".equalsIgnoreCase(threadWeaving) ? ThreadWeaving.Never : ThreadWeaving.Always);
        KNOWN_LOGGING_CLASSES.put("org.eclipse.equinox.common", Collections.singleton("org.eclipse.core.runtime.ILogListener"));
        KNOWN_LOGGING_CLASSES.put("org.eclipse.ui.workbench", new HashSet<String>(Arrays.asList("org.eclipse.ui.statushandlers.StatusAdapter", "org.eclipse.ui.internal.misc.StatusUtil", "org.eclipse.ui.statushandlers.WorkbenchStatusDialogManager", "org.eclipse.ui.internal.statushandlers.StatusHandlerRegistry", "org.eclipse.ui.internal.statushandlers.StatusHandlerDescriptorsMap")));
        KNOWN_LOGGING_CLASSES.put("org.eclipse.ui.ide", Collections.singleton("org.eclipse.ui.internal.ide.IDEWorkbenchErrorHandler$1"));
    }

    public void activate(@NonNull BundleContext bundleContext, ServiceReference<IExtensionRegistry> serviceReference) {
        this.loadAspectBindingRegistry(bundleContext, serviceReference);
        TransformerPlugin.initialize(bundleContext, this.aspectBindingRegistry, this.permissionManager);
    }

    private void loadAspectBindingRegistry(BundleContext context, ServiceReference<IExtensionRegistry> serviceReference) {
        PackageAdmin packageAdmin = null;
        ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
        if (ref != null) {
            packageAdmin = (PackageAdmin)context.getService(ref);
        } else {
            TransformerPlugin.log(4, "Failed to load PackageAdmin service. Will not be able to handle fragments.");
        }
        IExtensionRegistry extensionRegistry = (IExtensionRegistry)context.getService(serviceReference);
        if (extensionRegistry == null) {
            TransformerPlugin.log(4, "Failed to acquire ExtensionRegistry service, cannot load aspect bindings.");
        } else {
            this.permissionManager = new AspectPermissionManager(context.getBundle(), packageAdmin);
            this.permissionManager.loadAspectBindingNegotiators(extensionRegistry);
            this.aspectBindingRegistry.loadAspectBindings(extensionRegistry, packageAdmin, this);
            this.loadLiftingParticipant(extensionRegistry);
        }
    }

    @NonNull
    public AspectPermissionManager getAspectPermissionManager() {
        AspectPermissionManager manager = this.permissionManager;
        if (manager == null) {
            throw new NullPointerException("Missing AspectPermissionManager");
        }
        return manager;
    }

    private void loadLiftingParticipant(IExtensionRegistry extensionRegistry) {
        IConfigurationElement[] liftingParticipantConfigs = extensionRegistry.getConfigurationElementsFor("org.eclipse.objectteams.otequinox", "liftingParticipant");
        if (liftingParticipantConfigs.length != 1) {
            if (liftingParticipantConfigs.length > 1) {
                TransformerPlugin.log(4, "Cannot install more than one lifting participant.");
            }
            return;
        }
        this.liftingParticipantConfig = liftingParticipantConfigs[0];
        this.installLiftingParticipant();
    }

    private void installLiftingParticipant() {
        Class<?> teamClass = this.ooTeam;
        IConfigurationElement config = this.liftingParticipantConfig;
        if (teamClass != null && config != null) {
            try {
                Field field = teamClass.getDeclaredField(LIFTING_PARTICIPANT_FIELD);
                field.set(null, config.createExecutableExtension("class"));
                TransformerPlugin.log(1, "Registered Lifting Participant from " + config.getContributor().getName());
            }
            catch (Exception e) {
                TransformerPlugin.log(e, "Failed to install lifting participant from " + config.getContributor().getName());
            }
            this.liftingParticipantConfig = null;
        }
    }

    void setBaseTripWire(@Nullable PackageAdmin packageAdmin, @NonNull String baseBundleId, AspectBinding.BaseBundle baseBundle) {
        if (!this.baseTripWires.containsKey(baseBundleId)) {
            this.baseTripWires.put(baseBundleId, new BaseBundleLoadTrigger(baseBundleId, baseBundle, this.aspectBindingRegistry, packageAdmin));
        }
    }

    boolean triggerBaseTripWires(@Nullable String bundleName, @NonNull WovenClass baseClass) {
        BaseBundleLoadTrigger activation = this.baseTripWires.get(bundleName);
        if (activation != null) {
            activation.fire(baseClass, this.beingDefined, this);
            if (activation.isDone()) {
                this.baseTripWires.remove(bundleName);
            }
            return activation.areAllAspectsDenied();
        }
        return false;
    }

    public void weave(WovenClass wovenClass) {
        block17: {
            this.beingDefined.add(wovenClass.getClassName());
            try {
                BundleWiring bundleWiring = wovenClass.getBundleWiring();
                String bundleName = bundleWiring.getBundle().getSymbolicName();
                String className = wovenClass.getClassName();
                if (bundleName.equals("org.eclipse.objectteams.otequinox") || bundleName.startsWith("org.eclipse.objectteams.otre") || bundleName.equals("org.objectweb.asm")) {
                    return;
                }
                if (this.isEclipseLoggingClass(bundleName, className)) {
                    return;
                }
                if (this.isClassWithJSR(className)) {
                    return;
                }
                if ("org.apache.bcel".equals(bundleName)) {
                    BCELPatcher.fixBCEL(wovenClass);
                    return;
                }
                byte[] bytes = wovenClass.getBytes();
                WeavingReason reason = this.requiresWeaving(bundleWiring, className, bytes, true);
                if (reason == WeavingReason.None) break block17;
                boolean allAspectsAreDenied = this.triggerBaseTripWires(bundleName, wovenClass);
                if (reason == WeavingReason.Base && allAspectsAreDenied) {
                    return;
                }
                if (reason == WeavingReason.Thread) {
                    if (DEFAULT_WEAVING_SCHEME == WeavingScheme.Unknown) {
                        TransformerPlugin.log(2, "Not performing thread weaving for " + className + " (weaving scheme not yet knonw)");
                        return;
                    }
                    AspectBinding.BaseBundle baseBundle = this.aspectBindingRegistry.getBaseBundle(bundleName);
                    BaseBundleLoadTrigger.addOTREImport(baseBundle, bundleName, wovenClass, DEFAULT_WEAVING_SCHEME == WeavingScheme.OTDRE);
                }
                long time = 0L;
                DelegatingTransformer transformer = DelegatingTransformer.newTransformer(DEFAULT_WEAVING_SCHEME, this, bundleWiring);
                Class<?> classBeingRedefined = null;
                try {
                    byte[] newBytes;
                    String displayName = (Object)((Object)reason) + " class " + className;
                    TransformerPlugin.log(0, "About to transform " + displayName);
                    time = 0L;
                    if (Util.PROFILE) {
                        time = System.nanoTime();
                    }
                    if ((newBytes = transformer.transform(bundleWiring.getBundle(), className, classBeingRedefined, null, bytes)) != null && newBytes != bytes && !Arrays.equals(newBytes, bytes)) {
                        if (Util.PROFILE) {
                            Util.profile(time, Util.ProfileKind.Transformation, className);
                        }
                        TransformerPlugin.log(1, "Transformation performed on " + displayName);
                        wovenClass.setBytes(newBytes);
                        if (reason == WeavingReason.Aspect) {
                            this.recordBaseClasses(transformer, bundleName, className);
                        }
                    } else if (Util.PROFILE) {
                        Util.profile(time, Util.ProfileKind.NoTransformation, className);
                    }
                }
                catch (IllegalClassFormatException e) {
                    TransformerPlugin.log(e, "Failed to transform class " + className);
                }
            }
            catch (ClassCircularityError cce) {
                TransformerPlugin.log(cce, "Weaver encountered a circular class dependency");
            }
        }
    }

    private boolean isClassWithJSR(String className) {
        return "org.apache.felix.gogo.runtime.Pipe".equals(className);
    }

    private boolean isEclipseLoggingClass(String bundleName, String className) {
        Set<String> knownClasses = KNOWN_LOGGING_CLASSES.get(bundleName);
        if (knownClasses != null) {
            return knownClasses.contains(className);
        }
        return bundleName.equals("org.eclipse.ui.views.log") ? className.startsWith("org.eclipse.ui.internal.views.log.LogView$") : bundleName.startsWith("org.eclipse.epp.logging.aeri");
    }

    WeavingReason requiresWeaving(BundleWiring bundleWiring, @NonNull String className, byte[] bytes, boolean considerSupers) {
        Bundle bundle = bundleWiring.getBundle();
        if (this.aspectBindingRegistry.getAdaptedBasePlugins(bundle) != null) {
            return WeavingReason.Aspect;
        }
        if (this.aspectBindingRegistry.isBoundBaseClass(className)) {
            return WeavingReason.Base;
        }
        boolean isBaseBundle = false;
        List<AspectBinding> aspectBindings = this.aspectBindingRegistry.getAdaptingAspectBindings(bundle.getSymbolicName());
        if (aspectBindings != null && !aspectBindings.isEmpty()) {
            isBaseBundle = true;
            if (bytes != null) {
                for (AspectBinding aspectBinding : aspectBindings) {
                    if (aspectBinding.hasScannedTeams || aspectBinding.hasBeenDenied) continue;
                    return WeavingReason.Base;
                }
            }
            if (this.isAdaptedBaseClass(aspectBindings, className, considerSupers, bytes, bundleWiring.getClassLoader())) {
                return WeavingReason.Base;
            }
        }
        long time = 0L;
        if (Util.PROFILE) {
            time = System.nanoTime();
        }
        if (this.needsThreadNotificationCode(className, bytes, bundleWiring.getClassLoader(), isBaseBundle)) {
            return WeavingReason.Thread;
        }
        if (Util.PROFILE) {
            Util.profile(time, Util.ProfileKind.SuperClassFetching, "");
        }
        return WeavingReason.None;
    }

    boolean scheduleReweaving(String className, IReweavingTask task) {
        if (this.beingDefined.contains(className)) {
            this.pendingReweavingTasks.put(className, task);
            return true;
        }
        return false;
    }

    boolean isAdaptedBaseClass(List<AspectBinding> aspectBindings, String className, boolean searchSupers, byte[] bytes, ClassLoader resourceLoader) {
        if (this.skipBaseClassCheck) {
            return true;
        }
        if ("java.lang.Object".equals(className)) {
            return false;
        }
        long start = 0L;
        if (Util.PROFILE) {
            start = System.nanoTime();
        }
        try {
            String superClassName;
            for (AspectBinding aspectBinding : aspectBindings) {
                if (!aspectBinding.allBaseClassNames.contains(className) || aspectBinding.hasBeenDenied) continue;
                return true;
            }
            ASMByteCodeAnalyzer.ClassInformation classInfo = null;
            if (bytes != null) {
                classInfo = this.byteCodeAnalyzer.getClassInformation(bytes, className);
            } else {
                try {
                    Object object = null;
                    Object var10_11 = null;
                    try (InputStream is = resourceLoader.getResourceAsStream(String.valueOf(className.replace('.', '/')) + ".class");){
                        if (is != null) {
                            classInfo = this.byteCodeAnalyzer.getClassInformation(is, className);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException e) {
                    if (bytes != null && Util.PROFILE) {
                        Util.profile(start, Util.ProfileKind.SuperClassFetching, className);
                    }
                    return false;
                }
            }
            if (searchSupers && classInfo != null && !classInfo.isInterface() && (superClassName = classInfo.getSuperClassName()) != null) {
                boolean bl = this.isAdaptedBaseClass(aspectBindings, superClassName, searchSupers, null, resourceLoader);
                return bl;
            }
            return false;
        }
        finally {
            if (bytes != null && Util.PROFILE) {
                Util.profile(start, Util.ProfileKind.SuperClassFetching, className);
            }
        }
    }

    private void recordBaseClasses(DelegatingTransformer transformer, @NonNull String aspectBundle, String className) {
        Collection<String> adaptedBases = transformer.fetchAdaptedBases();
        if (adaptedBases == null || adaptedBases.isEmpty()) {
            return;
        }
        this.aspectBindingRegistry.addBoundBaseClasses(adaptedBases);
        List<AspectBinding> aspectBindings = this.aspectBindingRegistry.getAspectBindings(aspectBundle);
        if (aspectBindings != null) {
            for (AspectBinding aspectBinding : aspectBindings) {
                if (aspectBinding.hasScannedTeams) continue;
                AspectBinding.TeamBinding[] teamBindingArray = aspectBinding.teams;
                int n = aspectBinding.teams.length;
                int n2 = 0;
                while (n2 < n) {
                    AspectBinding.TeamBinding team = teamBindingArray[n2];
                    if (team.teamName.equals(className) && !team.hasScannedBases) {
                        for (AspectBinding.TeamBinding equivalent : team.equivalenceSet) {
                            equivalent.addBaseClassNames(adaptedBases);
                            equivalent.hasScannedBases = true;
                        }
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeferredTeamClasses(List<WaitingTeamRecord> teamClasses) {
        List<WaitingTeamRecord> list = this.deferredTeams;
        synchronized (list) {
            this.deferredTeams.addAll(teamClasses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiateScheduledTeams(String triggerClassName) {
        ArrayList<WaitingTeamRecord> scheduledTeams = null;
        List<WaitingTeamRecord> list = this.deferredTeams;
        synchronized (list) {
            for (WaitingTeamRecord record : new ArrayList<WaitingTeamRecord>(this.deferredTeams)) {
                if (!record.notFoundClass.equals(triggerClassName)) continue;
                if (scheduledTeams == null) {
                    scheduledTeams = new ArrayList<WaitingTeamRecord>();
                }
                if (!this.deferredTeams.remove(record)) continue;
                scheduledTeams.add(record);
            }
        }
        if (scheduledTeams == null) {
            return;
        }
        for (WaitingTeamRecord record : scheduledTeams) {
            if (record.team.isActivated) continue;
            String teamName = record.team.teamName;
            TransformerPlugin.log(1, "Consider for instantiation/activation: team " + teamName);
            try {
                TeamLoader loader = new TeamLoader(this.deferredTeams, this.beingDefined, DEFAULT_WEAVING_SCHEME == WeavingScheme.OTDRE);
                loader.instantiateAndActivate(record.aspectBinding, record.team, record.activationKind);
            }
            catch (Exception e) {
                TransformerPlugin.log(e, "Failed to instantiate team " + teamName);
            }
        }
    }

    public void modified(WovenClass wovenClass) {
        if (wovenClass.getState() == 4) {
            String className = wovenClass.getClassName();
            if (className.equals("org.objectteams.Team")) {
                this.ooTeam = wovenClass.getDefinedClass();
                this.installLiftingParticipant();
            }
            this.beingDefined.remove(className);
            IReweavingTask task = this.pendingReweavingTasks.remove(className);
            if (task != null) {
                try {
                    task.reweave(wovenClass.getDefinedClass());
                }
                catch (IllegalClassFormatException e) {
                    TransformerPlugin.log(e, "Failed to reweave class " + wovenClass.getClassName());
                    TransformerPlugin.flushLog();
                    return;
                }
            }
            this.instantiateScheduledTeams(className);
            TransformerPlugin.flushLog();
        }
    }

    static boolean hasImport(WovenClass clazz, String packageName, String packageWithAttribute) {
        List imports = clazz.getDynamicImports();
        for (String imp : imports) {
            if (!imp.equals(packageName) && !imp.equals(packageWithAttribute)) continue;
            return true;
        }
        for (Wire wire : clazz.getBundleWiring().getRequiredResourceWires("osgi.wiring.package")) {
            Object packageValue = wire.getRequirement().getAttributes().get("osgi.wiring.package");
            if (!packageName.equals(packageValue) && !packageWithAttribute.equals(packageValue)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean needsThreadNotificationCode(String className, byte[] bytes, ClassLoader resourceLoader, boolean isBaseBundle) {
        if ("java.lang.Object".equals(className)) {
            return false;
        }
        switch (WEAVE_THREAD_NOTIFICATION) {
            case Never: {
                return false;
            }
            case Base: {
                if (isBaseBundle) return false;
                return false;
            }
        }
        ASMByteCodeAnalyzer.ClassInformation classInfo = null;
        if (bytes != null) {
            classInfo = this.byteCodeAnalyzer.getClassInformation(bytes, className);
        } else {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream is = resourceLoader.getResourceAsStream(String.valueOf(className.replace('.', '/')) + ".class");){
                    if (is != null) {
                        classInfo = this.byteCodeAnalyzer.getClassInformation(is, className);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        if (classInfo == null) return false;
        if (classInfo.isInterface()) return false;
        String superClassName = classInfo.getSuperClassName();
        if ("java.lang.Thread".equals(superClassName)) {
            return true;
        }
        String[] superInterfaceNames = classInfo.getSuperInterfaceNames();
        if (superInterfaceNames == null) return false;
        int i = 0;
        while (i < superInterfaceNames.length) {
            if ("java.lang.Runnable".equals(superInterfaceNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static enum ThreadWeaving {
        Never,
        Base,
        Always;

    }

    static enum WeavingReason {
        None,
        Aspect,
        Base,
        Thread;

    }

    static enum WeavingScheme {
        Unknown,
        OTRE,
        OTDRE;

    }
}

