/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.AdditionalTypeCollection;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathJrtWithReleaseOption;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.jdt.internal.core.util.Util;

public class State {
    String javaProjectName;
    public ClasspathMultiDirectory[] sourceLocations;
    public ClasspathMultiDirectory[] testSourceLocations;
    ClasspathLocation[] binaryLocations;
    ClasspathLocation[] testBinaryLocations;
    Map<String, ReferenceCollection> references;
    public Map<String, String> typeLocators;
    int buildNumber;
    long lastStructuralBuildTime;
    SimpleLookupTable structuralBuildTimes;
    private String[] knownPackageNames;
    private long previousStructuralBuildTime;
    private StringSet structurallyChangedTypes;
    public static int MaxStructurallyChangedTypes = 100;
    public static final byte VERSION = 34;
    static final byte SOURCE_FOLDER = 1;
    static final byte BINARY_FOLDER = 2;
    static final byte EXTERNAL_JAR = 3;
    static final byte INTERNAL_JAR = 4;

    State() {
    }

    protected State(JavaBuilder javaBuilder) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = -1L;
        this.structurallyChangedTypes = null;
        this.javaProjectName = javaBuilder.currentProject.getName();
        this.sourceLocations = javaBuilder.nameEnvironment.sourceLocations;
        this.binaryLocations = javaBuilder.nameEnvironment.binaryLocations;
        this.testSourceLocations = javaBuilder.testNameEnvironment.sourceLocations;
        this.testBinaryLocations = javaBuilder.testNameEnvironment.binaryLocations;
        this.references = new LinkedHashMap<String, ReferenceCollection>(7);
        this.typeLocators = new LinkedHashMap<String, String>(7);
        this.buildNumber = 0;
        this.lastStructuralBuildTime = this.computeStructuralBuildTime(javaBuilder.lastState == null ? 0L : javaBuilder.lastState.lastStructuralBuildTime);
        this.structuralBuildTimes = new SimpleLookupTable(3);
    }

    long computeStructuralBuildTime(long previousTime) {
        long newTime = System.currentTimeMillis();
        if (newTime <= previousTime) {
            newTime = previousTime + 1L;
        }
        return newTime;
    }

    void copyFrom(State lastState) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = lastState.previousStructuralBuildTime;
        this.structurallyChangedTypes = lastState.structurallyChangedTypes;
        this.buildNumber = lastState.buildNumber + 1;
        this.lastStructuralBuildTime = lastState.lastStructuralBuildTime;
        this.structuralBuildTimes = lastState.structuralBuildTimes;
        this.references = new LinkedHashMap<String, ReferenceCollection>(lastState.references);
        this.typeLocators = new LinkedHashMap<String, String>(lastState.typeLocators);
    }

    public char[][] getDefinedTypeNamesFor(String typeLocator) {
        ReferenceCollection c = this.references.get(typeLocator);
        if (c instanceof AdditionalTypeCollection) {
            return ((AdditionalTypeCollection)c).definedTypeNames;
        }
        return null;
    }

    public Map<String, ReferenceCollection> getReferences() {
        return this.references;
    }

    StringSet getStructurallyChangedTypes(State prereqState) {
        if (prereqState != null && prereqState.previousStructuralBuildTime > 0L) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqState.javaProjectName);
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.previousStructuralBuildTime) {
                return prereqState.structurallyChangedTypes;
            }
        }
        return null;
    }

    public boolean isDuplicateLocator(String qualifiedTypeName, String typeLocator) {
        String existing = this.typeLocators.get(qualifiedTypeName);
        return existing != null && !existing.equals(typeLocator);
    }

    public boolean isKnownPackage(String qualifiedPackageName) {
        int result;
        if (this.knownPackageNames == null) {
            LinkedHashSet<String> names = new LinkedHashSet<String>(this.typeLocators.size());
            Set<Map.Entry<String, String>> keyTable = this.typeLocators.entrySet();
            for (Map.Entry<String, String> entry : keyTable) {
                String packageName = entry.getKey();
                int last = packageName.lastIndexOf(47);
                packageName = last == -1 ? null : packageName.substring(0, last);
                while (packageName != null && !names.contains(packageName)) {
                    names.add(packageName);
                    last = packageName.lastIndexOf(47);
                    String string = packageName = last == -1 ? null : packageName.substring(0, last);
                }
            }
            this.knownPackageNames = new String[names.size()];
            names.toArray(this.knownPackageNames);
            Arrays.sort(this.knownPackageNames);
        }
        return (result = Arrays.binarySearch(this.knownPackageNames, qualifiedPackageName)) >= 0;
    }

    public boolean isKnownType(String qualifiedTypeName) {
        return this.typeLocators.containsKey(qualifiedTypeName);
    }

    boolean isSourceFolderEmpty(IContainer sourceFolder) {
        String sourceFolderName = sourceFolder.getProjectRelativePath().addTrailingSeparator().toString();
        for (String value : this.typeLocators.values()) {
            if (!value.startsWith(sourceFolderName)) continue;
            return false;
        }
        return true;
    }

    void record(String typeLocator, char[][][] qualifiedRefs, char[][] simpleRefs, char[][] rootRefs, char[] mainTypeName, ArrayList typeNames) {
        if (typeNames.size() == 1 && CharOperation.equals(mainTypeName, (char[])typeNames.get(0))) {
            this.references.put(typeLocator, new ReferenceCollection(qualifiedRefs, simpleRefs, rootRefs));
        } else {
            char[][] definedTypeNames = new char[typeNames.size()][];
            typeNames.toArray((T[])definedTypeNames);
            this.references.put(typeLocator, new AdditionalTypeCollection(definedTypeNames, qualifiedRefs, simpleRefs, rootRefs));
        }
    }

    void recordLocatorForType(String qualifiedTypeName, String typeLocator) {
        this.knownPackageNames = null;
        int start = typeLocator.indexOf(qualifiedTypeName, 0);
        if (start > 0) {
            qualifiedTypeName = typeLocator.substring(start, start + qualifiedTypeName.length());
        }
        this.typeLocators.put(qualifiedTypeName, typeLocator);
    }

    void recordStructuralDependency(IProject prereqProject, State prereqState) {
        if (prereqState != null && prereqState.lastStructuralBuildTime > 0L) {
            this.structuralBuildTimes.put(prereqProject.getName(), prereqState.lastStructuralBuildTime);
        }
    }

    void removeLocator(String typeLocatorToRemove) {
        this.knownPackageNames = null;
        this.references.remove(typeLocatorToRemove);
        this.typeLocators.values().removeIf(v -> typeLocatorToRemove.equals(v));
    }

    void removePackage(IResourceDelta sourceDelta) {
        IResource resource = sourceDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                IResourceDelta[] children = sourceDelta.getAffectedChildren();
                int i = 0;
                int l = children.length;
                while (i < l) {
                    this.removePackage(children[i]);
                    ++i;
                }
                return;
            }
            case 1: {
                IPath typeLocatorPath = resource.getProjectRelativePath();
                if (!Util.isJavaLikeFileName(typeLocatorPath.lastSegment())) break;
                this.removeLocator(typeLocatorPath.toString());
            }
        }
    }

    void removeQualifiedTypeName(String qualifiedTypeNameToRemove) {
        this.knownPackageNames = null;
        this.typeLocators.remove(qualifiedTypeNameToRemove);
    }

    static State read(IProject project, DataInputStream in) throws IOException, CoreException {
        String jarPath;
        IProject outputFolder;
        Path path;
        if (JavaBuilder.DEBUG) {
            System.out.println("About to read state " + project.getName());
        }
        if (34 != in.readByte()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Found non-compatible state version... answered null for " + project.getName());
            }
            return null;
        }
        State newState = new State();
        newState.javaProjectName = in.readUTF();
        if (!project.getName().equals(newState.javaProjectName)) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Project's name does not match... answered null");
            }
            return null;
        }
        newState.buildNumber = in.readInt();
        newState.lastStructuralBuildTime = in.readLong();
        int length = in.readInt();
        newState.sourceLocations = new ClasspathMultiDirectory[length];
        int i = 0;
        while (i < length) {
            IProject sourceFolder = project;
            IProject outputFolder2 = project;
            String folderName = in.readUTF();
            if (folderName.length() > 0) {
                sourceFolder = project.getFolder(folderName);
            }
            if ((folderName = in.readUTF()).length() > 0) {
                outputFolder2 = project.getFolder(folderName);
            }
            ClasspathMultiDirectory md = (ClasspathMultiDirectory)ClasspathLocation.forSourceFolder((IContainer)sourceFolder, (IContainer)outputFolder2, State.readNames(in), State.readNames(in), in.readBoolean());
            if (in.readBoolean()) {
                md.hasIndependentOutputFolder = true;
            }
            newState.sourceLocations[i] = md;
            ++i;
        }
        length = in.readInt();
        newState.binaryLocations = new ClasspathLocation[length];
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        int i2 = 0;
        while (i2 < length) {
            switch (in.readByte()) {
                case 1: {
                    newState.binaryLocations[i2] = newState.sourceLocations[in.readInt()];
                    break;
                }
                case 2: {
                    path = new Path(in.readUTF());
                    outputFolder = path.segmentCount() == 1 ? root.getProject(path.toString()) : root.getFolder((IPath)path);
                    newState.binaryLocations[i2] = ClasspathLocation.forBinaryFolder((IContainer)outputFolder, in.readBoolean(), State.readRestriction(in), (IPath)new Path(in.readUTF()), in.readBoolean());
                    break;
                }
                case 3: {
                    jarPath = in.readUTF();
                    if (org.eclipse.jdt.internal.compiler.util.Util.isJrt(jarPath)) {
                        newState.binaryLocations[i2] = ClasspathLocation.forJrtSystem(jarPath, State.readRestriction(in), (IPath)new Path(in.readUTF()), in.readUTF());
                        break;
                    }
                    newState.binaryLocations[i2] = ClasspathLocation.forLibrary(jarPath, in.readLong(), State.readRestriction(in), (IPath)new Path(in.readUTF()), in.readBoolean(), in.readUTF());
                    break;
                }
                case 4: {
                    newState.binaryLocations[i2] = ClasspathLocation.forLibrary(root.getFile((IPath)new Path(in.readUTF())), State.readRestriction(in), (IPath)new Path(in.readUTF()), in.readBoolean(), in.readUTF());
                }
            }
            ClasspathLocation loc = newState.binaryLocations[i2];
            char[] patchName = State.readName(in);
            loc.patchModuleName = patchName.length > 0 ? new String(patchName) : null;
            int limitSize = in.readInt();
            if (limitSize != 0) {
                loc.limitModuleNames = new LinkedHashSet<String>(limitSize);
                int j = 0;
                while (j < limitSize) {
                    loc.limitModuleNames.add(in.readUTF());
                    ++j;
                }
            } else {
                loc.limitModuleNames = null;
            }
            IUpdatableModule.UpdatesByKind updates = new IUpdatableModule.UpdatesByKind();
            List<Consumer<IUpdatableModule>> packageUpdates = null;
            int packageUpdatesSize = in.readInt();
            if (packageUpdatesSize != 0) {
                packageUpdates = updates.getList(IUpdatableModule.UpdateKind.PACKAGE, true);
                int j = 0;
                while (j < packageUpdatesSize) {
                    char[] pkgName = State.readName(in);
                    char[][] targets = State.readNames(in);
                    packageUpdates.add(new IUpdatableModule.AddExports(pkgName, targets));
                    ++j;
                }
            }
            List<Consumer<IUpdatableModule>> moduleUpdates = null;
            int moduleUpdatesSize = in.readInt();
            if (moduleUpdatesSize != 0) {
                moduleUpdates = updates.getList(IUpdatableModule.UpdateKind.MODULE, true);
                char[] modName = State.readName(in);
                moduleUpdates.add(new IUpdatableModule.AddReads(modName));
            }
            if (packageUpdates != null || moduleUpdates != null) {
                loc.updates = updates;
            }
            ++i2;
        }
        length = in.readInt();
        newState.testSourceLocations = new ClasspathMultiDirectory[length];
        i2 = 0;
        while (i2 < length) {
            IProject sourceFolder = project;
            outputFolder = project;
            String folderName = in.readUTF();
            if (folderName.length() > 0) {
                sourceFolder = project.getFolder(folderName);
            }
            if ((folderName = in.readUTF()).length() > 0) {
                outputFolder = project.getFolder(folderName);
            }
            ClasspathMultiDirectory md = (ClasspathMultiDirectory)ClasspathLocation.forSourceFolder((IContainer)sourceFolder, (IContainer)outputFolder, State.readNames(in), State.readNames(in), in.readBoolean());
            if (in.readBoolean()) {
                md.hasIndependentOutputFolder = true;
            }
            newState.testSourceLocations[i2] = md;
            ++i2;
        }
        length = in.readInt();
        newState.testBinaryLocations = new ClasspathLocation[length];
        i2 = 0;
        while (i2 < length) {
            switch (in.readByte()) {
                case 1: {
                    newState.testBinaryLocations[i2] = newState.testSourceLocations[in.readInt()];
                    break;
                }
                case 2: {
                    path = new Path(in.readUTF());
                    outputFolder = path.segmentCount() == 1 ? root.getProject(path.toString()) : root.getFolder((IPath)path);
                    newState.testBinaryLocations[i2] = ClasspathLocation.forBinaryFolder((IContainer)outputFolder, in.readBoolean(), State.readRestriction(in), (IPath)new Path(in.readUTF()), in.readBoolean());
                    break;
                }
                case 3: {
                    jarPath = in.readUTF();
                    if (org.eclipse.jdt.internal.compiler.util.Util.isJrt(jarPath)) {
                        newState.testBinaryLocations[i2] = ClasspathLocation.forJrtSystem(jarPath, State.readRestriction(in), (IPath)new Path(in.readUTF()), in.readUTF());
                        break;
                    }
                    newState.testBinaryLocations[i2] = ClasspathLocation.forLibrary(jarPath, in.readLong(), State.readRestriction(in), (IPath)new Path(in.readUTF()), in.readBoolean(), in.readUTF());
                    break;
                }
                case 4: {
                    newState.testBinaryLocations[i2] = ClasspathLocation.forLibrary(root.getFile((IPath)new Path(in.readUTF())), State.readRestriction(in), (IPath)new Path(in.readUTF()), in.readBoolean(), in.readUTF());
                }
            }
            ++i2;
        }
        length = in.readInt();
        newState.structuralBuildTimes = new SimpleLookupTable(length);
        i2 = 0;
        while (i2 < length) {
            newState.structuralBuildTimes.put(in.readUTF(), in.readLong());
            ++i2;
        }
        length = in.readInt();
        String[] internedTypeLocators = new String[length];
        int i3 = 0;
        while (i3 < length) {
            internedTypeLocators[i3] = in.readUTF();
            ++i3;
        }
        length = in.readInt();
        newState.typeLocators = new LinkedHashMap<String, String>((int)((double)length / 0.75 + 1.0));
        i3 = 0;
        while (i3 < length) {
            newState.recordLocatorForType(in.readUTF(), internedTypeLocators[in.readInt()]);
            ++i3;
        }
        char[][] internedRootNames = ReferenceCollection.internSimpleNames(State.readNames(in), false, false);
        char[][] internedSimpleNames = ReferenceCollection.internSimpleNames(State.readNames(in), false, false);
        length = in.readInt();
        Object internedQualifiedNames = new char[length][][];
        int i4 = 0;
        while (i4 < length) {
            int qLength = in.readInt();
            char[][] qName = new char[qLength][];
            int j = 0;
            while (j < qLength) {
                qName[j] = internedSimpleNames[in.readInt()];
                ++j;
            }
            internedQualifiedNames[i4] = qName;
            ++i4;
        }
        internedQualifiedNames = ReferenceCollection.internQualifiedNames(internedQualifiedNames, false, false);
        length = in.readInt();
        newState.references = new LinkedHashMap<String, ReferenceCollection>((int)((double)length / 0.75 + 1.0));
        i4 = 0;
        while (i4 < length) {
            String typeLocator = internedTypeLocators[in.readInt()];
            ReferenceCollection collection = null;
            switch (in.readByte()) {
                case 1: {
                    char[][] additionalTypeNames = State.readNames(in);
                    char[][][] qualifiedNames = new char[in.readInt()][][];
                    int j = 0;
                    int m = qualifiedNames.length;
                    while (j < m) {
                        qualifiedNames[j] = internedQualifiedNames[in.readInt()];
                        ++j;
                    }
                    char[][] simpleNames = new char[in.readInt()][];
                    int j2 = 0;
                    int m2 = simpleNames.length;
                    while (j2 < m2) {
                        simpleNames[j2] = internedSimpleNames[in.readInt()];
                        ++j2;
                    }
                    char[][] rootNames = new char[in.readInt()][];
                    int j3 = 0;
                    int m3 = rootNames.length;
                    while (j3 < m3) {
                        rootNames[j3] = internedRootNames[in.readInt()];
                        ++j3;
                    }
                    collection = new AdditionalTypeCollection(additionalTypeNames, qualifiedNames, simpleNames, rootNames);
                    break;
                }
                case 2: {
                    char[][][] qNames = new char[in.readInt()][][];
                    int j = 0;
                    int m = qNames.length;
                    while (j < m) {
                        qNames[j] = internedQualifiedNames[in.readInt()];
                        ++j;
                    }
                    char[][] sNames = new char[in.readInt()][];
                    int j4 = 0;
                    int m4 = sNames.length;
                    while (j4 < m4) {
                        sNames[j4] = internedSimpleNames[in.readInt()];
                        ++j4;
                    }
                    char[][] rNames = new char[in.readInt()][];
                    int j5 = 0;
                    int m5 = rNames.length;
                    while (j5 < m5) {
                        rNames[j5] = internedRootNames[in.readInt()];
                        ++j5;
                    }
                    collection = new ReferenceCollection(qNames, sNames, rNames);
                }
            }
            newState.references.put(typeLocator, collection);
            ++i4;
        }
        if (JavaBuilder.DEBUG) {
            System.out.println("Successfully read state for " + newState.javaProjectName);
        }
        return newState;
    }

    private static char[] readName(DataInputStream in) throws IOException {
        int nLength = in.readInt();
        char[] name = new char[nLength];
        int j = 0;
        while (j < nLength) {
            name[j] = in.readChar();
            ++j;
        }
        return name;
    }

    private static char[][] readNames(DataInputStream in) throws IOException {
        int length = in.readInt();
        char[][] names = new char[length][];
        int i = 0;
        while (i < length) {
            names[i] = State.readName(in);
            ++i;
        }
        return names;
    }

    private static AccessRuleSet readRestriction(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length == 0) {
            return null;
        }
        AccessRule[] accessRules = new AccessRule[length];
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        while (i < length) {
            char[] pattern = State.readName(in);
            int problemId = in.readInt();
            accessRules[i] = manager.getAccessRuleForProblemId(pattern, problemId);
            ++i;
        }
        return new AccessRuleSet(accessRules, in.readByte(), manager.intern(in.readUTF()));
    }

    void tagAsNoopBuild() {
        this.buildNumber = -1;
    }

    boolean wasNoopBuild() {
        return this.buildNumber == -1;
    }

    void tagAsStructurallyChanged() {
        this.previousStructuralBuildTime = this.lastStructuralBuildTime;
        this.structurallyChangedTypes = new StringSet(7);
        this.lastStructuralBuildTime = this.computeStructuralBuildTime(this.previousStructuralBuildTime);
    }

    boolean wasStructurallyChanged(IProject prereqProject, State prereqState) {
        if (prereqState != null) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqProject.getName());
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.lastStructuralBuildTime) {
                return false;
            }
        }
        return true;
    }

    void wasStructurallyChanged(String typeName) {
        if (this.structurallyChangedTypes != null) {
            if (this.structurallyChangedTypes.elementSize > MaxStructurallyChangedTypes) {
                this.structurallyChangedTypes = null;
            } else {
                this.structurallyChangedTypes.add(typeName);
            }
        }
    }

    void write(DataOutputStream out) throws IOException {
        ClasspathLocation c;
        ClasspathMultiDirectory md;
        out.writeByte(34);
        out.writeUTF(this.javaProjectName);
        out.writeInt(this.buildNumber);
        out.writeLong(this.lastStructuralBuildTime);
        int length = this.sourceLocations.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            md = this.sourceLocations[i];
            out.writeUTF(md.sourceFolder.getProjectRelativePath().toString());
            out.writeUTF(md.binaryFolder.getProjectRelativePath().toString());
            this.writeNames(md.inclusionPatterns, out);
            this.writeNames(md.exclusionPatterns, out);
            out.writeBoolean(md.ignoreOptionalProblems);
            out.writeBoolean(md.hasIndependentOutputFolder);
            ++i;
        }
        length = this.binaryLocations.length;
        out.writeInt(length);
        i = 0;
        while (i < length) {
            c = this.binaryLocations[i];
            if (c instanceof ClasspathMultiDirectory) {
                out.writeByte(1);
                int j = 0;
                int m = this.sourceLocations.length;
                while (j < m) {
                    if (this.sourceLocations[j] == c) {
                        out.writeInt(j);
                    }
                    ++j;
                }
            } else if (c instanceof ClasspathDirectory) {
                out.writeByte(2);
                ClasspathDirectory cd = (ClasspathDirectory)c;
                out.writeUTF(cd.binaryFolder.getFullPath().toString());
                out.writeBoolean(cd.isOutputFolder);
                this.writeRestriction(cd.accessRuleSet, out);
                out.writeUTF(cd.externalAnnotationPath != null ? cd.externalAnnotationPath : "");
                out.writeBoolean(cd.isOnModulePath);
            } else if (c instanceof ClasspathJar) {
                ClasspathJar jar = (ClasspathJar)c;
                if (jar.resource == null) {
                    out.writeByte(3);
                    out.writeUTF(jar.zipFilename);
                    out.writeLong(jar.lastModified());
                } else {
                    out.writeByte(4);
                    out.writeUTF(jar.resource.getFullPath().toString());
                }
                this.writeRestriction(jar.accessRuleSet, out);
                out.writeUTF(jar.externalAnnotationPath != null ? jar.externalAnnotationPath : "");
                out.writeBoolean(jar.isOnModulePath);
                out.writeUTF(jar.compliance == null ? "" : jar.compliance);
            } else if (c instanceof ClasspathJrt) {
                ClasspathJrt jrt = (ClasspathJrt)c;
                out.writeByte(3);
                out.writeUTF(jrt.zipFilename);
                this.writeRestriction(jrt.accessRuleSet, out);
                out.writeUTF(jrt.externalAnnotationPath != null ? jrt.externalAnnotationPath : "");
                if (jrt instanceof ClasspathJrtWithReleaseOption) {
                    out.writeUTF(((ClasspathJrtWithReleaseOption)jrt).release);
                } else {
                    out.writeUTF("");
                }
            }
            char[] patchName = c.patchModuleName == null ? CharOperation.NO_CHAR : c.patchModuleName.toCharArray();
            this.writeName(patchName, out);
            if (c.limitModuleNames != null) {
                out.writeInt(c.limitModuleNames.size());
                for (String name : c.limitModuleNames) {
                    out.writeUTF(name);
                }
            } else {
                out.writeInt(0);
            }
            if (c.updates != null) {
                List<Consumer<IUpdatableModule>> pu = c.updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
                if (pu != null) {
                    Map<String, List<Consumer>> map = pu.stream().collect(Collectors.groupingBy(update -> CharOperation.charToString(((IUpdatableModule.AddExports)update).getName())));
                    out.writeInt(map.size());
                    map.entrySet().stream().forEach(entry -> {
                        String pkgName = (String)entry.getKey();
                        try {
                            this.writeName(pkgName.toCharArray(), out);
                            char[][] targetModules = ((List)entry.getValue()).stream().map(consumer -> ((IUpdatableModule.AddExports)consumer).getTargetModules()).filter(targets -> targets != null).reduce((f, s) -> CharOperation.arrayConcat(f, s)).orElse(null);
                            this.writeNames(targetModules, out);
                        }
                        catch (IOException iOException) {}
                    });
                } else {
                    out.writeInt(0);
                }
                List<Consumer<IUpdatableModule>> mu = c.updates.getList(IUpdatableModule.UpdateKind.MODULE, false);
                if (mu != null) {
                    out.writeInt(mu.size());
                    for (Consumer<IUpdatableModule> cons : mu) {
                        IUpdatableModule.AddReads m = (IUpdatableModule.AddReads)cons;
                        this.writeName(m.getTarget(), out);
                    }
                } else {
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
                out.writeInt(0);
            }
            ++i;
        }
        length = this.testSourceLocations.length;
        out.writeInt(length);
        i = 0;
        while (i < length) {
            md = this.testSourceLocations[i];
            out.writeUTF(md.sourceFolder.getProjectRelativePath().toString());
            out.writeUTF(md.binaryFolder.getProjectRelativePath().toString());
            this.writeNames(md.inclusionPatterns, out);
            this.writeNames(md.exclusionPatterns, out);
            out.writeBoolean(md.ignoreOptionalProblems);
            out.writeBoolean(md.hasIndependentOutputFolder);
            ++i;
        }
        length = this.testBinaryLocations.length;
        out.writeInt(length);
        i = 0;
        while (i < length) {
            c = this.testBinaryLocations[i];
            if (c instanceof ClasspathMultiDirectory) {
                out.writeByte(1);
                int j = 0;
                int m = this.testSourceLocations.length;
                while (j < m) {
                    if (this.testSourceLocations[j] == c) {
                        out.writeInt(j);
                        break;
                    }
                    ++j;
                }
            } else if (c instanceof ClasspathDirectory) {
                out.writeByte(2);
                ClasspathDirectory cd = (ClasspathDirectory)c;
                out.writeUTF(cd.binaryFolder.getFullPath().toString());
                out.writeBoolean(cd.isOutputFolder);
                this.writeRestriction(cd.accessRuleSet, out);
                out.writeUTF(cd.externalAnnotationPath != null ? cd.externalAnnotationPath : "");
                out.writeBoolean(cd.isOnModulePath);
            } else if (c instanceof ClasspathJar) {
                ClasspathJar jar = (ClasspathJar)c;
                if (jar.resource == null) {
                    out.writeByte(3);
                    out.writeUTF(jar.zipFilename);
                    out.writeLong(jar.lastModified());
                } else {
                    out.writeByte(4);
                    out.writeUTF(jar.resource.getFullPath().toString());
                }
                this.writeRestriction(jar.accessRuleSet, out);
                out.writeUTF(jar.externalAnnotationPath != null ? jar.externalAnnotationPath : "");
                out.writeBoolean(jar.isOnModulePath);
                out.writeUTF(jar.compliance != null ? jar.compliance : "");
            } else if (c instanceof ClasspathJrt) {
                ClasspathJrt jrt = (ClasspathJrt)c;
                out.writeByte(3);
                out.writeUTF(jrt.zipFilename);
                this.writeRestriction(jrt.accessRuleSet, out);
                out.writeUTF(jrt.externalAnnotationPath != null ? jrt.externalAnnotationPath : "");
                if (jrt instanceof ClasspathJrtWithReleaseOption) {
                    out.writeUTF(((ClasspathJrtWithReleaseOption)jrt).release);
                } else {
                    out.writeUTF("");
                }
            }
            ++i;
        }
        length = this.structuralBuildTimes.elementSize;
        out.writeInt(length);
        if (length > 0) {
            Object[] keyTable = this.structuralBuildTimes.keyTable;
            Object[] valueTable = this.structuralBuildTimes.valueTable;
            i = 0;
            int l = keyTable.length;
            while (i < l) {
                if (keyTable[i] != null) {
                    --length;
                    out.writeUTF((String)keyTable[i]);
                    out.writeLong((Long)valueTable[i]);
                }
                ++i;
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("structuralBuildNumbers table is inconsistent");
            }
        }
        length = this.references.size();
        out.writeInt(length);
        SimpleLookupTable internedTypeLocators = new SimpleLookupTable(length);
        if (length > 0) {
            Set<String> keys = this.references.keySet();
            for (String key : keys) {
                if (key == null) continue;
                --length;
                out.writeUTF(key);
                internedTypeLocators.put(key, internedTypeLocators.elementSize);
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("references table is inconsistent");
            }
        }
        length = this.typeLocators.size();
        out.writeInt(length);
        if (length > 0) {
            Set<Map.Entry<String, String>> entries = this.typeLocators.entrySet();
            for (Map.Entry<String, String> entry2 : entries) {
                String key = entry2.getKey();
                String value = entry2.getValue();
                if (key == null) continue;
                --length;
                out.writeUTF(key);
                Integer index = (Integer)internedTypeLocators.get(value);
                out.writeInt(index);
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("typeLocators table is inconsistent");
            }
        }
        SimpleLookupTable internedRootNames = new SimpleLookupTable(3);
        SimpleLookupTable internedQualifiedNames = new SimpleLookupTable(31);
        SimpleLookupTable internedSimpleNames = new SimpleLookupTable(31);
        for (ReferenceCollection collection : this.references.values()) {
            char[][] rNames = collection.rootReferences;
            int j = 0;
            int m = rNames.length;
            while (j < m) {
                char[] rName = rNames[j];
                if (!internedRootNames.containsKey(rName)) {
                    internedRootNames.put(rName, internedRootNames.elementSize);
                }
                ++j;
            }
            char[][][] qNames = collection.qualifiedNameReferences;
            int j2 = 0;
            int m2 = qNames.length;
            while (j2 < m2) {
                char[][] qName = qNames[j2];
                if (!internedQualifiedNames.containsKey(qName)) {
                    internedQualifiedNames.put(qName, internedQualifiedNames.elementSize);
                    int k = 0;
                    int n = qName.length;
                    while (k < n) {
                        char[] sName = qName[k];
                        if (!internedSimpleNames.containsKey(sName)) {
                            internedSimpleNames.put(sName, internedSimpleNames.elementSize);
                        }
                        ++k;
                    }
                }
                ++j2;
            }
            char[][] sNames = collection.simpleNameReferences;
            int j3 = 0;
            int m3 = sNames.length;
            while (j3 < m3) {
                char[] sName = sNames[j3];
                if (!internedSimpleNames.containsKey(sName)) {
                    internedSimpleNames.put(sName, internedSimpleNames.elementSize);
                }
                ++j3;
            }
        }
        char[][] internedArray = new char[internedRootNames.elementSize][];
        Object[] rootNames = internedRootNames.keyTable;
        Object[] positions = internedRootNames.valueTable;
        int i2 = positions.length;
        while (--i2 >= 0) {
            if (positions[i2] == null) continue;
            int index = (Integer)positions[i2];
            internedArray[index] = (char[])rootNames[i2];
        }
        this.writeNames(internedArray, out);
        internedArray = new char[internedSimpleNames.elementSize][];
        Object[] simpleNames = internedSimpleNames.keyTable;
        positions = internedSimpleNames.valueTable;
        int i3 = positions.length;
        while (--i3 >= 0) {
            if (positions[i3] == null) continue;
            int index = (Integer)positions[i3];
            internedArray[index] = (char[])simpleNames[i3];
        }
        this.writeNames(internedArray, out);
        char[][][] internedQArray = new char[internedQualifiedNames.elementSize][][];
        Object[] qualifiedNames = internedQualifiedNames.keyTable;
        positions = internedQualifiedNames.valueTable;
        int i4 = positions.length;
        while (--i4 >= 0) {
            if (positions[i4] == null) continue;
            int index = (Integer)positions[i4];
            internedQArray[index] = (char[][])qualifiedNames[i4];
        }
        length = internedQArray.length;
        out.writeInt(length);
        i4 = 0;
        while (i4 < length) {
            char[][] qName = internedQArray[i4];
            int qLength = qName.length;
            out.writeInt(qLength);
            int j = 0;
            while (j < qLength) {
                Integer index = (Integer)internedSimpleNames.get(qName[j]);
                out.writeInt(index);
                ++j;
            }
            ++i4;
        }
        length = this.references.size();
        out.writeInt(length);
        if (length > 0) {
            for (Map.Entry<String, ReferenceCollection> entry3 : this.references.entrySet()) {
                String key = entry3.getKey();
                --length;
                Integer index = (Integer)internedTypeLocators.get(key);
                out.writeInt(index);
                ReferenceCollection collection = entry3.getValue();
                if (collection instanceof AdditionalTypeCollection) {
                    out.writeByte(1);
                    AdditionalTypeCollection atc = (AdditionalTypeCollection)collection;
                    this.writeNames(atc.definedTypeNames, out);
                } else {
                    out.writeByte(2);
                }
                char[][][] qNames = collection.qualifiedNameReferences;
                int qLength = qNames.length;
                out.writeInt(qLength);
                int j = 0;
                while (j < qLength) {
                    index = (Integer)internedQualifiedNames.get(qNames[j]);
                    out.writeInt(index);
                    ++j;
                }
                char[][] sNames = collection.simpleNameReferences;
                int sLength = sNames.length;
                out.writeInt(sLength);
                int j4 = 0;
                while (j4 < sLength) {
                    index = (Integer)internedSimpleNames.get(sNames[j4]);
                    out.writeInt(index);
                    ++j4;
                }
                char[][] rNames = collection.rootReferences;
                int rLength = rNames.length;
                out.writeInt(rLength);
                int j5 = 0;
                while (j5 < rLength) {
                    index = (Integer)internedRootNames.get(rNames[j5]);
                    out.writeInt(index);
                    ++j5;
                }
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("references table is inconsistent");
            }
        }
    }

    private void writeName(char[] name, DataOutputStream out) throws IOException {
        int nLength = name.length;
        out.writeInt(nLength);
        int j = 0;
        while (j < nLength) {
            out.writeChar(name[j]);
            ++j;
        }
    }

    private void writeNames(char[][] names, DataOutputStream out) throws IOException {
        int length = names == null ? 0 : names.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            this.writeName(names[i], out);
            ++i;
        }
    }

    private void writeRestriction(AccessRuleSet accessRuleSet, DataOutputStream out) throws IOException {
        if (accessRuleSet == null) {
            out.writeInt(0);
        } else {
            AccessRule[] accessRules = accessRuleSet.getAccessRules();
            int length = accessRules.length;
            out.writeInt(length);
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    AccessRule accessRule = accessRules[i];
                    this.writeName(accessRule.pattern, out);
                    if (accessRule.problemId == 121312) {
                        out.writeInt(0);
                    } else {
                        out.writeInt(accessRule.problemId);
                    }
                    ++i;
                }
                out.writeByte(accessRuleSet.classpathEntryType);
                out.writeUTF(accessRuleSet.classpathEntryName);
            }
        }
    }

    public String toString() {
        return "State for " + this.javaProjectName + " (#" + this.buildNumber + " @ " + new Date(this.lastStructuralBuildTime) + ")";
    }
}

