/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ExtraCompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.IProblemRechecker;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.OTNameUtils;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.RoleClassLiteralAccess;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeContainerMethod;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectMapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CopyInheritanceSourceAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.InheritedRolesAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.OTDynCallinBindingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.OTSpecialAccessAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.ITranslationStates;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.AnchorMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticBaseCallSurrogate;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticRoleBridgeMethodBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticRoleFieldAccess;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineNumberProvider;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.TypeLevel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.ReflectionGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.ReplaceSingleNameVisitor;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.SerializationGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StandardElementGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.Protections;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class CopyInheritance
implements IOTConstants,
ClassFileConstants,
ExtraCompilerModifiers,
ITranslationStates {
    public static void copyRoles(SourceTypeBinding teamBinding) {
        TeamModel teamModel = teamBinding.getTeamModel();
        ReferenceBinding superTeam = teamBinding.superclass;
        if (superTeam == null) {
            assert ((teamBinding.tagBits & 0x20000L) != 0L) : "Only broken teams can have null superclass";
            return;
        }
        if (TeamModel.setTagBit(teamBinding, 256)) {
            TSuperHelper.addMarkerInterface(teamModel, superTeam);
            CopyInheritance.copyRolesFromTeam(superTeam, teamModel, false);
        }
        if (teamBinding.isRole()) {
            ReferenceBinding[] tSuperRoleBindings = teamBinding.roleModel.getTSuperRoleBindings();
            int length = tSuperRoleBindings.length;
            if (length > 8) {
                throw new InternalCompilerError("Too many tsuper roles in " + String.valueOf(teamBinding.readableName()));
            }
            int i = 0;
            while (i < length) {
                ReferenceBinding tsuperTeam = tSuperRoleBindings[i];
                int tagBits = 1 << i & 0xFF;
                if (TeamModel.setTagBit(teamBinding, tagBits)) {
                    TSuperHelper.addMarkerInterface(teamModel, tsuperTeam);
                    CopyInheritance.copyRolesFromTeam(tsuperTeam, teamModel, true);
                }
                ++i;
            }
        }
        teamModel.addAttribute(new InheritedRolesAttribute(teamModel.getBinding()));
    }

    private static void copyRolesFromTeam(ReferenceBinding sourceTeam, TeamModel targetTeamModel, boolean isTsuperTeam) {
        if (!sourceTeam.isTeam()) {
            return;
        }
        CopyInheritance.loadRoleFiles(sourceTeam, targetTeamModel.getBinding().memberTypes());
        CopyInheritance.loadRoleFiles(targetTeamModel.getBinding(), sourceTeam.memberTypes());
        CopyInheritance.doCopyRoles(sourceTeam, targetTeamModel, isTsuperTeam);
        CopyInheritance.connectRolesFromTeam(sourceTeam, targetTeamModel.getAst(), isTsuperTeam);
    }

    private static void connectRolesFromTeam(ReferenceBinding sourceTeam, TypeDeclaration teamDeclaration, boolean isTsuperTeam) {
        TypeDeclaration[] subRoles = teamDeclaration.memberTypes;
        if (subRoles != null) {
            HashMap<String, TypeDeclaration> roleIfcs = new HashMap<String, TypeDeclaration>();
            TypeDeclaration[] typeDeclarationArray = subRoles;
            int n = subRoles.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration typeDeclaration = typeDeclarationArray[n2];
                if (typeDeclaration.isInterface() && !typeDeclaration.isRegularInterface()) {
                    roleIfcs.put(new String(typeDeclaration.name), typeDeclaration);
                }
                ++n2;
            }
            SupertypeObligation[][] obligations = new SupertypeObligation[subRoles.length][];
            int i = 0;
            while (i < subRoles.length) {
                TypeDeclaration subRoleDecl = subRoles[i];
                if ((subRoleDecl.modifiers & 0x4000) == 0) {
                    RoleModel subRole = subRoleDecl.getRoleModel();
                    obligations[i] = TypeLevel.connectRoleClasses(sourceTeam, subRoleDecl);
                    subRole.recordIfcPart(roleIfcs);
                    if (subRoleDecl.binding != null && subRoleDecl.binding.isSynthInterface()) {
                        CopyInheritance.checkRoleShadows(teamDeclaration.scope, teamDeclaration.binding, subRoleDecl);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < subRoles.length) {
                if ((subRoles[i].modifiers & 0x4000) == 0) {
                    CopyInheritance.verifyTSupers(subRoles[i].getRoleModel());
                    SupertypeObligation[] obligs = obligations[i];
                    int j = 0;
                    while (j < obligs.length) {
                        obligs[j].check(subRoles[i]);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static void checkRoleShadows(ClassScope scope, ReferenceBinding sourceType, TypeDeclaration memberDecl) {
        ReferenceBinding currentType = sourceType.enclosingType();
        char[] internalName = memberDecl.name;
        while (currentType != null) {
            ReferenceBinding otherType = scope.findMemberType(internalName, currentType);
            if (otherType != null && otherType.isValidBinding()) {
                if (TypeAnalyzer.isPredefinedRole(otherType)) {
                    return;
                }
                if (TSuperHelper.isMarkerInterface(otherType)) {
                    return;
                }
                scope.problemReporter().roleShadowsVisibleType(memberDecl, otherType);
                break;
            }
            currentType = currentType.enclosingType();
        }
        TypeBinding otherType2 = (TypeBinding)scope.compilationUnitScope().getTypeOrPackage(internalName, 4, false);
        if (otherType2 != null && otherType2.isValidBinding()) {
            scope.problemReporter().roleShadowsVisibleType(memberDecl, otherType2);
        }
    }

    public static void connectBinaryTSupers(TeamModel subTeamModel) {
        ReferenceBinding subTeam = subTeamModel.getBinding();
        ReferenceBinding superTeam = subTeam.superclass();
        if (superTeam != null && superTeam.isTeam()) {
            Dependencies.ensureBindingState(superTeam, 6);
            ReferenceBinding[] referenceBindingArray = superTeam.memberTypes();
            int n = referenceBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding tsuperRole = referenceBindingArray[n2];
                CopyInheritance.connectToTSuperRole(subTeamModel, subTeam, tsuperRole);
                ++n2;
            }
        }
    }

    private static void connectToTSuperRole(TeamModel subTeamModel, ReferenceBinding subTeam, ReferenceBinding tsuperRole) {
        ReferenceBinding subRole = subTeam.getMemberType(tsuperRole.internalName());
        if (subRole != null) {
            if (subRole.roleModel == null) {
                assert (CharOperation.equals(subRole.internalName(), IOTConstants.ROFI_CACHE));
            } else {
                subRole.roleModel.connect(subTeamModel, tsuperRole);
            }
        }
    }

    private static void setRoleState(RoleModel subRole, int state) {
        subRole.setState(state);
        if (subRole.isTeam()) {
            subRole.getTeamModelOfThis().setMemberStateShallow(state);
        } else {
            subRole.setMemberState(state);
        }
    }

    private static void loadRoleFiles(ReferenceBinding sourceTeam, ReferenceBinding[] suggestedRoles) {
        if (sourceTeam instanceof SourceTypeBinding) {
            ClassScope scope = ((SourceTypeBinding)sourceTeam).scope;
            if (scope == null) {
                return;
            }
            TypeDeclaration teamDecl = scope.referenceContext;
            HashSet<String> processed = new HashSet<String>();
            int i = 0;
            while (i < suggestedRoles.length) {
                char[] roleName = suggestedRoles[i].internalName();
                sourceTeam.getMemberType(roleName);
                processed.add(new String(roleName));
                ++i;
            }
            if (teamDecl.fields != null) {
                i = 0;
                while (i < teamDecl.fields.length) {
                    CopyInheritance.loadRoFiFromType(sourceTeam, teamDecl.fields[i].type, processed);
                    ++i;
                }
            }
            if (teamDecl.methods != null) {
                i = 0;
                while (i < teamDecl.methods.length) {
                    AbstractMethodDeclaration method = teamDecl.methods[i];
                    if (method.arguments != null) {
                        int j = 0;
                        while (j < method.arguments.length) {
                            CopyInheritance.loadRoFiFromType(sourceTeam, method.arguments[j].type, processed);
                            ++j;
                        }
                    }
                    if (method instanceof MethodDeclaration) {
                        CopyInheritance.loadRoFiFromType(sourceTeam, ((MethodDeclaration)method).returnType, processed);
                    }
                    ++i;
                }
            }
        }
    }

    private static void loadRoFiFromType(ReferenceBinding sourceTeam, TypeReference type, HashSet<String> processed) {
        char[] typeName;
        String typeString;
        if (type instanceof SingleTypeReference && !processed.contains(typeString = new String(typeName = ((SingleTypeReference)type).token))) {
            ReferenceBinding rofi = sourceTeam.getMemberType(typeName);
            while (rofi != null && !rofi.isBinaryBinding()) {
                SourceTypeBinding sourceRole = (SourceTypeBinding)rofi;
                if (sourceRole.scope != null && (sourceRole.tagBits & 0x100L) == 0L) {
                    sourceRole.scope.connectTypeHierarchyWithoutMembers();
                }
                if (sourceRole.isSynthInterface()) {
                    rofi = sourceRole.getRealClass();
                    if (rofi == null || !rofi.isInterface()) continue;
                    throw new InternalCompilerError("Role has no class-part");
                }
                rofi = null;
            }
            processed.add(typeString);
        }
    }

    private static void doCopyRoles(ReferenceBinding srcTeam, TeamModel targetTeam, boolean isTsuperTeam) {
        ReferenceBinding[] tsuperRoles = srcTeam.getTeamModel().getKnownRoles();
        if (tsuperRoles == null) {
            return;
        }
        TypeDeclaration teamDeclaration = targetTeam.getAst();
        int i = 0;
        while (i < tsuperRoles.length) {
            ReferenceBinding tsuperRoleBinding = tsuperRoles[i];
            TypeDeclaration subRoleType = CopyInheritance.copyRole(tsuperRoleBinding, false, teamDeclaration, isTsuperTeam);
            if (subRoleType != null) {
                RoleModel subRoleModel = subRoleType.getRoleModel();
                subRoleModel.connect(targetTeam, tsuperRoleBinding);
            } else {
                CopyInheritance.connectToTSuperRole(targetTeam, teamDeclaration.binding, tsuperRoleBinding);
            }
            ++i;
        }
    }

    private static void verifyTSupers(RoleModel role) {
        if (!role.getAst().isInterface()) {
            return;
        }
        ReferenceBinding[] tsupers = role.getTSuperRoleBindings();
        if (tsupers.length > 1) {
            int i = 0;
            while (i < tsupers.length) {
                int j = 0;
                while (j < tsupers.length) {
                    ReferenceBinding common;
                    if (i != j && (common = CopyInheritance.findCommonSuper(tsupers[i], tsupers[j])) == null) {
                        TypeDeclaration roleDecl = role.getAst();
                        roleDecl.scope.problemReporter().incomparableTSupers(roleDecl, tsupers[i], tsupers[j]);
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static ReferenceBinding findCommonSuper(ReferenceBinding type1, ReferenceBinding type2) {
        ReferenceBinding current = type1;
        while (current != null && current.depth() == type1.depth()) {
            if (type2.isCompatibleWith(current)) {
                return current;
            }
            current = current.superclass();
        }
        ReferenceBinding[] superInterfaces = type1.superInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            ReferenceBinding common = CopyInheritance.findCommonSuper(superInterfaces[i], type2);
            if (common != null) {
                return common;
            }
            ++i;
        }
        return null;
    }

    public static boolean copyLocalTypes(RoleModel roleModel) {
        ReferenceBinding[] tsuperRoles = roleModel.getTSuperRoleBindings();
        TeamModel teamModel = roleModel.getTeamModel();
        int i = 0;
        while (i < tsuperRoles.length) {
            ReferenceBinding tsuperRole = tsuperRoles[i];
            if (tsuperRole != null) {
                ReferenceBinding superTeam = tsuperRole.enclosingType();
                RoleModel tsuperModel = tsuperRole.roleModel;
                Dependencies.ensureRoleState(tsuperModel, 22);
                Iterator<RoleModel> tsuperLocals = tsuperModel.localTypes();
                while (tsuperLocals.hasNext()) {
                    RoleModel tsuperLocal = tsuperLocals.next();
                    Dependencies.ensureRoleState(tsuperLocal, 21);
                    ReferenceBinding tsuperNestedBinding = tsuperLocal.getBinding();
                    TypeDeclaration localDecl = CopyInheritance.copyRoleNestedInternal(teamModel, roleModel, tsuperNestedBinding);
                    if (localDecl == null) continue;
                    TypeLevel.mergeSuperinterfaces(superTeam, tsuperNestedBinding, localDecl.binding);
                    TypeLevel.copyAdjustSuperclass(tsuperNestedBinding, localDecl, null);
                }
            }
            ++i;
        }
        return true;
    }

    private static TypeDeclaration copyRoleNestedInternal(TeamModel destTeamModel, RoleModel destRole, ReferenceBinding tsuperNestedBinding) {
        TypeDeclaration subRoleType = CopyInheritance.copyRole(tsuperNestedBinding, true, destTeamModel.getAst(), false);
        if (subRoleType != null) {
            RoleModel subRoleModel = subRoleType.getRoleModel();
            subRoleModel.connect(destTeamModel, tsuperNestedBinding);
            if (tsuperNestedBinding.isLocalType()) {
                destRole.addLocalType(tsuperNestedBinding.constantPoolName(), subRoleModel);
            }
        }
        return subRoleType;
    }

    private static TypeDeclaration copyRole(ReferenceBinding superRole, boolean isNestedType, TypeDeclaration subTeamDecl, boolean isTsuperTeam) {
        subTeamDecl.getTeamModel()._isCopyingLateRole = true;
        try {
            if (superRole instanceof MissingTypeBinding) {
                return null;
            }
            if (superRole.sourceName == null) {
                return null;
            }
            String name = new String(superRole.sourceName);
            if (name.startsWith("TSuper__OT__") || CharOperation.equals(superRole.sourceName, ROFI_CACHE)) {
                return null;
            }
            if (subTeamDecl.isRole() && superRole.roleModel.equals(subTeamDecl.getRoleModel())) {
                return null;
            }
            TypeDeclaration subRoleDecl = CopyInheritance.findMemberType(subTeamDecl, superRole.sourceName);
            ReferenceBinding subRoleBinding = subTeamDecl.binding.getMemberType(superRole.internalName());
            if (subRoleBinding != null) {
                if (CopyInheritance.shouldPreserveBinaryRole(subRoleBinding, subTeamDecl.compilationResult)) {
                    if (isNestedType) {
                        subRoleBinding.roleModel.maybeAddLocalToEnclosing();
                    }
                    CopyInheritance.connectBinaryNested(superRole, subTeamDecl, subRoleBinding);
                    return null;
                }
                if (subRoleDecl == null) {
                    subRoleDecl = CopyInheritance.findMemberType(subTeamDecl, superRole.sourceName);
                }
                if (subRoleDecl != null && (subRoleDecl.binding.tagBits & 0x100L) == 0L) {
                    subRoleDecl.scope.connectTypeHierarchyWithoutMembers();
                }
                if (subRoleDecl == null) {
                    return null;
                }
            }
            if (subRoleDecl == null) {
                char[] superRoleName = superRole.internalName();
                if (superRole.isLocalType()) {
                    int lastDollar;
                    if (!superRole.isBinaryBinding()) {
                        ((LocalTypeBinding)superRole).computeConstantPoolName();
                    }
                    if ((lastDollar = CharOperation.lastIndexOf('$', superRole.sourceName)) >= 0) {
                        superRoleName = CharOperation.subarray(superRole.sourceName, lastDollar + 1, -1);
                    } else {
                        char[] superConstantPoolName = superRole.constantPoolName();
                        lastDollar = CharOperation.lastIndexOf('$', superConstantPoolName);
                        if (lastDollar >= 0) {
                            superRoleName = CharOperation.subarray(superConstantPoolName, lastDollar + 1, -1);
                        }
                    }
                }
                if ((subRoleDecl = AstConverter.createNestedType(superRoleName, superRole.modifiers, isNestedType, true, subTeamDecl, superRole)).isInterface()) {
                    ReferenceBinding[] tsuperSupers = superRole.superInterfaces();
                    subRoleDecl.binding.superInterfaces = new ReferenceBinding[tsuperSupers.length];
                    int j = 0;
                    int i = 0;
                    while (i < tsuperSupers.length) {
                        ReferenceBinding tsubRole;
                        char[] tsuperSuperName = tsuperSupers[i].internalName();
                        if (!CharOperation.equals(tsuperSuperName, superRoleName) && (tsubRole = subTeamDecl.binding.getMemberType(tsuperSuperName)) != null) {
                            subRoleDecl.binding.superInterfaces[j++] = tsubRole;
                        }
                        ++i;
                    }
                    if (j < tsuperSupers.length) {
                        subRoleDecl.binding.superInterfaces = new ReferenceBinding[j];
                        System.arraycopy(subRoleDecl.binding.superInterfaces, 0, subRoleDecl.binding.superInterfaces, 0, j);
                    }
                }
            } else {
                if (subRoleDecl.isRegularInterface() != superRole.isRegularInterface()) {
                    subRoleDecl.scope.problemReporter().roleClassIfcConflict(subRoleDecl);
                    subRoleDecl.isGenerated = true;
                    subRoleDecl.isPurelyCopied = true;
                    subRoleDecl.modifiers = superRole.modifiers;
                    subRoleDecl.fields = null;
                    subRoleDecl.methods = null;
                    subRoleDecl.superclass = null;
                    subRoleDecl.superInterfaces = null;
                    SourceTypeBinding roleBinding = subRoleDecl.binding;
                    roleBinding.modifiers = superRole.modifiers;
                    roleBinding.setFields(Binding.NO_FIELDS);
                    roleBinding.setMethods(Binding.NO_METHODS);
                    roleBinding.baseclass = null;
                    roleBinding.superclass = subTeamDecl.scope.getJavaLangObject();
                    roleBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
                    TypeDeclaration typeDeclaration = subRoleDecl;
                    return typeDeclaration;
                }
                if (superRole.isTeam() && !subRoleDecl.isTeam()) {
                    if (!Protections.hasClassKindProblem(subRoleDecl.binding)) {
                        subRoleDecl.scope.problemReporter().regularOverridesTeam(subRoleDecl, superRole);
                    }
                    subRoleDecl.modifiers |= 0x20000000;
                    if (subRoleBinding != null) {
                        subRoleBinding.modifiers |= 0x20000000;
                    }
                }
                if (!isTsuperTeam) {
                    if (CharOperation.equals(subRoleDecl.name, OTCONFINED)) {
                        subRoleDecl.scope.problemReporter().overridingConfined(subRoleDecl, "Confined");
                        return null;
                    }
                    if (CharOperation.equals(subRoleDecl.name, ICONFINED)) {
                        subRoleDecl.scope.problemReporter().overridingConfined(subRoleDecl, "IConfined");
                        return null;
                    }
                    if (superRole.isFinal()) {
                        subRoleDecl.scope.problemReporter().overridingFinalRole(subRoleDecl, superRole);
                        return null;
                    }
                }
            }
            superRole.roleModel.hasBaseclassProblem();
            TypeDeclaration typeDeclaration = subRoleDecl;
            return typeDeclaration;
        }
        finally {
            subTeamDecl.getTeamModel()._isCopyingLateRole = false;
        }
    }

    public static void connectBinaryNested(ReferenceBinding superRole, TypeDeclaration subTeam, ReferenceBinding subRole) {
        subRole.roleModel.connect(subTeam.getTeamModel(), superRole);
        Dependencies.ensureBindingState(subRole, 19);
        subTeam.scope.compilationUnitScope().registerBinaryNested(subRole);
    }

    public static ReferenceBinding checkCopyLateRoleFile(SourceTypeBinding teamBinding, char[] name) {
        TypeDeclaration roleDecl;
        if (!TeamModel.hasTagBit(teamBinding, 256)) {
            return null;
        }
        ReferenceBinding ifcPart = null;
        if (CharOperation.prefixEquals(IOTConstants.OT_DELIM_NAME, name)) {
            char[] ifcName = CharOperation.subarray(name, IOTConstants.OT_DELIM_LEN, -1);
            ifcPart = teamBinding.getMemberType(ifcName);
        }
        if ((roleDecl = CopyInheritance.internalCheckCopyLateRoleFile(teamBinding, name)) != null && ifcPart != null) {
            ReferenceBinding superTeam = teamBinding.superclass;
            if (!CopyInheritance.hasHiearchyCheckBegun(superTeam)) {
                Dependencies.ensureBindingState(superTeam, 6);
            }
            TypeLevel.connectRoleClasses(superTeam, roleDecl);
        }
        if (roleDecl != null) {
            return roleDecl.binding;
        }
        return null;
    }

    private static boolean hasHiearchyCheckBegun(ReferenceBinding type) {
        if ((type.tagBits & 0x100L) != 0L) {
            return true;
        }
        if (type.enclosingType() != null) {
            return CopyInheritance.hasHiearchyCheckBegun(type.enclosingType());
        }
        return false;
    }

    public static TypeDeclaration internalCheckCopyLateRoleFile(SourceTypeBinding teamBinding, char[] name) {
        ReferenceBinding superTeam = (ReferenceBinding)teamBinding.superclass().original();
        if (superTeam != null && superTeam.isTeam() && !TypeAnalyzer.isOrgObjectteamsTeam(superTeam) && !teamBinding._teamModel._isCopyingLateRole && !OTNameUtils.isTSuperMarkerInterface(name)) {
            TypeDeclaration tsuperDecl;
            ReferenceBinding tsuperRole = superTeam.getMemberType(name);
            if ((tsuperRole == null || !tsuperRole.isValidBinding() && tsuperRole.problemId() == 1) && superTeam instanceof SourceTypeBinding && (tsuperDecl = CopyInheritance.internalCheckCopyLateRoleFile((SourceTypeBinding)superTeam, name)) != null) {
                tsuperRole = tsuperDecl.binding;
            }
            if (tsuperRole != null && tsuperRole.isRole() && tsuperRole.isValidBinding() && !tsuperRole.isLocalType()) {
                if ((teamBinding.tagBits & 0x100L) != 0L) {
                    return CopyInheritance.copyLateRole(teamBinding._teamModel.getAst(), tsuperRole);
                }
                return CopyInheritance.copyLateRolePart(teamBinding._teamModel.getAst(), tsuperRole);
            }
        }
        return null;
    }

    public static TypeDeclaration copyLateRole(TypeDeclaration teamDecl, ReferenceBinding tsuperRole) {
        TypeDeclaration roleType = null;
        ReferenceBinding ifcPart = null;
        char[] tsuperName = tsuperRole.internalName();
        if (CharOperation.prefixEquals(IOTConstants.OT_DELIM_NAME, tsuperName)) {
            char[] ifcName = CharOperation.subarray(tsuperName, IOTConstants.OT_DELIM_LEN, -1);
            ifcPart = teamDecl.binding.getMemberType(ifcName);
        }
        roleType = CopyInheritance.copyLateRolePart(teamDecl, tsuperRole);
        if (ifcPart != null) {
            ReferenceBinding superTeam = tsuperRole.enclosingType();
            if ((superTeam.tagBits & 0x100L) == 0L) {
                Dependencies.ensureBindingState(superTeam, 6);
            }
            if (StateHelper.hasState(tsuperRole, 6)) {
                RoleModel subRole = roleType.getRoleModel();
                TypeLevel.connectRoleClasses(superTeam, roleType);
                CopyInheritance.setRoleState(subRole, 6);
            }
        }
        if (roleType == null) {
            return null;
        }
        Dependencies.lateRolesCatchup(teamDecl.getTeamModel());
        return roleType;
    }

    private static TypeDeclaration copyLateRolePart(TypeDeclaration teamDecl, ReferenceBinding tsuperRole) {
        TypeDeclaration roleDecl = CopyInheritance.copyRole(tsuperRole, false, teamDecl, false);
        if (roleDecl != null) {
            TeamModel teamModel = teamDecl.getTeamModel();
            RoleModel subRoleModel = roleDecl.getRoleModel();
            subRoleModel.connect(teamModel, tsuperRole);
            return roleDecl;
        }
        return null;
    }

    private static boolean shouldPreserveBinaryRole(ReferenceBinding subRoleBinding, CompilationResult result) {
        return subRoleBinding.isBinaryBinding();
    }

    public static void copyAttribute(RoleModel subRole) {
        if (subRole != null) {
            ReferenceBinding[] tsuperRoles = subRole.getTSuperRoleBindings();
            int i = 0;
            while (i < tsuperRoles.length) {
                Dependencies.ensureBindingState(tsuperRoles[i], 18);
                subRole.copyAttributeFrom(tsuperRoles[i].roleModel, IOTConstants.CALLIN_METHOD_MAPPINGS);
                ++i;
            }
        }
    }

    public static void copyAttribute(TeamModel subTeam) {
        if (subTeam != null && !TypeAnalyzer.isOrgObjectteamsTeam(subTeam.getBinding())) {
            ReferenceBinding superTeam = subTeam.getBinding().superclass();
            if (superTeam != null && superTeam.isValidBinding() && superTeam.isTeam() && !TypeAnalyzer.isOrgObjectteamsTeam(superTeam)) {
                CopyInheritance.copyAttributesFromTo(superTeam, subTeam);
            }
            if (subTeam.isRole()) {
                ReferenceBinding[] referenceBindingArray = subTeam.getRoleModelOfThis().getTSuperRoleBindings();
                int n = referenceBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceBinding tsuperRole = referenceBindingArray[n2];
                    if (tsuperRole.isTeam()) {
                        CopyInheritance.copyAttributesFromTo(tsuperRole, subTeam);
                    }
                    ++n2;
                }
            }
        }
    }

    private static void copyAttributesFromTo(ReferenceBinding superTeam, TeamModel subTeam) {
        Dependencies.ensureBindingState(superTeam, 18);
        subTeam.copyAttributeFrom(superTeam.getTeamModel(), IOTConstants.STATIC_REPLACE_BINDINGS);
        subTeam.copyAttributeFrom(superTeam.getTeamModel(), OTDynCallinBindingsAttribute.ATTRIBUTE_NAME);
        OTSpecialAccessAttribute attrib = (OTSpecialAccessAttribute)superTeam.getTeamModel().getAttribute(IOTConstants.OTSPECIAL_ACCESS);
        if (attrib != null) {
            attrib.addFieldAccessesTo(subTeam);
        }
    }

    public static void copyFeatures(RoleModel role, ReferenceBinding tsuperRoleBinding) {
        MethodBinding[] methods;
        TypeDeclaration rt = role.getAst();
        Dependencies.ensureBindingState(tsuperRoleBinding, 10);
        FieldBinding[] fields = tsuperRoleBinding.fields();
        if (fields != null) {
            int j = 0;
            while (j < fields.length) {
                CopyInheritance.copyField(fields[j], rt);
                ++j;
            }
        }
        if ((methods = tsuperRoleBinding.methods()) != null) {
            int j = 0;
            while (j < methods.length) {
                CopyInheritance.copyMethod(methods[j], rt);
                ++j;
            }
        }
    }

    public static void copyGeneratedFeatures(RoleModel model) {
        TypeDeclaration roleType = model.getAst();
        ReferenceBinding[] tsuperRoles = model.getTSuperRoleBindings();
        int i = 0;
        while (i < tsuperRoles.length) {
            if (!tsuperRoles[i].isInterface()) {
                FieldBinding[] fields = tsuperRoles[i].fields();
                int j = 0;
                while (j < fields.length) {
                    if (!model.hasAlreadyBeenCopied(fields[j])) {
                        CopyInheritance.copyField(fields[j], roleType);
                    }
                    ++j;
                }
                MethodBinding[] methods = tsuperRoles[i].methods();
                int j2 = 0;
                while (j2 < methods.length) {
                    if (model.hasAlreadyBeenCopied(methods[j2])) {
                        if (!methods[j2].isAbstract()) {
                            MethodBinding[] existingMethod = model.getBinding().methods();
                            int k = 0;
                            while (k < existingMethod.length) {
                                if (existingMethod[k].isCopiedFrom(methods[j2]) && existingMethod[k].isAbstract()) {
                                    existingMethod[k].modifiers &= 0xFEFFFBFF;
                                    AbstractMethodDeclaration decl = existingMethod[k].sourceMethod();
                                    if (decl != null) {
                                        decl.modifiers &= 0xFEFFFBFF;
                                    }
                                    break;
                                }
                                ++k;
                            }
                        }
                    } else {
                        CopyInheritance.copyMethod(methods[j2], roleType);
                    }
                    ++j2;
                }
            }
            ++i;
        }
    }

    private static void copyMethod(MethodBinding method, TypeDeclaration targetRoleDecl) {
        AbstractMethodDeclaration newMethodDecl;
        boolean wasSynthetic = false;
        SourceTypeBinding site = null;
        if ((method.modifiers & 0x1000) != 0) {
            wasSynthetic = true;
            if (!SyntheticBaseCallSurrogate.isBaseCallSurrogateName(method.selector)) {
                site = targetRoleDecl.binding;
            }
            if (SyntheticRoleBridgeMethodBinding.isPrivateBridgeSelector(method.selector)) {
                return;
            }
        }
        if (TypeContainerMethod.isTypeContainer(method)) {
            return;
        }
        if (CopyInheritance.isCreator(method) || CharOperation.equals(IOTConstants._OT_GETBASE, method.selector) || CharOperation.prefixEquals(IOTConstants.CAST_PREFIX, method.selector) || CharOperation.prefixEquals(IOTConstants.GET_CLASS_PREFIX, method.selector)) {
            return;
        }
        if (targetRoleDecl.isTeam() && (ReflectionGenerator.isReflectionMethod(method) || SerializationGenerator.isSerializationMethod(method))) {
            return;
        }
        if (MethodModel.isFakedMethod(method)) {
            return;
        }
        if (CharOperation.equals(IOTConstants.MIGRATE_TO_TEAM, method.selector)) {
            return;
        }
        targetRoleDecl.getRoleModel().recordCopiedFeature(method);
        ReferenceBinding srcRole = method.declaringClass;
        TypeDeclaration targetTeamDecl = targetRoleDecl.enclosingType;
        ReferenceBinding srcTeam = TeamModel.getEnclosingTeam(srcRole);
        SourceTypeBinding tgtTeam = targetTeamDecl.binding;
        MethodBinding origin = method.copyInheritanceSrc != null ? method.copyInheritanceSrc : method;
        AbstractMethodDeclaration methodFound = CopyInheritance.findMethod(srcTeam, method, tgtTeam, targetRoleDecl);
        if (method.isConstructor()) {
            if (srcRole.id == 119) {
                ConstructorDeclaration ctor = targetRoleDecl.createDefaultConstructor(true, true);
                targetRoleDecl.binding.resolveGeneratedMethod(ctor, false, origin, true);
                return;
            }
            if (targetRoleDecl.getRoleModel()._refinesExtends) {
                if (methodFound != null) {
                    methodFound.binding.addOverriddenTSuper(method);
                }
                return;
            }
        }
        boolean reuseFoundMethod = false;
        if (methodFound != null) {
            MethodModel model;
            if (methodFound.binding == null) {
                return;
            }
            if (methodFound.binding.copyInheritanceSrc == origin) {
                return;
            }
            if (methodFound.isMappingWrapper == AbstractMethodDeclaration.WrapperKind.CALLOUT && (model = methodFound.model) != null && model._inferredCallout != null) {
                methodFound.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.NONE;
                model._inferredCallout = null;
                methodFound.statements = null;
                methodFound.isCopied = true;
                methodFound.binding.copyInheritanceSrc = method;
                methodFound.sourceMethodBinding = method;
                reuseFoundMethod = true;
            }
            methodFound.binding.addOverriddenTSuper(method);
            if (method.isAbstract()) {
                CopyInheritance.weakenSignature(methodFound, method);
                return;
            }
            if (method.isFinal()) {
                methodFound.scope.problemReporter().finalMethodCannotBeOverridden(methodFound.binding, method);
                return;
            }
            CopyInheritance.weakenSignature(methodFound, method);
            MethodBinding foundSrc = methodFound.binding.copyInheritanceSrc;
            if (foundSrc != null && foundSrc != origin) {
                if (!TeamModel.isMoreSpecificThan(foundSrc.declaringClass, origin.declaringClass)) {
                    methodFound.binding.setCopyInheritanceSrc(origin);
                    methodFound.sourceMethodBinding = origin;
                    methodFound.isTSuper = TSuperHelper.isTSuper(method);
                    if (!method.isAbstract()) {
                        methodFound.modifiers &= 0xFEFFFBFF;
                        methodFound.binding.modifiers &= 0xFEFFFBFF;
                    }
                }
                return;
            }
        }
        AstGenerator gen = new AstGenerator(targetRoleDecl.sourceStart, targetRoleDecl.sourceEnd);
        gen.replaceableEnclosingClass = tgtTeam;
        if (methodFound != null && reuseFoundMethod) {
            newMethodDecl = methodFound;
        } else {
            newMethodDecl = AstConverter.createMethod(method, site, targetRoleDecl.compilationResult, Expression.DecapsulationState.REPORTED, gen);
            if (methodFound != null) {
                TSuperHelper.addMarkerArg(newMethodDecl, srcTeam);
            }
            if (newMethodDecl.isConstructor()) {
                ReferenceBinding newBase;
                ConstructorDeclaration cd = (ConstructorDeclaration)newMethodDecl;
                cd.constructorCall = SuperReference.implicitSuperConstructorCall();
                if (Lifting.isLiftingCtor(method) && method.parameters[0].isRole() && TypeBinding.notEquals(newBase = targetRoleDecl.binding.baseclass(), method.parameters[0])) {
                    newMethodDecl.arguments[0].type = gen.baseclassReference(newBase);
                }
            }
            AstEdit.addMethod(targetRoleDecl, newMethodDecl, wasSynthetic, false, origin, true);
        }
        if (method.isPrivate()) {
            newMethodDecl.binding.modifiers |= 0x8000000;
        }
        newMethodDecl.binding.copiedInContext = tgtTeam.enclosingType();
        MethodModel newModel = MethodModel.getModel(newMethodDecl);
        newModel.addAttribute(CopyInheritanceSourceAttribute.copyInherSrcAttribute(origin, newModel));
        if (wasSynthetic) {
            targetRoleDecl.getRoleModel().addSyntheticMethodMapping(method, newMethodDecl.binding);
        }
        if (method.isAnyCallin() && !method.isCallin()) {
            newMethodDecl.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.CALLIN;
        }
        if (methodFound == null) {
            if (TSuperHelper.isTSuper(method)) {
                newMethodDecl.isTSuper = true;
            }
            if (method.model != null && method.model.callinFlags != 0) {
                MethodModel.addCallinFlag(newMethodDecl, method.model.callinFlags);
            }
            if (method.isAnyCallin()) {
                TypeBinding inheritedSrcReturn = MethodModel.getReturnType(method);
                if (inheritedSrcReturn.isRole()) {
                    inheritedSrcReturn = RoleTypeCreator.maybeWrapUnqualifiedRoleType(inheritedSrcReturn, targetRoleDecl.binding);
                }
                MethodModel.saveReturnType(newMethodDecl.binding, inheritedSrcReturn);
            } else {
                if (!(method.isPublic() || method.isConstructor() || targetRoleDecl.isInterface() || CharOperation.prefixEquals(IOTConstants.OT_DOLLAR_NAME, method.selector))) {
                    MethodModel.getModel(newMethodDecl).storeModifiers(newMethodDecl.modifiers);
                }
                if (method.model != null && method.model._inferredCallout != null) {
                    newModel._inferredCallout = method.model._inferredCallout;
                }
            }
            if (newMethodDecl.isAbstract() && (targetRoleDecl.modifiers & 0x400) == 0) {
                targetRoleDecl.scope.problemReporter().setRechecker(new IProblemRechecker(){

                    @Override
                    public boolean shouldBeReported(IrritantSet[] foundIrritants) {
                        return newMethodDecl.isAbstract();
                    }
                }).abstractMethodMustBeImplemented(targetRoleDecl.binding, newMethodDecl.binding);
            }
        }
    }

    public static void copySyntheticRoleFieldsAndMethods(TypeDeclaration roleType) {
        ReferenceBinding[] tsuperRoleBindings = roleType.getRoleModel().getTSuperRoleBindings();
        int i = 0;
        while (i < tsuperRoleBindings.length) {
            TypeBinding tsuperRoleBinding = tsuperRoleBindings[i].erasure();
            if (tsuperRoleBinding instanceof SourceTypeBinding) {
                FieldBinding[] synthFields;
                SyntheticMethodBinding[] synthMethods = ((SourceTypeBinding)tsuperRoleBinding).syntheticMethods();
                if (synthMethods != null) {
                    int j = 0;
                    while (j < synthMethods.length) {
                        CopyInheritance.copySyntheticMethod(synthMethods[j], roleType, roleType.getRoleModel(), roleType.enclosingType);
                        ++j;
                    }
                }
                if ((synthFields = ((SourceTypeBinding)tsuperRoleBinding).syntheticFields()) != null) {
                    int j = 0;
                    while (j < synthFields.length) {
                        roleType.binding.addCopiedSyntheticFied(synthFields[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static void copySyntheticTeamMethods(TypeDeclaration teamType) {
        if (teamType.binding == null) {
            return;
        }
        ReferenceBinding superTeam = teamType.binding.superclass();
        if (superTeam instanceof SourceTypeBinding && superTeam.isTeam()) {
            Dependencies.ensureTeamState(superTeam.getTeamModel(), 25);
            SyntheticMethodBinding[] synthMethods = ((SourceTypeBinding)superTeam).syntheticMethods();
            if (synthMethods != null) {
                int j = 0;
                while (j < synthMethods.length) {
                    if (synthMethods[j] instanceof SyntheticRoleFieldAccess) {
                        CopyInheritance.copySyntheticMethod(synthMethods[j], teamType, teamType);
                    }
                    ++j;
                }
            }
        }
    }

    public static void copySyntheticTeamMethods(TeamModel teamModel, BinaryTypeBinding superTeam) {
        TypeDeclaration tgtTeamDecl = teamModel.getAst();
        MethodBinding[] methodBindingArray = superTeam.methods();
        int n = methodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding method = methodBindingArray[n2];
            if (method instanceof SyntheticRoleFieldAccess) {
                SyntheticRoleFieldAccess srcMethod = (SyntheticRoleFieldAccess)method;
                srcMethod.resolveTypes();
                srcMethod.resolvedField();
                CopyInheritance.copySyntheticMethod(srcMethod, tgtTeamDecl, tgtTeamDecl);
            }
            ++n2;
        }
    }

    private static void copySyntheticMethod(SyntheticMethodBinding srcMethod, TypeDeclaration tgtTypeDecl, RoleModel tgtRoleModel, TypeDeclaration targetTeamDecl) {
        MethodBinding dstMethod = CopyInheritance.copySyntheticMethod(srcMethod, tgtTypeDecl, targetTeamDecl);
        if (dstMethod != null) {
            tgtRoleModel.addSyntheticMethodMapping(srcMethod, dstMethod);
        }
    }

    private static MethodBinding copySyntheticMethod(SyntheticMethodBinding srcMethod, TypeDeclaration tgtTypeDecl, TypeDeclaration targetTeamDecl) {
        int lineNumber;
        MethodBinding dstMethod = null;
        boolean isSuperAccess = false;
        if ((srcMethod.modifiers & 0x1000) != 0) {
            switch (srcMethod.purpose) {
                case 3: {
                    isSuperAccess = true;
                }
                case 1: {
                    FieldBinding srcField = srcMethod instanceof SyntheticRoleFieldAccess ? ((SyntheticRoleFieldAccess)srcMethod).resolvedField() : srcMethod.targetReadField;
                    FieldBinding dstField = ConstantPoolObjectMapper.mapField(srcMethod, srcField, targetTeamDecl.binding);
                    dstMethod = tgtTypeDecl.binding.addSyntheticMethod(dstField, true, isSuperAccess, false);
                    if (srcField.isStatic() || !(srcMethod instanceof SyntheticRoleFieldAccess)) break;
                    dstMethod.parameters[0] = srcMethod.parameters[0];
                    break;
                }
                case 4: {
                    isSuperAccess = true;
                }
                case 2: {
                    FieldBinding srcField = srcMethod instanceof SyntheticRoleFieldAccess ? ((SyntheticRoleFieldAccess)srcMethod).resolvedField() : srcMethod.targetWriteField;
                    FieldBinding dstField = ConstantPoolObjectMapper.mapField(srcMethod, srcField, targetTeamDecl.binding);
                    dstMethod = tgtTypeDecl.binding.addSyntheticMethod(dstField, false, isSuperAccess, false);
                    if (srcField.isStatic() || !(srcMethod instanceof SyntheticRoleFieldAccess)) break;
                    dstMethod.parameters[0] = srcMethod.parameters[0];
                    break;
                }
                case 7: {
                    isSuperAccess = true;
                }
                case 5: {
                    MethodBinding dstOrigMethod = ConstantPoolObjectMapper.mapMethod(srcMethod, srcMethod.targetMethod, null, targetTeamDecl.binding);
                    if (dstOrigMethod.isCallin()) {
                        dstMethod = tgtTypeDecl.binding.addSyntheticBaseCallSurrogate(dstOrigMethod);
                        break;
                    }
                    dstMethod = tgtTypeDecl.binding.addSyntheticMethod(dstOrigMethod, isSuperAccess);
                    break;
                }
                case 8: {
                    dstMethod = ConstantPoolObjectMapper.mapMethod(srcMethod, srcMethod, null, targetTeamDecl.binding);
                    if (dstMethod != null) break;
                    tgtTypeDecl.scope.problemReporter().abortDueToInternalError("Expected synthetic bridge method does not exist: " + new String(srcMethod.readableName()));
                    break;
                }
                case 23: 
                case 24: {
                    return null;
                }
                default: {
                    tgtTypeDecl.scope.problemReporter().abortDueToInternalError("Synthetic methods only partially supported");
                    return null;
                }
            }
        }
        if (dstMethod instanceof SyntheticMethodBinding && (lineNumber = srcMethod.getLineNumber()) > -1) {
            MethodBinding copySrc = srcMethod.copyInheritanceSrc;
            if (copySrc == null) {
                copySrc = srcMethod;
            }
            SyntheticMethodBinding synthMethod = (SyntheticMethodBinding)dstMethod;
            LineNumberProvider lineNoProvider = TypeModel.getLineNumberProvider(tgtTypeDecl);
            LineInfo lineInfo = lineNoProvider.addLineInfo(copySrc.declaringClass, lineNumber, 1);
            synthMethod.lineNumber = lineInfo.getOutputStartLine();
        }
        return dstMethod;
    }

    public static void connectDefaultCtor(RoleModel clazz, MethodBinding binding) {
        ReferenceBinding[] tsupers = clazz.getTSuperRoleBindings();
        if (tsupers.length == 0) {
            return;
        }
        MethodBinding[] tsuperCtors = new MethodBinding[tsupers.length];
        int j = 0;
        int i = 0;
        while (i < tsupers.length) {
            MethodBinding tsuperCtor = tsupers[i].getExactConstructor(Binding.NO_PARAMETERS);
            if (tsuperCtor != null) {
                tsuperCtors[j++] = tsuperCtor;
            }
            ++i;
        }
        if (j > 0) {
            if (j == tsupers.length) {
                binding.overriddenTSupers = tsuperCtors;
            } else {
                binding.overriddenTSupers = new MethodBinding[j];
                System.arraycopy(tsuperCtors, 0, binding.overriddenTSupers, 0, j);
            }
        }
    }

    private static void copyField(FieldBinding field, TypeDeclaration roleDeclaration) {
        roleDeclaration.getRoleModel().recordCopiedFeature(field);
        if ((field.modifiers & 0x1000) != 0) {
            roleDeclaration.binding.addCopiedSyntheticFied(field);
            return;
        }
        if ((field.otBits & 1) != 0) {
            return;
        }
        if (roleDeclaration.fields != null) {
            int i = 0;
            while (i < roleDeclaration.fields.length) {
                FieldDeclaration currentField = roleDeclaration.fields[i];
                if (CharOperation.equals(currentField.name, field.name)) {
                    if (currentField.binding != null && currentField.binding.copyInheritanceSrc != null && currentField.binding.copyInheritanceSrc == field.copyInheritanceSrc) {
                        return;
                    }
                    ProblemReporter problemReporter = currentField.isStatic() ? roleDeclaration.staticInitializerScope.problemReporter() : roleDeclaration.initializerScope.problemReporter();
                    problemReporter.implicitlyHideField(currentField);
                    return;
                }
                ++i;
            }
        }
        AstGenerator gen = new AstGenerator(roleDeclaration.sourceStart, roleDeclaration.sourceEnd);
        gen.replaceableEnclosingClass = roleDeclaration.binding.enclosingType();
        FieldDeclaration fieldDeclaration = AstConverter.createField(field, roleDeclaration, gen);
        AstEdit.addField(roleDeclaration, fieldDeclaration, true, false, false);
        if (fieldDeclaration.binding != null) {
            fieldDeclaration.binding.modifiers |= 0x8000000;
            fieldDeclaration.binding.modifiers |= field.modifiers & 0x4000000;
        }
    }

    public static MethodDeclaration createCreationMethod(TypeDeclaration teamDeclaration, RoleModel roleModel, ConstructorDeclaration constructor, MethodBinding constructorBinding, boolean needMethodBody) {
        Argument[] srcArguments;
        TypeBinding[] srcParams;
        int modifiers;
        int end;
        int start;
        boolean hasError = false;
        if (constructor != null) {
            if (constructor.isTSuper || constructor.hasErrors()) {
                return null;
            }
            if (constructor.isDefaultConstructor() && roleModel.hasBaseclassProblem()) {
                hasError = true;
            }
            start = constructor.sourceStart;
            end = constructor.sourceEnd;
            modifiers = constructor.modifiers;
            constructorBinding = constructor.binding;
        } else {
            if (TSuperHelper.isTSuper(constructorBinding)) {
                return null;
            }
            start = teamDeclaration.sourceStart;
            end = teamDeclaration.sourceEnd;
            modifiers = constructorBinding.modifiers;
        }
        int originalModifiers = -1;
        if (constructorBinding != null && (constructorBinding.isDefault() || constructorBinding.isPrivate())) {
            originalModifiers = constructorBinding.modifiers;
            MethodModel.getModel(constructorBinding).storeModifiers(originalModifiers);
        }
        AstGenerator gen = new AstGenerator(start, end);
        gen.replaceableEnclosingClass = teamDeclaration.binding;
        Argument[] newArguments = null;
        if (constructorBinding != null && (srcParams = constructorBinding.parameters) != null) {
            newArguments = AstConverter.createArgumentsFromParameters(srcParams, gen);
            if (srcParams.length == 1 && TypeBinding.equalsEquals(srcParams[0], roleModel.getInterfacePartBinding()) && (constructorBinding.isPrivate() || constructorBinding.isDefault())) {
                roleModel.getAst().scope.problemReporter().roleConstructorHiddenByLiftingConstructor(constructor);
            }
            if (Lifting.isLiftingCtor(constructorBinding)) {
                gen.addNonNullAnnotation(newArguments[0], teamDeclaration.scope.environment());
            }
        }
        if (newArguments != null && constructorBinding != null && Lifting.isLiftingCtor(constructorBinding)) {
            newArguments[0].type.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
        }
        if (newArguments != null && constructor != null && (srcArguments = constructor.arguments) != null && srcArguments.length == newArguments.length) {
            int i = 0;
            while (i < srcArguments.length) {
                newArguments[i].name = srcArguments[i].name;
                ++i;
            }
        }
        TypeReference[] exceptions = null;
        if (constructor != null) {
            if (constructor.thrownExceptions != null) {
                exceptions = AstClone.copyTypeArray(constructor.thrownExceptions);
            }
        } else if (constructorBinding != null) {
            if (constructorBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                exceptions = AstClone.copyExceptions(constructorBinding, gen);
            }
        } else {
            throw new InternalCompilerError("Either constructor or constructorBinding must be nonnull");
        }
        MethodDeclaration newMethod = CopyInheritance.internalCreateCreationMethod(teamDeclaration, roleModel, constructorBinding, modifiers, newArguments, exceptions, needMethodBody && !hasError, start, end);
        if (hasError) {
            newMethod.tagAsHavingErrors();
        }
        if (newMethod != null) {
            MethodModel model = MethodModel.getModel(newMethod);
            model._srcCtor = constructorBinding;
            if (originalModifiers != -1) {
                model.storeModifiers(originalModifiers);
            }
        }
        if (newMethod != null && constructor != null) {
            AstClone.copySrcLocation(constructor, newMethod);
        }
        return newMethod;
    }

    private static MethodDeclaration internalCreateCreationMethod(TypeDeclaration teamDeclaration, RoleModel roleModel, MethodBinding constructor, int ctorModifiers, Argument[] newArguments, TypeReference[] thrownExceptions, boolean needMethodBody, int start, int end) {
        if ((ctorModifiers & 2) != 0) {
            return null;
        }
        char[] typeName = roleModel.getBinding().internalName();
        AstGenerator gen = new AstGenerator(start, end);
        int typeModifiers = roleModel.getBinding().modifiers;
        char[] roleName = roleModel.getName();
        TypeVariableBinding[] typeVars = roleModel.getBinding().typeVariables();
        MethodDeclaration newMethod = gen.method(teamDeclaration.compilationResult, Protections.combine(typeModifiers, ctorModifiers), CopyInheritance.createRoleTypeRef(roleName, typeVars, gen), CharOperation.concat(CREATOR_PREFIX_NAME, roleName), newArguments);
        newMethod.thrownExceptions = thrownExceptions;
        if (typeVars != Binding.NO_TYPE_VARIABLES) {
            newMethod.typeParameters = new TypeParameter[typeVars.length];
            int i = 0;
            while (i < typeVars.length) {
                newMethod.typeParameters[i] = gen.typeParameter(typeVars[i]);
                ++i;
            }
        }
        if ((typeModifiers & 0x400) != 0) {
            if ((teamDeclaration.modifiers & 0x400) != 0) {
                newMethod.modifiers |= 0x1000000;
            } else {
                MethodModel.getModel(newMethod).markAsForbiddenCreationMethod();
                newMethod.modifiers &= 0xFEFFFBFF;
            }
        }
        if (needMethodBody) {
            Expression returnExpr;
            if ((typeModifiers & 0x400) == 0) {
                Expression[] expressions = null;
                if (newArguments != null) {
                    int argumentlength = newArguments.length;
                    expressions = new Expression[argumentlength];
                    int i = 0;
                    while (i < argumentlength) {
                        expressions[i] = gen.singleNameReference(newArguments[i].name);
                        ++i;
                    }
                }
                returnExpr = gen.allocation(CopyInheritance.createRoleTypeRef(typeName, typeVars, gen), expressions);
                ((AllocationExpression)returnExpr).isGenerated = true;
            } else {
                returnExpr = gen.nullLiteral();
            }
            newMethod.setStatements(new Statement[]{gen.returnStatement(returnExpr)});
        }
        newMethod.isGenerated = true;
        AstEdit.addMethod(teamDeclaration, newMethod, false, false, constructor, false);
        return newMethod;
    }

    static TypeReference createRoleTypeRef(char[] typeName, TypeVariableBinding[] typeVars, AstGenerator gen) {
        if (typeVars != Binding.NO_TYPE_VARIABLES) {
            TypeReference[] typeArgs = new TypeReference[typeVars.length];
            int i = 0;
            while (i < typeArgs.length) {
                typeArgs[i] = gen.singleTypeReference(typeVars[i].sourceName);
                ++i;
            }
            return new ParameterizedSingleTypeReference(typeName, typeArgs, 0, gen.pos);
        }
        return gen.singleTypeReference(typeName);
    }

    public static void createCreatorIfcPart(SourceTypeBinding teamBinding, MethodDeclaration creatorDecl) {
        ReferenceBinding ifcBinding;
        MethodBinding foundMethod;
        MethodDeclaration ifcCreator = null;
        if (teamBinding.isRole() && ((foundMethod = TypeAnalyzer.findMethod(creatorDecl.scope, ifcBinding = teamBinding.roleModel.getInterfacePartBinding(), creatorDecl.selector, creatorDecl.binding.parameters)) == null || foundMethod.problemId() == 1)) {
            TypeDeclaration enclTeamDecl = teamBinding.roleModel.getTeamModel().getAst();
            ifcCreator = AstConverter.genRoleIfcMethod(enclTeamDecl, creatorDecl);
            AstEdit.addMethod(teamBinding.roleModel.getInterfaceAst(), ifcCreator);
            MethodModel.getModel((AbstractMethodDeclaration)ifcCreator)._srcCtor = creatorDecl.model._srcCtor;
        }
    }

    public static void copyCastToAndGetClassMethods(TypeDeclaration teamDecl) {
        if (teamDecl.superclass == null) {
            return;
        }
        MethodBinding[] superMethods = teamDecl.binding.superclass.availableMethods();
        int i = 0;
        while (i < superMethods.length) {
            char[] roleName;
            ReferenceBinding roleBinding;
            MethodBinding superMethod = superMethods[i];
            if (CharOperation.prefixEquals(IOTConstants.CAST_PREFIX, superMethod.selector)) {
                ReferenceBinding roleBinding2 = (ReferenceBinding)superMethod.returnType;
                RoleTypeBinding roleType = (RoleTypeBinding)RoleTypeCreator.maybeWrapUnqualifiedRoleType(teamDecl.scope, teamDecl.binding.getMemberType(roleBinding2.sourceName()), null);
                if (roleType != null) {
                    int dimensions = 0;
                    int thirdDollar = CharOperation.indexOf('$', superMethod.selector, IOTConstants.CAST_PREFIX.length);
                    if (thirdDollar > -1) {
                        char[] dimString = CharOperation.subarray(superMethod.selector, thirdDollar + 1, -1);
                        dimensions = Integer.parseInt(new String(dimString));
                    }
                    MethodBinding castMethod = StandardElementGenerator.getCastMethod(teamDecl.getTeamModel(), roleType, teamDecl.scope, dimensions, false, teamDecl.superclass.sourceStart, teamDecl.superclass.sourceEnd);
                    ReferenceBinding refType = (ReferenceBinding)castMethod.returnType;
                    castMethod.returnType = refType.weakenFrom((ReferenceBinding)superMethod.returnType);
                }
            } else if (CharOperation.prefixEquals(GET_CLASS_PREFIX, superMethods[i].selector) && !(roleBinding = teamDecl.binding.getMemberType(roleName = CharOperation.subarray(superMethods[i].selector, GET_CLASS_PREFIX.length, -1))).isBinaryBinding()) {
                RoleClassLiteralAccess.ensureGetClassMethod(teamDecl.getTeamModel(), roleBinding.roleModel);
            }
            ++i;
        }
    }

    public static MessageSend createConstructorMethodInvocationExpression(Scope scope, AllocationExpression allocationExpr) {
        if (!(allocationExpr.type instanceof SingleTypeReference)) {
            scope.problemReporter().roleCreationNotRelativeToEnclosingTeam(allocationExpr);
            allocationExpr.resolvedType = allocationExpr.type.resolvedType;
            return null;
        }
        AstGenerator gen = new AstGenerator(allocationExpr.sourceStart, allocationExpr.sourceEnd);
        char[] typeName = allocationExpr.type.getTypeName()[0];
        char[] selector = CharOperation.concat(CREATOR_PREFIX_NAME, typeName);
        Expression receiver = null;
        if (allocationExpr instanceof QualifiedAllocationExpression) {
            receiver = ((QualifiedAllocationExpression)allocationExpr).enclosingInstance;
        }
        if (receiver == null && allocationExpr.type instanceof ParameterizedSingleTypeReference) {
            ParameterizedSingleTypeReference psType = (ParameterizedSingleTypeReference)allocationExpr.type;
            if (psType.typeAnchors != null) {
                assert (psType.typeAnchors.length == 1) : "Currently only one value parameter supported.";
                receiver = psType.typeAnchors[0].anchor;
            }
        }
        if (receiver != null) {
            ReferenceBinding receiverType = (ReferenceBinding)receiver.resolvedType;
            if (receiverType != null) {
                receiverType = receiverType.getRealClass();
                Dependencies.ensureBindingState(receiverType, 6);
                if (receiverType.getMemberType(typeName) == null) {
                    scope.problemReporter().noSuchRoleInTeam(allocationExpr.type, receiverType);
                    return null;
                }
            }
        } else {
            receiver = ThisReference.implicitThis();
        }
        RoleConstructorCall message = new RoleConstructorCall(allocationExpr);
        gen.setPos(message);
        message.nameSourcePosition = gen.pos;
        message.selector = selector;
        message.receiver = receiver;
        message.arguments = allocationExpr.arguments;
        allocationExpr.resolvedType = null;
        return message;
    }

    public static void weakenInterfaceSignatures(ReferenceBinding superRoleIfc, ReferenceBinding subTeam, TypeDeclaration subRoleIfcDecl) {
        ReferenceBinding superTeam = superRoleIfc.enclosingType();
        MethodBinding[] superMethods = superRoleIfc.methods();
        CopyInheritance.checkPrivateMethods(superTeam, superMethods, subTeam, subRoleIfcDecl);
        AbstractMethodDeclaration[] oldMethods = subRoleIfcDecl.methods;
        if (oldMethods == null) {
            return;
        }
        MethodVerifier verifier = subRoleIfcDecl.scope.environment().methodVerifier();
        HashSet<AbstractMethodDeclaration> foundMethodDecls = new HashSet<AbstractMethodDeclaration>();
        HashSet<MethodBinding> foundMethodBinds = new HashSet<MethodBinding>();
        int i = 0;
        while (i < superMethods.length) {
            MethodBinding inheritedMethod = superMethods[i];
            AbstractMethodDeclaration methodFound = CopyInheritance.findMethod(superTeam, superMethods[i], subTeam, subRoleIfcDecl);
            if (methodFound != null && methodFound.binding != null) {
                if (inheritedMethod.isValidBinding()) {
                    verifier.checkAgainstImplicitlyInherited(subRoleIfcDecl.binding, subTeam, methodFound.binding, superTeam, inheritedMethod);
                }
                if (!(methodFound.isGenerated && !methodFound.hasErrors() || methodFound.isDefaultMethod())) {
                    foundMethodDecls.add(methodFound);
                    foundMethodBinds.add(methodFound.binding);
                }
            }
            ++i;
        }
        int declarationLen = oldMethods.length - foundMethodDecls.size();
        if (declarationLen == 0) {
            subRoleIfcDecl.methods = null;
        } else {
            subRoleIfcDecl.methods = new AbstractMethodDeclaration[declarationLen];
            CopyInheritance.reduceArray(oldMethods, subRoleIfcDecl.methods, foundMethodDecls);
        }
        int bindingLen = subRoleIfcDecl.binding.methods().length - foundMethodBinds.size();
        SourceTypeBinding subRoleBind = subRoleIfcDecl.binding;
        subRoleBind.reduceMethods(foundMethodBinds, bindingLen);
        ReferenceBinding[] superInterfaces = superRoleIfc.superInterfaces();
        int i2 = 0;
        while (i2 < superInterfaces.length) {
            ReferenceBinding superIfc = superInterfaces[i2];
            if (superIfc.isSynthInterface()) {
                CopyInheritance.weakenInterfaceSignatures(superIfc, subTeam, subRoleIfcDecl);
            }
            ++i2;
        }
    }

    private static void checkPrivateMethods(ReferenceBinding superTeam, MethodBinding[] superMethods, ReferenceBinding subTeam, TypeDeclaration subRoleIfcDecl) {
        RoleModel roleModel = subRoleIfcDecl.getRoleModel();
        if (roleModel == null) {
            return;
        }
        TypeDeclaration classPart = roleModel._classPart;
        if (classPart == null) {
            return;
        }
        MethodVerifier verifier = subRoleIfcDecl.scope.environment().methodVerifier();
        MethodBinding[] methodBindingArray = superMethods;
        int n = superMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding inheritedMethod = methodBindingArray[n2];
            AbstractMethodDeclaration methodFound = CopyInheritance.findMethod(superTeam, inheritedMethod, subTeam, classPart);
            if (methodFound != null && (methodFound.modifiers & 2) != 0 && methodFound.binding != null && inheritedMethod.isValidBinding()) {
                verifier.checkAgainstImplicitlyInherited(classPart.binding, subTeam, methodFound.binding, superTeam, inheritedMethod);
            }
            ++n2;
        }
    }

    public static void weakenSignaturesFromSupers(ReferenceBinding currentRole, TypeDeclaration roleClassDecl, TypeDeclaration roleIfcDecl) {
        CopyInheritance.weakenSignaturesFromExtends(roleClassDecl, roleIfcDecl, currentRole.superclass());
        ReferenceBinding[] superIfcs = currentRole.superInterfaces();
        int i = 0;
        while (i < superIfcs.length) {
            CopyInheritance.weakenSignaturesFromExtends(roleClassDecl, roleIfcDecl, superIfcs[i]);
            ++i;
        }
    }

    private static void weakenSignaturesFromExtends(TypeDeclaration roleClassDecl, TypeDeclaration roleIfcDecl, ReferenceBinding superRole) {
        if (superRole == null || !superRole.isDirectRole()) {
            return;
        }
        if (roleIfcDecl == null) {
            return;
        }
        if (TypeBinding.notEquals(roleIfcDecl.binding.erasure(), superRole.erasure())) {
            Dependencies.ensureBindingState(superRole, 16);
            MethodBinding[] superMethods = superRole.methods();
            if (superMethods != null) {
                ReferenceBinding thisTeam = roleClassDecl.binding.enclosingType();
                int i = 0;
                while (i < superMethods.length) {
                    AbstractMethodDeclaration methodDecl = CopyInheritance.findMethod(thisTeam, superMethods[i], thisTeam, roleClassDecl);
                    if (methodDecl != null) {
                        CopyInheritance.weakenSignature(methodDecl, superMethods[i]);
                    }
                    if ((methodDecl = CopyInheritance.findMethod(thisTeam, superMethods[i], thisTeam, roleIfcDecl)) != null) {
                        CopyInheritance.weakenSignature(methodDecl, superMethods[i]);
                    }
                    ++i;
                }
            }
        }
        CopyInheritance.weakenSignaturesFromSupers(superRole, roleClassDecl, roleIfcDecl);
    }

    private static TypeDeclaration findMemberType(TypeDeclaration where, char[] name) {
        if (where.memberTypes != null) {
            int i = 0;
            while (i < where.memberTypes.length) {
                if (where.memberTypes[i] != null) {
                    TypeDeclaration memberType = where.memberTypes[i];
                    if (CharOperation.equals(memberType.name, name)) {
                        return memberType;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static AbstractMethodDeclaration findMethod(ReferenceBinding givenTeam, MethodBinding givenMethod, ReferenceBinding targetTeam, TypeDeclaration targetClassDecl) {
        if (targetClassDecl.methods == null) {
            return null;
        }
        targetClassDecl.binding.getMethods(givenMethod.selector);
        int i = 0;
        while (i < targetClassDecl.methods.length) {
            block7: {
                AbstractMethodDeclaration targetMethDecl;
                block8: {
                    targetMethDecl = targetClassDecl.methods[i];
                    if (targetMethDecl == null || targetMethDecl.isClinit() || targetMethDecl.isConstructor() != givenMethod.isConstructor()) break block7;
                    if (targetMethDecl.isConstructor()) break block8;
                    MethodDeclaration md = (MethodDeclaration)targetMethDecl;
                    if (!CharOperation.equals(givenMethod.selector, md.selector)) break block7;
                }
                if (targetMethDecl.binding == null) {
                    return targetMethDecl;
                }
                if (TypeAnalyzer.isEqualMethodSignature(givenTeam, givenMethod, targetTeam, targetMethDecl.binding, 3)) {
                    return targetMethDecl;
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean weakenSignature(AbstractMethodDeclaration method, MethodBinding template) {
        MethodBinding binding = method.binding;
        if (method.isConstructor()) {
            return false;
        }
        if (binding == null || method.hasErrors()) {
            return false;
        }
        if (MethodModel.hasProblem(template)) {
            method.tagAsHavingErrors();
            return false;
        }
        MethodScope scope = method.scope;
        boolean changed = false;
        if (TypeBinding.notEquals(method.binding.returnType, template.returnType) && method.binding.returnType instanceof DependentTypeBinding) {
            method.binding.returnType = WeakenedTypeBinding.makeWeakenedTypeBinding((DependentTypeBinding)method.binding.returnType.leafComponentType(), (ReferenceBinding)template.returnType.leafComponentType(), template.returnType.dimensions());
        }
        if (Lifting.isLiftToMethod(method.binding)) {
            return changed;
        }
        int paramLen = binding.parameters.length;
        assert (paramLen == template.parameters.length);
        if (paramLen == 0) {
            return changed;
        }
        if (method.isConstructor() && binding.declaringClass.isTeam()) {
            return changed;
        }
        int i = 0;
        while (i < paramLen) {
            TypeBinding param = binding.parameters[i];
            TypeBinding tmplParam = template.parameters[i];
            if (param.isRole()) {
                binding.parameters[i] = template.parameters[i];
                if (param.isParameterizedType() && tmplParam.isParameterizedType()) {
                    TypeBinding[] args = ((ParameterizedTypeBinding)param).arguments;
                    ReferenceBinding tmplType = ((ParameterizedTypeBinding)tmplParam).genericType();
                    try {
                        LookupEnvironment env = Config.getLookupEnvironment();
                        binding.parameters[i] = new ParameterizedTypeBinding(tmplType, args, tmplType.enclosingType(), env);
                    }
                    catch (Config.NotConfiguredException e) {
                        e.logWarning("Cannot create parameterized type");
                    }
                }
            }
            ++i;
        }
        if (method.isAbstract()) {
            return changed;
        }
        if (method.isCopied) {
            return changed;
        }
        ArrayList<Statement> newLocalStats = new ArrayList<Statement>();
        int i2 = 0;
        while (i2 < method.arguments.length) {
            TypeReference newType;
            final Argument argument = method.arguments[i2];
            char[] oldName = argument.name;
            if (!RoleTypeBinding.isRoleWithExplicitAnchor(argument.type.resolvedType) && (newType = TypeAnalyzer.weakenTypeReferenceFromBinding(scope, argument.type, argument.binding.type, binding.parameters[i2])) != argument.type) {
                changed = true;
                newType.setBaseclassDecapsulation(argument.type.getBaseclassDecapsulation());
                newLocalStats.add(CopyInheritance.generateCastedLocal(argument, newType));
                if (method instanceof ConstructorDeclaration) {
                    ConstructorDeclaration ctor = (ConstructorDeclaration)method;
                    ReplaceSingleNameVisitor.IExpressionProvider provider = new ReplaceSingleNameVisitor.IExpressionProvider(){

                        @Override
                        public Expression newExpression() {
                            return new SingleNameReference(argument.name, argument.sourceStart);
                        }
                    };
                    if (ctor.constructorCall != null) {
                        ctor.constructorCall.traverse(new ReplaceSingleNameVisitor(oldName, provider), null);
                    }
                }
            }
            ++i2;
        }
        if (!binding.declaringClass.isDirectRole() && CharOperation.equals(binding.selector, IOTConstants.INIT_METHOD_NAME)) {
            return changed;
        }
        if (!newLocalStats.isEmpty()) {
            if (StateHelper.hasState(binding.declaringClass, 21)) {
                for (Statement localDeclaration : newLocalStats) {
                    localDeclaration.resolve(method.scope);
                }
            }
            MethodModel.prependStatements(method, newLocalStats);
        }
        return changed;
    }

    public static <T> void reduceArray(T[] origArray, T[] newArray, HashSet<T> filter) {
        int j = 0;
        int i = 0;
        while (i < origArray.length) {
            if (!filter.contains(origArray[i])) {
                newArray[j++] = origArray[i];
            }
            ++i;
        }
    }

    private static LocalDeclaration generateCastedLocal(Argument argument, TypeReference newType) {
        char[] oldArgName = argument.name;
        TypeReference oldType = argument.type;
        char[] newArgName = CharOperation.concat(OT_DELIM_NAME, oldArgName);
        argument.updateName(newArgName);
        argument.type = newType;
        AstGenerator gen = new AstGenerator(argument.sourceStart, argument.sourceEnd);
        LocalDeclaration localVar = gen.localVariable(oldArgName, AstClone.copyTypeReference(oldType), (Expression)gen.castExpression(gen.singleNameReference(newArgName), oldType, 0));
        localVar.modifiers = argument.modifiers;
        return localVar;
    }

    public static void weakenTeamMethodSignatures(TypeDeclaration teamDecl) {
        HashSet<AbstractMethodDeclaration> weakenedMethods = new HashSet<AbstractMethodDeclaration>();
        ReferenceBinding superTeam = teamDecl.binding.superclass();
        while (superTeam != null) {
            MethodBinding[] superMethods = superTeam.methods();
            int i = 0;
            while (i < superMethods.length) {
                AbstractMethodDeclaration tgtMethod = CopyInheritance.findMethod(superTeam, superMethods[i], teamDecl.binding, teamDecl);
                if (tgtMethod != null && !weakenedMethods.contains(tgtMethod)) {
                    CopyInheritance.weakenSignature(tgtMethod, superMethods[i]);
                    weakenedMethods.add(tgtMethod);
                }
                ++i;
            }
            superTeam = superTeam.superclass();
        }
    }

    public static boolean isCreator(MethodBinding method) {
        return CopyInheritance.isCreator(method.selector);
    }

    public static boolean isCreator(AbstractMethodDeclaration method) {
        return CopyInheritance.isCreator(method.selector);
    }

    public static boolean isCreator(char[] selector) {
        return CharOperation.prefixEquals(CREATOR_PREFIX_NAME, selector);
    }

    public static boolean needsSuperCtorCall(RoleModel role) {
        ReferenceBinding[] referenceBindingArray = role.getTSuperRoleBindings();
        int n = referenceBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding tsuperRole = referenceBindingArray[n2];
            RoleModel tsuperModel = tsuperRole.roleModel;
            if (tsuperModel != null && tsuperModel.hasFinalFieldInit()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class RoleConstructorCall
    extends MessageSend {
        public AllocationExpression allocationOrig;

        public RoleConstructorCall(AllocationExpression allocationExpr) {
            this.allocationOrig = allocationExpr;
        }

        @Override
        public TypeBinding resolveType(BlockScope blockScope) {
            MethodBinding ctor;
            TypeBinding result = super.resolveType(blockScope);
            ReferenceBinding roleType = (ReferenceBinding)this.resolvedType;
            if (roleType != null && roleType.isValidBinding() && Lifting.isLiftToConstructor(ctor = roleType.getExactConstructor(this.binding.parameters), roleType) && this.arguments != null && this.arguments.length > 0) {
                Expression currentArg = this.arguments[0];
                while (currentArg instanceof CastExpression) {
                    currentArg = ((CastExpression)currentArg).expression;
                }
                if (currentArg instanceof AllocationExpression || currentArg instanceof MessageSend && CopyInheritance.isCreator(((MessageSend)currentArg).binding)) {
                    TypeBinding allocType = currentArg.resolvedType;
                    Config confBak = Config.createOrResetConfig(this);
                    try {
                        if (allocType.isCompatibleWith(roleType.baseclass()) && !Config.getLoweringRequired()) {
                            TypeBinding typeBinding = result;
                            return typeBinding;
                        }
                    }
                    finally {
                        Config.removeOrRestore(confBak, this);
                    }
                }
                blockScope.problemReporter().liftCtorArgNotAllocation(ctor, this, roleType.baseclass());
                this.binding.roleCreatorRequiringRuntimeCheck = true;
            }
            return result;
        }

        @Override
        protected TypeBinding afterMethodLookup(Scope scope, AnchorMapping anchorMapping, TypeBinding[] argumentTypes, TypeBinding returnType) {
            MethodModel model;
            this.allocationOrig.binding = this.binding;
            if (this.binding instanceof ProblemMethodBinding) {
                this.allocationOrig.binding = ((ProblemMethodBinding)this.binding).closestMatch;
            }
            if (this.allocationOrig.binding != null && (model = this.allocationOrig.binding.model) != null && model._srcCtor != null) {
                this.allocationOrig.binding = model._srcCtor;
            }
            return super.afterMethodLookup(scope, anchorMapping, argumentTypes, returnType);
        }
    }

    static class SupertypeObligation {
        ReferenceBinding thatSuperType;
        ReferenceBinding thisSuperType;
        ASTNode location;
        ReferenceBinding outerTSuper;

        SupertypeObligation(ReferenceBinding thisSupertype, ReferenceBinding thatSupertype, ASTNode location, ReferenceBinding outerTSuper) {
            this.thisSuperType = thisSupertype;
            this.thatSuperType = thatSupertype;
            this.location = location;
            this.outerTSuper = outerTSuper;
        }

        void check(TypeDeclaration subRole) {
            if (!this.thisSuperType.isCompatibleWith(this.thatSuperType)) {
                subRole.scope.problemReporter().incompatibleSuperclasses(this.location != null ? this.location : subRole, this.thisSuperType, this.thatSuperType, this.outerTSuper);
            }
        }
    }
}

