/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLowerExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.ArrayLowering;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.DeclaredLifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ProblemAnchorBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.IDependentTypeSubstitution;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class RoleTypeCreator
implements TagBits {
    static boolean doingSignatures = false;

    public static TypeBinding maybeWrapQualifiedRoleType(final Scope scope, final Expression anchorExpr, TypeBinding typeToWrap, final ASTNode typedNode) {
        if (typeToWrap == null) {
            return null;
        }
        if (TSuperHelper.isMarkerInterface(typeToWrap)) {
            return typeToWrap;
        }
        TypeBinding originalType = typeToWrap;
        int dimensions = typeToWrap.dimensions();
        if (!((typeToWrap = typeToWrap.leafComponentType()) instanceof ReferenceBinding) || typeToWrap.isEnum()) {
            return originalType;
        }
        ReferenceBinding refBinding = (ReferenceBinding)typeToWrap;
        if (scope instanceof BlockScope && RoleTypeCreator.avoidWrapRoleType((BlockScope)scope, anchorExpr)) {
            return originalType;
        }
        if (refBinding instanceof CaptureBinding) {
            return ((CaptureBinding)refBinding).maybeWrapQualifiedRoleType(scope, anchorExpr, typedNode, originalType);
        }
        TypeBinding wrappedRoleType = RoleTypeCreator.internalWrapQualifiedRoleType(scope, anchorExpr, originalType, typedNode, refBinding, dimensions);
        return wrappedRoleType.maybeWrapRoleType(typedNode, new TypeArgumentUpdater(){

            @Override
            public TypeBinding updateArg(ReferenceBinding arg) {
                if (arg instanceof WildcardBinding) {
                    return ((WildcardBinding)arg).maybeWrapQualifiedRoleType(scope, anchorExpr, typedNode);
                }
                return arg;
            }
        });
    }

    static TypeBinding internalWrapQualifiedRoleType(final Scope scope, final Expression anchorExpr, TypeBinding originalType, final ASTNode typedNode, ReferenceBinding refBinding, int dimensions) {
        SourceTypeBinding site = scope.enclosingSourceType();
        assert (site != null);
        boolean needAnchor = true;
        ITeamAnchor existingAnchor = RoleTypeCreator.retrieveAnchor(refBinding);
        if (existingAnchor == null) {
            if (!refBinding.isDirectRole()) {
                return originalType.maybeWrapRoleType(typedNode, new TypeArgumentUpdater(){

                    @Override
                    public TypeBinding updateArg(ReferenceBinding arg) {
                        return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, anchorExpr, arg, typedNode);
                    }
                });
            }
        } else {
            needAnchor = !(existingAnchor instanceof TThisBinding) ? false : TeamModel.findEnclosingTeamContainingRole(site, refBinding) == null;
        }
        ProblemReporter problemReporter = scope.problemReporter();
        ITeamAnchor variableBinding = RoleTypeCreator.getAnchorVariableBinding(site, anchorExpr, refBinding, needAnchor ? problemReporter : null, typedNode);
        if (problemReporter.referenceContext == null) {
            class NullReporter
            extends ProblemReporter {
                NullReporter(ProblemReporter orig) {
                    super(orig.policy, orig.options, orig.problemFactory);
                }

                @Override
                public void handle(int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, ReferenceContext context, CompilationResult unitResult) {
                }
            }
            problemReporter = new NullReporter(problemReporter);
        }
        boolean decapsulationAllowed = false;
        if (typedNode instanceof Expression) {
            decapsulationAllowed = ((Expression)typedNode).getBaseclassDecapsulation().isAllowed();
        }
        if (variableBinding instanceof VariableBinding && (((VariableBinding)variableBinding).otBits & 2) != 0) {
            if (!refBinding.isRoleType()) {
                return variableBinding.getDependentTypeBinding(refBinding, -1, null, dimensions);
            }
            return originalType;
        }
        if (variableBinding == null) {
            if (needAnchor) {
                problemReporter.missingTypeAnchor(typedNode, refBinding);
            }
        } else if (variableBinding == RoleTypeBinding.NoAnchor) {
            if (existingAnchor != null) {
                variableBinding = TeamAnchor.maybeImproveAnchor(site, existingAnchor, anchorExpr);
                if (variableBinding != null && variableBinding != existingAnchor) {
                    return variableBinding.getRoleTypeBinding(refBinding, dimensions);
                }
                return originalType;
            }
            if (needAnchor) {
                problemReporter.noTeamAnchorInScope(anchorExpr, refBinding);
            }
        } else {
            if (!variableBinding.isFinal()) {
                TypeBinding variableType = variableBinding.getResolvedType();
                if (variableType.isRole()) {
                    variableType = ((ReferenceBinding)variableType).getRealClass();
                }
                variableBinding = new LocalVariableBinding(variableBinding.internalName(), variableType, 16, false){

                    @Override
                    public int problemId() {
                        return 112209;
                    }
                };
            }
            if (!(variableBinding instanceof TThisBinding || RoleTypeCreator.isThisLike(anchorExpr) || refBinding.isPublic() || decapsulationAllowed)) {
                problemReporter.externalizingNonPublicRole(typedNode, refBinding);
            } else {
                if (existingAnchor != null && !(existingAnchor instanceof TThisBinding) && !existingAnchor.hasSameBestNameAs(variableBinding) && (variableBinding = TeamAnchor.maybeImproveAnchor(site, existingAnchor, anchorExpr)) == null) {
                    return originalType;
                }
                TypeBinding[] typeArguments = refBinding.isParameterizedType() ? ((ParameterizedTypeBinding)refBinding).arguments : null;
                return RoleTypeCreator.getAnchoredType(scope, typedNode, variableBinding, refBinding, typeArguments, dimensions);
            }
        }
        return originalType;
    }

    private static boolean isThisLike(Expression expression) {
        if (expression instanceof SingleNameReference) {
            return ((SingleNameReference)expression).isThisLike;
        }
        return false;
    }

    static ITeamAnchor retrieveAnchor(ReferenceBinding refBinding) {
        if (refBinding instanceof DependentTypeBinding) {
            return ((DependentTypeBinding)refBinding)._teamAnchor;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeBinding maybeWrapQualifiedRoleType(MessageSend send, BlockScope scope) {
        Expression receiver = send.receiver;
        TypeBinding returnType = send.binding.returnType;
        if (returnType == null) return returnType;
        if (!(returnType.leafComponentType() instanceof ReferenceBinding)) return returnType;
        if (returnType.leafComponentType().isEnum()) {
            return returnType;
        }
        int dimensions = returnType.dimensions();
        ReferenceBinding refReturn = (ReferenceBinding)returnType.leafComponentType();
        if (send.expectedType != null && !(send.expectedType instanceof DependentTypeBinding) && refReturn.isRole() && !refReturn.isPublic() && returnType.isCompatibleWith(send.expectedType)) {
            return returnType;
        }
        boolean isCalloutGet = CharOperation.prefixEquals(IOTConstants.OT_GETFIELD, send.selector);
        AbstractMethodDeclaration referenceMethod = scope.methodScope().referenceMethod();
        if (referenceMethod != null) {
            isCalloutGet &= referenceMethod.isMappingWrapper.callout();
        }
        if (!isCalloutGet) {
            if (refReturn instanceof WeakenedTypeBinding) {
                WeakenedTypeBinding weakenedReturn = (WeakenedTypeBinding)refReturn;
                if (dimensions > 0) {
                    throw new InternalCompilerError("array not yet supported in this position");
                }
                DependentTypeBinding strongType = weakenedReturn.getStrongType();
                if (!TypeBinding.notEquals(((ReferenceBinding)strongType).getRealType(), weakenedReturn.weakenedType)) return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, send.receiver, strongType, send);
                if (send.expectedType != null) {
                    if (weakenedReturn.weakenedType.isCompatibleWith(send.expectedType)) return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, send.receiver, strongType, send);
                }
                send.valueCast = strongType;
                return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, send.receiver, strongType, send);
            }
            if (!(refReturn instanceof RoleTypeBinding)) return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, receiver, returnType, send);
            RoleTypeBinding roleReturn = (RoleTypeBinding)refReturn;
            if (roleReturn._argumentPosition > -1 && send.binding.original() == roleReturn._declaringMethod.getMethod()) {
                ReferenceBinding roleEnclosing = roleReturn.enclosingType();
                Expression anchorExpr = send.arguments[roleReturn._argumentPosition];
                TypeBinding anchorType = anchorExpr.resolvedType;
                ITeamAnchor anchor = null;
                if (anchorType.isRole() && ((ReferenceBinding)anchorType).isCompatibleViaLowering(roleEnclosing)) {
                    if (!anchorExpr.isThis()) return returnType;
                    anchor = ((ReferenceBinding)anchorType).getField(IOTConstants._OT_BASE, true);
                    return anchor.getRoleTypeBinding(roleReturn, returnType.dimensions());
                } else {
                    if (anchorType.isRole()) {
                        anchorType = ((ReferenceBinding)anchorType).getRealClass();
                    }
                    if (!anchorType.isCompatibleWith(roleEnclosing)) {
                        return returnType;
                    }
                    anchor = (ITeamAnchor)((Object)((NameReference)anchorExpr).binding);
                }
                return anchor.getRoleTypeBinding(roleReturn, returnType.dimensions());
            }
            ITeamAnchor anchor = roleReturn._teamAnchor;
            ReferenceBinding receiverType = (ReferenceBinding)send.actualReceiverType;
            if (anchor instanceof TThisBinding && (receiverType.isTeam() || receiverType.isRole())) {
                roleReturn = (RoleTypeBinding)TeamModel.strengthenRoleType(receiverType, roleReturn);
                returnType = dimensions > 0 ? roleReturn.getArrayType(dimensions) : roleReturn;
            }
            if (!RoleTypeCreator.avoidWrapRoleType(scope, receiver)) return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, receiver, returnType, send);
            return returnType;
        }
        if (send.arguments == null) return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, receiver, returnType, send);
        if (send.arguments.length <= 0) return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, receiver, returnType, send);
        receiver = new SingleNameReference(IOTConstants._OT_BASE, 0L);
        receiver.resolve(scope);
        return RoleTypeCreator.maybeWrapQualifiedRoleType(scope, receiver, returnType, send);
    }

    static boolean avoidWrapRoleType(BlockScope scope, Expression receiver) {
        if (scope.compilerOptions().weavingScheme == CompilerOptions.WeavingScheme.OTRE) {
            return CallinImplementor.avoidWrapRoleType(scope, receiver);
        }
        return RoleTypeCreator.isThisLike(receiver);
    }

    public static ITeamAnchor getAnchorFromQualifiedReceiver(ReferenceBinding site, ReferenceBinding type, VariableBinding firstVariable, FieldBinding[] otherBindings, boolean mergePath, ProblemReporter problemReporter, Expression node, long[] positions) {
        assert (firstVariable.type instanceof ReferenceBinding);
        ITeamAnchor candidateTeam = null;
        candidateTeam = firstVariable.asAnchorFor(type);
        if (candidateTeam != null && !candidateTeam.isFinal()) {
            assert (problemReporter != null && positions != null);
            SingleNameReference anchorExpr = new SingleNameReference(firstVariable.name, positions[0]);
            problemReporter.anchorPathNotFinal(anchorExpr, candidateTeam, type.readableName());
            return null;
        }
        if (otherBindings != null) {
            ITeamAnchor currentVariable = firstVariable;
            int i = 0;
            while (i < otherBindings.length) {
                if ((currentVariable = otherBindings[i].setPathPrefix(currentVariable)).hasValidReferenceType()) {
                    if (!currentVariable.isFinal()) {
                        if (problemReporter != null) {
                            assert (positions != null);
                            int start = (int)(positions[0] >>> 32);
                            int end = (int)(positions[i + 1] & 0xFFFFFFFFFFFFFFFFL);
                            QualifiedNameReference fakedAnchor = new QualifiedNameReference(new char[0][], new long[0], start, end);
                            problemReporter.anchorPathNotFinal(fakedAnchor, currentVariable, type.readableName());
                        }
                        return null;
                    }
                    if (currentVariable.isTeamContainingRole(type)) {
                        candidateTeam = currentVariable;
                    }
                }
                ++i;
            }
        }
        if (candidateTeam == null) {
            if (type instanceof RoleTypeBinding && ((RoleTypeBinding)type).hasExplicitAnchor()) {
                if (mergePath) {
                    ITeamAnchor anchor = TeamAnchor.maybeImproveAnchor(site, ((RoleTypeBinding)type)._teamAnchor, node);
                    if (anchor != null) {
                        return anchor;
                    }
                } else {
                    return null;
                }
            }
            if (problemReporter != null) {
                problemReporter.noTeamAnchorInScope(node, type);
            }
        } else if (type instanceof RoleTypeBinding && ((RoleTypeBinding)type).hasExplicitAnchor() && mergePath) {
            candidateTeam = ((RoleTypeBinding)type)._teamAnchor.setPathPrefix(candidateTeam);
        }
        return candidateTeam;
    }

    public static TypeBinding maybeWrapUnqualifiedRoleType(Scope scope, TypeBinding typeToWrap, ASTNode typedNode) {
        ReferenceBinding site = scope.enclosingSourceType();
        MethodScope methodScope = scope.methodScope();
        if (methodScope != null && methodScope.referenceMethod() != null && methodScope.referenceMethod().isMappingWrapper._callin() && scope.compilerOptions().weavingScheme == CompilerOptions.WeavingScheme.OTRE) {
            char[] selector = methodScope.referenceMethod().selector;
            int secondDollar = CharOperation.indexOf('$', selector, 4);
            char[] roleName = CharOperation.subarray(selector, 4, secondDollar);
            site = ((ReferenceBinding)site).getMemberType(roleName);
        }
        return RoleTypeCreator.maybeWrapUnqualifiedRoleType(scope, site, typeToWrap, typedNode, scope.problemReporter());
    }

    public static TypeBinding maybeWrapUnqualifiedRoleType(TypeBinding typeToWrap, ReferenceBinding site) {
        return RoleTypeCreator.maybeWrapUnqualifiedRoleType(null, site, typeToWrap, null, null);
    }

    public static TypeBinding maybeWrapUnqualifiedRoleType(final Scope scope, final ReferenceBinding site, TypeBinding typeToWrap, final ASTNode typedNode, ProblemReporter problemReporter) {
        assert (site != null);
        if (typeToWrap == null) {
            return null;
        }
        if (!typeToWrap.isValidBinding()) {
            return typeToWrap;
        }
        if (TSuperHelper.isMarkerInterface(typeToWrap)) {
            return typeToWrap;
        }
        TypeBinding originalType = typeToWrap;
        int dimensions = typeToWrap.dimensions();
        typeToWrap = typeToWrap.leafComponentType();
        TypeBinding[] arguments = null;
        if (typeToWrap.isParameterizedType()) {
            arguments = ((ParameterizedTypeBinding)typeToWrap).arguments;
        }
        if (!(typeToWrap instanceof ReferenceBinding) || typeToWrap.isEnum()) {
            return originalType;
        }
        if (typeToWrap instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)typeToWrap).deferredWrappableType(scope, site, typedNode, problemReporter);
        }
        if (typeToWrap instanceof IntersectionTypeBinding18) {
            return originalType;
        }
        ReferenceBinding refBinding = (ReferenceBinding)typeToWrap;
        if (!refBinding.isDirectRole()) {
            final ProblemReporter reporter = problemReporter;
            return originalType.maybeWrapRoleType(typedNode, new TypeArgumentUpdater(){

                @Override
                public TypeBinding updateArg(ReferenceBinding arg) {
                    return RoleTypeCreator.maybeWrapUnqualifiedRoleType(scope, site, arg, typedNode, reporter);
                }
            });
        }
        if (typeToWrap instanceof RoleTypeBinding) {
            RoleTypeBinding roleType = (RoleTypeBinding)typeToWrap;
            if (!(roleType._teamAnchor instanceof TThisBinding)) {
                return originalType;
            }
            if (TeamModel.findEnclosingTeamContainingRole(site, roleType) != null) {
                problemReporter = null;
            }
        }
        VariableBinding variableBinding = null;
        ReferenceBinding teamBinding = TeamModel.findEnclosingTeamContainingRole(site, refBinding);
        if (teamBinding != null) {
            variableBinding = TThisBinding.getTThisForRole(refBinding, teamBinding);
        }
        if (variableBinding == null) {
            variableBinding = RoleTypeCreator.cannotWrapType(refBinding, problemReporter, typedNode);
        }
        assert (variableBinding != null);
        if (variableBinding == RoleTypeBinding.NoAnchor) {
            return originalType;
        }
        if (!variableBinding.isFinal()) {
            if (problemReporter != null) {
                problemReporter.anchorPathNotFinal(null, variableBinding, refBinding.sourceName());
            }
            return null;
        }
        if (!(variableBinding instanceof TThisBinding) && !refBinding.isPublic()) {
            if (problemReporter != null) {
                problemReporter.externalizingNonPublicRole(typedNode, refBinding);
            }
            return null;
        }
        return RoleTypeCreator.getAnchoredType(scope, typedNode, variableBinding, refBinding, arguments, dimensions);
    }

    public static TypeBinding maybeWrapUnqualifiedRoleType(TypeBinding typeToWrap, Scope scope, ASTNode typedNode) {
        return RoleTypeCreator.maybeWrapUnqualifiedRoleType(scope, typeToWrap, typedNode);
    }

    public static void wrapTypesInMethodDeclSignature(MethodBinding method, @NonNull AbstractMethodDeclaration decl) {
        ReferenceBinding sourceDeclaringType;
        if (decl.ignoreFurtherInvestigation || method == null || method.isSynthetic()) {
            return;
        }
        if ((method.otBits & 1) != 0) {
            return;
        }
        doingSignatures = true;
        method.otBits |= 1;
        ReferenceBinding site = method.declaringClass;
        assert (!(site instanceof BinaryTypeBinding));
        TypeReference typedExpr = null;
        if (decl instanceof MethodDeclaration) {
            typedExpr = ((MethodDeclaration)decl).returnType;
        }
        LocalVariableBinding defaultAnchor = null;
        if (method.model != null && method.model._thisSubstitution != null && (sourceDeclaringType = (ReferenceBinding)method.model._thisSubstitution.binding.type).getRealClass().isTeam()) {
            method.model._thisSubstitution.bind(decl.scope, null, true);
            defaultAnchor = method.model._thisSubstitution.binding;
        }
        if (CopyInheritance.isCreator(method) || Lifting.isLiftToMethod(method)) {
            DependentTypeBinding roleType;
            int dimensions = method.returnType.dimensions();
            ReferenceBinding returnRef = (ReferenceBinding)method.returnType.leafComponentType();
            TThisBinding anchor = method.declaringClass.getTeamModel().getTThis();
            TypeBinding roleArrayType = anchor.getRoleTypeBinding(returnRef, dimensions);
            ReferenceBinding lastType = roleType = (DependentTypeBinding)roleArrayType.leafComponentType();
            char[] typeName = CharOperation.subarray(decl.selector, IOTConstants.CREATOR_PREFIX_NAME.length, -1);
            while (site != null) {
                ReferenceBinding memberType = site.getMemberType(typeName);
                if (memberType == null) break;
                lastType = memberType;
                site = site.superclass();
            }
            method.returnType = WeakenedTypeBinding.requireWeakening(roleType, lastType) ? WeakenedTypeBinding.makeWeakenedTypeBinding(roleType, lastType, dimensions) : roleArrayType;
        } else {
            method.returnType = RoleTypeCreator.maybeWrapSignatureType(method.returnType, decl.scope, typedExpr, defaultAnchor);
            RoleTypeCreator.checkArrayLoweringForReturn(method, decl.scope);
        }
        TypeBinding[] parameters = method.parameters;
        Argument[] arguments = decl.arguments;
        int i = 0;
        while (i < parameters.length) {
            Argument argument = arguments != null ? arguments[i] : null;
            parameters[i] = RoleTypeCreator.maybeWrapSignatureType(parameters[i], decl.scope, argument, defaultAnchor);
            if (argument != null && argument.binding != null) {
                argument.binding.type = parameters[i];
            }
            ++i;
        }
        doingSignatures = false;
    }

    private static void checkArrayLoweringForReturn(MethodBinding method, BlockScope scope) {
        int dimensions = method.returnType.dimensions();
        if (dimensions == 0) {
            return;
        }
        if (method.declaringClass.isRole() && !method.isPublic() || method.isPrivate()) {
            return;
        }
        TypeBinding leafReturn = method.returnType.leafComponentType();
        if (!leafReturn.isRole()) {
            return;
        }
        TypeBinding baseType = ((ReferenceBinding)leafReturn).baseclass();
        if (baseType == null) {
            return;
        }
        baseType = scope.createArrayType(baseType, dimensions);
        new ArrayLowering(null).ensureTransformMethod(scope, null, method.returnType, baseType, false);
    }

    private static TypeBinding maybeWrapSignatureType(TypeBinding type, MethodScope scope, ASTNode typedNode, ITeamAnchor defaultAnchor) {
        if (defaultAnchor != null && !type.leafComponentType().isBaseType() && defaultAnchor.isTeamContainingRole((ReferenceBinding)type.leafComponentType())) {
            return defaultAnchor.getDependentTypeBinding((ReferenceBinding)type.leafComponentType(), 0, Binding.NO_PARAMETERS, type.dimensions());
        }
        return RoleTypeCreator.maybeWrapUnqualifiedRoleType(type, scope, typedNode);
    }

    public static void wrapTypesInMethodBindingSignature(MethodBinding method, LookupEnvironment environment) {
        if ((method.otBits & 1) != 0) {
            return;
        }
        doingSignatures = true;
        try {
            method.otBits |= 1;
            ReferenceBinding site = method.declaringClass;
            if (method.anchorList != null) {
                method.anchorList.wrapTypes(environment);
            }
            if (CopyInheritance.isCreator(method)) {
                ReferenceBinding returnRef = (ReferenceBinding)method.returnType;
                ReferenceBinding team0 = returnRef.enclosingType();
                if (team0 == null || team0.getTeamModel() == null) {
                    return;
                }
                TThisBinding anchor0 = team0.getTeamModel().getTThis();
                DependentTypeBinding type1 = (DependentTypeBinding)anchor0.getRoleTypeBinding(returnRef, returnRef.dimensions());
                TThisBinding anchor = method.declaringClass.getTeamModel().getTThis();
                method.returnType = type1.maybeInstantiate(anchor, 0);
            } else if (!CharOperation.prefixEquals(DeclaredLifting.OT_LIFT_DYNAMIC, method.selector)) {
                method.returnType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(method.returnType, site);
            }
            TypeBinding[] parameters = method.parameters;
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = RoleTypeCreator.maybeWrapUnqualifiedRoleType(parameters[i], site);
                ++i;
            }
        }
        finally {
            doingSignatures = false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static ITeamAnchor getAnchorVariableBinding(ReferenceBinding site, Expression anchorExpr, ReferenceBinding roleType, ProblemReporter problemReporter, ASTNode typedNode) {
        ReferenceBinding teamBinding;
        ITeamAnchor anchorBinding;
        block35: {
            block33: {
                block38: {
                    block37: {
                        block36: {
                            block34: {
                                anchorBinding = null;
                                if (anchorExpr instanceof CastExpression) {
                                    CastExpression cast = (CastExpression)anchorExpr;
                                    if (RoleTypeBinding.isRoleWithExplicitAnchor(cast.resolvedType)) {
                                        anchorBinding = ((RoleTypeBinding)cast.resolvedType)._teamAnchor;
                                    } else {
                                        anchorExpr = ((CastExpression)anchorExpr).expression;
                                    }
                                }
                                if (anchorExpr instanceof PotentialLowerExpression) {
                                    anchorExpr = ((PotentialLowerExpression)anchorExpr).expression;
                                }
                                if (!(anchorExpr instanceof ThisReference)) break block34;
                                teamBinding = (ReferenceBinding)anchorExpr.resolvedType;
                                ReferenceBinding enclosingTeam = TeamModel.findEnclosingTeamContainingRole(teamBinding, roleType);
                                if (enclosingTeam == null) {
                                    if (problemReporter != null) {
                                        void var8_11;
                                        Expression expression = anchorExpr;
                                        if (expression.sourceEnd == 0) {
                                            ASTNode aSTNode = typedNode;
                                        }
                                        problemReporter.typeAnchorNotEnclosingTeam((ASTNode)var8_11, teamBinding, roleType);
                                    }
                                    return null;
                                }
                                anchorBinding = TThisBinding.getTThisForRole(roleType, enclosingTeam);
                                if (anchorBinding == null) {
                                    return RoleTypeCreator.cannotWrapType(roleType, problemReporter, typedNode);
                                }
                                break block35;
                            }
                            if (anchorExpr instanceof TypeAnchorReference && ((TypeAnchorReference)anchorExpr).isExpression) {
                                anchorExpr = ((TypeAnchorReference)anchorExpr).anchor;
                            }
                            if (anchorExpr instanceof ArrayReference) {
                                anchorExpr = ((ArrayReference)anchorExpr).receiver;
                            }
                            if (!(anchorExpr instanceof FieldReference)) break block36;
                            anchorBinding = ((Reference)anchorExpr).fieldBinding();
                            break block33;
                        }
                        if (!anchorExpr.isTypeReference()) break block37;
                        anchorBinding = null;
                        teamBinding = TeamModel.findEnclosingTeamContainingRole(site, roleType);
                        if (teamBinding == null) {
                            if (problemReporter != null) {
                                problemReporter.missingTypeAnchor(anchorExpr, roleType);
                            }
                            return null;
                        }
                        anchorBinding = TThisBinding.getTThisForRole(roleType, teamBinding);
                        if (anchorBinding == null) {
                            if (problemReporter != null) {
                                problemReporter.typeAnchorIsNotAVariable(anchorExpr, roleType.sourceName());
                            }
                            return null;
                        }
                        break block33;
                    }
                    if (!(anchorExpr instanceof NameReference)) break block38;
                    if (anchorExpr instanceof QualifiedNameReference) {
                        QualifiedNameReference qRef = (QualifiedNameReference)anchorExpr;
                        anchorBinding = RoleTypeCreator.getAnchorFromQualifiedReceiver(site, roleType, (VariableBinding)qRef.binding, qRef.otherBindings, false, problemReporter, anchorExpr, qRef.sourcePositions);
                        if (anchorBinding == null) {
                            return RoleTypeBinding.NoAnchor;
                        }
                        break block33;
                    } else if (((NameReference)anchorExpr).binding instanceof VariableBinding) {
                        ITeamAnchor[] anchors;
                        anchorBinding = (ITeamAnchor)((Object)((NameReference)anchorExpr).binding);
                        if (roleType.isTypeVariable() && (anchors = ((TypeVariableBinding)roleType).anchors) != null) {
                            return anchorBinding;
                        }
                        break block33;
                    } else {
                        if (problemReporter != null) {
                            problemReporter.typeAnchorIsNotAVariable(anchorExpr, roleType.sourceName());
                        }
                        return null;
                    }
                }
                if (anchorExpr instanceof QualifiedAllocationExpression) {
                    QualifiedAllocationExpression allocation = (QualifiedAllocationExpression)anchorExpr;
                    return ((RoleTypeBinding)allocation.resolvedType)._teamAnchor;
                }
                if (anchorExpr instanceof MessageSend) {
                    TypeBinding receiverLeaf = ((MessageSend)anchorExpr).actualReceiverType.leafComponentType();
                    if (RoleTypeBinding.isRoleWithExplicitAnchor(receiverLeaf)) {
                        anchorBinding = ((RoleTypeBinding)receiverLeaf)._teamAnchor;
                        break block33;
                    } else {
                        if (anchorExpr.resolvedType != null && anchorExpr.resolvedType.isRoleType()) {
                            return ((DependentTypeBinding)anchorExpr.resolvedType)._teamAnchor;
                        }
                        return RoleTypeCreator.cannotWrapType(roleType, problemReporter, typedNode);
                    }
                }
                if (anchorExpr instanceof AllocationExpression) {
                    String displayName = "fresh-instance-of-" + ((AllocationExpression)anchorExpr).type.toString();
                    LocalVariableBinding fakeVariable = new LocalVariableBinding(displayName.toCharArray(), (TypeBinding)roleType.enclosingType(), 16, false);
                    fakeVariable.otBits |= 2;
                    return fakeVariable;
                }
                if (anchorBinding == null) {
                    return RoleTypeCreator.cannotWrapType(roleType, problemReporter, typedNode);
                }
            }
            assert (anchorBinding != null);
        }
        if (!anchorBinding.isTeamContainingRole(roleType) && (anchorBinding = anchorBinding.retrieveAnchorFromAnchorRoleTypeFor(roleType)) == null) {
            if (roleType instanceof DependentTypeBinding && ((DependentTypeBinding)roleType).hasExplicitAnchor()) {
                return RoleTypeCreator.cannotWrapType(roleType, problemReporter, typedNode);
            }
            teamBinding = TeamModel.findEnclosingTeamContainingRole(site, roleType);
            if (teamBinding == null) {
                return RoleTypeCreator.cannotWrapType(roleType, problemReporter, typedNode);
            }
            anchorBinding = TThisBinding.getTThisForRole(roleType, teamBinding);
        }
        assert (anchorBinding != null);
        return anchorBinding.asAnchorFor(roleType);
    }

    private static VariableBinding cannotWrapType(ReferenceBinding roleType, ProblemReporter problemReporter, ASTNode typedNode) {
        if (!roleType.isRoleType() && problemReporter != null && (typedNode.bits & 0x200000) == 0) {
            ReferenceContext ctx = problemReporter.referenceContext;
            problemReporter.missingTypeAnchor(typedNode, roleType);
            problemReporter.referenceContext = ctx;
        }
        return RoleTypeBinding.NoAnchor;
    }

    public static TypeBinding resolveAnchoredType(Scope scope, Expression typeExpression, char[][] tokens, int dimensions) {
        TypeBinding resolved;
        VariableBinding anchor;
        int variableStart = 0;
        ReferenceBinding staticType = null;
        boolean havePackagePrefix = false;
        int i = 0;
        while (i < tokens.length - 2) {
            Binding staticPart = scope.getTypeOrPackage(CharOperation.subarray(tokens, 0, i + 1));
            if (staticPart == null || !staticPart.isValidBinding()) break;
            if (staticPart instanceof ReferenceBinding) {
                staticType = (ReferenceBinding)staticPart;
                variableStart = i + 1;
            } else {
                havePackagePrefix = true;
            }
            ++i;
        }
        if (staticType != null) {
            boolean isStatic = true;
            if (CharOperation.equals(tokens[variableStart], "this".toCharArray())) {
                if (++variableStart >= tokens.length) {
                    return null;
                }
                isStatic = false;
            }
            anchor = TypeAnalyzer.findField(staticType, tokens[variableStart], isStatic, true);
        } else {
            try {
                anchor = RoleTypeCreator.findResolvedVariable(scope, tokens[0], null);
            }
            catch (InternalCompilerError ice) {
                if (havePackagePrefix) {
                    return null;
                }
                throw ice;
            }
        }
        if (anchor == null) {
            return null;
        }
        ProblemReferenceBinding foundProblem = null;
        if (anchor.hasValidReferenceType() && !anchor.isFinal()) {
            if (!anchor.isTeam() && variableStart == tokens.length - 2) {
                return new ProblemReferenceBinding(tokens, null, 1);
            }
            foundProblem = new ProblemReferenceBinding(anchor, tokens[tokens.length - 1], null, 51);
        }
        if ((resolved = RoleTypeCreator.resolveOtherPathElements(scope, typeExpression, anchor, tokens, variableStart + 1, dimensions)) != null && resolved.isValidBinding() && foundProblem != null) {
            return foundProblem;
        }
        return resolved;
    }

    private static TypeBinding resolveOtherPathElements(Scope scope, Expression typeExpression, ITeamAnchor anchor, char[][] tokens, int startIdx, int dimensions) {
        ITeamAnchor current = anchor;
        int i = startIdx;
        while (i < tokens.length - 1) {
            if (!anchor.hasValidReferenceType()) {
                return null;
            }
            if ((current = current.getFieldOfType(tokens[i], false, false)) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(tokens, 0, i + 1), null, 53);
            }
            if (!current.isFinal()) {
                return new ProblemReferenceBinding(current, tokens[tokens.length - 1], null, 51);
            }
            anchor = current.setPathPrefix(anchor);
            ++i;
        }
        if (!anchor.hasValidReferenceType()) {
            return null;
        }
        if (!anchor.isTeam()) {
            ReferenceBinding anchorType = (ReferenceBinding)anchor.getResolvedType();
            ReferenceBinding last = anchorType.getMemberType(tokens[tokens.length - 1]);
            if (last == null || !last.isValidBinding()) {
                return new ProblemReferenceBinding(tokens, null, 1);
            }
            return new ProblemReferenceBinding(anchorType.compoundName, anchorType, 52);
        }
        return RoleTypeCreator.resolveRoleTypeFromAnchor(scope, typeExpression, anchor, tokens[tokens.length - 1], dimensions, scope.problemReporter());
    }

    public static VariableBinding findResolvedVariable(Scope scope, char[] name, InvocationSite site) {
        TypeDeclaration classPartAst;
        if (scope.kind == 4 || scope.kind == 5) {
            return null;
        }
        VariableBinding anchor = scope.findVariable(name, site);
        if (anchor != null) {
            return anchor;
        }
        Scope classPartScope = scope;
        TypeDeclaration type = scope.referenceType();
        if (type != null && type.isRole() && type.isInterface() && (classPartAst = type.getRoleModel().getClassPartAst()) != null) {
            classPartScope = classPartAst.scope;
        }
        if (classPartScope != scope) {
            anchor = classPartScope.findVariable(name, site);
        }
        if (anchor != null) {
            return anchor;
        }
        anchor = RoleTypeCreator.findResolvedVariable(scope.parent, name, site);
        if (anchor != null) {
            return anchor;
        }
        return RoleTypeCreator.resolveField(classPartScope, name);
    }

    private static FieldBinding resolveField(Scope scope, char[] name) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof CompilationUnitScope) {
            return null;
        }
        SourceTypeBinding type = scope.enclosingSourceType();
        return TypeAnalyzer.findField(type, name, scope.isStatic(), true);
    }

    public static TypeBinding resolveRoleTypeFromAnchor(Scope scope, Expression typeExpression, ITeamAnchor anchor, char[] roleName, int dimensions, ProblemReporter problemReporter) {
        ReferenceBinding roleType = anchor.getMemberTypeOfType(roleName);
        if (roleType == null) {
            ReferenceContext contextSave = problemReporter.referenceContext;
            Dependencies.ensureTeamState(anchor.getTeamModelOfType(), 6);
            roleType = anchor.getMemberTypeOfType(roleName);
            problemReporter.referenceContext = contextSave;
            if (roleType == null) {
                return new ProblemReferenceBinding(roleName, 1, null);
            }
        }
        return RoleTypeCreator.getAnchoredType(scope, typeExpression, anchor, roleType, null, dimensions);
    }

    public static TypeBinding getAnchoredType(Scope scope, ASTNode typedNode, ITeamAnchor variableBinding, ReferenceBinding roleBinding, TypeBinding[] arguments, int dimensions) {
        if (!(variableBinding instanceof TThisBinding)) {
            Expression.DecapsulationState decapsulation = Expression.DecapsulationState.NONE;
            if (typedNode instanceof Expression) {
                Expression expr = (Expression)typedNode;
                decapsulation = expr.getBaseclassDecapsulation(roleBinding);
            }
            int problemReason = 0;
            if (!roleBinding.isPublic()) {
                if (decapsulation.isAllowed()) {
                    if (scope != null) {
                        scope.problemReporter().decapsulation((Expression)typedNode, roleBinding);
                    }
                } else {
                    problemReason = 2;
                }
            } else if (!variableBinding.isFinal()) {
                problemReason = 51;
            }
            if (problemReason != 0) {
                return new ProblemReferenceBinding(variableBinding, roleBinding.sourceName(), roleBinding, problemReason);
            }
        }
        if (roleBinding instanceof DependentTypeBinding) {
            DependentTypeBinding wrappedRole = (DependentTypeBinding)roleBinding;
            if (wrappedRole._teamAnchor != variableBinding) {
                return wrappedRole.maybeInstantiate(variableBinding, dimensions);
            }
            if (dimensions > 0) {
                return wrappedRole.getArrayType(dimensions);
            }
            return wrappedRole;
        }
        if (!variableBinding.isTeam()) {
            throw new InternalCompilerError("ANCHOR IS NOT A TEAM");
        }
        if (!roleBinding.isInterface() && (roleBinding = roleBinding.roleModel.getInterfacePartBinding()) == null) {
            throw new InternalCompilerError("Role class has no interface");
        }
        TypeBinding typeBinding = variableBinding.getRoleTypeBinding(roleBinding, arguments, dimensions);
        return typeBinding;
    }

    public static TypeBinding getTypeAnchoredToParameter(TypeReference type, Argument[] arguments, int index, MethodScope scope, CompilationResult.CheckPoint cp) {
        if (!(type instanceof QualifiedTypeReference)) {
            return null;
        }
        QualifiedTypeReference argType = (QualifiedTypeReference)type;
        VariableBinding anchor = null;
        char[] anchorName = argType.tokens[0];
        int argPos = 0;
        while (argPos < index) {
            Argument argument = arguments[argPos];
            argument.bind(scope, argument.type.resolvedType, false);
            if (CharOperation.equals(argument.name, anchorName)) {
                argument.binding.useFlag = 1;
                anchor = argument.binding;
                if (!scope.classScope().referenceContext.isConverted) break;
                anchor.modifiers |= 0x10;
                break;
            }
            ++argPos;
        }
        if (anchor == null) {
            argPos = -1;
            anchor = RoleTypeCreator.findAnchorInScope(scope, anchorName);
        }
        if (anchor == null) {
            return null;
        }
        if (!anchor.isFinal()) {
            char[][] typeName = type.getTypeName();
            scope.problemReporter().anchorPathNotFinal(argType, anchor, typeName[typeName.length - 1]);
            return null;
        }
        if (anchor.type == null) {
            return null;
        }
        if (!anchor.type.isTeam()) {
            if (!anchor.type.isValidBinding()) {
                return null;
            }
            RoleTypeCreator.reportAnchorIsNotATeam(scope, argType);
            return null;
        }
        TypeBinding anchoredType = RoleTypeCreator.resolveOtherPathElements(scope, type, anchor, argType.tokens, 1, argType.dimensions());
        if (anchoredType != null) {
            if (!anchoredType.isValidBinding()) {
                scope.problemReporter().invalidType(type, anchoredType);
                return null;
            }
            if (anchoredType.leafComponentType().isRoleType()) {
                RoleTypeBinding leafRoleType = (RoleTypeBinding)anchoredType.leafComponentType();
                leafRoleType._argumentPosition = argPos;
                final AbstractMethodDeclaration methodDecl = scope.referenceMethod();
                leafRoleType._declaringMethod = new DependentTypeBinding.IMethodProvider(){

                    @Override
                    public MethodBinding getMethod() {
                        return methodDecl.binding;
                    }
                };
            }
            scope.referenceContext.compilationResult().rollBack(cp);
            scope.problemReporter().deprecatedPathSyntax(type);
        }
        return anchoredType;
    }

    private static boolean isConvertedArgument(ITeamAnchor anchor, Scope scope) {
        if (!(anchor instanceof VariableBinding)) {
            return false;
        }
        if ((((VariableBinding)anchor).tagBits & 0x400L) == 0L) {
            return false;
        }
        return scope.classScope().referenceContext.isConverted;
    }

    public static ITeamAnchor resolveTypeAnchoredToArgument(AbstractMethodDeclaration method, int anchorArgPos) {
        MethodScope scope = method.scope;
        Argument[] arguments = method.arguments;
        int i = 0;
        while (i <= anchorArgPos) {
            arguments[i].bind(scope, arguments[i].type.resolvedType, i == anchorArgPos);
            ++i;
        }
        LocalVariableBinding anchor = arguments[anchorArgPos].binding;
        if (anchor == null) {
            return null;
        }
        anchor.resolvedPosition = anchorArgPos;
        if (!anchor.isFinal() && !RoleTypeCreator.isConvertedArgument(anchor, scope)) {
            return new ProblemAnchorBinding(anchor, 51);
        }
        if (anchor.type == null) {
            return null;
        }
        if (!anchor.type.isTeam()) {
            if (anchor.type.isValidBinding()) {
                scope.problemReporter().illegalTypeAnchorNotATeam(arguments[anchorArgPos]);
            }
            return null;
        }
        return anchor;
    }

    private static VariableBinding findAnchorInScope(MethodScope scope, char[] anchorName) {
        SingleNameReference invocationSite = new SingleNameReference("this".toCharArray(), 0L);
        invocationSite.binding = scope.enclosingSourceType();
        Binding binding = scope.getBinding(anchorName, 3, (InvocationSite)invocationSite, true);
        if (binding instanceof VariableBinding) {
            return (VariableBinding)binding;
        }
        return null;
    }

    private static void reportAnchorIsNotATeam(MethodScope scope, QualifiedTypeReference argType) {
        char[][] tokens = CharOperation.subarray(argType.tokens, 0, argType.tokens.length - 1);
        long[] sourcePositions = new long[tokens.length];
        System.arraycopy(argType.sourcePositions, 0, sourcePositions, 0, tokens.length);
        int sourceEnd = (int)(sourcePositions[tokens.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        QualifiedNameReference prefix = new QualifiedNameReference(tokens, sourcePositions, argType.sourceStart, sourceEnd);
        scope.problemReporter().illegalTypeAnchorNotATeam(prefix);
    }

    public static ReferenceBinding findExactRole(ReferenceBinding role, ReferenceBinding site) {
        if (site != null && !doingSignatures) {
            ReferenceBinding teamBinding = TeamModel.findEnclosingTeamContainingRole(site, role);
            if (teamBinding == null) {
                return new ProblemReferenceBinding(site.sourceName(), 50, role);
            }
            return teamBinding.getMemberType(role.internalName());
        }
        return role;
    }

    public static TypeBinding wrapTypeWithAnchorFromName(TypeBinding typeToWrap, char[] anchorName, ReferenceBinding site, LookupEnvironment environment) {
        char[][] tokens;
        ReferenceBinding leafType = (ReferenceBinding)typeToWrap.leafComponentType();
        if (leafType.isRawType()) {
            leafType = ((ParameterizedTypeBinding)leafType).genericType();
        }
        if (!DependentTypeBinding.mayTakeValueParam(leafType)) {
            assert (false) : "this method should only be called for types requiring an anchor";
            return typeToWrap;
        }
        char[][] prefixTokens = tokens = CharOperation.splitOn('.', anchorName);
        ReferenceBinding typePrefix = null;
        while (prefixTokens.length > 0) {
            typePrefix = environment.askForType(prefixTokens, site.fPackage.enclosingModule);
            if (typePrefix != null) break;
            prefixTokens = CharOperation.subarray(prefixTokens, 0, prefixTokens.length - 1);
        }
        ReferenceBinding currentType = site;
        int idx = 0;
        if (typePrefix != null) {
            idx = prefixTokens.length;
            currentType = typePrefix;
        }
        ITeamAnchor currentVar = TypeAnalyzer.findField(currentType, tokens[idx++], false, true);
        int i = idx;
        while (i < tokens.length) {
            if (currentVar == null) {
                environment.problemReporter.abortDueToInternalError("Type anchor in class file " + new String(site.readableName()) + " unresolvable path component: " + new String(tokens[i - 1]));
                return null;
            }
            FieldBinding next = currentVar.getFieldOfType(tokens[i], false, true);
            currentVar = next.setPathPrefix(currentVar);
            ++i;
        }
        if (!currentVar.isTeam()) {
            environment.problemReporter.abortDueToInternalError("Type anchor in class file " + new String(site.readableName()) + " does not resolve to a team: " + new String(anchorName));
            return null;
        }
        TypeBinding[] typeArguments = typeToWrap.isParameterizedType() ? ((ParameterizedTypeBinding)typeToWrap).arguments : null;
        return currentVar.getDependentTypeBinding(leafType, -1, typeArguments, typeToWrap.dimensions());
    }

    public static ReferenceBinding maybeInstantiateFromPlayedBy(final Scope scope, ReferenceBinding baseSideType) {
        TypeArgumentUpdater typeArgumentUpdater = new TypeArgumentUpdater(){

            @Override
            public TypeBinding updateArg(ReferenceBinding arg) {
                return RoleTypeCreator.maybeInstantiateFromPlayedBy(scope, arg);
            }
        };
        if (!baseSideType.isDirectRole()) {
            return (ReferenceBinding)baseSideType.maybeWrapRoleType(null, typeArgumentUpdater);
        }
        ITeamAnchor baseSideAnchor = RoleTypeCreator.getPlayedByAnchor(scope);
        if (baseSideAnchor != null) {
            if (baseSideType instanceof DependentTypeBinding) {
                RoleTypeBinding baseSideRole = RoleTypeBinding.getRoleTypeBinding(baseSideType);
                return (ReferenceBinding)baseSideRole.maybeInstantiate(baseSideAnchor, 0);
            }
            return (ReferenceBinding)baseSideAnchor.getRoleTypeBinding(baseSideType, 0);
        }
        return baseSideType;
    }

    public static ITeamAnchor getPlayedByAnchor(Scope scope) {
        SourceTypeBinding currentType = scope.enclosingSourceType();
        ReferenceBinding baseclass = currentType.baseclass();
        if (currentType.isDirectRole() && baseclass != null) {
            if (baseclass.isDirectRole()) {
                if (baseclass instanceof WeakenedTypeBinding) {
                    baseclass = ((WeakenedTypeBinding)baseclass).getStrongType();
                }
                if (RoleTypeBinding.isRoleWithExplicitAnchor(baseclass)) {
                    return ((RoleTypeBinding)baseclass)._teamAnchor;
                }
            }
            if (baseclass.isTeam()) {
                return ((ReferenceBinding)currentType).getField(IOTConstants._OT_BASE, true);
            }
        }
        return null;
    }

    public static boolean isCompatibleViaBaseAnchor(Scope scope, TypeBinding baseType, TypeBinding roleType, int bindDir) {
        if (baseType instanceof ReferenceBinding) {
            ReferenceBinding baseAnchoredBase = RoleTypeCreator.maybeInstantiateFromPlayedBy(scope, (ReferenceBinding)baseType);
            if (bindDir == 82 ? baseAnchoredBase.isCompatibleWith(roleType) : roleType.isCompatibleWith(baseAnchoredBase)) {
                return true;
            }
        }
        return false;
    }

    public static TypeBinding deepSubstitute(TypeBinding original, LookupEnvironment environment, IDependentTypeSubstitution substitution) {
        TypeBinding substituted;
        TypeBinding type = original;
        int dimensions = type.dimensions();
        type = type.leafComponentType();
        TypeBinding[] typeArguments = null;
        boolean hasInstantiated = false;
        if (type.isParameterizedType()) {
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)type;
            if (ptb.arguments != null) {
                typeArguments = new TypeBinding[ptb.arguments.length];
                int j = 0;
                while (j < ptb.arguments.length) {
                    TypeBinding givenTypeArgument = ptb.arguments[j];
                    typeArguments[j] = RoleTypeCreator.deepSubstitute(givenTypeArgument, environment, substitution);
                    if (typeArguments[j] == null) {
                        typeArguments[j] = givenTypeArgument;
                    } else if (typeArguments[j] != givenTypeArgument) {
                        hasInstantiated = true;
                    }
                    ++j;
                }
                if (hasInstantiated) {
                    type = ptb.genericType();
                } else {
                    typeArguments = null;
                }
            }
        }
        if (type instanceof DependentTypeBinding && (substituted = substitution.substitute((DependentTypeBinding)type, typeArguments, dimensions)) != type) {
            return substituted;
        }
        if (hasInstantiated) {
            ParameterizedTypeBinding parameterized = environment.createParameterizedType((ReferenceBinding)type, typeArguments, original.enclosingType());
            if (dimensions == 0) {
                return parameterized;
            }
            return environment.createArrayType(parameterized, dimensions);
        }
        return original;
    }

    public static interface TypeArgumentUpdater {
        public TypeBinding updateArg(ReferenceBinding var1);
    }
}

