/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.lang.reflect.Field;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.objectteams.Team;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class LiftingParticipantAdapter
extends ClassVisitor {
    private static boolean checked = false;
    private static String PARTICIPANT_NAME = System.getProperty("ot.lifting.participant");
    private static final String LIFTING_PARTICIPANT_FIELD = "_OT$liftingParticipant";
    private static final String LIFT_PREFIX = "_OT$liftTo";
    private static final String CREATE_ROLE_METHOD = "createRole";
    private static final String CREATE_ROLE_DESC = "(L" + ClassNames.ITEAM_SLASH + ";L" + ClassNames.OBJECT_SLASH + ";Ljava/lang/String;)L" + ClassNames.OBJECT_SLASH + ";";

    public LiftingParticipantAdapter(ClassVisitor cv) {
        super(524288, cv);
    }

    public static synchronized boolean isLiftingParticipantConfigured(ClassLoader loader) {
        try {
            Field participantField = Team.class.getField(LIFTING_PARTICIPANT_FIELD);
            boolean shouldInstantiateAndRegister = LiftingParticipantAdapter.check(participantField);
            if (shouldInstantiateAndRegister) {
                Class<?> participantClass = loader.loadClass(PARTICIPANT_NAME);
                participantField.set(null, participantClass.newInstance());
            }
        }
        catch (Exception e) {
            new IllegalArgumentException("Lifting participant " + PARTICIPANT_NAME + " is invalid.", e).printStackTrace();
            PARTICIPANT_NAME = null;
        }
        return PARTICIPANT_NAME != null;
    }

    static synchronized boolean check(Field participantField) throws IllegalAccessException {
        if (!checked) {
            checked = true;
            Object participant = participantField.get(null);
            if (PARTICIPANT_NAME != null) {
                if (participant != null) {
                    throw new IllegalStateException("liftingParticipant already installed.");
                }
                return true;
            }
            if (participant != null) {
                PARTICIPANT_NAME = participant.getClass().getName();
            }
        }
        return false;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.startsWith(LIFT_PREFIX)) {
            MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, null, null);
            return new InstructionAdapter(this.api, methodVisitor){
                private Label done;
                {
                    this.done = null;
                }

                public void visitTypeInsn(int opcode, String type) {
                    if (this.isRelevantAllocation(opcode, type)) {
                        this.insertParticipantSequence(type);
                    }
                    super.visitTypeInsn(opcode, type);
                }

                boolean isRelevantAllocation(int opcode, String type) {
                    return opcode == 187 && !type.equals(ClassNames.LIFTING_FAILED_EXCEPTION) && !type.equals(ClassNames.LIFTING_VETO_EXCEPTION) && !type.equals(ClassNames.WRONG_ROLE_EXCEPTION);
                }

                void insertParticipantSequence(String roleType) {
                    this.getstatic(ClassNames.TEAM_SLASH, LiftingParticipantAdapter.LIFTING_PARTICIPANT_FIELD, String.valueOf('L') + ClassNames.ILIFTING_PARTICIPANT + ';');
                    this.visitVarInsn(25, 0);
                    this.visitVarInsn(25, 1);
                    this.visitLdcInsn(roleType);
                    this.invokeinterface(ClassNames.ILIFTING_PARTICIPANT, LiftingParticipantAdapter.CREATE_ROLE_METHOD, CREATE_ROLE_DESC);
                    this.dup();
                    Label doCreate = new Label();
                    this.ifnull(doCreate);
                    this.checkcast(Type.getObjectType((String)roleType));
                    this.done = new Label();
                    this.goTo(this.done);
                    this.visitLabel(doCreate);
                    this.pop();
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    if (this.done != null && opcode == 183) {
                        this.visitLabel(this.done);
                        this.done = null;
                    }
                }
            };
        }
        return null;
    }
}

