/*******************************************************************************
 * Copyright (c) 2000, 2019 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Technical University Berlin - extended API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int
		TokenNameNotAToken = 0,
	    TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;

	// BEGIN_AUTOGENERATED_REGION
	int TokenNameIdentifier = 14,
							TokenNameabstract = 56,
							TokenNameassert = 89,
							TokenNameboolean = 116,
							TokenNamebreak = 90,
							TokenNamebyte = 117,
							TokenNamecase = 115,
							TokenNamecatch = 118,
							TokenNamechar = 119,
							TokenNameclass = 74,
							TokenNamecontinue = 91,
							TokenNameconst = 151,
							TokenNamedefault = 83,
							TokenNamedo = 92,
							TokenNamedouble = 120,
							TokenNameelse = 133,
							TokenNameenum = 79,
							TokenNameextends = 100,
							TokenNamefalse = 42,
							TokenNamefinal = 57,
							TokenNamefinally = 129,
							TokenNamefloat = 121,
							TokenNamefor = 93,
							TokenNamegoto = 152,
							TokenNameif = 94,
							TokenNameimplements = 148,
							TokenNameimport = 122,
							TokenNameinstanceof = 18,
							TokenNameint = 123,
							TokenNameinterface = 78,
							TokenNamelong = 124,
							TokenNamenative = 58,
							TokenNamenew = 37,
							TokenNamenon_sealed = 59,
							TokenNamenull = 43,
							TokenNamepackage = 101,
							TokenNameprivate = 60,
							TokenNameprotected = 61,
							TokenNamepublic = 62,
							TokenNamereturn = 95,
							TokenNameshort = 125,
							TokenNamestatic = 41,
							TokenNamestrictfp = 63,
							TokenNamesuper = 35,
							TokenNameswitch = 67,
							TokenNamesynchronized = 53,
							TokenNamethis = 36,
							TokenNamethrow = 86,
							TokenNamethrows = 126,
							TokenNametransient = 64,
							TokenNametrue = 44,
							TokenNametry = 96,
							TokenNamevoid = 127,
							TokenNamevolatile = 65,
							TokenNamewhile = 87,
							TokenNamemodule = 130,
							TokenNameopen = 131,
							TokenNamerequires = 134,
							TokenNametransitive = 141,
							TokenNameexports = 135,
							TokenNameopens = 136,
							TokenNameto = 149,
							TokenNameuses = 137,
							TokenNameprovides = 138,
							TokenNamewith = 102,
							TokenNameas = 142,
							TokenNamebase = 33,
							TokenNamecallin = 66,
							TokenNameplayedBy = 150,
							TokenNameprecedence = 103,
							TokenNameteam = 54,
							TokenNametsuper = 38,
							TokenNamewhen = 99,
							TokenNamewithin = 97,
							TokenNamereplace = 143,
							TokenNameafter = 139,
							TokenNamebefore = 144,
							TokenNameget = 145,
							TokenNameset = 146,
							TokenNameIntegerLiteral = 45,
							TokenNameLongLiteral = 46,
							TokenNameFloatingPointLiteral = 47,
							TokenNameDoubleLiteral = 48,
							TokenNameCharacterLiteral = 49,
							TokenNameStringLiteral = 50,
							TokenNameTextBlock = 51,
							TokenNamePLUS_PLUS = 2,
							TokenNameMINUS_MINUS = 3,
							TokenNameEQUAL_EQUAL = 21,
							TokenNameLESS_EQUAL = 15,
							TokenNameGREATER_EQUAL = 16,
							TokenNameNOT_EQUAL = 22,
							TokenNameLEFT_SHIFT = 19,
							TokenNameRIGHT_SHIFT = 13,
							TokenNameUNSIGNED_RIGHT_SHIFT = 17,
							TokenNamePLUS_EQUAL = 104,
							TokenNameMINUS_EQUAL = 105,
							TokenNameMULTIPLY_EQUAL = 106,
							TokenNameDIVIDE_EQUAL = 107,
							TokenNameAND_EQUAL = 108,
							TokenNameOR_EQUAL = 109,
							TokenNameXOR_EQUAL = 110,
							TokenNameREMAINDER_EQUAL = 111,
							TokenNameLEFT_SHIFT_EQUAL = 112,
							TokenNameRIGHT_SHIFT_EQUAL = 113,
							TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 114,
							TokenNameOR_OR = 31,
							TokenNameAND_AND = 30,
							TokenNamePLUS = 4,
							TokenNameMINUS = 5,
							TokenNameNOT = 70,
							TokenNameREMAINDER = 10,
							TokenNameXOR = 27,
							TokenNameAND = 23,
							TokenNameMULTIPLY = 9,
							TokenNameOR = 28,
							TokenNameTWIDDLE = 71,
							TokenNameDIVIDE = 11,
							TokenNameGREATER = 12,
							TokenNameLESS = 8,
							TokenNameLPAREN = 20,
							TokenNameRPAREN = 24,
							TokenNameLBRACE = 40,
							TokenNameRBRACE = 34,
							TokenNameLBRACKET = 6,
							TokenNameRBRACKET = 73,
							TokenNameSEMICOLON = 25,
							TokenNameQUESTION = 29,
							TokenNameCOLON = 68,
							TokenNameCOMMA = 32,
							TokenNameDOT = 1,
							TokenNameEQUAL = 84,
							TokenNameAT = 39,
							TokenNameELLIPSIS = 132,
							TokenNameARROW = 81,
							TokenNameCOLON_COLON = 7,
							TokenNameBeginLambda = 52,
							TokenNameBeginIntersectionCast = 72,
							TokenNameBeginTypeArguments = 85,
							TokenNameElidedSemicolonAndRightBrace = 75,
							TokenNameAT308 = 26,
							TokenNameAT308DOTDOTDOT = 147,
							TokenNameBeginCaseExpr = 76,
							TokenNameRestrictedIdentifierYield = 88,
							TokenNameRestrictedIdentifierrecord = 80,
							TokenNameRestrictedIdentifiersealed = 55,
							TokenNameRestrictedIdentifierpermits = 140,
							TokenNameATOT = 128,
							TokenNameBINDIN = 82,
							TokenNameCALLOUT_OVERRIDE = 98,
							TokenNameSYNTHBINDOUT = 77,
							TokenNameEOF = 69,
							TokenNameERROR = 153;

	// This alias is statically inserted by GenerateParserScript.java:
	int TokenNameBINDOUT = TokenNameARROW;
}
