/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class GuardPredicateDeclaration
extends ASTNode {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(GuardPredicateDeclaration.class, "expression", Expression.class, true, false);
    public static final SimplePropertyDescriptor BASE_PROPERTY = new SimplePropertyDescriptor(GuardPredicateDeclaration.class, "base", Boolean.TYPE, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_3_0;
    private Expression expression = null;
    private boolean isBase = false;

    static {
        ArrayList propertyList = new ArrayList(3);
        GuardPredicateDeclaration.createPropertyList(GuardPredicateDeclaration.class, propertyList);
        GuardPredicateDeclaration.addProperty(BASE_PROPERTY, propertyList);
        GuardPredicateDeclaration.addProperty(EXPRESSION_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = GuardPredicateDeclaration.reapPropertyList(propertyList);
    }

    public static List<StructuralPropertyDescriptor> propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            throw new UnsupportedOperationException("JLS2 not supported");
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    GuardPredicateDeclaration(AST ast) {
        super(ast);
    }

    @Override
    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == BASE_PROPERTY) {
            if (get) {
                return this.isBase();
            }
            this.setBase(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    int getNodeType0() {
        return 120;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel == 2) {
                this.unsupportedIn2();
            }
            if (this.ast.apiLevel >= 3) {
                this.acceptChild(visitor, this.expression);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        if (this.ast.apiLevel == 2) {
            this.unsupportedIn2();
        }
        GuardPredicateDeclaration result = new GuardPredicateDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setBase(this.isBase());
        result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        return result;
    }

    public boolean isBase() {
        return this.isBase;
    }

    public void setBase(boolean isBase) {
        this.preValueChange(BASE_PROPERTY);
        this.isBase = isBase;
        this.postValueChange(BASE_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode getExpression() {
        if (this.expression == null) {
            GuardPredicateDeclaration guardPredicateDeclaration = this;
            synchronized (guardPredicateDeclaration) {
                if (this.expression == null) {
                    this.preLazyInit();
                    this.expression = new SimpleName(this.ast);
                    this.postLazyInit(this.expression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    @Override
    List internalStructuralPropertiesForType(int apiLevel) {
        return GuardPredicateDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    void appendDebugString(StringBuffer buffer) {
        if (this.isBase) {
            buffer.append("base ");
        }
        buffer.append("when (");
        this.expression.appendDebugString(buffer);
        buffer.append(")");
    }

    @Override
    int memSize() {
        return 40;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize());
    }
}

