/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.index.IndexQualifier;
import org.eclipse.jdt.internal.core.index.MetaIndex;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.AddFolderToIndex;
import org.eclipse.jdt.internal.core.search.indexing.AddJarFileToIndex;
import org.eclipse.jdt.internal.core.search.indexing.AddJrtToIndex;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.IndexAllProject;
import org.eclipse.jdt.internal.core.search.indexing.IndexBinaryFolder;
import org.eclipse.jdt.internal.core.search.indexing.IndexNamesRegistry;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.IndexingParser;
import org.eclipse.jdt.internal.core.search.indexing.QualifierQuery;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.RemoveFolderFromIndex;
import org.eclipse.jdt.internal.core.search.indexing.RemoveFromIndex;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class IndexManager
extends JobManager
implements IIndexConstants {
    private static final boolean DISABLE_META_INDEX = Boolean.parseBoolean(System.getProperty("org.eclipse.jdt.disableMetaIndex", "false"));
    public SimpleLookupTable indexLocations = new SimpleLookupTable();
    private SimpleLookupTable indexes = new SimpleLookupTable();
    private boolean needToSave = false;
    private IPath javaPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File indexNamesMapFile = new File(this.getSavedIndexesDirectory(), "indexNamesMap.txt");
    private File participantIndexNamesFile = new File(this.getSavedIndexesDirectory(), "participantsIndexNames.txt");
    private boolean javaLikeNamesChanged = true;
    public static final Integer SAVED_STATE = 0;
    public static final Integer UPDATING_STATE = 1;
    public static final Integer UNKNOWN_STATE = 2;
    public static final Integer REBUILDING_STATE = 3;
    public static final Integer REUSE_STATE = 4;
    private final IndexNamesRegistry nameRegistry = new IndexNamesRegistry(new File(this.getSavedIndexesDirectory(), "savedIndexNames.txt"), this.getJavaPluginWorkingLocation());
    private SimpleLookupTable participantsContainers = null;
    private boolean participantUpdated = false;
    private volatile MetaIndex metaIndex;
    public static final String MANAGE_PRODUCT_INDEXES_PROPERTY = "jdt.core.manageProductIndexes";
    private static final boolean IS_MANAGING_PRODUCT_INDEXES_PROPERTY = Boolean.getBoolean("jdt.core.manageProductIndexes");
    public static final String INDEX_MANAGER_NOTIFY_IDLE_WAIT_PROPERTY = "jdt.core.indexManager.notifyIdleWait";
    private static final long INDEX_MANAGER_NOTIFY_IDLE_WAIT = IndexManager.getNotifyIdleWait();
    public static boolean DEBUG = false;
    private static final String INDEX_META_CONTAINER = "meta_index";
    LinkedHashSet<Index> metaIndexUpdates = new LinkedHashSet();

    /*
     * Unable to fully structure code
     */
    public IStatus waitForIndex(boolean enableIndexer, IProgressMonitor monitor) {
        v0 = indexing = this.awaitingJobsCount() > 0;
        if (!indexing) {
            return Status.OK_STATUS;
        }
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        enableCount = 0;
        try {
            while (enableIndexer && !this.isEnabled()) {
                ++enableCount;
                this.enable();
            }
            this.performConcurrentJob(new IJob(){

                @Override
                public boolean belongsTo(String jobFamily) {
                    return false;
                }

                @Override
                public void cancel() {
                }

                @Override
                public void ensureReadyToRun() {
                }

                @Override
                public boolean execute(IProgressMonitor progress) {
                    return progress == null || !progress.isCanceled();
                }

                @Override
                public String getJobFamily() {
                    return "";
                }
            }, 3, monitor);
            var6_5 = monitor.isCanceled() != false ? Status.CANCEL_STATUS : Status.OK_STATUS;
            ** while (enableCount > 0)
        }
        catch (OperationCanceledException v1) {
            var6_6 = Status.CANCEL_STATUS;
            ** while (enableCount > 0)
        }
lbl-1000:
        // 1 sources

        {
            --enableCount;
            this.disable();
            continue;
        }
lbl18:
        // 1 sources

        return var6_5;
lbl-1000:
        // 1 sources

        {
            --enableCount;
            this.disable();
            continue;
        }
lbl26:
        // 1 sources

        return var6_6;
        {
            catch (Throwable var5_7) {
                ** while (enableCount > 0)
            }
        }
lbl-1000:
        // 1 sources

        {
            --enableCount;
            this.disable();
            continue;
        }
lbl32:
        // 1 sources

        throw var5_7;
    }

    public synchronized void aboutToUpdateIndex(IPath containerPath, Integer newIndexState) {
        Integer currentIndexState;
        IndexLocation indexLocation = this.computeIndexLocation(containerPath);
        Object state = this.getIndexStates().get(indexLocation);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.compareTo(REBUILDING_STATE) >= 0) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexLocation, newIndexState);
        } else if (compare < 0 && this.indexes.get(indexLocation) == null) {
            this.rebuildIndex(indexLocation, containerPath);
        }
    }

    public void addBinary(IFile resource, IPath containerPath) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        IndexLocation indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void addSource(IFile resource, IPath containerPath, SourceElementParser parser) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        document.setParser(parser);
        IndexLocation indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void cleanUpIndexes() {
        SimpleSet knownPaths = new SimpleSet();
        if (!DISABLE_META_INDEX) {
            knownPaths.add(this.computeIndexLocation((IPath)new Path(INDEX_META_CONTAINER)));
        }
        IJavaSearchScope scope = BasicSearchEngine.createWorkspaceScope();
        PatternSearchJob job = new PatternSearchJob(null, SearchEngine.getDefaultSearchParticipant(), scope, null);
        Index[] selectedIndexes = job.getIndexes(null);
        int i = 0;
        int l = selectedIndexes.length;
        while (i < l) {
            IndexLocation IndexLocation2 = selectedIndexes[i].getIndexLocation();
            knownPaths.add(IndexLocation2);
            ++i;
        }
        if (this.indexStates != null) {
            Object[] keys = this.indexStates.keyTable;
            IndexLocation[] locations = new IndexLocation[this.indexStates.elementSize];
            int count = 0;
            int i2 = 0;
            int l2 = keys.length;
            while (i2 < l2) {
                IndexLocation key = (IndexLocation)keys[i2];
                if (key != null && !knownPaths.includes(key)) {
                    locations[count++] = key;
                }
                ++i2;
            }
            if (count > 0) {
                this.removeIndexesState(locations);
            }
        }
        this.deleteIndexFiles(knownPaths, null);
    }

    public synchronized IndexLocation computeIndexLocation(IPath containerPath, URL newIndexURL) {
        IndexLocation indexLocation = (IndexLocation)this.indexLocations.get(containerPath);
        if (indexLocation == null) {
            if (newIndexURL != null) {
                indexLocation = IndexLocation.createIndexLocation(newIndexURL);
                indexLocation = (IndexLocation)this.getIndexStates().getKey(indexLocation);
                this.indexLocations.put(containerPath, indexLocation);
            }
        } else {
            URL existingURL = indexLocation.getUrl();
            if (newIndexURL != null && !newIndexURL.equals(existingURL)) {
                this.removeIndex(containerPath);
                indexLocation = IndexLocation.createIndexLocation(newIndexURL);
                indexLocation = (IndexLocation)this.getIndexStates().getKey(indexLocation);
                this.indexLocations.put(containerPath, indexLocation);
            }
        }
        return indexLocation;
    }

    public synchronized IndexLocation computeIndexLocation(IPath containerPath) {
        IndexLocation indexLocation = (IndexLocation)this.indexLocations.get(containerPath);
        if (indexLocation == null) {
            String pathString = containerPath.toOSString();
            CRC32 checksumCalculator = new CRC32();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (VERBOSE) {
                Util.verbose("-> index name for " + pathString + " is " + fileName);
            }
            indexLocation = (IndexLocation)this.getIndexStates().getKey(new FileIndexLocation(new File(this.getSavedIndexesDirectory(), fileName)));
            this.indexLocations.put(containerPath, indexLocation);
        }
        return indexLocation;
    }

    public final void deleteIndexFiles() {
        this.deleteIndexFiles(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndexFiles(IProgressMonitor monitor) {
        if (DEBUG) {
            Util.verbose("Deleting index files");
        }
        this.nameRegistry.delete();
        this.deleteIndexFiles(null, monitor);
        IndexManager indexManager = this;
        synchronized (indexManager) {
            this.metaIndex = null;
        }
    }

    private void deleteIndexFiles(SimpleSet pathsToKeep, IProgressMonitor monitor) {
        File[] indexesFiles = this.getSavedIndexesDirectory().listFiles();
        if (indexesFiles == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)indexesFiles.length);
        int i = 0;
        int l = indexesFiles.length;
        while (i < l) {
            subMonitor.split(1);
            String fileName = indexesFiles[i].getAbsolutePath();
            if (pathsToKeep == null || !pathsToKeep.includes(new FileIndexLocation(indexesFiles[i]))) {
                String suffix = ".index";
                if (fileName.regionMatches(true, fileName.length() - suffix.length(), suffix, 0, suffix.length())) {
                    if (VERBOSE || DEBUG) {
                        Util.verbose("Deleting index file " + indexesFiles[i]);
                    }
                    indexesFiles[i].delete();
                }
            }
            ++i;
        }
    }

    public synchronized void ensureIndexExists(IndexLocation indexLocation, IPath containerPath) {
        SimpleLookupTable states = this.getIndexStates();
        Object state = states.get(indexLocation);
        if (state == null) {
            this.updateIndexState(indexLocation, REBUILDING_STATE);
            this.getIndex(containerPath, indexLocation, true, true);
        }
    }

    public SourceElementParser getSourceElementParser(IJavaProject project, ISourceElementRequestor requestor) {
        Map<String, String> options = project.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        IndexingParser parser = new IndexingParser(requestor, new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(options), true, true, false);
        parser.reportOnlyOneSyntaxError = true;
        parser.javadocParser.checkDocComment = true;
        parser.javadocParser.reportProblems = false;
        return parser;
    }

    public synchronized Index getIndex(IndexLocation indexLocation) {
        return (Index)this.indexes.get(indexLocation);
    }

    public synchronized Index getIndex(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        IndexLocation indexLocation = this.computeIndexLocation(containerPath);
        return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
    }

    public synchronized Index getIndex(IPath containerPath, IndexLocation indexLocation, boolean reuseExistingFile, boolean createIfMissing) {
        Index index = this.getIndex(indexLocation);
        if (index == null) {
            String containerPathString;
            Integer currentIndexState;
            Object state = this.getIndexStates().get(indexLocation);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState == UNKNOWN_STATE) {
                this.rebuildIndex(indexLocation, containerPath);
                return null;
            }
            String string = containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
            if (reuseExistingFile) {
                block17: {
                    if (indexLocation.exists()) {
                        try {
                            index = new Index(indexLocation, containerPathString, true);
                            this.indexes.put(indexLocation, index);
                            return index;
                        }
                        catch (IOException iOException) {
                            if (currentIndexState == REBUILDING_STATE || currentIndexState == REUSE_STATE) break block17;
                            if (VERBOSE) {
                                Util.verbose("-> cannot reuse existing index: " + indexLocation + " path: " + containerPathString);
                            }
                            this.rebuildIndex(indexLocation, containerPath);
                            return null;
                        }
                    }
                }
                if (currentIndexState == SAVED_STATE) {
                    this.rebuildIndex(indexLocation, containerPath);
                    return null;
                }
                if (currentIndexState == REUSE_STATE) {
                    if (VERBOSE) {
                        Util.verbose("-> cannot reuse given index: " + indexLocation + " path: " + containerPathString);
                    }
                    if (!IS_MANAGING_PRODUCT_INDEXES_PROPERTY) {
                        this.indexLocations.put(containerPath, null);
                        indexLocation = this.computeIndexLocation(containerPath);
                        this.rebuildIndex(indexLocation, containerPath);
                    } else {
                        this.rebuildIndex(indexLocation, containerPath, true);
                    }
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    if (VERBOSE) {
                        Util.verbose("-> create empty index: " + indexLocation + " path: " + containerPathString);
                    }
                    index = new Index(indexLocation, containerPathString, false);
                    this.indexes.put(indexLocation, index);
                    return index;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        Util.verbose("-> unable to create empty index: " + indexLocation + " path: " + containerPathString);
                    }
                    return null;
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index[] getIndexes(IndexLocation[] locations, IProgressMonitor progressMonitor) {
        int length = locations.length;
        Index[] locatedIndexes = new Index[length];
        int count = 0;
        if (this.javaLikeNamesChanged) {
            this.javaLikeNamesChanged = this.hasJavaLikeNamesChanged();
        }
        int i = 0;
        while (i < length) {
            Index index;
            block21: {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IndexLocation indexLocation = locations[i];
                index = this.getIndex(indexLocation);
                if (index == null) {
                    IndexManager indexManager;
                    IPath containerPath = (IPath)this.indexLocations.keyForValue(indexLocation);
                    if (containerPath != null) {
                        index = this.getIndex(containerPath, indexLocation, true, false);
                        if (index != null && this.javaLikeNamesChanged && !index.isIndexForJar()) {
                            File indexFile = index.getIndexFile();
                            if (indexFile.exists()) {
                                if (DEBUG) {
                                    Util.verbose("Change in javaLikeNames - removing index file for " + containerPath);
                                }
                                indexFile.delete();
                            }
                            indexManager = this;
                            synchronized (indexManager) {
                                this.indexes.put(indexLocation, null);
                            }
                            this.rebuildIndex(indexLocation, containerPath);
                            index = null;
                        }
                    } else if (indexLocation.isParticipantIndex() && indexLocation.exists()) {
                        try {
                            IPath container = this.getParticipantsContainer(indexLocation);
                            if (container == null) break block21;
                            index = new Index(indexLocation, container.toOSString(), true);
                            indexManager = this;
                            synchronized (indexManager) {
                                this.indexes.put(indexLocation, index);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (index != null) {
                locatedIndexes[count++] = index;
            }
            ++i;
        }
        if (this.javaLikeNamesChanged) {
            this.writeJavaLikeNamesFile();
            this.javaLikeNamesChanged = false;
        }
        if (count < length) {
            Index[] indexArray = locatedIndexes;
            locatedIndexes = new Index[count];
            System.arraycopy(indexArray, 0, locatedIndexes, 0, count);
        }
        return locatedIndexes;
    }

    public synchronized Index getIndexForUpdate(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        IndexLocation indexLocation = this.computeIndexLocation(containerPath);
        if (this.getIndexStates().get(indexLocation) == REBUILDING_STATE) {
            return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
        }
        return null;
    }

    SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        File indexesDirectoryPath = this.getSavedIndexesDirectory();
        char[][] savedNames = this.nameRegistry.read(null);
        if (savedNames != null) {
            int i = 1;
            int l = savedNames.length;
            while (i < l) {
                char[] savedName = savedNames[i];
                if (savedName.length > 0) {
                    FileIndexLocation indexLocation = new FileIndexLocation(new File(indexesDirectoryPath, String.valueOf(savedName)));
                    if (VERBOSE) {
                        Util.verbose("Reading saved index file " + indexLocation);
                    }
                    this.indexStates.put(indexLocation, SAVED_STATE);
                }
                ++i;
            }
        } else {
            this.writeJavaLikeNamesFile();
            this.javaLikeNamesChanged = false;
            this.deleteIndexFiles();
        }
        this.readIndexMap();
        return this.indexStates;
    }

    private IPath getParticipantsContainer(IndexLocation indexLocation) {
        if (this.participantsContainers == null) {
            this.readParticipantsIndexNamesFile();
        }
        return (IPath)this.participantsContainers.get(indexLocation);
    }

    private IPath getJavaPluginWorkingLocation() {
        IPath stateLocation;
        if (this.javaPluginLocation != null) {
            return this.javaPluginLocation;
        }
        this.javaPluginLocation = stateLocation = JavaCore.getPlugin().getStateLocation();
        return this.javaPluginLocation;
    }

    private File getSavedIndexesDirectory() {
        return new File(this.getJavaPluginWorkingLocation().toOSString());
    }

    private boolean hasJavaLikeNamesChanged() {
        Object currentNames = Util.getJavaLikeExtensions();
        int current = ((char[][])currentNames).length;
        char[][] prevNames = this.readJavaLikeNamesFile();
        if (prevNames == null) {
            if (VERBOSE && current != 1) {
                Util.verbose("No Java like names found and there is atleast one non-default javaLikeName", System.err);
            }
            return current != 1;
        }
        int prev = prevNames.length;
        if (current != prev) {
            if (VERBOSE) {
                Util.verbose("Java like names have changed", System.err);
            }
            return true;
        }
        if (current > 1) {
            char[][] cArray = currentNames;
            char[][] cArrayArray = new char[current][];
            currentNames = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, current);
            Util.sort(currentNames);
        }
        int i = 0;
        while (i < current) {
            if (!CharOperation.equals(currentNames[i], prevNames[i])) {
                if (VERBOSE) {
                    Util.verbose("Java like names have changed", System.err);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public void indexDocument(SearchDocument searchDocument, SearchParticipant searchParticipant, Index index, IPath indexLocation) {
        try {
            searchDocument.setIndex(index);
            searchParticipant.indexDocument(searchDocument, indexLocation);
        }
        finally {
            searchDocument.setIndex(null);
        }
    }

    public void indexResolvedDocument(SearchDocument searchDocument, SearchParticipant searchParticipant, Index index, IPath indexLocation) {
        searchParticipant.resolveDocument(searchDocument);
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return;
        }
        try {
            monitor.enterWrite();
            searchDocument.setIndex(index);
            searchParticipant.indexResolvedDocument(searchDocument, indexLocation);
        }
        finally {
            searchDocument.setIndex(null);
            monitor.exitWrite();
        }
    }

    public void indexAll(IProject project) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        try {
            this.disable();
            try {
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                JavaProject javaProject = (JavaProject)model.getJavaProject((IResource)project);
                IClasspathEntry[] entries = javaProject.getResolvedClasspath();
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1) {
                        this.indexLibrary(entry.getPath(), project, ((ClasspathEntry)entry).getLibraryIndexLocation());
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            IndexAllProject request = new IndexAllProject(project, this);
            this.requestIfNotWaiting(request);
        }
        finally {
            this.enable();
        }
    }

    public void indexLibrary(IPath path, IProject requestingProject, URL indexURL) {
        this.indexLibrary(path, requestingProject, indexURL, false);
    }

    private IndexRequest getRequest(Object target, IPath jPath, IndexLocation indexFile, IndexManager manager, boolean updateIndex) {
        return this.isJrt(((File)target).getName()) ? new AddJrtToIndex(jPath, indexFile, this, updateIndex) : new AddJarFileToIndex(jPath, indexFile, this, updateIndex);
    }

    private boolean isJrt(String fileName) {
        return fileName != null && fileName.endsWith("jrt-fs.jar");
    }

    public void indexLibrary(IPath path, IProject requestingProject, URL indexURL, boolean updateIndex) {
        IndexLocation indexFile = null;
        boolean forceIndexUpdate = false;
        if (indexURL != null) {
            if (IS_MANAGING_PRODUCT_INDEXES_PROPERTY) {
                indexFile = this.computeIndexLocation(path, indexURL);
                forceIndexUpdate = !updateIndex && !indexFile.exists() ? true : updateIndex;
            } else {
                indexFile = IndexLocation.createIndexLocation(indexURL);
            }
        }
        if (JavaCore.getPlugin() == null) {
            return;
        }
        IndexRequest request = null;
        Object target = JavaModel.getTarget(path, true);
        if (target instanceof IFile) {
            request = this.isJrt(((IFile)target).getFullPath().toOSString()) ? new AddJrtToIndex((IFile)target, indexFile, this, forceIndexUpdate) : new AddJarFileToIndex((IFile)target, indexFile, this, forceIndexUpdate);
        } else if (target instanceof File) {
            request = this.getRequest(target, path, indexFile, this, forceIndexUpdate);
        } else if (target instanceof IContainer) {
            request = new IndexBinaryFolder((IContainer)target, this);
        } else {
            return;
        }
        this.requestIfNotWaiting(request);
    }

    synchronized boolean addIndex(IPath containerPath, IndexLocation indexFile) {
        this.getIndexStates().put(indexFile, REUSE_STATE);
        this.indexLocations.put(containerPath, indexFile);
        Index index = this.getIndex(containerPath, indexFile, true, false);
        if (index == null) {
            indexFile.close();
            this.indexLocations.put(containerPath, null);
            return false;
        }
        this.writeIndexMapFile();
        return true;
    }

    public void indexSourceFolder(JavaProject javaProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = javaProject.getProject();
        if (this.awaitingJobs.size() > 1 && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new AddFolderToIndex(sourceFolder, project, inclusionPatterns, exclusionPatterns, this));
    }

    public synchronized void jobWasCancelled(IPath containerPath) {
        IndexLocation indexLocation = this.computeIndexLocation(containerPath);
        Index index = this.getIndex(indexLocation);
        if (index != null) {
            index.monitor = null;
            this.indexes.removeKey(indexLocation);
        }
        this.updateIndexState(indexLocation, UNKNOWN_STATE);
    }

    @Override
    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    @Override
    protected void notifyIdle(long idlingTime) {
        if (idlingTime > INDEX_MANAGER_NOTIFY_IDLE_WAIT && this.needToSave) {
            this.saveIndexes();
        }
    }

    @Override
    public String processName() {
        return Messages.process_name;
    }

    private char[][] readJavaLikeNamesFile() {
        block5: {
            File javaLikeNamesFile;
            block4: {
                String pathName = this.getJavaPluginWorkingLocation().toOSString();
                javaLikeNamesFile = new File(pathName, "javaLikeNames.txt");
                if (javaLikeNamesFile.exists()) break block4;
                return null;
            }
            try {
                char[] javaLikeNames = org.eclipse.jdt.internal.compiler.util.Util.getFileCharContent(javaLikeNamesFile, null);
                if (javaLikeNames.length > 0) {
                    char[][] names = CharOperation.splitOn('\n', javaLikeNames);
                    return names;
                }
            }
            catch (IOException iOException) {
                if (!VERBOSE) break block5;
                Util.verbose("Failed to read javaLikeNames file");
            }
        }
        return null;
    }

    private void rebuildIndex(IndexLocation indexLocation, IPath containerPath) {
        this.rebuildIndex(indexLocation, containerPath, false);
    }

    private void rebuildIndex(IndexLocation indexLocation, IPath containerPath, boolean updateIndex) {
        Object target = JavaModel.getTarget(containerPath, true);
        if (target == null) {
            return;
        }
        if (VERBOSE) {
            Util.verbose("-> request to rebuild index: " + indexLocation + " path: " + containerPath);
        }
        this.updateIndexState(indexLocation, REBUILDING_STATE);
        IndexRequest request = null;
        if (target instanceof IProject) {
            IProject p = (IProject)target;
            if (JavaProject.hasJavaNature(p)) {
                request = new IndexAllProject(p, this);
            }
        } else if (target instanceof IFolder) {
            request = new IndexBinaryFolder((IContainer)((IFolder)target), this);
        } else if (target instanceof IFile) {
            request = this.isJrt(((IFile)target).getFullPath().toOSString()) ? new AddJrtToIndex((IFile)target, null, this, updateIndex) : new AddJarFileToIndex((IFile)target, null, this, updateIndex);
        } else if (target instanceof File) {
            request = this.getRequest(target, containerPath, null, this, updateIndex);
        }
        if (request != null) {
            this.request(request);
        }
    }

    public synchronized Index recreateIndex(IPath containerPath) {
        String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
        try {
            ReadWriteMonitor monitor;
            IndexLocation indexLocation = this.computeIndexLocation(containerPath);
            Index index = this.getIndex(indexLocation);
            ReadWriteMonitor readWriteMonitor = monitor = index == null ? null : index.monitor;
            if (VERBOSE) {
                Util.verbose("-> recreating index: " + indexLocation + " for path: " + containerPathString);
            }
            index = new Index(indexLocation, containerPathString, false);
            this.indexes.put(indexLocation, index);
            index.monitor = monitor;
            return index;
        }
        catch (IOException e) {
            if (VERBOSE) {
                Util.verbose("-> failed to recreate index for path: " + containerPathString);
                e.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String containerRelativePath, IPath indexedContainer) {
        this.request(new RemoveFromIndex(containerRelativePath, indexedContainer, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(IPath containerPath) {
        File indexFile = null;
        Index index = null;
        IndexManager indexManager = this;
        synchronized (indexManager) {
            IndexLocation indexLocation;
            if (VERBOSE || DEBUG) {
                Util.verbose("removing index " + containerPath);
            }
            if ((index = this.getIndex(indexLocation = this.computeIndexLocation(containerPath))) != null) {
                index.monitor = null;
                indexFile = index.getIndexFile();
            }
            if (indexFile == null) {
                indexFile = indexLocation.getIndexFile();
            }
            if (this.indexStates.get(indexLocation) == REUSE_STATE) {
                indexLocation.close();
                this.indexLocations.put(containerPath, null);
            } else if (indexFile != null && indexFile.exists()) {
                if (DEBUG) {
                    Util.verbose("removing index file " + indexFile);
                }
                indexFile.delete();
            }
            this.indexes.removeKey(indexLocation);
            if (IS_MANAGING_PRODUCT_INDEXES_PROPERTY) {
                this.indexLocations.removeKey(containerPath);
            }
            this.updateIndexState(indexLocation, null);
        }
        this.removeFromMetaIndex(index, indexFile, containerPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromMetaIndex(Index index, File indexFile, IPath containerPath) {
        if (DISABLE_META_INDEX) {
            return;
        }
        LinkedHashSet<Index> linkedHashSet = this.metaIndexUpdates;
        synchronized (linkedHashSet) {
            if (index != null) {
                this.metaIndexUpdates.remove(index);
            }
        }
        if (indexFile != null) {
            this.updateMetaIndex(indexFile.getName(), Collections.emptyList());
        } else if (VERBOSE) {
            Util.verbose(String.format("Unable to update meta index for container path %s because index file is null", containerPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexPath(IPath path) {
        ArrayList<String> affectedIndexes = new ArrayList<String>();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            if (VERBOSE || DEBUG) {
                Util.verbose("removing index path " + path);
            }
            Object[] keyTable = this.indexes.keyTable;
            Object[] valueTable = this.indexes.valueTable;
            IndexLocation[] locations = null;
            int max = this.indexes.elementSize;
            int count = 0;
            int i = 0;
            int l = keyTable.length;
            while (i < l) {
                IndexLocation indexLocation = (IndexLocation)keyTable[i];
                if (indexLocation != null) {
                    if (indexLocation.startsWith(path)) {
                        Index index = (Index)valueTable[i];
                        affectedIndexes.add(indexLocation.fileName());
                        if (!DISABLE_META_INDEX) {
                            LinkedHashSet<Index> linkedHashSet = this.metaIndexUpdates;
                            synchronized (linkedHashSet) {
                                this.metaIndexUpdates.remove(index);
                            }
                        }
                        index.monitor = null;
                        if (locations == null) {
                            locations = new IndexLocation[max];
                        }
                        locations[count++] = indexLocation;
                        if (this.indexStates.get(indexLocation) == REUSE_STATE) {
                            indexLocation.close();
                        } else {
                            if (DEBUG) {
                                Util.verbose("removing index file " + indexLocation);
                            }
                            indexLocation.delete();
                        }
                    } else {
                        --max;
                    }
                }
                ++i;
            }
            if (locations != null) {
                i = 0;
                while (i < count) {
                    this.indexes.removeKey(locations[i]);
                    ++i;
                }
                this.removeIndexesState(locations);
                if (this.participantsContainers != null) {
                    boolean update = false;
                    int i2 = 0;
                    while (i2 < count) {
                        if (this.participantsContainers.get(locations[i2]) != null) {
                            update = true;
                            this.participantsContainers.removeKey(locations[i2]);
                        }
                        ++i2;
                    }
                    if (update) {
                        this.writeParticipantsIndexNamesFile();
                    }
                }
            }
        }
        affectedIndexes.forEach(in -> this.updateMetaIndex((String)in, Collections.emptyList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexFamily(IPath path) {
        ArrayList<IPath> toRemove = null;
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Object[] containerPaths = this.indexLocations.keyTable;
            int i = 0;
            int length = containerPaths.length;
            while (i < length) {
                IPath containerPath = (IPath)containerPaths[i];
                if (containerPath != null && path.isPrefixOf(containerPath)) {
                    if (toRemove == null) {
                        toRemove = new ArrayList<IPath>();
                    }
                    toRemove.add(containerPath);
                }
                ++i;
            }
        }
        if (toRemove != null) {
            int i = 0;
            int length = toRemove.size();
            while (i < length) {
                this.removeIndex((IPath)toRemove.get(i));
                ++i;
            }
        }
    }

    public void removeSourceFolderFromIndex(JavaProject javaProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = javaProject.getProject();
        if (this.awaitingJobs.size() > 1 && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new RemoveFolderFromIndex(sourceFolder, inclusionPatterns, exclusionPatterns, project, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            if (this.indexes != null) {
                this.indexes = new SimpleLookupTable();
                this.indexStates = null;
            }
            this.indexLocations = new SimpleLookupTable();
            this.javaPluginLocation = null;
            LinkedHashSet<Index> linkedHashSet = this.metaIndexUpdates;
            synchronized (linkedHashSet) {
                this.metaIndexUpdates.clear();
            }
        }
    }

    public synchronized boolean resetIndex(IPath containerPath) {
        String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
        try {
            IndexLocation indexLocation = this.computeIndexLocation(containerPath);
            Index index = this.getIndex(indexLocation);
            if (VERBOSE) {
                Util.verbose("-> reseting index: " + indexLocation + " for path: " + containerPathString);
            }
            if (index == null) {
                return this.recreateIndex(containerPath) != null;
            }
            index.reset();
            return true;
        }
        catch (IOException e) {
            if (VERBOSE) {
                Util.verbose("-> failed to reset index for path: " + containerPathString);
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePreBuiltIndex(Index index) throws IOException {
        if (index.hasChanged()) {
            if (VERBOSE) {
                Util.verbose("-> saving pre-build index " + index.getIndexLocation());
            }
            index.save();
            this.updateMetaIndex(index);
        }
        IndexManager indexManager = this;
        synchronized (indexManager) {
            this.updateIndexState(index.getIndexLocation(), REUSE_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndex(Index index) throws IOException {
        if (index.hasChanged()) {
            if (VERBOSE) {
                Util.verbose("-> saving index " + index.getIndexLocation());
            }
            index.save();
            this.updateMetaIndex(index);
        }
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Path containerPath = new Path(index.containerPath);
            if (this.awaitingJobs.size() > 1) {
                ListIterator iterator = this.awaitingJobs.listIterator(this.awaitingJobs.size());
                IJob first = (IJob)this.awaitingJobs.get(0);
                while (iterator.hasPrevious()) {
                    IJob job = (IJob)iterator.previous();
                    if (job == first) break;
                    if (!(job instanceof IndexRequest) || !((IndexRequest)job).containerPath.equals((Object)containerPath)) continue;
                    return;
                }
            }
            IndexLocation indexLocation = this.computeIndexLocation((IPath)containerPath);
            this.updateIndexState(indexLocation, SAVED_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndexes() {
        ArrayList<Index> toSave = new ArrayList<Index>();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Object[] valueTable = this.indexes.valueTable;
            int i = 0;
            int l = valueTable.length;
            while (i < l) {
                Index index = (Index)valueTable[i];
                if (index != null) {
                    toSave.add(index);
                }
                ++i;
            }
        }
        boolean allSaved = true;
        int i = 0;
        int length = toSave.size();
        while (i < length) {
            block17: {
                Index index = (Index)toSave.get(i);
                ReadWriteMonitor monitor = index.monitor;
                if (monitor != null) {
                    try {
                        monitor.enterRead();
                        if (!index.hasChanged()) break block17;
                        if (monitor.exitReadEnterWrite()) {
                            try {
                                try {
                                    this.saveIndex(index);
                                }
                                catch (IOException e) {
                                    if (VERBOSE) {
                                        Util.verbose("-> got the following exception while saving:", System.err);
                                        e.printStackTrace();
                                    }
                                    allSaved = false;
                                    monitor.exitWriteEnterRead();
                                    break block17;
                                }
                            }
                            catch (Throwable throwable) {
                                monitor.exitWriteEnterRead();
                                throw throwable;
                            }
                            monitor.exitWriteEnterRead();
                            break block17;
                        }
                        allSaved = false;
                    }
                    finally {
                        monitor.exitRead();
                    }
                }
            }
            ++i;
        }
        if (this.participantsContainers != null && this.participantUpdated) {
            this.writeParticipantsIndexNamesFile();
            this.participantUpdated = false;
        }
        this.needToSave = !(allSaved &= this.saveMetaIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveMetaIndex() {
        boolean saved;
        IndexLocation metaIndexLocation;
        Integer indexState;
        block16: {
            MetaIndex mindex = this.metaIndex;
            if (mindex == null) {
                return true;
            }
            indexState = UNKNOWN_STATE;
            IndexManager indexManager = this;
            synchronized (indexManager) {
                metaIndexLocation = mindex.getIndexLocation();
                indexState = (Integer)this.getIndexStates().get(metaIndexLocation);
            }
            saved = false;
            ReadWriteMonitor monitor = null;
            try {
                try {
                    monitor = mindex.getMonitor();
                    if (monitor != null) {
                        monitor.enterWrite();
                        if (mindex.hasChanged()) {
                            mindex.save();
                        }
                        if (!SAVED_STATE.equals(indexState)) {
                            indexState = SAVED_STATE;
                        }
                        saved = true;
                    }
                }
                catch (IOException e) {
                    JavaCore.getJavaCore().getLog().error("Failed to update qualified index.", (Throwable)e);
                    if (monitor != null) {
                        monitor.exitWrite();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (monitor != null) {
                    monitor.exitWrite();
                }
                throw throwable;
            }
            if (monitor != null) {
                monitor.exitWrite();
            }
        }
        if (saved) {
            this.updateIndexState(metaIndexLocation, indexState);
        }
        return saved;
    }

    public void scheduleDocumentIndexing(final SearchDocument searchDocument, IPath container, final IndexLocation indexLocation, final SearchParticipant searchParticipant) {
        this.request(new IndexRequest(container, this){

            @Override
            public boolean execute(IProgressMonitor progressMonitor) {
                if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                Index index = IndexManager.this.getIndex(this.containerPath, indexLocation, true, true);
                if (index == null) {
                    return true;
                }
                ReadWriteMonitor monitor = index.monitor;
                if (monitor == null) {
                    return true;
                }
                Path indexPath = new Path(indexLocation.getCanonicalFilePath());
                try {
                    monitor.enterWrite();
                    IndexManager.this.indexDocument(searchDocument, searchParticipant, index, (IPath)indexPath);
                }
                finally {
                    monitor.exitWrite();
                }
                if (searchDocument.shouldIndexResolvedDocument()) {
                    IndexManager.this.indexResolvedDocument(searchDocument, searchParticipant, index, (IPath)indexPath);
                }
                IndexManager.this.updateMetaIndex(index);
                return true;
            }

            public String toString() {
                return "indexing " + searchDocument.getPath();
            }

            @Override
            public boolean waitNeeded() {
                return false;
            }
        });
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(10);
        buffer.append(super.toString());
        buffer.append("In-memory indexes:\n");
        int count = 0;
        Object[] valueTable = this.indexes.valueTable;
        int i = 0;
        int l = valueTable.length;
        while (i < l) {
            Index index = (Index)valueTable[i];
            if (index != null) {
                buffer.append(++count).append(" - ").append(index.toString()).append('\n');
            }
            ++i;
        }
        return buffer.toString();
    }

    private void readIndexMap() {
        block5: {
            try {
                String savedSignature;
                char[] indexMaps = org.eclipse.jdt.internal.compiler.util.Util.getFileCharContent(this.indexNamesMapFile, null);
                char[][] names = CharOperation.splitOn('\n', indexMaps);
                if (names.length >= 3 && (savedSignature = "INDEX VERSION 1.131 OT2").equals(new String(names[0]))) {
                    int i = 1;
                    int l = names.length - 1;
                    while (i < l) {
                        IndexLocation indexPath = IndexLocation.createIndexLocation(new URL(new String(names[i])));
                        if (indexPath != null) {
                            this.indexLocations.put(new Path(new String(names[i + 1])), indexPath);
                            this.indexStates.put(indexPath, REUSE_STATE);
                        }
                        i += 2;
                    }
                }
            }
            catch (IOException iOException) {
                if (!VERBOSE) break block5;
                Util.verbose("Failed to read saved index file names");
            }
        }
    }

    private void readParticipantsIndexNamesFile() {
        SimpleLookupTable containers;
        block4: {
            containers = new SimpleLookupTable(3);
            try {
                char[][] names;
                char[] participantIndexNames = org.eclipse.jdt.internal.compiler.util.Util.getFileCharContent(this.participantIndexNamesFile, null);
                if (participantIndexNames.length > 0 && (names = CharOperation.splitOn('\n', participantIndexNames)).length >= 3 && "INDEX VERSION 1.131 OT2".equals(new String(names[0]))) {
                    int i = 1;
                    int l = names.length - 1;
                    while (i < l) {
                        FileIndexLocation indexLocation = new FileIndexLocation(new File(new String(names[i])), true);
                        containers.put(indexLocation, new Path(new String(names[i + 1])));
                        i += 2;
                    }
                }
            }
            catch (IOException iOException) {
                if (!VERBOSE) break block4;
                Util.verbose("Failed to read participant index file names");
            }
        }
        this.participantsContainers = containers;
    }

    private synchronized void removeIndexesState(IndexLocation[] locations) {
        this.getIndexStates();
        int length = locations.length;
        boolean changed = false;
        int i = 0;
        while (i < length) {
            if (locations[i] != null && this.indexStates.removeKey(locations[i]) != null) {
                changed = true;
                if (VERBOSE) {
                    Util.verbose("-> index state updated to: ? for: " + locations[i]);
                }
            }
            ++i;
        }
        if (!changed) {
            return;
        }
        this.writeSavedIndexNamesFile();
        this.writeIndexMapFile();
    }

    synchronized void updateIndexState(IndexLocation indexLocation, Integer indexState) {
        if (indexLocation == null) {
            throw new IllegalArgumentException();
        }
        this.getIndexStates();
        if (indexState != null) {
            if (indexState.equals(this.indexStates.get(indexLocation))) {
                return;
            }
            this.indexStates.put(indexLocation, indexState);
        } else {
            if (!this.indexStates.containsKey(indexLocation)) {
                return;
            }
            this.indexStates.removeKey(indexLocation);
        }
        this.writeSavedIndexNamesFile();
        if (VERBOSE) {
            if (indexState == null) {
                Util.verbose("-> index state removed for: " + indexLocation);
            } else {
                String state = "?";
                if (indexState == SAVED_STATE) {
                    state = "SAVED";
                } else if (indexState == UPDATING_STATE) {
                    state = "UPDATING";
                } else if (indexState == UNKNOWN_STATE) {
                    state = "UNKNOWN";
                } else if (indexState == REBUILDING_STATE) {
                    state = "REBUILDING";
                } else if (indexState == REUSE_STATE) {
                    state = "REUSE";
                }
                Util.verbose("-> index state updated to: " + state + " for: " + indexLocation);
            }
        }
    }

    public void updateParticipant(IPath indexPath, IPath containerPath) {
        FileIndexLocation indexLocation;
        if (this.participantsContainers == null) {
            this.readParticipantsIndexNamesFile();
        }
        if (this.participantsContainers.get(indexLocation = new FileIndexLocation(indexPath.toFile(), true)) == null) {
            this.participantsContainers.put(indexLocation, containerPath);
            this.participantUpdated = true;
        }
    }

    private void writeJavaLikeNamesFile() {
        block18: {
            BufferedWriter writer = null;
            String pathName = this.getJavaPluginWorkingLocation().toOSString();
            try {
                try {
                    Object currentNames = Util.getJavaLikeExtensions();
                    int length = ((char[][])currentNames).length;
                    if (length > 1) {
                        char[][] cArray = currentNames;
                        char[][] cArrayArray = new char[length][];
                        currentNames = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 0, length);
                        Util.sort(currentNames);
                    }
                    File javaLikeNamesFile = new File(pathName, "javaLikeNames.txt");
                    writer = new BufferedWriter(new FileWriter(javaLikeNamesFile));
                    int i = 0;
                    while (i < length - 1) {
                        writer.write(currentNames[i]);
                        writer.write(10);
                        ++i;
                    }
                    if (length > 0) {
                        writer.write(currentNames[length - 1]);
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        Util.verbose("Failed to write javaLikeNames file", System.err);
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeIndexMapFile() {
        block17: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.indexNamesMapFile));
                    writer.write("INDEX VERSION 1.131 OT2");
                    writer.write(10);
                    Object[] keys = this.indexStates.keyTable;
                    Object[] states = this.indexStates.valueTable;
                    int i = 0;
                    int l = states.length;
                    while (i < l) {
                        IPath container;
                        IndexLocation location = (IndexLocation)keys[i];
                        if (location != null && states[i] == REUSE_STATE && (container = (IPath)this.indexLocations.keyForValue(location)) != null) {
                            writer.write(location.toString());
                            writer.write(10);
                            writer.write(container.toOSString());
                            writer.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        Util.verbose("Failed to write saved index file names", System.err);
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeParticipantsIndexNamesFile() {
        block17: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.participantIndexNamesFile));
                    writer.write("INDEX VERSION 1.131 OT2");
                    writer.write(10);
                    Object[] indexFiles = this.participantsContainers.keyTable;
                    Object[] containers = this.participantsContainers.valueTable;
                    int i = 0;
                    int l = indexFiles.length;
                    while (i < l) {
                        IndexLocation indexFile = (IndexLocation)indexFiles[i];
                        if (indexFile != null) {
                            writer.write(indexFile.getIndexFile().getPath());
                            writer.write(10);
                            writer.write(((IPath)containers[i]).toOSString());
                            writer.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        Util.verbose("Failed to write participant index file names", System.err);
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeSavedIndexNamesFile() {
        Object[] keys = this.indexStates.keyTable;
        Object[] states = this.indexStates.valueTable;
        int numToSave = 0;
        int i = 0;
        int l = states.length;
        while (i < l) {
            IndexLocation key = (IndexLocation)keys[i];
            if (key != null && states[i] == SAVED_STATE) {
                ++numToSave;
            }
            ++i;
        }
        char[][] arrays = new char[numToSave][];
        int idx = 0;
        int i2 = 0;
        int l2 = states.length;
        while (i2 < l2) {
            IndexLocation key = (IndexLocation)keys[i2];
            if (key != null && states[i2] == SAVED_STATE) {
                arrays[idx++] = key.fileName().toCharArray();
            }
            ++i2;
        }
        this.nameRegistry.write(arrays);
    }

    private static long getNotifyIdleWait() {
        long idleWait = 1000L;
        String idleWaitPropertyValue = System.getProperty(INDEX_MANAGER_NOTIFY_IDLE_WAIT_PROPERTY);
        if (idleWaitPropertyValue != null) {
            try {
                idleWait = Long.parseLong(idleWaitPropertyValue);
            }
            catch (NumberFormatException e) {
                Util.log(e, "Failed to parse value of property \"jdt.core.indexManager.notifyIdleWait\": " + idleWaitPropertyValue);
            }
        }
        return idleWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Set<String>> findMatchingIndexNames(QualifierQuery query) {
        if (DISABLE_META_INDEX) {
            return Optional.empty();
        }
        MetaIndex mindex = null;
        long startTime = System.currentTimeMillis();
        try {
            mindex = this.loadMetaIndexIfNeeded();
            if (mindex == null) {
                Optional<Set<String>> optional = Optional.empty();
                return optional;
            }
            ReadWriteMonitor monitor = mindex.getMonitor();
            if (monitor == null) {
                Optional<Set<String>> optional = Optional.empty();
                return optional;
            }
            monitor.enterRead();
            mindex.startQuery();
            try {
                Set<String> indexesNotInMeta;
                ArrayList<char[]> qualifiedCategories = new ArrayList<char[]>(2);
                ArrayList<char[]> simpleCategories = new ArrayList<char[]>(2);
                QualifierQuery.QueryCategory[] queryCategoryArray = query.getCategories();
                int n = queryCategoryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    QualifierQuery.QueryCategory cat = queryCategoryArray[n2];
                    if (cat == QualifierQuery.QueryCategory.REF) {
                        qualifiedCategories.add(META_INDEX_QUALIFIED_TYPE_QUALIFIER_REF);
                        simpleCategories.add(META_INDEX_SIMPLE_TYPE_QUALIFIER_REF);
                    } else if (cat == QualifierQuery.QueryCategory.SUPER) {
                        qualifiedCategories.add(META_INDEX_QUALIFIED_SUPER_TYPE_QUALIFIER_REF);
                        simpleCategories.add(META_INDEX_SIMPLE_SUPER_TYPE_QUALIFIER_REF);
                    }
                    ++n2;
                }
                ArrayList<EntryResult> results = new ArrayList<EntryResult>();
                if (query.getQualifiedKey().length > 0) {
                    results.addAll(this.runQuery(mindex, (char[][])qualifiedCategories.toArray((T[])new char[0][]), query.getQualifiedKey()));
                }
                results.addAll(this.runQuery(mindex, (char[][])simpleCategories.toArray((T[])new char[0][]), query.getSimpleKey()));
                IndexManager indexManager = this;
                synchronized (indexManager) {
                    indexesNotInMeta = mindex.getIndexesNotInMeta(this.indexes);
                }
                if (VERBOSE) {
                    Util.verbose("-> not in meta-index: " + indexesNotInMeta.size() + ", in: " + results.size() + " for query " + query);
                }
                Index i = mindex.getIndex();
                Optional<Set<String>> optional = Optional.of(Stream.concat(indexesNotInMeta.stream(), results.stream().flatMap(r -> {
                    try {
                        return Stream.of(r.getDocumentNames(i));
                    }
                    catch (IOException iOException) {
                        return Stream.empty();
                    }
                })).collect(Collectors.toSet()));
                mindex.stopQuery();
                monitor.exitRead();
                return optional;
            }
            catch (Throwable throwable) {
                try {
                    mindex.stopQuery();
                    monitor.exitRead();
                    throw throwable;
                }
                catch (IOException e) {
                    JavaCore.getJavaCore().getLog().error("Error filtering index locations based on qualifier.", (Throwable)e);
                    Optional<Set<String>> optional = Optional.empty();
                    return optional;
                }
            }
        }
        finally {
            if (VERBOSE) {
                long wallClockTime = System.currentTimeMillis() - startTime;
                Util.verbose("-> execution time: " + wallClockTime + "ms - IndexManager#findMatchingIndexNames");
            }
        }
    }

    private List<EntryResult> runQuery(MetaIndex index, char[][] categories, char[] key) throws IOException {
        EntryResult[] result = index.query(categories, key, 8);
        if (result != null) {
            return Arrays.asList(result);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaIndex loadMetaIndexIfNeeded() throws IOException {
        MetaIndex mindex = this.metaIndex;
        if (mindex != null) {
            return mindex;
        }
        IndexManager indexManager = this;
        synchronized (indexManager) {
            if (this.metaIndex == null) {
                Integer currentIndexState;
                IndexLocation indexLocation = this.computeIndexLocation((IPath)new Path(INDEX_META_CONTAINER));
                Object state = this.getIndexStates().get(indexLocation);
                Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
                if (UNKNOWN_STATE.equals(currentIndexState)) {
                    if (VERBOSE) {
                        Util.verbose("-> create empty meta-index: " + indexLocation + " path: " + INDEX_META_CONTAINER);
                    }
                    this.metaIndex = new MetaIndex(new Index(indexLocation, INDEX_META_CONTAINER, false));
                    this.updateIndexState(indexLocation, REUSE_STATE);
                } else if (indexLocation.exists()) {
                    if (VERBOSE) {
                        Util.verbose("-> load existing meta-index: " + indexLocation + " path: " + INDEX_META_CONTAINER);
                    }
                    this.metaIndex = new MetaIndex(new Index(indexLocation, INDEX_META_CONTAINER, true));
                } else {
                    this.getIndexStates().put(indexLocation, UNKNOWN_STATE);
                    this.loadMetaIndexIfNeeded();
                }
            }
            return this.metaIndex;
        }
    }

    void updateMetaIndex(Index index) {
        if (DISABLE_META_INDEX) {
            return;
        }
        this.scheduleForMetaIndexUpdate(index);
    }

    void updateMetaIndex(String indexFileName, List<IndexQualifier> qualifications) {
        if (DISABLE_META_INDEX) {
            return;
        }
        if (indexFileName == null) {
            return;
        }
        ReadWriteMonitor monitor = null;
        try {
            MetaIndex mindex = this.loadMetaIndexIfNeeded();
            IndexLocation mindexLocation = mindex.getIndexLocation();
            monitor = mindex.getMonitor();
            if (monitor == null) {
                this.updateIndexState(mindexLocation, UNKNOWN_STATE);
                return;
            }
            try {
                if (VERBOSE) {
                    int qsize = qualifications.size();
                    Util.verbose("-> updating meta-index with " + qsize + " elements for " + indexFileName);
                }
                monitor.enterWrite();
                mindex.remove(indexFileName);
                for (IndexQualifier qualifier : qualifications) {
                    mindex.addIndexEntry(qualifier.getCategory(), qualifier.getKey(), indexFileName);
                }
                if (VERBOSE) {
                    Util.verbose("-> meta-index updated for " + indexFileName);
                }
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> failed to update meta index for index " + indexFileName + " because of the following exception:");
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.exitWrite();
            }
        }
    }

    public Optional<MetaIndex> getMetaIndex() {
        if (DISABLE_META_INDEX) {
            return Optional.empty();
        }
        try {
            MetaIndex index = this.loadMetaIndexIfNeeded();
            return Optional.ofNullable(index);
        }
        catch (IOException e) {
            JavaCore.getJavaCore().getLog().error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleForMetaIndexUpdate(Index index) {
        LinkedHashSet<Index> linkedHashSet = this.metaIndexUpdates;
        synchronized (linkedHashSet) {
            if (this.metaIndexUpdates.contains(index)) {
                if (VERBOSE) {
                    Util.verbose("-> already waiting for meta-index update for " + index);
                }
                return;
            }
            this.metaIndexUpdates.add(index);
        }
        this.requestIfNotWaiting(new MetaIndexUpdateRequest());
    }

    class MetaIndexUpdateRequest
    implements IJob {
        volatile boolean isCancelled;

        MetaIndexUpdateRequest() {
        }

        @Override
        public boolean belongsTo(String jobFamily) {
            return false;
        }

        @Override
        public void cancel() {
            this.isCancelled = true;
        }

        @Override
        public void ensureReadyToRun() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(IProgressMonitor progress) {
            while (!(progress != null && progress.isCanceled() || this.isCancelled)) {
                Index index = null;
                LinkedHashSet<Index> linkedHashSet = IndexManager.this.metaIndexUpdates;
                synchronized (linkedHashSet) {
                    Iterator iterator = IndexManager.this.metaIndexUpdates.iterator();
                    if (iterator.hasNext()) {
                        index = (Index)iterator.next();
                        iterator.remove();
                    }
                }
                if (index == null) {
                    return true;
                }
                File indexFile = index.getIndexFile();
                if (indexFile == null) continue;
                if (VERBOSE) {
                    Util.verbose("-> meta-index update from queue with size " + IndexManager.this.metaIndexUpdates.size());
                }
                try {
                    IndexManager.this.updateMetaIndex(indexFile.getName(), index.getMetaIndexQualifications());
                }
                catch (IOException e) {
                    if (!JobManager.VERBOSE) continue;
                    Util.verbose("-> failed to update meta index for index " + indexFile.getName() + " because of the following exception:");
                    e.printStackTrace();
                }
            }
            return true;
        }

        @Override
        public String getJobFamily() {
            return "";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MetaIndexUpdateRequest)) {
                return false;
            }
            MetaIndexUpdateRequest other = (MetaIndexUpdateRequest)obj;
            return this.isCancelled == other.isCancelled;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

