/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.MappingProposalSubProcessor;

public class QuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            return this.hasToggleSignaturesOfMethodMappingProposal(coveringNode);
        }
        return false;
    }

    private boolean hasToggleSignaturesOfMethodMappingProposal(ASTNode coveringNode) {
        while (coveringNode != null) {
            switch (coveringNode.getNodeType()) {
                case 107: 
                case 108: {
                    AbstractMethodMappingDeclaration methodMapping = (AbstractMethodMappingDeclaration)coveringNode;
                    return !methodMapping.hasParameterMapping();
                }
                case 15: 
                case 55: 
                case 115: {
                    return false;
                }
            }
            coveringNode = coveringNode.getParent();
        }
        return false;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ICommandAccess> resultingCollections = new ArrayList<ICommandAccess>();
            Errors matchedErrorsAtLocation = this.matchErrorsAtLocation(locations, new int[]{141005, 131004});
            if (matchedErrorsAtLocation != Errors.EXPECTED) {
                MappingProposalSubProcessor.getRemoveMethodMappingSignaturesProposal(context.getCompilationUnit(), coveringNode, 1, resultingCollections);
            }
            if ((matchedErrorsAtLocation = this.matchErrorsAtLocation(locations, new int[]{141006, 131005})) == Errors.NONE) {
                MappingProposalSubProcessor.getAddMethodMappingSignaturesProposal(context.getCompilationUnit(), coveringNode, 1, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    private Errors matchErrorsAtLocation(IProblemLocation[] locations, int[] expectedProblemIds) {
        boolean hasMatch = false;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                block7: {
                    IProblemLocation location = locations[i];
                    if (location.isError()) {
                        int problemId = location.getProblemId();
                        if (expectedProblemIds != null) {
                            int j = 0;
                            while (j < expectedProblemIds.length) {
                                if (expectedProblemIds[j] == problemId) {
                                    hasMatch = true;
                                    break block7;
                                }
                                ++j;
                            }
                        }
                        if (!"org.eclipse.jdt.core.problem".equals(location.getMarkerType()) || JavaCore.getOptionForConfigurableSeverity((int)problemId) == null) {
                            return Errors.UNEXPECTED;
                        }
                    }
                }
                ++i;
            }
        }
        return hasMatch ? Errors.EXPECTED : Errors.NONE;
    }

    static enum Errors {
        NONE,
        EXPECTED,
        UNEXPECTED;

    }
}

